/****************************************************************************
**
**  Name:  SSECTION.C
**
**  Description:
**      Set up section bases for Srecord loading.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/ssection.c_v  $
** 
**    Rev 1.9   17 Jun 1994 15:02:06   nghia
** Used local heap instead of Tmalloc for locality.
** Cleanup old junks.  Used LdrWarning.
** 
**    Rev 1.8   18 May 1994 17:23:04   nghia
** Cleanup for Loader Launcher integration.
** Removed old junks.
** 
**    Rev 1.7   04 Jun 1993 10:34:26   nghia
** Revised to meet coding standard.
** Report error using only the Warning() and WarningEx() routines.
** PIP for Source.
** 
**    Rev 1.6   12 Feb 1993 18:10:16   nghia
** Updated for release.
** 
**    Rev 1.5   06 Nov 1992 17:35:00   courtney
** Update local nSections after freeing.
** 
**    Rev 1.4   22 Oct 1992 16:15:56   courtney
** Cleanup error reporting to use generic loader's string resource messages.
** 
**    Rev 1.3   25 Sep 1992 21:07:26   courtney
** Added symbol support.
** 
**    Rev 1.2   25 Sep 1992 05:44:56   courtney
** Sections allocated only if symbol loading requested; use
** TMalloc/TFree.
** 
**    Rev 1.1   21 Aug 1992 10:28:02   courtney
** Add include wrappers.
** 
**    Rev 1.0   31 Dec 1991 09:38:14   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arccore/loader/srec/ssection.c_v   1.9   17 Jun 1994 15:02:06   nghia  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <io.h>
#include <alloc.h>

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

#ifndef __SLDR__
#include "sldr.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
SEC_INFO *section_info[MAX_SECTIONS];
U16 nSections;

/*****************************************************************************
**
**  ProcessSecPart
**
*****************************************************************************/
S16 ProcessSecPart(U16 symflag) {
   SEC_INFO *psection;
   RETCODE err;
   U16 index;  /* number of sections processed */

   // Construct array of structs for section info: SEC_INFO
   // For Srecord, we set up 2 fake sections, for loading code and symbols,
   // respectively.
   index = nSections = 0;

   /* fake section for code */
   if ((psection = (SEC_INFO *)malloc(sizeof(SEC_INFO))) == NULL) {
      err = ER_NO_MEMORY;
      return(err);
   }
   memset(psection, 0, sizeof(SEC_INFO));
   strcpy(psection->name, SBASE_CODE);
   psection->sindex = SCODE_INDEX;
   section_info[index++] = psection;
   // should this be created even if no symbols? 
   if (symflag && (SymAddBaseCreate((LPSTR)SBASE_CODE, SCODE_INDEX, 0L,
                                    BASE_CODE) != GOOD)) {
      if ((err = LdrWarning(ER_SYMBASE, NULL, NULL, NULL)) != GOOD) {
         LdrProgressDone(err);
         return err;
      }
   }
   /* Fake section for symbols */
   if ((psection = (SEC_INFO *)malloc(sizeof(SEC_INFO))) == NULL) {
      err = ER_NO_MEMORY;
      return(err);
   }
   
   memset(psection, 0, sizeof(SEC_INFO));
   strcpy(psection->name, SBASE_SYMBOL);
   psection->sindex = SSYM_INDEX;
   section_info[index++] = psection;
   if (symflag && (SymAddBaseCreate((LPSTR)SBASE_SYMBOL, SSYM_INDEX,	0L,
                                     BASE_DATA) != GOOD)) {
      if ((err = LdrWarning(ER_SYMBASE, NULL, NULL, NULL)) != GOOD) {
         LdrProgressDone(err);
         return err;
      }
   }
   // save the number of section to deallocation 
   nSections = index;
   return GOOD;
}  /* ProcessSecPart */

/*****************************************************************************
**
**  FreeSections
**
*****************************************************************************/
RETCODE FreeSections(U16 *pn) {
   LOOP_VAR i;
   U16 n;

   /* free memory associated with section info struct */
   n = *pn;
   for (i = 0; i < n; i++) 
      free((LPSTR)section_info[i]);
   /* reset */
   *pn = 0;
   return GOOD;
}  /* FreeSections */

/********************************** E O F ***********************************/
