/****************************************************************************
**
**  Name:  maldebug.h
**
**  Description:
**      Memory allocation debug routines.
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arccore/malloc/maldebug.h_v  $
** 
**    Rev 1.1   04 Dec 1992 07:30:04   doug
** added _debugHeap command support
** 
**    Rev 1.0   29 Aug 1992 12:13:40   doug
** Initial revision.
**
**  $Header:   S:/tbird/arccore/malloc/maldebug.h_v   1.1   04 Dec 1992 07:30:04   doug  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MALDEBUG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


                    /*********************************
                     *                               *
                     *   EVENT NOTIFICATION DEFINES  *
                     *                               *
                     *********************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  SetVerifyHeap
**
**  Description:
**      Set mode to verify heap whenever a TMalloc or TFree call is made.
**
**  Parameters:
**     input:
**        verify : TRUE to verify, FALSE to turn debug off
**
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT SetVerifyHeap(BOOLEAN verify);

/****************************************************************************
**
**  GetVerifyHeap
**
**  Description:
**      Get the current mode of the verification function.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        verify:  TRUE if verification on, FALSE if off
**
*****************************************************************************/
RETCODE EXPORT GetVerifyHeap(BOOLEAN *verify);

/****************************************************************************
**
**  SetDebugHeap
**
**  Description:
**      Set mode to display all TMalloc or TFree calls to CLI transcript.
**
**  Parameters:
**     input:
**        debug : TRUE to turn debug on, FALSE to turn debug off
**
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT SetDebugHeap(BOOLEAN debug);

/****************************************************************************
**
**  GetDebugHeap
**
**  Description:
**      Get the current mode of the debug function.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        debug:  TRUE if debug on, FALSE if off
**
*****************************************************************************/
RETCODE EXPORT GetDebugHeap(BOOLEAN *debug);

/****************************************************************************
**
**  SendMessageToCli
**
**  Description:
**      Send a text string message to the CLI transcript window.
**
**  Parameters:
**     input:
**        msgPtr:  pointer to text.
**
**     output:
**        none
**
*****************************************************************************/
RETCODE SendMessageToCli(LPSTR msgPtr);

#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
