/****************************************************************************
**
**  Name:  mapcli.h
**
**  Description:
**     CLI for Map server
**
**  Status: TESTED
**
**  $Log:   S:/tbird/arcm030/map/mapcli.h_v  $
** 
**    Rev 1.3   24 May 1994 07:52:06   tom
** Merged 1.2.1.0 onto trunk.
** 
**    Rev 1.2.1.0   15 May 1994 01:18:38   tom
** PDM Map presenter changes.
** 
**    Rev 1.2   23 Oct 1992 21:25:44   brucea
** Moved prototypes from pmem.h into here
** Added: three chip select function prototypes
** 
**    Rev 1.1   27 Feb 1992 15:27:24   doug
** Simple map CLI
** 
**    Rev 1.0   23 Jan 1992 16:06:40   doug
** Initial revision.
**
**  $Header:   S:/tbird/arcm030/map/mapcli.h_v   1.3   24 May 1994 07:52:06   tom  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/


#define _MAPCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/


/****************************************************************************
**
**  InitCServer
**
**  Description:
**     Initialize the CLI commands for this server.
**
**  Parameters:
**     input:
**        cliHandle:  CLI Server Handle
**        dllHandle:  DLL Handle.
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) ;

/****************************************************************************
**
**  MapCliMemoryMap
**
**  Description:
**     CLI command for "map"
**
**     Syntax:  map [<address base>|clear]
**
**     Maps one block of 256k of memory.  Truncates address base to 256k
**     boundary.
**
**  Parameters:
**     input:
**        cmdString:  command text input
**        argc:  argument count
**        argv:  argument data
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapCliMemoryMap(LPSTR cmdString, U32 argc, U32 argv[]) ;


/*---------------------------------------------------------------------------
** MapCliConfigEmuToChipSelects
**
** Purpose: Sends command to chassis to program the probe hardware to match
**    the 68332 internal chip select registers.
----------------------------------------------------------------------------*/
RETCODE EXPORT
MapCliConfigEmuToChipSelects(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
** MapCliSaveChipSelectConfig
**
** Purpose: Gets the 68332 internal chip select registers from the processor
**    and outputs the values in ascii to the entered filename.
----------------------------------------------------------------------------*/
RETCODE EXPORT
MapCliSaveChipSelectConfig(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
** MapCliRestoreChipSelectRegisters
**
** Purpose: CLI interface to restore chip selects; calls RestoreChipSelects
----------------------------------------------------------------------------*/
RETCODE EXPORT
MapCliRestoreChipSelectRegisters(LPSTR cmdString, U32 argc, U32 argv[]);

/*---------------------------------------------------------------------------
** MapCliSaveMap
**
** Purpose: CLI interface to save map setting
----------------------------------------------------------------------------*/
RETCODE EXPORT
MapCliSaveMap(LPSTR cmdString, U32 argc, U32 argv[]);

/*---------------------------------------------------------------------------
** MapCliRestoreMap
**
** Purpose: CLI interface to restore map setting
----------------------------------------------------------------------------*/
RETCODE EXPORT
MapCliRestoreMap(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************** E O F ***********************************/
