/****************************************************************************
**
**  Name: OMF86.H
**
**  Description:
**     Contains the declaration of the OMF86 loader interfaces.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm332/omf86/omf86.h_v  $
** 
**    Rev 1.2   11 Oct 1994 10:10:08   joyce
** Extend the interface OMF86LoaderLoadModuleByDesc() so the loader options can
** be gotten from the loader launcher.
**
**    Rev 1.1   14 Jul 1994 15:19:00   steve
** Joyce's omf86 changes for 386 build 8
**
**    Rev 1.0   24 May 1994 14:48:30   joyce
** Initial revision.
**
**  $Header:   S:/tbird/arcm332/omf86/omf86.h_v   1.2   11 Oct 1994 10:10:08   joyce  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __OMF86__
#define __OMF86__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
**
**  OMF86LoaderLoad
**
**   Description:
**        Load the specified OMF86 load file, using the input load flags.
**
**   Parameters:
**        input:
**           loadFileName   File name (including path) of the loadfile
**           loadFlags      Load options (combination of one or more load
**                          options: LOAD_CODE, LOAD_SYMBOLS, etc.,)
**           parentHwnd     Parent Window handle (HWND).
**           addrSpace      user's option which is either USER or SMM
**
**        output:
**           none.
**
**   Returns:
**        GOOD on successful load operation
**        if error occurs, an error code is returned to caller.
**
******************************************************************************/
RETCODE EXPORT OMF86LoaderLoad(LPSTR loadFileName, U32 loadFlags,
                               HWND parentHwnd,
                               ADDR_SPACE addrSpace);

/*****************************************************************************
**
**  OMF86LoaderLoadModuleByDesc
**
**   Description:
**        Load local symbols for the specified module.  This function is called
**        by the Loader Launcher and used by the Symbol Server and the Shell's
**        LOAD command in response to the ondemand loading request.  Only local
**        symbols and line number records will be loaded.  All global symbols
**        - including module, function, and type information has already been
**        loaded).
**
**   Parameters:
**       input:
**          fileName       Filename where module is found
**          moduleName     Name of module to load
**          moduleDesc     Module Descriptor of the specified module
**                         (assigned by the Symbol Server)
**          addrSpace      user's option which is either USER or SMM
**          loadFlags      Load options (combination of one or more load
**                         options: LOAD_CODE, LOAD_SYMBOLS, etc.,)
**
**       output:
**          none.
**
**  Returns:
**       GOOD on successful load of required module
**       if an error occurred, an error code is returned to report.
**
*****************************************************************************/
RETCODE EXPORT OMF86LoaderLoadModuleByDesc(LPSTR fileName, LPSTR moduleName,
                                           SYM_DESCRIPTOR moduleDesc,
                                           ADDR_SPACE addrSpace,
                                           U32 loadFlags);


/*****************************************************************************
**
**  OMF86LoaderGetStartPC
**
**  Description:
**     Function to retrieve the loaded loadfile start PC.  This function will
**     allocate the returned address descriptor, Caller is responsible for
**     destroying the descriptor when done.  When error occurs, this function
**     does not return the start PC.
**
**  Parameters:
**     input:
**        none.
**
**     output:
**        ptrStartPC     Pointer to an Address Descriptor.
**
**     Returns:
**        GOOD on successful operation
**        if an error occurred, an error code is returned to caller.
**
******************************************************************************/
RETCODE EXPORT OMF86LoaderGetStartPC(DESCRIPTOR FAR *ptrStartPC);

/******************************************************************************
**
**  OMF86LoaderGetStackInfo
**
**  Description:
**     Function to retrieve the loadfile's stack information.
**     This function will allocate the returned address descriptor, Caller is
**     responsible for destroying the descriptor when done.  When error occurs,
**     this function does not return the descriptor.
**
**  Parameters:
**     input:
**        none.
**
**     output:
**        ptrStackTop   Pointer to address descriptor.
**        stkSize       Pointer to Stack size.
**
**     Returns:
**        GOOD on successful operation
**        if an error occurred, an error code is returned to caller.
**
*****************************************************************************/
RETCODE EXPORT OMF86LoaderGetStackInfo(DESCRIPTOR FAR *ptrStackTop,
                                       U32 FAR *stkSize);

/*****************************************************************************
**
**  OMF86LoaderGetBytes
**
**  Description:
**     Function to get the data blocks for code loading. This
**     function reads loadfile according to the specified size, then
**     copy the contents to the caller.
**
**  Parameters:
**     input:
**        info          Pointer to the handle of the loadfile.
**        count         Size of the contents which this function should read.
**
**     output:
**        dest          Pointer to the returned contents.
**
**     Returns:
**        GOOD on successful operation
**        if an error occurred, an error code is returned to caller.
**
*****************************************************************************/
RETCODE EXPORT OMF86LoaderGetBytes(VOID FAR *info, U8 FAR *dest, U16 count);


/*****************************************************************************
**
**  OMF86LoaderGetFromIterDataBlock
**
**  Description:
**     Function to get the iterated data blocks for code loading. This
**     function doesn't actually read loadfile because the data is already
**     read, it just return what's already there to the caller according to
**     the specified size.
**
**  Parameters:
**     input:
**        info          Pointer to file handle. This parameter is not used
**                      by this function.
**        count         Size of the contents which this function should get.
**
**     output:
**        dest          Pointer to the returned contents.
**
**     Returns:
**        GOOD
**
*****************************************************************************/
RETCODE EXPORT OMF86LoaderGetFromIterDataBlock(VOID FAR *info, U8 FAR *dest,
                                               U16 count);


#ifdef __cplusplus
}
#endif

#endif /* __OMF86__ */
/*********************************** EOF ************************************/
