/****************************************************************************
**
** Name: local.h
**
** Description:
**       Local prototypes for confidence testing
**
**  $Log:   S:/tbird/arcm332/pvtest/local.h_v  $
** 
**    Rev 1.1   10 Oct 1994 13:31:22   ernie
** Increased buffer sizes to accommodate test 10--procconnect
** 
**    Rev 1.0   10 May 1994 09:53:00   ernie
** Initial revision.
** 
**  $Header:   S:/tbird/arcm332/pvtest/local.h_v   1.1   10 Oct 1994 13:31:22   ernie  $
**
** Copyright (C) 1991-94 Microtek International, Inc.
**
*****************************************************************************/
#define _LOCAL_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define CONFIG_FILE      "pvtest.cfg"
#define MAX_MAPPED_NAME  32
#define MAX_LINE        256
#define MAX_TESTS       256
#define MAX_TESTLIST    256

/* Test message levels */
#define BRIEF 0
#define NORM  1
#define FAIL  1
#define VERB  2
#define DEBUG 3

#define MESSAGE_SIZE 256

typedef RETCODE (*TESTFUNC) (BOOLEAN *pass, BOOLEAN *abort);
typedef RETCODE EXPORT (*CONFIG_CALLBACK) (LPSTR key, LPSTR value, BOOLEAN *abort,
   VOID *data);

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
** TestReadPhysical
**
** description:
**   Memory read function including extended spaces
**
** parameters:
**   offset   physical address to read
**   space    extended address space
**   length   number of bytes to read
**   data     data buffer (caller provides storage)
**   loop     if TRUE, repeat operation until aborted.
**
*****************************************************************************/
RETCODE EXPORT TestReadPhysical(U32 offset, ADDR_SPACE space, U32 length,
                        U8 *data, BOOLEAN loop);

/****************************************************************************
**
** TestWritePhysical
**
** description:
**   Memory write function including extended spaces
**
** parameters:
**   offset   physical address to write
**   space    extended address space
**   length   number of bytes to write
**   data     data buffer
**   loop     if TRUE, repeat operation until aborted.
**
*****************************************************************************/
RETCODE EXPORT TestWritePhysical(U32 offset, ADDR_SPACE space, U32 length,
                        U8 *data, BOOLEAN loop);

/****************************************************************************
**
** TestRamtstPhysical
**
** description:
**   Memory write function including extended spaces
**
** parameters:
**   offset   physical address to start test
**   mask     1's in bits in address that remain constant throughout test
**   space    extended address space
**   length   number of bytes to test
**   access   access size to use for test
**   loop     if TRUE, repeat operation until aborted.
**   info     pointer to structure to receive error information
**
*****************************************************************************/
RETCODE EXPORT TestRamtstPhysical(U32 offset, U32 mask, ADDR_SPACE space,
   U32 length, ACCESS_SIZE access, BOOLEAN loop, RAMTST_INFO *info);

/****************************************************************************
**
** Miscellaneous functions
**
*****************************************************************************/
RETCODE EXPORT ConfigFileRead(LPSTR section, LPSTR key, LPSTR value);
RETCODE EXPORT ConfigFileEnumerate(LPSTR section,
      CONFIG_CALLBACK callback, BOOLEAN *abort, VOID *data);
RETCODE SendCliMessage(LPSTR msgPtr);
BOOLEAN TestIsTestName(LPSTR str, U16 *testNumber);
LPSTR TestGetTestName(U16 testNumber);
RETCODE Print(U16 msgLevel, LPSTR format, ...);

/****************************************************************************
**
** Test functions
**
*****************************************************************************/
RETCODE TestInit(VOID);
RETCODE TestChassisControl(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTicControl(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTraceMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTrigMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTricConnect(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTraceConnect(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestXilinxProgram(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestSastConnect(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTargetConnect(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcConnect(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestIceMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcBasic(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcInternal(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestMapMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestOverlayMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcGrHalt(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcGoHalt(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcReset(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcStep(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcSwBkpt(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcHwBkpt(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcTrigger(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestProcTrace(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestSastMemory(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestMapBkpt(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestMapRom(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestSignalGating(BOOLEAN *pass, BOOLEAN *abort);
RETCODE TestTraceAux(BOOLEAN *pass, BOOLEAN *abort);

RETCODE TestSendCommand(TEST_COMMAND cmd, BOOLEAN looping);
RETCODE TestSASTInit(VOID);
RETCODE TestSASTOn(VOID);
RETCODE TestSASTOff(VOID);
RETCODE TestMapClear(VOID);
RETCODE TestMapWrite(U32 block, U32 addr, U32 length, BOOLEAN enable,
      MAP_PROTECT protect);

/******************************** E O F ***********************************/
