/*----------------------------------------------------------------------------
** Name: symutil.h
**
** Title: Utility Routines for Symbol Server
**
** Purpose:
**    Catch-all for definitions and functions needed by multiple symbol files
**
** Status: PRELIMINARY | CODED
**
** $Log:   S:/tbird/arccore/symbol/symutil.h_v  $
** 
**    Rev 1.10   25 Jul 1994 11:10:58   brucea
** Modified: UtilGetSegSelFromSymDesc()
** 
**    Rev 1.9   06 Apr 1992 12:00:38   brucea
** No change: was modified (and back again) to find bug in ldrsvr.h
** 
**    Rev 1.8   06 Apr 1992 10:02:32   brucea
** removed: #ifdef __cplusplus brackets
** 
**    Rev 1.7   10 Jan 1992 15:50:30   brucea
** Moved #define NULL_SYMBOL, MAX_SYMNAME_LENGTH, MAX_PATH_LENGTH from here
**   to symblsvr.h
** 
**    Rev 1.6   02 Jan 1992 11:59:10   john
** Added prototype for comparing two timestamps
** 
**    Rev 1.5   13 Dec 1991 14:16:12   brucea
** Added prototype for UtilIsValidSymDescriptor
** 
**    Rev 1.4   12 Dec 1991 14:13:02   john
** Added prototype for UtilDeleteTables().
** 
**    Rev 1.3   11 Dec 1991 16:05:42   brucea
** Changes below:
**
** Added prototypes: UtilGetAddrFromSymDesc, UtilGetOffsetFromAddrDesc,
**    UtilSetAddrOffset, UtilSetEndAddrOffset
**
**    Rev 1.2   02 Dec 1991 18:04:20   john
** Added call to support on demand loading
** 
**    Rev 1.1   29 Nov 1991 19:48:58   brucea
** Added _SYMBLSVR to .h list
** Added #define's
** Added UtilSetAddrParams prototype
** 
**    Rev 1.0   18 Nov 1991 16:28:20   brucea
** Initial revision.
** 
** $Header:   S:/tbird/arccore/symbol/symutil.h_v   1.10   25 Jul 1994 11:10:58   brucea  $
**
** Copyright (C) 1991 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#define _SYMUTIL_

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMBOLS_LOADED  0L  // for on-demand, indicates symbols all loaded ;

#define DEFAULT_START_ADDR 0xFFFFFFFFL
#define DEFAULT_END_ADDR   0L

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

                       /**********************************
                        *                                *
                        *       FUNCTION PROTOTYPES      *
                        *                                *
                        **********************************/
BOOLEAN
UtilIsValidSymDescriptor(SYM_DESCRIPTOR symDesc);

RETCODE
UtilGetAddrFromSymDesc(SYM_DESCRIPTOR symDesc,
                       BASE_ADDRESS *baseAddr);

RETCODE
UtilGetSegSelFromSymDesc(SYM_DESCRIPTOR symDesc,
                         U16 FAR *addrSegSel,
                         U16 FAR *ldt);

RETCODE
UtilGetOffsetFromAddrDesc(SYM_DESCRIPTOR   symbolDesc,
                          DESCRIPTOR       addrDesc,
                          OFFSET_ADDR_TYPE *offsetAddr);

RETCODE
UtilSetAddrOffset(SYM_DESCRIPTOR   symbolDesc,
                  OFFSET_ADDR_TYPE offsetAddr,
                  DESCRIPTOR       addrDesc);

RETCODE
UtilSetEndAddrOffset(SYM_DESCRIPTOR   symbolDesc,
                     OFFSET_ADDR_TYPE endOffsetAddr,
                     DESCRIPTOR       addrDesc);
/*--------------------------------------------------------------------------*/
/* UtilOnDemandLoad
**
** Purpose:
**    Allows the symbol server to call the code loader so symbols for a 
**    module can be loaded on demand.
**
** Input parameters:
**    inputSymbol: a symbol descriptor to a func/block/module.  This will
**                 be used to find out if the modules symbols have been 
**                 loaded.
**
** Output parameters:
**
** Error: Reports error symbol is not a func/block/module or if the load
**        fails.
*/
/*--------------------------------------------------------------------------*/
RETCODE
UtilOnDemandLoad(SYM_DESCRIPTOR inputSymbol);

RETCODE
UtilSetAddrParams(BASE_INDEX       baseIndex,
                  OFFSET_ADDR_TYPE offsetAddr,
                  OFFSET_ADDR_TYPE offsetAddrEnd,
                  DESCRIPTOR       desc);

//------------------------------------------------------------------------
// UtilCmpTimestamp
//
// Purpose:
//       Return the difference between two timestamps;
//       Returns 0 if they are identical in all fields,
//          <0 if t1 < t2,
//          >0 if t1 > t2
//       where the value returned is the amount of difference, in
//       the first field where they differ.
//
// Input parameters:
//       time1: pointer to the first timestamp.
//       time2: pointer to the second timestamp.
//
// Output parameters:
//
//------------------------------------------------------------------------
S16 UtilCmpTimestamp(TIMESTAMP_TYPE *time1, TIMESTAMP_TYPE *time2);

//------------------------------------------------------------------------
// UtilDeleteTables
//
// Purpose:
//    Removes all tables and dynamically allocated memory
//
// Input parameters:
//
// Output parameters:
//
//------------------------------------------------------------------------
RETCODE UtilDeleteTables(VOID);

/******************************** E O F *************************************/