/****************************************************************************
**
**  Name:  trace.c
**
**  Description:
**     Provides shared data server handling routines for trace and trigger.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/flash/trace.c_v  $
** 
**    Rev 1.64   01 Mar 1994 10:49:06   john
** cputype is now global, removed fcn calls to get it
** 
**    Rev 1.63   23 Feb 1994 15:36:56   john
** Modified FwPs... call to be a dynamic call.  Modified to use GetFwPsTable
** call instead of an extern.
** 
**    Rev 1.62   23 Feb 1994 15:26:20   mindy
** Remove explicit max trace buffer update; periodic update sufficient by
** itself.
** 
**    Rev 1.61   04 Jan 1994 14:09:00   mindy
** Changes made to handle the possiblity of two fetches occurring within
** a single frame (only poss. in the 360 world).
** 
**    Rev 1.60   08 Nov 1993 20:28:52   mindy
** Created a new routine GetMacValidTraceBuffer.  THis is used by 
** ValidTraceBUffer and the new sds member SD_MAX_TRACE_BUFFER
** 
**    Rev 1.59   10 Sep 1993 10:25:58   mindy
** don't think this change will affect much but...
** 
**    Rev 1.58   01 Sep 1993 22:10:44   unknown
** a) Get number trace buffers was returning (1) when SdReadMember returned
**    a zero (Don't know what would cause this to happen...) so I'm now
**    keeping an old "good" copy of last number of trace buffers and return
**    this when I get zero value back.
** b) Removed event flag stuff for background process to "process" trace buffer
**    dq'r information.  No longer do it this way.
** c) Trace Buffer is broken up into chunks.  Each chunk is "processed" as
**    needed.
** d) Added trace read frame routine that only reads one word. Lower word
**    of status xilinx.  Every little bit helps!
** 
**    Rev 1.57   09 Aug 1993 07:19:32   mindy
** Fixed problem with instruction mode wrapping around the top.
** 
**    Rev 1.56   30 Jul 1993 09:08:14   ernie
** Set markerRoutine to a generic function.  The cpuType is no longer
** available at the time TrcHostTimeInit() is called.
** 
**    Rev 1.55   29 Jul 1993 15:32:10   ernie
** Fixed bug in GetEmonInfo caused by using wrong variable name.
** 
**    Rev 1.54   29 Jul 1993 11:40:56   ernie
** Added freeing of memory under error condition
** 
**    Rev 1.53   28 Jul 1993 13:32:14   ernie
** (For Mindy) Replaced old cpu32 linked cursor algorithm.  New is not working.
** 
**    Rev 1.52   28 Jul 1993 13:17:54   ernie
** 1. Changed emon_info task to have only one done flag set when all buffers'
**    emon_info has been calculated.
** 2. Changed logic in GetEmonInfo() to correctly calculate youngest frame
**    even when the trace buffer is not full.
** 
**    Rev 1.51   27 Jul 1993 20:09:26   ernie
** Fixed a bug where the background dequeuer marking task was colliding with
** the host reading trace buffer endpoints.  Created a set of 256 event flags
** to denote that the corresponding trace buffer's emon info has been
** calculated.  A task is kicked off when tracing stops to calculate each
** emon info and post to the flag.  The background task and the host interface
** (SDN_CHECK_BUFFER) both pend on the appropriate evflag.
** 
**    Rev 1.50   27 Jul 1993 12:47:46   ernie
** Increased maximum timeout for dequeuer marking.  68340 was timing out.
** 
**    Rev 1.49   22 Jul 1993 12:15:30   mindy
** a) added trace support for executing a background task to mark instruction
**    starts.
** b) changed linked cursor routine calculate an instruction address from
**    instruction starts.
** 
**    Rev 1.48   01 Jun 1993 12:27:02   ernie
** Accelerated trace search by creating optimized assembly language
** functions for searching for EMON frames.  Also changed search algorithm
** to search formware from the beginning and backward from the end for
** EMON frames to determine valid frame range.
** 
**    Rev 1.47   19 May 1993 15:30:10   john
** Corrected timeout error when IsValidTraceBuffer returned false.
** Fixed bug in IsValidTraceBuffer.  Current trace buffer was not being
** calculated correctly.
** 
**    Rev 1.46   20 Apr 1993 13:02:22   john
** Fixed trace routines to support 330/340
** 
**    Rev 1.45   10 Mar 1993 12:16:32   ernie
** Added support for show cycle triggering and tracing
** 
**    Rev 1.44   07 Jan 1993 07:31:50   mindy
** a) fixed problem with first bus cycle containing zeros.
** b) off by one when getting first clock cycle if doing a backwards read
** c) no callback on write on frame count.
** 
**    Rev 1.43   16 Dec 1992 15:25:40   mindy
** moved trace to fw
** 
**    Rev 1.42   10 Dec 1992 09:48:56   mindy
** (changed by ernie for mindy):
** Corrected read of trigger position in DqSyncAction().  The second argument
** to SdnReadPartialMember() is a byte offset, not an item offset.
** 
**    Rev 1.41   09 Dec 1992 13:11:38   mindy
** Moved dq'r to return a structure of dq lines so now host only feeds
** the dq data through the disassembler.
** 
**    Rev 1.40   02 Nov 1992 12:51:06   ernie
** 1. Fixed bug in DqSync() when >1 trace buffers (>> vs >>=).
** 2. Added abort capability for DqSync().
** 3. Streamlined sync-up code slightly by inlining functions used once.
** 
**    Rev 1.39   16 Oct 1992 09:46:38   ernie
** Fixed a problem with the EMBRK clb reprogramming when brkmode is off.
** Previously, the -BRK sequencer output would not cause EMBRK when the
** trace buffer was full (FILL=1) because of a misprogrammed EMBRK clb.
** 
**    Rev 1.38   15 Oct 1992 15:47:20   ernie
** Added dequeuer support for loop mode
** 
**    Rev 1.37   14 Oct 1992 14:45:26   ernie
** Added dequeuer sync-up support
** 
**    Rev 1.36   18 Sep 1992 12:56:46   ernie
** Added control for emon fall trigger enable. Used by go from bkpt.
** 
**    Rev 1.35   17 Sep 1992 15:16:30   ernie
** 1. Streamlined initialization code, and removed duplicated initialization
**    of some shared data members.  Trace is now programmed to PRE by
**    default as intended.
** 2. Accelerated trace search by moving the guts to assembly and using
**    block properties of the trace memory addressing translation.
** 
**    Rev 1.34   11 Sep 1992 12:37:32   ernie
** Removed kludge for fixing up trigger positions in the first 11 frames.
** This is now fixed in hardware (tman).
** 
**    Rev 1.33   04 Sep 1992 12:50:06   ernie
** Changed default trace setup to PRE and QUAL_BUS to match host defaults
** 
**    Rev 1.32   27 Aug 1992 14:53:54   ernie
** Added kludge for alpha release.  If trigger position is before the beginning
** of the trace buffer (possible because of pipelining between trace buffer
** and trigger machine), it is adjusted to the beginning before passing to the
** host.  User will see trigger at the wrong point, but at least the host
** won't hang.
** 
**    Rev 1.31   25 Aug 1992 10:17:08   ernie
** 1. Changed trace check routine to call SdWriteMemberIfChanged.  This allows
**    SD_TRACING to be updated elsewhere but still prevents multiple sd
**    item updates.
** 2. Fixed bug in event flag logic.  Now ER_OVF is allowed and expected
**    if trace system reprogramming did not occur.
** 3. Added write of SD_TRACING immediately after tracing is started.  This
**    insures the trace event gets to the host regardless of the timing
**    of the periodic monitoring task.
** 
**    Rev 1.30   21 Aug 1992 11:39:16   ernie
** Converted reconfigDone to evflag; added semaphore on TMAN read access
** 
**    Rev 1.29   20 Aug 1992 13:57:50   ernie
** Added acknowledge for enable sequencer
** 
**    Rev 1.28   19 Aug 1992 08:48:18   ernie
** Fixed polarity and masking of trace status info
** 
**    Rev 1.27   19 Aug 1992 08:14:02   ernie
** Changed TrcUpdateTask to write status members only if changed.  This
** allows shared data members to be used as events on the host to cause
** the status presenter to update the screen.  The polling task has also
** been changed to NOT write the trigger positions, since this is a lot
** of data and is really not useful until tracing stops.
** 
**    Rev 1.26   10 Aug 1992 09:25:06   ernie
** Added interlock on start trace to keep it from starting until trigger
** hardware reprogramming has completed.  This is sort of kludged right now
** so it can get in today's release.  Eventually the interlock will be
** changed to an event flag.
** 
**    Rev 1.25   29 Jul 1992 12:38:44   ernie
** Changed method used to enable sequencer during initialization.  Now uses
** the reconfigPending flag as an indicator that the sequencer was
** successfully enabled.  Until reconfigPending is cleared, the init routine
** continually reads SD_ENABLE_SEQUENCER to get any error code that may be
** returned by the shared data handler routine.
** 
**    Rev 1.24   27 Jul 1992 08:14:24   ernie
** 1. Changed initialization of UPDATES_PER_MINUTE to be a U32.
** 2. Added initialization for missing members in init routine.
** 3. Init routine changed to enable sequencer and wait until done before
**    returning.  This catches problems programming TMAN, for example,
**    during boot rather than the first time trace is programmed.
** 4. TrcTracingTask always writes result, even if errors occur.
** 5. DMA channel programming ok in init routine, but swapped when
**    trace is cleared and restarted.
** 
**    Rev 1.23   17 Jul 1992 13:13:28   ernie
** Changed shared data include file to sdprobe.h
** 
**    Rev 1.22   29 May 1992 14:13:02   john
** Changed order of the tman dma channels because the swat board
** was wired to the wrong channel.
** 
**    Rev 1.21   20 May 1992 14:26:34   john
** fixed sequencer ram programming sequence #define
** 
**    Rev 1.20   30 Apr 1992 08:17:58   mindy
** Removed disable of TOFF when emulation breaks since new probes have a
** working emon.
** 
**    Rev 1.19   24 Apr 1992 06:19:58   mindy
** Implemented ERnie's fix for break when trace store problem.
** 
**    Rev 1.18   16 Apr 1992 14:11:46   john
** Created local variable for trigger programming fix
** 
**    Rev 1.17   09 Apr 1992 08:21:18   mindy
** Changed trace initialization to do a program hardware automatically!
** also added some unregister to clean descriptor allocation.
** 
**    Rev 1.16   13 Feb 1992 10:57:10   mindy
** a) mask off the upper bits of the current sub buffer number since only
**    the bottom 10 bits are part of the sub buffer number.
** b) Added a ClearTriggerPositions() routine - zero out the trigger position
**    area whenever the sequencer is programmed or when a clear trace  is done.
**    The clear trigger position call is made at a strange place for the
**    program sequencer because it needs to be complete immediately for the
**    host.
** 
**    Rev 1.15   01 Feb 1992 09:34:42   ernie
** Added support routines to change framequal polarity
** 
**    Rev 1.14   28 Jan 1992 08:45:52   ernie
** Moved terminal count clb inputs to B and C.
** 
**    Rev 1.13   25 Jan 1992 05:27:06   ernie
** Fixed problem of trigger positions being written to the wrong place
** when using multiple trace buffers.
** 
**    Rev 1.12   24 Jan 1992 10:57:40   ernie
** reset DMA pointers after a clear sub buffer pointer
** 
**    Rev 1.11   14 Jan 1992 12:32:52   ernie
** Bug fixes found up to this point.
** 
**    Rev 1.10   02 Dec 1991 08:21:36   ernie
** Added SD_TRACE_EMPTY support.
** 
**    Rev 1.9   02 Dec 1991 08:05:38   ernie
** added trace search support
** 
**    Rev 1.8   15 Nov 1991 10:38:52   ernie
** Removed warnings
** 
**    Rev 1.7   24 Oct 1991 09:55:02   ernie
** Added support for 8 and 32 bit event recognizers
** 
**    Rev 1.6   14 Oct 1991 09:30:06   ernie
** 1. Moved trigger position memory to probeint.asm to give better control
**    over placement from linker.  Done to save flash prom space.
** 2. Changed MEM_SEQUENCER to real base of seqencer memory (0xD0C000) so
**    0xC000 no longer needs to be added.
** 
**    Rev 1.5   16 Sep 1991 10:05:10   ernie
** Finished implementing PDR2 release
** 
**    Rev 1.4   12 Aug 1991 14:07:06   ernie
** Incorporated review comments.  Code still untested.
** 
**    Rev 1.3   05 Aug 1991 09:46:14   ernie
** Coded.
**
**    Rev 1.2   30 Jul 1991 11:46:14   doug
** the trigger position has only one member, so code has to be different; a
** suggestion to change sdproc has been made to avoid this problem
** 
**    Rev 1.1   26 Jul 1991 15:50:40   doug
** initialize some of the trace shared data members to help the current
** trace server to be useful (no hardware yet).
** 
**    Rev 1.0   23 Jul 1991 15:29:04   jim
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/flash/trace.c_v   1.64   01 Mar 1994 10:49:06   john  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _MEMORY_H
#include "memory.h"
#endif
#ifndef _STDIO_
#include "stdio.h"
#endif
#ifndef _STDLIB_H
#include <stdlib.h>
#endif
#ifndef _CPMAP_
#include "cpmap.h"
#endif
#ifndef _DESCRIP_
#include "descrip.h"
#endif
#ifndef _DQ_
#include "dq.h"
#endif
#ifndef _ERROR_
#include "error.h"
#endif
#ifndef _FWPROBE_
#include "fwprobe.h"
#endif
#ifndef _FWPS_
#include "fwps.h"
#endif
#ifndef _INTERNAL_
#include "internal.h"
#endif
#ifndef _MEMORY_H
#include "memory.h"
#endif
#ifndef _REGCTRL_
#include "regctrl.h"
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"
#endif
#ifndef _SSHARED_
#include "sshared.h"
#endif
#ifndef _TRACE_
#include "trace.h"
#endif
#ifndef _TRIG_
#include "trig.h"
#endif
#ifndef _VRTX_
#include "vrtx.h"
#endif
#ifndef _XILINX_
#include "xilinx.h"
#endif

/*!!!*/
#undef PRIVATE
#define PRIVATE  

                        /****************************
                         *                          *
                         *  EXTERNAL DEFINITIONS    *
                         *                          *
                         ****************************/

extern CPU_TYPE cpuType;

                        /****************************
                         *                          *
                         *     LOCAL DEFINITIONS    *
                         *                          *
                         ****************************/
/*
** TMAN I/O configuration registers
*/
#define PFCRD     (IO_TMAN + 0x10)   /* read post fill counter value */
#define SBARD     (IO_TMAN + 0x00)   /* read subbuffer number (DMA) */
#define TPIRD     (IO_TMAN + 0x02)   /* read trigger pos indicator (DMA) */
#define CLRSBWR   (IO_TMAN + 0x00)   /* clear subbuffer and trace bfr cntr */
#define CLRTPIWR  (IO_TMAN + 0x02)   /* clear trigger pos indicator */
#define STARTWR   (IO_TMAN + 0x08)   /* start tracing */
#define SLRESWR   (IO_TMAN + 0x0A)   /* reset sequence level */
#define CNTR0RD   (IO_TMAN + 0x12)   /* read current contents of counter 0 */
#define CNTR1RD   (IO_TMAN + 0x1C)   /* read current contents of counter 1 */
#define TESTCLRRD (IO_TMAN + 0x14)   /* clear TRIC TEST bit */
#define TESTSETWR (IO_TMAN + 0x04)   /* set TRIC TEST bit */
#define CPUTRIGH  (IO_TMAN + 0x0E)   /* Cause trigger and halt */
#define STATRD    (IO_TMAN + 0x16)   /* read current seq level and trc state*/
#define OEWR      (IO_TMAN + 0x0C)   /* D0= TRIC OE pin (high to enable) */
                                     /* D1= Enable emonfall trigger */
#define STAT_TRACING_BIT   10   /* bit assignments for STATRD port */
#define STAT_SEQ_LEVEL_BIT 13

#define CLB_TPIMSB  0x0d02
#define CLB_DONE    0x0c01
#define CLB_RUNODD  0x0f05
#define CLB_TC0     0x0a09
#define CLB_TC1     0x0a0d
#define CLB_EMBRK   0x050d
#define CLB_EMF     0x0d05

#define GROUP_R_LOW  (0x400000 / sizeof(U16))
#define GROUP_S_LOW  (0x400800 / sizeof(U16))
#define GROUP_R_HIGH (0x000000 / sizeof(U16))
#define GROUP_S_HIGH (0x000800 / sizeof(U16))
#define GROUP_T_ALL (0x200000 / sizeof(U16))
#define GROUP_U_ALL (0x200800 / sizeof(U16))
#define INC_LSW (0x000000 / sizeof(U16))
#define INC_MSW (0x000200 / sizeof(U16))

#define QUALBIT() (((probeType==M68330_TB) || (probeType == M68340_TB)) \
  ? (0x1) : (0x4))  /* AS/DQ */
#define  QUAL_FRAME_BIT       0x8
#define SHOWQUALFR(frame) (((probeType==M68340_TB) || (probeType==M68330_TB)) \
  ? (((frame).groupSlsw & 0x03) == 1)   /* DS low, AS hi */ \
  : (((frame).groupSlsw & 0x06) == 4))  /* DS low, DQ hi */
#define SHOWQUALGR(group) (((probeType==M68340_TB) || (probeType==M68330_TB)) \
  ? ((group & 0x03) == 1)   /* DS low, AS hi */ \
  : ((group & 0x06) == 4))  /* DS low, DQ hi */
#define  MAX_FOR_BUS_CYCLE    50

typedef struct {
   BOOLEAN calculated;
   BOOLEAN allowAllCycles;
   U32 pre;
   U32 post;
}EMON_INFO;

static U16 cmp0ClbTable[] = { 0x0808, 0x0708, 0x0a08, 0x0b08, 0x0c08 };
static U16 cmp1ClbTable[] = { 0x080c, 0x070c, 0x0a0c, 0x0b0c, 0x0d0c };

static U32 trcBufMaskDbl[] =
   {0x00000,0x20000,0x30000,0x38000,0x3C000,0x3E000,0x3F000,0x3F800,0x3FC00};
static U32 trcBufMaskSgl[] =
   {0x00000,0x10000,0x18000,0x1C000,0x1E000,0x1F000,0x1F800,0x1FC00,0x1FE00};
static U32 trcFrmMaskDbl[] =
   {0x3FFFF,0x1FFFF,0x0FFFF,0x07FFF,0x03FFF,0x01FFF,0x00FFF,0x007FF,0x003FF};
static U32 trcFrmMaskSgl[] =
   {0x1FFFF,0x0FFFF,0x07FFF,0x03FFF,0x01FFF,0x00FFF,0x007FF,0x003FF,0x001FF};

static U32 trcBufMask=0, trcFrmMask=0x1ffff;

#define INIT_SEQ_VALUE  0xffff

static SEMAPHORE tmanSemaphore;
static EVFLAG reconfigPendingFlag;
#define RECONFIG_DONE  1
static EVFLAG emonInfoFlag;
#define EMON_INFO_DONE 1

static BOOLEAN emonFallEnable;

static EMON_INFO bufferEmon[256];

static U32 updateInterval;
static MBOX updateIntervalMbox;

static BOOLEAN showCycleEnable = FALSE;

static const U8 tmanRawBits[] = {
#include "tmanbits.h"
};

static DESCRIPTOR descSeqLevel;
static DESCRIPTOR descCurSubbuffer;
static DESCRIPTOR descTracing;
static DESCRIPTOR descCounter0;
static DESCRIPTOR descCounter1;
static DESCRIPTOR descNumTrcbufs;
static DESCRIPTOR descTraceMode;
static DESCRIPTOR descTraceEmpty;
static DESCRIPTOR descBrkOnTraceFull;
static DESCRIPTOR descTerminalCountA;
static DESCRIPTOR descTerminalCountB;
static DESCRIPTOR descMaxBuffer;

static BOOLEAN doubleVram;

typedef enum {
   TRACE_SEARCH_FORWARD, TRACE_SEARCH_BACKWARD, TRACE_SEARCH_END=0x7fff
} TRACE_SEARCH_DIRECTION;

U8 *instMarkers;
U32 markerAreaSize;
static U16 chunkSize;
static BOOLEAN *chunks;

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/
/*
** Shared Data Server Handler routines
*/
RETCODE PRIVATE TrcReconfigPendingTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcDiagnosticModeTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcTrigOutEnableTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcUpdatesPerMinuteTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcGetStatusTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcTracingTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcTracingAction(DESCRIPTOR desc,BOOLEAN *tracing);
RETCODE PRIVATE TrcEnableSequencerTask(DESCRIPTOR desc);
RETCODE PRIVATE EnableSequencerAction(BOOLEAN enable);
RETCODE PRIVATE TrcClearTraceTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcIncTraceBufferTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcSearchTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcSearchBuffer(DESCRIPTOR desc, BOOLEAN *found);
RETCODE PRIVATE TrcBufferCheckTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcLinkedCursorTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcLinkedCursor(DESCRIPTOR desc, BOOLEAN *instFrame);
RETCODE PRIVATE TrcResetSequenceLevelTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcReadTrace(DESCRIPTOR desc);
RETCODE PRIVATE TrcReadTraceTask(DESCRIPTOR desc);
RETCODE PRIVATE TrcWriteLengthTask(DESCRIPTOR desc) ;
RETCODE PRIVATE TrcNumBuffersTask(DESCRIPTOR desc);
/*
** Other local routines
*/
RETCODE PRIVATE TrcWriteStatus(BOOLEAN alwaysWrite);
_far VOID TrcUpdateTask(VOID);
_far VOID TrcMonitorTask(VOID);
VOID PRIVATE WriteTraceFrame(U32 frame, TRACE_FRAME result);
VOID PRIVATE VramInit(VOID);
VOID PRIVATE VramClearSam(VOID);
VOID PRIVATE EnableTMAN(VOID);
BOOLEAN SearchSingleTraceBlock(U32 frame, U32 *blockSize,EVTREC_RANGE *event);
BOOLEAN SearchDoubleTraceBlock(U32 frame, U32 *blockSize,EVTREC_RANGE *event);
BOOLEAN SearchSingleTraceBlockReverse(U32 frame, U32 *blockSize,
                                      EVTREC_RANGE *event);
BOOLEAN SearchDoubleTraceBlockReverse(U32 frame, U32 *blockSize,
                                      EVTREC_RANGE *event);
BOOLEAN SearchSingleEmonBlock(U32 frame, U32 *blockSize);
BOOLEAN SearchDoubleEmonBlock(U32 frame, U32 *blockSize);
BOOLEAN SearchSingleEmonBlockReverse(U32 frame, U32 *blockSize);
BOOLEAN SearchDoubleEmonBlockReverse(U32 frame, U32 *blockSize);
BOOLEAN TrcFindForwardLiveOne(U8 **instMarkerPtr, U8 *stopPtr, U8 *wrapPtr, 
                              U8 *resetPtr);
BOOLEAN TrcFindReverseLiveOne(U8 **instMarkerPtr, U8 *stopPtr, U8 *wrapPtr, 
                              U8 *resetPtr);

RETCODE  GetOldestFrame(U16 buffer, U32 *oldest);
RETCODE HandleSplittingSearch(U16 buffer, U32 *frameNo, EVTREC_RANGE *event,
                              TRACE_SEARCH_DIRECTION dir, BOOLEAN *found);
RETCODE PRIVATE DoTraceSearch(U32 *startFrame, U32 numFrames,
            EVTREC_RANGE *event, TRACE_SEARCH_DIRECTION dir, BOOLEAN *found);
RETCODE PRIVATE DoEmonSearch(U32 *startFrame, U32 numFrames,
            TRACE_SEARCH_DIRECTION dir, BOOLEAN *found);
VOID FrameScoop(U16 buffer, U32 frame, U32 *before, U32 *after);
RETCODE TraceBufferEnds(U16 buffer, U32 *lowest, U32 *highest);
BOOLEAN ValidTraceBuffer(U16 buffer);
RETCODE GetStartingBusCycle(U16 buffer, U32 *frameNo, TRACE_FRAME *frame,
         BOOLEAN *foundOne);
BOOLEAN CompletedBusCycleFound(TRACE_FRAME rawFrame,TRACE_FRAME *busFrame,
                               BOOLEAN *showCycleQualified);
RETCODE GetEmonInfo(U16 buffer);
RETCODE PendForEmonInfo(VOID);
RETCODE ClearEmonInfoFlag(VOID);
RETCODE StartEmonInfoTask(VOID);
_far VOID TrcComputeEmonInfoTask(VOID);

U32 ConvMarkerPtrToPhysicalFrame(U8 *instMarkerPtr, U8 bitSet, U8 *markers);
RETCODE ProcessChunk(U16 buffer, BOOLEAN *chunkArray, U32 physFrame,
                     U32 *nextChunkPhysFrame, U32 *prevPhysFrame);

U16 GetMaxValidTraceBuffer(VOID);

RETCODE EXPORT TrcSetEmonFallEnable(BOOLEAN enable) {
   emonFallEnable = enable;
   EnableTMAN();
   return(GOOD);
}

RETCODE EXPORT TrcGetEmonFallEnable(BOOLEAN *enable) {
   *enable = emonFallEnable;
   return(GOOD);
}

RETCODE EXPORT TrcInit(VOID) {
   RETCODE err;
   DESCRIPTOR desc;
   MEMBER_NAME fullName[SD_MAX_NAME];
   LOOP_VAR i;
   U8 tmodCompatibility;

   emonFallEnable=TRUE;
/*
** Flag to require TMAN programming when trace system is started.
*/
   tmanSemaphore = sc_screate(1,PRIORITY,&err);
   if (err) return(err);
   reconfigPendingFlag = sc_fcreate(&err);
   if (err) return(err);
   sc_fclear(reconfigPendingFlag, RECONFIG_DONE, &err);
   if (err) return(err);
   emonInfoFlag = sc_fcreate(&err);
   if (err) return(err);
   sc_fclear(emonInfoFlag, EMON_INFO_DONE, &err);
   if (err) return(err);
   updateInterval = 0;
   sc_post ((char**)&updateIntervalMbox, (char *)&updateInterval, &err);
   if (err) return(err);
/* determine vram size and set doubleVram appropriately */
   if((err=SdnReadMember(SDN_TRACE_0_COMPATIBILITY,&tmodCompatibility))!=GOOD)
      return(err);
   doubleVram = (tmodCompatibility >= TMOD_40MHZ);
   /* initialize set of emon information to be not calcualted. */
   for (i=0;i<256;i++) bufferEmon[i].calculated = FALSE;
   ClearEmonInfoFlag();
/*
** Configure TMAN with default image so sequencer can be written
*/
   {
      DESCRIPTOR xlxDesc;
      RETCODE err1;
      if ((err = XlxOpen(XC3064, tmanRawBits, &xlxDesc)) != GOOD) return(err);
      err1 = XlxProgram(xlxDesc, XLX_TMAN);
      err = XlxClose(xlxDesc);
      if (err1) return (err1);
      if (err) return(err);
   }
   VramInit();
   EnableTMAN();
   _outb(SEQENBWR, SEQ_PROG);
   _outb(CLRSBWR,0);
   _outb(CLRTPIWR,0);

   if((err = SdnRegister(SDN_TRACE_MODE,TrcReconfigPendingTask,&desc))!=GOOD)
      return(err);

   {
      U16 data=1;
      if((err = SdnRegister(SDN_NUM_TRCBUFS,TrcNumBuffersTask,&desc))
         !=GOOD) return(err);
      if((err = SdnRegister(SDN_NUM_TRCBUFS,NULLPTR,&desc))
         !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
   }

   {
      BOOLEAN data=FALSE;
      if((err=SdnRegister(SDN_BRK_ON_TRACE_FULL,TrcReconfigPendingTask,&desc))
         !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err=SdnRegister(SDN_TRIC_DIAGNOSTIC_MODE,TrcDiagnosticModeTask,
         &desc)) != GOOD) return(err);
      if((err = SdnRegister(SDN_TRIC_DIAGNOSTIC_MODE,NULLPTR,&desc))!=GOOD)
         return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if ((err=SdUnRegister(desc)) != GOOD) return(err);
      if((err=SdnRegister(SDN_TRIGOUT_ENABLE,TrcTrigOutEnableTask,&desc))
         !=GOOD) return(err);
      if((err = SdnRegister(SDN_TRIGOUT_ENABLE,NULLPTR,&desc))!=GOOD)
         return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if ((err=SdUnRegister(desc)) != GOOD) return(err);
      if((err=SdnRegister(SDN_TRACE_GET_STATUS,TrcGetStatusTask,&desc))!=GOOD)
         return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err = SdnRegister(SDN_SET_TRACING,TrcTracingTask,&desc))!=GOOD)
         return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err = SdnRegister(SDN_CLEAR_TRACE,TrcClearTraceTask,&desc))!=GOOD)
         return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err = SdnRegister(SDN_INC_TRACE_BUFFER,TrcIncTraceBufferTask,&desc))
         !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err= SdnRegister(SDN_RESET_SEQUENCE_LEVEL,TrcResetSequenceLevelTask,
         &desc))!=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err =SdnRegister(SDN_ENABLE_SEQUENCER,TrcEnableSequencerTask,&desc))
         !=GOOD) return(err);
   }
   {
      U16 data=0;
      if((err= SdnRegister(SDN_TERMINAL_COUNT_A,TrcReconfigPendingTask,&desc))
         !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
      if((err= SdnRegister(SDN_TERMINAL_COUNT_B,TrcReconfigPendingTask,&desc))
         !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
   }

   {
      U32 data=0;
      if((err=SdnRegister(SDN_UPDATES_PER_MINUTE,TrcUpdatesPerMinuteTask,
         &desc)) !=GOOD) return(err);
      if((err = SdWriteMember(desc,&data,GOOD)) != GOOD) return(err);
   }

   for(i=0; i<NUM_TRACE; i++) {
      sprintf(fullName, "%s %d", SD_TRACE_BUFF_LEN, i);
      if((err=SdRegister(fullName,TrcReadTraceTask,&desc))!=GOOD) return(err);
   }
   if((err = SdnRegister(SDN_TRACE_WRITE_LENGTH,TrcWriteLengthTask,&desc))
      !=GOOD) return(err);
   if((err = SdnRegister(SDN_SEARCH_START_FRAME,TrcSearchTask,&desc)) != GOOD)
      return(err);
   if((err = SdnRegister(SDN_BUFFER_CHECK,TrcBufferCheckTask,&desc)) != GOOD)
      return(err);
   if((err=SdnRegister(SDN_LINKCURS_FRAME,TrcLinkedCursorTask,&desc))!=GOOD)
      return(err);
/*
** set up static descriptors for often-accessed sd members
*/ 
   if((err = SdnRegister(SDN_SEQUENCE_LEVEL,NULLPTR,&descSeqLevel))!=GOOD)
      return(err);
   if((err = SdnRegister(SDN_CURRENT_SUBBUFFER,NULLPTR,&descCurSubbuffer))
      !=GOOD) return(err);
   if((err= SdnRegister(SDN_TRACING,NULLPTR,&descTracing))!=GOOD) return(err);
   sprintf(fullName, "%s %d", SD_COUNTER_VALUE, 0);
   if((err = SdRegister(fullName,NULLPTR,&descCounter0))!=GOOD) return(err);
   sprintf(fullName, "%s %d", SD_COUNTER_VALUE, 1);
   if((err = SdRegister(fullName,NULLPTR,&descCounter1))!=GOOD) return(err);
   if((err = SdnRegister(SDN_NUM_TRCBUFS,NULLPTR,&descNumTrcbufs))!=GOOD)
      return(err);
   if((err = SdnRegister(SDN_TRACE_MODE,NULLPTR,&descTraceMode))!=GOOD)
      return(err);
   if((err = SdnRegister(SDN_TRACE_EMPTY,NULLPTR,&descTraceEmpty))!=GOOD)
      return(err);
   if((err = SdnRegister(SDN_BRK_ON_TRACE_FULL,NULLPTR,&descBrkOnTraceFull))
      !=GOOD) return(err);
   if((err = SdnRegister(SDN_TERMINAL_COUNT_A,NULLPTR,&descTerminalCountA))
      !=GOOD) return(err);
   if((err = SdnRegister(SDN_TERMINAL_COUNT_B,NULLPTR,&descTerminalCountB))
      !=GOOD) return(err);
   if((err = SdnRegister(SDN_MAX_TRACE_BUFFER,NULLPTR,&descMaxBuffer))
      !=GOOD) return(err);
   
   {
      BOOLEAN true=TRUE;
      if((err = SdWriteMember(descTraceEmpty,&true,GOOD))!=GOOD) return(err);
      ClearTriggerPositions();
   }
   {
      TRACE_MODE traceMode=TRACE_PRE;
      if((err = SdWriteMember(descTraceMode,&traceMode,GOOD))!=GOOD)
         return(err);
   }
   /* program trigger hardware, wait for result before returning */
   {
      BOOLEAN true = TRUE;
      if ((err = SdnWriteMember(SDN_ENABLE_SEQUENCER,&true,GOOD)) != GOOD)
         return(err);
      sc_fpend(reconfigPendingFlag,0,RECONFIG_DONE,AND_PEND,&err);
      if ((err = SdnReadMember(SDN_ENABLE_SEQUENCER,&true)) != GOOD)
         return(err);                     /* Sequencer enable failed */
   }
   sc_tcreate(TrcUpdateTask, 0, PRI_TRACE_UPDATE, &err);
   if (err) return(err);
   sc_tcreate(TrcMonitorTask, 0, PRI_TRACE_UPDATE, &err);
   if (err) return(err);

   return(GOOD);
}


RETCODE TrcHostTimeInit(VOID) {
   markerAreaSize = doubleVram ? 0x10000L : 0x8000L;
   if ((instMarkers = sc_gmem(markerAreaSize)) == NULL) return(ER_NO_MEM);
   chunkSize = doubleVram ? 256 : 128;
   if ((chunks = sc_gmem(sizeof(BOOLEAN)*NUM_SUBBUFFERS)) == NULL)
      return(ER_NO_MEM);
   return(GOOD);
}

/*
**  TrcReconfigPendingTask
**     A request has arrived which requires reloading the TMAN.  The request
**     is noted and when the sequencer is reenabled, the TMAN will be loaded
**     with the new parameters.
*/
RETCODE PRIVATE TrcReconfigPendingTask(DESCRIPTOR desc){
   RETCODE err;
   sc_fclear(reconfigPendingFlag,RECONFIG_DONE,&err);
   return(err);
}

/*
**  TrcNumBuffersTask
**     The number of trace buffer configuration has changed.  Using this
**     as a flag that we need to change the frame increment variables.
*/
RETCODE PRIVATE TrcNumBuffersTask(DESCRIPTOR desc) {
   U16 curNumBufs, numBufsIndex;
   RETCODE err;
   if((err=SdReadMember(desc,&curNumBufs))!=GOOD) return(err);
   for (numBufsIndex=0; curNumBufs>1; curNumBufs>>=1, numBufsIndex++) ;
   trcBufMask = doubleVram ? trcBufMaskDbl[numBufsIndex]
                             : trcBufMaskSgl[numBufsIndex];
   trcFrmMask = doubleVram ? trcFrmMaskDbl[numBufsIndex]
                             : trcFrmMaskSgl[numBufsIndex];
   return(TrcReconfigPendingTask(desc));
}
   
/*
**  TrcDiagnosticModeTask
**     Turns on or off the TRIC TEST bit.  When on, the TRIC generates a test
**     pattern of walking ones.
*/
RETCODE PRIVATE TrcDiagnosticModeTask(DESCRIPTOR desc){
   BOOLEAN testBit;
   RETCODE err;
   if ((err = SdReadMember(desc, &testBit)) != GOOD) return(err);
   if (testBit) _outb(TESTSETWR,0);
   else _inb(TESTCLRRD);
   return(GOOD);
}

/*
**  TrcTrigOutEnableTask
**     Turns on or off the external trigger out enable.
*/
RETCODE PRIVATE TrcTrigOutEnableTask(DESCRIPTOR desc){
   BOOLEAN bit;
   RETCODE err;
   if ((err = SdReadMember(desc, &bit)) != GOOD) return(err);
   if (bit) AssertTrigOutEnable();
   else DeassertTrigOutEnable();
   return(GOOD);
}

/*
**  TrcUpdatesPerMinuteTask
**     Sets up a VRTX task to periodically poll and write various trace system
**     conditions to the shared data server.  This is used by a host to get
**     periodic updates for real-time displays.  The items polled are:
**        1. SD_SEQUENCE_LEVEL
**        2. SD_CURRENT_SUBBUFFER
**        3. SD_COUNTER_VALUE (0 and 1)
**        4. SD_MAX_TRACE_BUFFER
*/
RETCODE PRIVATE TrcUpdatesPerMinuteTask(DESCRIPTOR desc) {
   RETCODE err;
   U32 updatesPerMinute;
   if ((err = SdReadMember(desc,&updatesPerMinute)) != GOOD) return(err);
   if (updatesPerMinute == 0) updateInterval = 0;
   else {
      updateInterval = ((60*SECOND) / updatesPerMinute);
      if (updateInterval == 0) updateInterval = 1;
   }
   sc_post ((char**)&updateIntervalMbox, (char *)&updateInterval, &err);
   return(err);
}

_far VOID TrcUpdateTask(VOID) {
   RETCODE err;
   U32 localUpdateInterval=0;               /* wait forever for first post */
   char *message;
   for (;;) {
      message = sc_pend((char**)&updateIntervalMbox,localUpdateInterval,&err);
      if (err == GOOD) localUpdateInterval = *((U32*)message);
      else if (err == ER_TMO) TrcWriteStatus(FALSE);
      else InternalError(err,"Trace Update sc_pend unknown error");
   }
}

_far VOID TrcMonitorTask(VOID) {
   RETCODE err;
   U8 value, curValue;
   for (;;) {
      sc_delay(SECOND/4);                    /* Check four times per second */
      sc_spend(tmanSemaphore, 0, &err);
      value = (U8) ((_inw(STATRD) >> STAT_TRACING_BIT) & 1);
      if( SdReadMember(descTracing, &curValue) == GOOD ) {
         if( curValue != value ) {
            SdWriteMember(descTracing, &value, GOOD);
            if( !value ) {
               // When tracing stops we need to go calculate the markers.
               memset(instMarkers,0,markerAreaSize);  // clear out all markers
               memset(chunks,0,NUM_SUBBUFFERS*sizeof(BOOLEAN));  // 1/subbuffer
               ClearDqFlushChunks();
               StartEmonInfoTask();
            }
         }
      }
      sc_spost(tmanSemaphore,&err);
   }
}

/*
**  TrcGetStatusTask
**     Reads then updates the trace system status.  When all status items have
**     been updated, firmware sets SD_TRACE_GET_STATUS back to FALSE.  The
**     items updated are:
**        1. SD_SEQUENCE_LEVEL
**        2. SD_CURRENT_SUBBUFFER
**        3. SD_COUNTER_VALUE (0 and 1)
*/
RETCODE PRIVATE TrcGetStatusTask(DESCRIPTOR desc){
   RETCODE err;
   BOOLEAN done=FALSE;
   if((err=TrcWriteStatus(TRUE))!=GOOD) return(err);
   return(SdWriteMember(desc,&done,GOOD));
}

RETCODE PRIVATE TrcWriteStatus(BOOLEAN alwaysWrite) {
   RETCODE err,err2;
   U16 value;
   sc_spend(tmanSemaphore, 0, &err2);
   value = (~(_inw(STATRD) >> STAT_SEQ_LEVEL_BIT)) & 3;
   err = SdWriteMemberIfChanged(descSeqLevel, alwaysWrite, &value,GOOD);
   value = (_inw(SBARD) & 0x3ff);
   if(!err)
      err = SdWriteMemberIfChanged(descCurSubbuffer,alwaysWrite,&value,GOOD);
   value = _inw(CNTR0RD) & 0x3ff;
   if(!err)
      err = SdWriteMemberIfChanged(descCounter0,alwaysWrite,&value,GOOD);
   value = _inw(CNTR1RD) & 0x3ff;
   if(!err)
      err = SdWriteMemberIfChanged(descCounter1,alwaysWrite,&value,GOOD);
   if( !err) {
      value = GetMaxValidTraceBuffer();
      if (value > 0) --value;  // don't decrement if 0
      err = SdWriteMemberIfChanged(descMaxBuffer,alwaysWrite,&value,GOOD);
   }   
   sc_spost(tmanSemaphore,&err2);
   return(err?err:err2);
}

/*
**  TrcTracingTask
**     Used by host software to manually start and stop tracing.  Also used by
**     start emulation commands to start the trace hardware before emulation
**     begins.  Writing TRUE causes tracing to begin immediately within the
**     current trace buffer.  Writing FALSE stops tracing after the current
**     trace buffer is filled.
*/
RETCODE PRIVATE TrcTracingTask(DESCRIPTOR desc){
   RETCODE err;
   BOOLEAN tracing;
   err = TrcTracingAction(desc,&tracing);
   return(SdnWriteMember(SDN_FW_TRACING_STATUS,&tracing,err));
}

RETCODE PRIVATE TrcTracingAction(DESCRIPTOR desc,BOOLEAN *tracing){
   U16 numTrcbufs, i;
   RETCODE err;
   BOOLEAN empty,false=FALSE,true=TRUE;
   if ((err = SdReadMember(desc, tracing)) != GOOD) return(err);
   if (*tracing) {
      sc_fpend(reconfigPendingFlag,0,RECONFIG_DONE,AND_PEND,&err);
      _outb(SEQENBWR, SEQ_PROG);   /* Clear lingering TMAN state */
      _outb(SEQENBWR, SEQ_STOP);  
      if((err = SdReadMember(descTraceEmpty,&empty))!=GOOD) return(err);
      if (!empty) VramClearSam();   /* Clear out any overrun frames */
      if ((err=SdReadMember(descNumTrcbufs,&numTrcbufs)) != GOOD) return(err);
      if (numTrcbufs == 1) {
         VramInit();        /* Start with QSF low in 1TB mode */
         EnableTMAN();
         _outb(CLRSBWR,0);  /* Start at beginning of trace store in 1TB mode*/
         ResetDMAPointer();
      }
      _outb(CLRTPIWR,0);
      _outb(STARTWR,0);             /* start trace */
      _outb(SEQENBWR, SEQ_RUN);     /* start sequencer */
      if((err = SdWriteMember(descTracing, &true, GOOD)) != GOOD) return(err);
      if((err = SdWriteMember(descTraceEmpty,&false,GOOD))!=GOOD) return(err);
      /* emon information bad now that we are starting to trace again. */
      for (i=0;i<256;i++) bufferEmon[i].calculated = FALSE;
      ClearEmonInfoFlag();
      // Kill marker task if it's still running from last time we stopped
      sc_tdelete(MARKER_TASK_ID,0,&err);// err just means task wasn't running.
   }
   else {
      _outb(CPUTRIGH,0);          /* Cause trigger and halt operation */
   }
   return(GOOD);
}

/*
**  TrcEnableSequencerTask
**     Turns sequencer on and off.  Used for stopping while trace system
**     parameters are reprogrammed. Enabling the sequencer actually causes
**     trace system reprogramming to occur.  All queued requests are
**     combined to generate the final xilinx config and setup parameters.
*/
RETCODE PRIVATE TrcEnableSequencerTask(DESCRIPTOR desc){
   BOOLEAN enable;
   RETCODE err,err2;
   if ((err = SdReadMember(desc, &enable)) != GOOD) return(err);
   /*
   **  Lower priority so that all other sd items in queue will complete
   **  before the sequencer is enabled.
   */
   sc_tpriority(0,PRI_DISPATCH_FUNC+1,&err);
   sc_spend(tmanSemaphore, 0, &err2);
   if (!err) err = EnableSequencerAction(enable);
   sc_spost(tmanSemaphore,&err2);
   err = SdnWriteMember(SDN_ENABLE_SEQUENCER_ACK, &err, err);
   return(err?err:err2);
}

RETCODE PRIVATE EnableSequencerAction(BOOLEAN enable) {
   BOOLEAN true=TRUE;
   RETCODE err;
   U16 clb;
   U32 reconfigDone;
   _outb(SEQENBWR, SEQ_STOP);
   if (enable) {
      _outb(SEQENBWR, SEQ_PROG);
      reconfigDone = sc_finquiry(reconfigPendingFlag,&err) & RECONFIG_DONE;
      if (err) return(err);
      if (!reconfigDone) {
         RETCODE err1;
         DESCRIPTOR xlxDesc;
         TRACE_MODE traceMode;
         BOOLEAN brkMode;
         U16 tcA, tcB;
         LOOP_VAR i;
         if ((err = XlxOpen(XC3064, tmanRawBits, &xlxDesc)) != GOOD)
            return(err);
         err1 = XlxCopyBitstream(xlxDesc);
         /*
         ** Modify TMAN Bitstream
         */
         /* Bit 7 of TPI counter is 0 in single vram mode */
         if ((err1 == GOOD) && !doubleVram)
            err1 = XlxModifyClb(xlxDesc,CLB_TPIMSB,XLX_G,0,0,0);

         /* In doubleVram, RUNODD clb must be cleared to enable odd bank */
         if ((err1==GOOD) && doubleVram) {
            err1 = XlxModifyClb(xlxDesc,CLB_RUNODD,XLX_F,0,0,0);
            if (err1==GOOD) err1=XlxModifyClb(xlxDesc,CLB_RUNODD,XLX_G,0,0,0);
         }

         /* Modify DONE clb for pre/ctr/post */
         if (err1 == GOOD) err1 = SdReadMember(descTraceMode,&traceMode);
         switch (traceMode) {
            case TRACE_PRE:
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,0,0,0); /* clr */
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,1,1,1); /* E */
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,4,4,1); /* QY */
               break;
            case TRACE_CENTER:
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,0,0,0); /* clr */
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,3,3,1); /* A*E */
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,CLB_DONE,XLX_G,4,4,1); /* QY */
               break;
            default:       /* No changes for POST mode */
               break;
         }

         /* If brk on trace full is OFF, remove from EMBRK clb */
         /* The reason is that the EMBRK clb is configured with base 'F', so
            the E input, instead of being one of the RAM inputs, acts as a
            multiplexer between function F and function G. (E low=F, high=G).
            The original equation is F=(B*~E)+(B*D)+(B*~C).  To make this
            into F=(B*~E)+(B*~C), the term (B*D*E*C) needs to be turned off.
            This means programming a 0 into function G (E high) for B*D*C.
          */
         if (err1==GOOD) err1 = SdReadMember(descBrkOnTraceFull,&brkMode);
         if ((!brkMode) && (err1==GOOD)) {
            err1=XlxModifyClb(xlxDesc,CLB_EMBRK,XLX_G,0x0D,0x0D,0); /*B*D*C*/
         }
         
         /* Program terminal counts */
         if (err1==GOOD) err1 = SdReadMember(descTerminalCountA, &tcA);
         if (err1==GOOD) err1 = SdReadMember(descTerminalCountB, &tcB);
         if (tcA==0) {     /* counter disabled -> program TC block to zero */
            if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,CLB_TC0,XLX_F,0,0,0);
            if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,CLB_TC0,XLX_G,0,0,0);
         } else {
            tcA--;
            for (i=0;i<5;i++,tcA>>=2) {
               clb = cmp0ClbTable[i];
               if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,clb,XLX_F,0,0,0);
               if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,clb,XLX_G,0,0,0);
               /* lsb=input B; msb=input C */
               if (err1==GOOD) err1=XlxModifyClb(xlxDesc,clb,XLX_F,
                  ((tcA&2)<<1)+((tcA&1)<<3),0xC,1);
               if (err1==GOOD) err1=XlxModifyClb(xlxDesc,clb,XLX_G,
                  ((tcA&2)<<1)+((tcA&1)<<3),0xC,1);
               if (err1!=GOOD) break;
            }
         }
         if (tcB==0) {     /* counter disabled -> program TC block to zero */
            if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,CLB_TC1,XLX_F,0,0,0);
            if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,CLB_TC1,XLX_G,0,0,0);
         } else {
            tcB--;
            for (i=0;i<5;i++,tcB>>=2) {
               clb = cmp1ClbTable[i];
               if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,clb,XLX_F,0,0,0);
               if (err1==GOOD) err1 = XlxModifyClb(xlxDesc,clb,XLX_G,0,0,0);
               if (err1==GOOD) err1=XlxModifyClb(xlxDesc,clb,XLX_F,
                  ((tcB&2)<<1)+((tcB&1)<<3),0xC,1);
               if (err1==GOOD) err1=XlxModifyClb(xlxDesc,clb,XLX_G,
                  ((tcB&2)<<1)+((tcB&1)<<3),0xC,1);
               if (err1!=GOOD) break;
            }
         }

         {
            static U16 pfClb[] = {
               0x0b01,0x0e01,0x0d01,0x0a01,0x0801,0x0701,0x0501,0x0201 };
            static U16 sbClb[] = {
               0x0c00,0x0b00,0x0e00,0x0d00,0x0a00,0x0800,0x0700,0x0500 };
            static U8 pfMask[] = { 4, 2, 2, 2, 2, 2, 2, 2 };
            U16 numTrcbufs, i;
            LOOP_VAR clb;
            if (err1==GOOD) err1 = SdReadMember(descNumTrcbufs,&numTrcbufs);
         /* Modify SBA chain for correct TSFILL operation */ 
            for (clb=0, i=numTrcbufs; clb<8; clb++, i>>=1) {
               if (i>2) { /* TBN counter */
                  /* XLX_G is already correct */
                  if (err1==GOOD)
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,0,0,0);
                  if (err1==GOOD)   /* QX*~E */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,4,5,1);
                  if (err1==GOOD)   /* B*~QX*A*E */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,0xB,0xF,1);
                  if (err1==GOOD)   /* B*QX*~A*E */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,0xD,0xF,1);
               }
               else if (i==2) { /* this clb is lsb of TBN counter */
                  if (err1==GOOD)
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_G,0,0,0);
                  if (err1==GOOD)     /* ~C*A */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_G,0x2,0x6,1);
                  if (err1==GOOD)     /* C*QX */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_G,0xC,0xC,1);
                  if (err1==GOOD)
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,0,0,0);
                  if (err1==GOOD)   /* QX*~E */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,4,5,1);
                  if (err1==GOOD)   /* B*~QX*E */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_F,0x9,0xD,1);
               }
               else {           /* this clb is part of SBN counter */
                  /* XLX_F is already correct */
                  if (err1==GOOD)
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_G,0,0,0);
                  if (err1==GOOD)     /* QX*A */
                     err1=XlxModifyClb(xlxDesc,sbClb[clb],XLX_G,0xA,0xA,1);
               }
               if (err1!=GOOD) break;
            }
         /* For >1 trace buffer, modify postfill counter logic */ 
            for (clb=0, i=numTrcbufs; i>1; i>>=1, clb++) {
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,pfClb[clb],XLX_G,0,0,0);
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,pfClb[clb],XLX_G,pfMask[clb],
                     pfMask[clb],1);
               if (err1==GOOD)
                  err1 = XlxModifyClb(xlxDesc,pfClb[clb],XLX_F,0,0,0);
               if (err1!=GOOD) break;
            }
         }
         if (err1 == GOOD) err1 = XlxProgram(xlxDesc, XLX_TMAN);
         err = XlxClose(xlxDesc);
         if (err1) return(err1);
         if (err) return(err);
      }
      if((err = SdWriteMember(descTraceEmpty,&true,GOOD))!=GOOD) return(err);
      VramInit();
      EnableTMAN();
      _outb(CLRSBWR,0);
      _outb(CLRTPIWR,0);
      ResetDMAPointer();
      _outb(SEQENBWR, SEQ_PROG);
      _outb(SEQENBWR, SEQ_STOP);
      _outb(SEQENBWR, SEQ_RUN);
      sc_fpost(reconfigPendingFlag,RECONFIG_DONE,&err);
      if ((err!=GOOD) && (err!=ER_OVF)) return(err);  /*ok if already posted*/
   }
   else if (!enable) {
      _outb(SEQENBWR, SEQ_PROG);
   }
   return(GOOD);
}

/*
**  TrcClearTraceTask
**     Resets trace buffer pointers to zero and initializes VRAM serial buffer
**     pointer.  Does not actually clear VRAM or side data file contents.
*/
RETCODE PRIVATE TrcClearTraceTask(DESCRIPTOR desc){
   BOOLEAN value;
   LOOP_VAR i;
   RETCODE err;
   if ((err = SdReadMember(desc, &value)) != GOOD) return(err);
   if (value) {
      VramInit();
      EnableTMAN();
      _outb(CLRSBWR,0);
      _outb(CLRTPIWR,0);
      ResetDMAPointer();
      if((err = SdWriteMember(descTraceEmpty,&value,GOOD))!=GOOD) return(err);
      ClearTriggerPositions();
      value = FALSE;
      for (i=0;i<256;i++) bufferEmon[i].calculated = FALSE;
      ClearEmonInfoFlag();
      if((err = SdWriteMember(desc,&value,GOOD)) != GOOD) return(err);
   }
   return(GOOD);
}

/*
**  TrcIncTraceBufferTask
**     Performs the equivalent of trigger-and-continue action.  TMAN DOES NOT
**     CURRENTLY SUPPORT THIS FUNCTION.
*/
RETCODE PRIVATE TrcIncTraceBufferTask(DESCRIPTOR desc){
   return(ER_NOT_SUPPORTED);
}

/*
**  TrcResetSequenceLevelTask
**     Writes to TMAN causing the sequencer level to be set to 0.  May be
**     called while sequencer is running.  Writes 0 to member when done.
*/
RETCODE PRIVATE TrcResetSequenceLevelTask(DESCRIPTOR desc){
   BOOLEAN value;
   RETCODE err;
   if ((err = SdReadMember(desc, &value)) != GOOD) return(err);
   if (value) {
      _outb(SLRESWR,0);
      value = FALSE;
      if ((err = SdWriteMember(desc,&value,GOOD)) != GOOD) return(err);
   }
   return(GOOD);
}

U16 *Frame2Addr(U32 frame) {
   U16 *vram;
   U32 row;
   PWORD *vramAlias = (PWORD *)&vram;
   vramAlias->selector = PL0_DATA_SEL;
   if (doubleVram) {
      row = (frame&0x3fe00)>>9;
      vramAlias->offset =
         (frame&0x1fe) +         /* column */
         ((row & 0x0101) << 12) +
         ((row & 0x00fc) << 11) +
         ((row & 0x0002) << 18) +
         ((frame&0x1)<<10);      /* odd/even bank */
   }
   else {
      row = (frame&0x1ff00)>>8;
      vramAlias->offset =
         ((frame&0xff)<<1) +     /* column */
         ((row & 0x0101) << 12) +
         ((row & 0x00fc) << 11) +
         ((row & 0x0002) << 18);
   }
   return(vram);
}

VOID EXPORT ReadTraceFrame(U32 frame, TRACE_FRAME *result) {
   U16 *vram;
   PWORD *vramAlias = (PWORD *)&vram;
   vram = Frame2Addr(frame);
   /*
   ** VRAM offset 0xxxxx is actually located at address 4xxxxx.  All other
   ** VRAM addresses match.
   */
   if (vramAlias->offset & 0x100000) {
      result->groupRlsw = vram[GROUP_R_HIGH + INC_LSW];
      result->groupRmsw = vram[GROUP_R_HIGH + INC_MSW];
      result->groupSlsw = vram[GROUP_S_HIGH + INC_LSW];
      result->groupSmsw = vram[GROUP_S_HIGH + INC_MSW];
   }
   else {
      result->groupRlsw = vram[GROUP_R_LOW + INC_LSW];
      result->groupRmsw = vram[GROUP_R_LOW + INC_MSW];
      result->groupSlsw = vram[GROUP_S_LOW + INC_LSW];
      result->groupSmsw = vram[GROUP_S_LOW + INC_MSW];
   }
   result->groupTlsw = vram[GROUP_T_ALL + INC_LSW];
   result->groupTmsw = vram[GROUP_T_ALL + INC_MSW];
}

VOID PRIVATE WriteTraceFrame(U32 frame, TRACE_FRAME result) {
   U16 *vram;
   PWORD *vramAlias = (PWORD *)&vram;
   vram = Frame2Addr(frame);
   if (vramAlias->offset & 0x100000) {
      vram[GROUP_R_HIGH + INC_LSW] = result.groupRlsw;
      vram[GROUP_R_HIGH + INC_MSW] = result.groupRmsw;
      vram[GROUP_S_HIGH + INC_LSW] = result.groupSlsw;
      vram[GROUP_S_HIGH + INC_MSW] = result.groupSmsw;
   }
   else {
      vram[GROUP_R_LOW + INC_LSW] = result.groupRlsw;
      vram[GROUP_R_LOW + INC_MSW] = result.groupRmsw;
      vram[GROUP_S_LOW + INC_LSW] = result.groupSlsw;
      vram[GROUP_S_LOW + INC_MSW] = result.groupSmsw;
   }
   vram[GROUP_T_ALL + INC_LSW] = result.groupTlsw;
   vram[GROUP_T_ALL + INC_MSW] = result.groupTmsw;
}

/*
**  TrcWriteLengthTask
**     Writes specified length of data found in SD_TRACE_WRITE_DATA to address
**     found in SD_TRACE_WRITE_ADDRESS in the trace buffer memory.
*/
RETCODE PRIVATE TrcWriteLengthTask(DESCRIPTOR desc) {
   RETCODE err;
   TRACE_FRAME tempFrame;
   U32 length;
   U32 frame;
   DESCRIPTOR tempDesc;
   LOOP_VAR frameCount;
   if ((err = SdReadMember(desc, &length)) != GOOD) return(err);
   if ((err = SdnRegister(SDN_TRACE_WRITE_ADDRESS,NULLPTR,&tempDesc)) != GOOD)
      return(err);
   if ((err = SdReadMember(tempDesc, &frame)) != GOOD) {
      SdUnRegister(tempDesc);
      return(err);
   }
   if ((err = SdUnRegister(tempDesc)) != GOOD) return(err);
   if ((err = SdRegister(SD_TRACE_WRITE_DATA,NULLPTR,&tempDesc)) != GOOD)
      return(err);
   for (frameCount=0; frameCount<length; frameCount++) {
      if ((err = SdReadPartialMember(tempDesc, frameCount*sizeof(TRACE_FRAME),
            sizeof(TRACE_FRAME), &tempFrame)) != GOOD) {
         SdUnRegister(tempDesc);
         return(err);
      }
      WriteTraceFrame(frame++,tempFrame);
   }

   if ((err = SdUnRegister(tempDesc)) != GOOD) return(err);
   return(GOOD);
}

/*
**  TrcSearchTask
**     Registered on SD_SEARCH_START_FRAME item.  Searches trace buffer
**     for a frame matching specified event.  Writes match frame to
**     SD_SEARCH_START_FRAME (if found), then writes TRUE or FALSE to
**     SD_FOUND_SEARCH_EVENT.
*/
RETCODE PRIVATE TrcSearchTask(DESCRIPTOR desc) {
   RETCODE err;
   BOOLEAN found;
   err = TrcSearchBuffer(desc, &found);
   return(SdnWriteMember(SDN_FOUND_SEARCH_EVENT,&found,err));
}
   
RETCODE PRIVATE TrcSearchBuffer(DESCRIPTOR desc, BOOLEAN *found) {
   RETCODE err;
   U16 buffer;
   S32 startFrame; 
   U32 physStartFrame;
   LOOP_VAR group;
   EVTREC_RANGE event[NUM_GROUPS];
   BOOLEAN emon;
   *found=FALSE;
   if((err=SdReadMember(desc,&startFrame))!=GOOD) return(err);
   if((err=SdnReadMember(SDN_SEARCH_BUFFER,&buffer))!=GOOD) return(err);
   if( !ValidTraceBuffer(buffer) ) return(ER_INVALID_BUFFER);
   if((err=SdnReadMember(SDN_SEARCH_EMON,&emon))!=GOOD) return(err);
   PendForEmonInfo();
   if( bufferEmon[buffer].allowAllCycles != emon ) {
      bufferEmon[buffer].allowAllCycles = emon;
      bufferEmon[buffer].calculated = FALSE;
      GetEmonInfo(buffer);
   }   
   physStartFrame = GetPhysicalFrame(buffer, startFrame);
   for (group=0; group<NUM_GROUPS; group++) {
      if((err=SdnReadMember(SDN_SEARCH_EVENT+group,&event[group]))!=GOOD)
         return(err);
      event[group].low  &= event[group].mask;
      event[group].high &= event[group].mask;
   }
   if((err=HandleSplittingSearch(buffer,&physStartFrame,event,
                                 TRACE_SEARCH_FORWARD,found))!=GOOD)
      return(err);
   if( *found ) {
      startFrame = PhysFrameToLogical(buffer, physStartFrame);
      if((err=SdWriteMember(desc,&startFrame,GOOD)) != GOOD ) return(err);
   }
   return(GOOD);
}
    
RETCODE HandleSplittingSearch(U16 buffer, U32 *frameNo, EVTREC_RANGE *event,
                              TRACE_SEARCH_DIRECTION dir, BOOLEAN *found) {
   RETCODE err;                              
   U32 highFrame, lowFrame, beforeFrames, afterFrames;
   FrameScoop(buffer,*frameNo,&beforeFrames,&afterFrames);
   if((err=TraceBufferEnds(buffer,&lowFrame,&highFrame))!=GOOD) return(err);
   if (dir == TRACE_SEARCH_FORWARD) {
      if( (*frameNo + afterFrames - 1) > highFrame ) {
            /*
            ** Search range wraps physical end of buffer.  Need to make two
            ** separate searches.  First search from frameNo to end of buffer.
            */
         U32 frameCount = highFrame - *frameNo + 1;
         if((err=DoTraceSearch(frameNo, frameCount, event, dir, found))!=GOOD)
            return(err);
         if( *found ) return(GOOD);
            /*
            ** Now search upward from start of buffer.
            */
         afterFrames -= frameCount;
         *frameNo = lowFrame;
      }
      if((err=DoTraceSearch(frameNo, afterFrames, event, dir, found))!=GOOD)
         return(err);
   } else {
      if(*frameNo < lowFrame + beforeFrames) {
         U32 frameCount = *frameNo + 1 - lowFrame;
         if((err=DoTraceSearch(frameNo, frameCount, event, dir, found))
            !=GOOD) return(err);
         if( *found ) return(GOOD);
         beforeFrames -= frameCount;
         *frameNo = highFrame;
      }
      if((err=DoTraceSearch(frameNo, beforeFrames+1, event, dir, found))
         !=GOOD) return(err);
   }
   return(GOOD);
}

RETCODE HandleSplitEmonSearch(U16 buffer, U32 *frameNo,
                              TRACE_SEARCH_DIRECTION dir, BOOLEAN *found) {
   RETCODE err;                              
   U32 highFrame, lowFrame, beforeFrames, afterFrames;
   FrameScoop(buffer,*frameNo,&beforeFrames,&afterFrames);
   if((err=TraceBufferEnds(buffer,&lowFrame,&highFrame))!=GOOD) return(err);
   if (dir == TRACE_SEARCH_FORWARD) {
      if( (*frameNo + afterFrames - 1) > highFrame ) {
            /*
            ** Search range wraps physical end of buffer.  Need to make two
            ** separate searches.  First search from frameNo to end of buffer.
            */
         U32 frameCount = highFrame - *frameNo + 1;
         if((err=DoEmonSearch(frameNo, frameCount, dir, found))!=GOOD)
            return(err);
         if( *found ) return(GOOD);
            /*
            ** Now search upward from start of buffer.
            */
         afterFrames -= frameCount;
         *frameNo = lowFrame;
      }
      if((err=DoEmonSearch(frameNo, afterFrames, dir, found))!=GOOD)
         return(err);
   } else {
      if(*frameNo < lowFrame + beforeFrames) {
         U32 frameCount = *frameNo + 1 - lowFrame;
         if((err=DoEmonSearch(frameNo, frameCount, dir, found))
            !=GOOD) return(err);
         if( *found ) return(GOOD);
         beforeFrames -= frameCount;
         *frameNo = highFrame;
      }
      if((err=DoEmonSearch(frameNo, beforeFrames+1, dir, found))
         !=GOOD) return(err);
   }
   return(GOOD);
}

RETCODE PRIVATE DoTraceSearch(U32 *startFrame, U32 numFrames,
            EVTREC_RANGE *event, TRACE_SEARCH_DIRECTION dir, BOOLEAN *found) {
   LOOP_VAR frame;
   /*
   ** Search each trace "block" for frame.  The Frame2Addr routine need
   ** be called only once per block to convert the frame number to address.
   ** Within a block, the next frame is easily calculated for either
   ** singleVram or doubleVram.  A block is 512 frames in doubleVram, or
   ** 256 frames in singleVram.
   */
   *found = FALSE;
   if (dir == TRACE_SEARCH_FORWARD) {
      if( doubleVram )
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(0x200-(frame&0x1ff), numFrames);
            if (SearchDoubleTraceBlock(frame, &blockSize, event)) {
               *found=TRUE;
               frame += blockSize;
               *startFrame = frame;
               break;
            }
            frame+=blockSize;
            numFrames-=blockSize;
         }
      else   /* singleVram */
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(0x100-(frame&0xff), numFrames);
            if (SearchSingleTraceBlock(frame, &blockSize, event)) {
               *found=TRUE;
               frame += blockSize;
               *startFrame = frame;
               break;
            }
            frame+=blockSize;
            numFrames-=blockSize;
         }
   } else {
      if( doubleVram )
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(1+(frame&0x1ff), numFrames);
            if (SearchDoubleTraceBlockReverse(frame, &blockSize, event)) {
               *found=TRUE;
               frame -= blockSize;
               *startFrame = frame;
               break;
            }
            frame-=blockSize;
            numFrames-=blockSize;
         }
      else   /* singleVram */
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(1+(frame&0xff), numFrames);
            if (SearchSingleTraceBlockReverse(frame, &blockSize, event)) {
               *found=TRUE;
               frame -= blockSize;
               *startFrame = frame;
               break;
            }
            frame-=blockSize;
            numFrames-=blockSize;
         }
   }
   return(GOOD);
}

RETCODE PRIVATE DoEmonSearch(U32 *startFrame, U32 numFrames,
            TRACE_SEARCH_DIRECTION dir, BOOLEAN *found) {
   LOOP_VAR frame;
   *found = FALSE;
   if (dir == TRACE_SEARCH_FORWARD) {
      if( doubleVram )
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(0x200-(frame&0x1ff), numFrames);
            if (SearchDoubleEmonBlock(frame, &blockSize)) {
               *found=TRUE;
               frame += blockSize;
               *startFrame = frame;
               break;
            }
            frame+=blockSize;
            numFrames-=blockSize;
         }
      else   /* singleVram */
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(0x100-(frame&0xff), numFrames);
            if (SearchSingleEmonBlock(frame, &blockSize)) {
               *found=TRUE;
               frame += blockSize;
               *startFrame = frame;
               break;
            }
            frame+=blockSize;
            numFrames-=blockSize;
         }
   } else {
      if( doubleVram )
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(1+(frame&0x1ff), numFrames);
            if (SearchDoubleEmonBlockReverse(frame, &blockSize)) {
               *found=TRUE;
               frame -= blockSize;
               *startFrame = frame;
               break;
            }
            frame-=blockSize;
            numFrames-=blockSize;
         }
      else   /* singleVram */
         for (frame=*startFrame; numFrames>0; ) {
            U32 blockSize = _min(1+(frame&0xff), numFrames);
            if (SearchSingleEmonBlockReverse(frame, &blockSize)) {
               *found=TRUE;
               frame -= blockSize;
               *startFrame = frame;
               break;
            }
            frame-=blockSize;
            numFrames-=blockSize;
         }
   }
   return(GOOD);
}

VOID PRIVATE VramInit(VOID) {
   U16 *vram;
   PWORD *vramAlias = (PWORD*)&vram;
   vramAlias->selector = PL0_DATA_SEL;
   vramAlias->offset = 0;
   *vram = 0;             /* Writes to physical addr 0 -- write xfr */
}

VOID PRIVATE VramClearSam(VOID) {
   U16 *vram;
   PWORD *vramAlias = (PWORD*)&vram;
   vramAlias->selector = PL0_DATA_SEL;
   if ((_inb(SBARD) & 1) != 0)
      vramAlias->offset = 0x100;    /* QSF bit is high; keep it high */
   else
      vramAlias->offset = 0;        /* QSF bit is low; keep it low */
   *vram = 0;                       /* Write transfer clears SAM */
}

VOID PRIVATE EnableTMAN(VOID) {
   _outb(OEWR, emonFallEnable ? 3 : 1);        /* enable TRIC outputs */
}

BOOLEAN EXPORT DoubleVRam(VOID) {
   return(doubleVram);
}

U32 EXPORT IncPhysicalFrame(U32 frame, S32 count) {
   return(((frame)&trcBufMask)|((frame)+(count))&trcFrmMask);
}

U16 EXPORT NumTraceBuffers(VOID) {
   static U16 oldNumTraceBuffers;
   U16 numTraceBuffers;
   if( SdnReadMember(SDN_NUM_TRCBUFS,&numTraceBuffers) ) return(1);
   if( numTraceBuffers ) oldNumTraceBuffers = numTraceBuffers;
   else numTraceBuffers = oldNumTraceBuffers;  // use old value if comes back 0
   return(numTraceBuffers);
}

U16 EXPORT NumSubBufsPerTraceBuffer(VOID) {
   return(NUM_SUBBUFFERS/NumTraceBuffers());
}

/*
** IncSubBuffer
**    Adds or subtracts count from the given sub buffer number.  This
**    handles wrapping results within a trace buffer (i.e.: keeps
**    results within the number of sub buffers per trace buffer range).
*/
U16 EXPORT IncSubBuffer(U16 subBuff, S16 count) {
   U16 numSubBuffers;
   numSubBuffers = NumSubBufsPerTraceBuffer();
   return( ((subBuff + count) & (numSubBuffers-1))
          | (subBuff & ~(numSubBuffers-1)) );
}

/*
** GetPostFillCount
**    Returns the number of sub buffers filled after the trigger.
**    Uses current trace mode (from shared data server) to calculate.
*/
typedef struct {
   U16 size;
   U16 postFill;
} POST_FILL_STRUCT;
#define  NUM_TB_SIZES         9   /* number of different trace buffer sizes */
static POST_FILL_STRUCT centerPostFill[NUM_TB_SIZES] =
   {{256,1},{128,3},{64,7},{32,15},{16,31},{8,63},{4,127},{2,255},{1,511}};
static POST_FILL_STRUCT postPostFill[NUM_TB_SIZES] =
   {{256,3},{128,7},{64,15},{32,31},{16,63},{8,127},{4,255},{2,511},{1,1023}};
U16 EXPORT GetPostFillCount(VOID) {
   TRACE_MODE trcMode;
   POST_FILL_STRUCT *arrayPtr;
   LOOP_VAR idx;
   if( SdnReadMember(SDN_TRACE_MODE,&trcMode) ) return(1);
   switch(trcMode) { 
      case TRACE_PRE: return(1);
      case TRACE_POST: arrayPtr = postPostFill; break;
      case TRACE_CENTER: arrayPtr = centerPostFill; break;
   }
   for( idx = 0; idx < NUM_TB_SIZES; idx++ ) {
      if( arrayPtr[idx].size == NumTraceBuffers() )
         return(arrayPtr[idx].postFill);
   }
   return(1);
}

U32 FrameNumberWithinTraceBuffer(U16 buffer, U32 frame) {
   U32 oldest, low, high;
   if( GetOldestFrame(buffer,  &oldest) ) return(0);
   if( frame >= oldest ) {
      /* simple case where frame and oldest relationship hasn't wrapped */
      return(frame-oldest);
   }
   if( TraceBufferEnds(buffer,&low,&high) ) return(0);
   return( (high - oldest + 1) + (frame - low) );
}

RETCODE GetEmonInfo(U16 buffer){
   static BOOLEAN getEmonSema = FALSE;
   if( !bufferEmon[buffer].calculated ) {
      U32 pre, post, oldest, youngest, frame, numFrames;
      pre = post = 0L;
      if( !getEmonSema && !bufferEmon[buffer].allowAllCycles ) {
         RETCODE err; 
         BOOLEAN fnd;
         getEmonSema = TRUE;
         if((numFrames=GetNumFramesInTraceBuffer(buffer))==0) {
            getEmonSema = FALSE;
            return(GOOD);
         }
         if((err=GetOldestFrame(buffer,&oldest))!=GOOD) {
            getEmonSema = FALSE;
            return(err);
         }
         if((err=GetYoungestFrame(buffer,&youngest))!=GOOD) {
            getEmonSema = FALSE;
            return(err);
         }
         frame = oldest;
         err=HandleSplitEmonSearch(buffer, &frame,TRACE_SEARCH_FORWARD,&fnd);
         pre = (fnd) ? FrameNumberWithinTraceBuffer(buffer,frame) : numFrames;
         if( !err && (pre < numFrames) ) {
            frame = youngest;
            err=HandleSplitEmonSearch(buffer,&frame,TRACE_SEARCH_BACKWARD,
                                      &fnd);
            if( fnd ) {
               post=numFrames-FrameNumberWithinTraceBuffer(buffer,frame)-1;
            }
         }
         getEmonSema = FALSE;
      }
      bufferEmon[buffer].pre = pre;
      bufferEmon[buffer].post = post;
      bufferEmon[buffer].calculated = TRUE;
   }
   return(GOOD);
}

U32 GetPreEmonCount(U16 buffer) {
   if( !bufferEmon[buffer].calculated ) {
      if (GetEmonInfo(buffer)) return(0);
   }
   return(bufferEmon[buffer].pre);
}

U32 GetPostEmonCount(U16 buffer) {
   if( !bufferEmon[buffer].calculated ) {
      if (GetEmonInfo(buffer)) return(0);
   }
   return(bufferEmon[buffer].post);
}

/*
** FrameScoop
**    Calculates the number of frames before and after the incoming
**    logical frame within the indicated trace buffer.
** Parameters:
**    input:
**       buffer:        which trace buffer to use
**       frame:         which frame to calculate information for.
**    output:
**       before:        number of frames before physical frame
**       after:         number of frames after physical frame (including
**                      physical frame)
*/
VOID FrameScoop(U16 buffer, U32 frame, U32 *before, U32 *after) {
   *before = 0;
   *after = 0;
   if( !TraceIsEmpty(buffer) ) {
      U32 numFrames=GetNumFramesInTraceBuffer(buffer);
      /* could also be no frames if no cycles collected with EMON off */
      if( (numFrames 
         - (GetPostEmonCount(buffer)+GetPreEmonCount(buffer))) == 0 ) return;
      *before = FrameNumberWithinTraceBuffer(buffer,frame);
      *after = numFrames - *before - GetPostEmonCount(buffer);
      *before -= GetPreEmonCount(buffer);
   }
}

/*
** TraceBufferEnds
**    Calculates the physical frame number of the lowest and highest
**    frames within the given trace buffer.  This has nothing to do with
**    frame ordering (i.e.: oldest to youngest) just returns the physical
**    frame number of the lowest and highest trace buffer frames within
**    the trace store.
*/
RETCODE TraceBufferEnds(U16 buffer, U32 *lowest, U32 *highest) {
   BOOLEAN full;
   *lowest = MaxNumFramesPerTraceBuffer() * buffer;
   full = TraceBufferFull(buffer);
   if( !full )
      *lowest += SubBufferStartOffset(buffer);
   if( full )
      *highest = (MaxNumFramesPerTraceBuffer() * (buffer+1)) - 1;
   else
      *highest = *lowest + GetNumFramesInTraceBuffer(buffer) - 1;
   return(GOOD);
}

S32 PhysFrameToLogical(U16 buffer, U32 frame) {
    /* number of frames from the oldest */
   return(FrameNumberWithinTraceBuffer(buffer,frame)
      - GetNumFramesBeforeTrigger(buffer));
}

RETCODE EXPORT TraceBufferInfo(U16 buffer, BOOLEAN emon, S32 *oldest, S32 *youngest){
   *oldest = 0;
   *youngest = 0;
   PendForEmonInfo();
   if( bufferEmon[buffer].allowAllCycles != emon ) {
      bufferEmon[buffer].allowAllCycles = emon;
      bufferEmon[buffer].calculated = TRUE;
      GetEmonInfo(buffer);
   }   
   if( !TraceIsEmpty(buffer) ) {
      U32 numFrames;
      if( (numFrames=GetNumFramesInTraceBuffer(buffer)) == 0)
         return(GOOD);    /* NO frames in trace buffer at ALL */
      if((numFrames-(GetPreEmonCount(buffer)+GetPostEmonCount(buffer)))==0)
         return(GOOD);  /* no EMON on cycles and debug emon is off */
      *oldest = -GetNumFramesBeforeTrigger(buffer) + GetPreEmonCount(buffer);
      *youngest = GetNumFramesAfterTrigger(buffer) 
                        - GetPostEmonCount(buffer);
   }
   return(GOOD);
}

U16 GetMaxValidTraceBuffer(VOID) {
   U16 currentTraceBuf, temp, maxNum;
   LOOP_VAR loopy;
   currentTraceBuf = (_inw(SBARD) & 0x3fe);
   maxNum = temp = NumTraceBuffers();

   /* figure out how far to shift the "currentTraceBuf" info to get */
   /* the actual trace buffer number without the sub-buffer info */
   for (loopy=0;loopy<10;loopy++, temp>>=1) {
      if (temp & 1) break;
   }
   /* shift out the sub-buffer information to get the trace buffer num */
   currentTraceBuf >>= (10-loopy);
   if( TraceStoreFull(currentTraceBuf) ) return(maxNum);
   return(currentTraceBuf);
}

/*
** ValidTraceBuffer
**    Determines if the incoming trace buffer is a valid trace buffer.
**    There's two conditions to check.  First is the trace store split
**    up into at least that many buffers and second has that trace buffer 
**    been filled yet.
*/
BOOLEAN ValidTraceBuffer(U16 buffer) {
   if( !buffer ) return(TRUE);
   if( buffer >= GetMaxValidTraceBuffer() ) return(FALSE);
   return(TRUE);
}
   
RETCODE PRIVATE TrcBufferCheckTask(DESCRIPTOR desc) {
   BOOLEAN emon;
   S32 oldest=0, youngest=0;
   U16 buffer;
   RETCODE err;
   err=SdReadMember(desc,&buffer);
   if( !ValidTraceBuffer(buffer) ) err=ER_INVALID_BUFFER;
   if( !err ) {
      PendForEmonInfo();
      err=SdnReadMember(SDN_BUFFER_CHECK_EMON,&emon);
      if( !err ) err = TraceBufferInfo(buffer, emon, &oldest, &youngest);
   }
   if( !err ) SdnWriteMember(SDN_BUFFER_OLDEST,&oldest,err);
   /* might write to YOUNGEST since Host is pending on this write. */
   SdnWriteMember(SDN_BUFFER_YOUNGEST,&youngest,err);
   return(GOOD);
}

RETCODE PRIVATE TrcLinkedCursorTask(DESCRIPTOR desc) {
   BOOLEAN instFrame;
   RETCODE err;
   err = TrcLinkedCursor(desc,&instFrame);
   return(SdnWriteMember(SDN_LINKCURS_INST,&instFrame,err));
}
   
RETCODE PRIVATE TrcLinkedCursor(DESCRIPTOR desc, BOOLEAN *instFrame) {
   BOOLEAN emon, foundOne;
   TRACE_FRAME frameData;
   S32 logFrame, frame;
   U32 address, frameNo;
   U16 buffer, count;
   RETCODE err;
   *instFrame = FALSE;
   if((err=SdReadMember(desc,&logFrame))!=GOOD) return(err);
   if((err=SdnReadMember(SDN_LINKCURS_BUFFER,&buffer))!=GOOD) return(err);
   if( !ValidTraceBuffer(buffer) ) return(ER_INVALID_BUFFER);
   if((err=SdnReadMember(SDN_LINKCURS_EMON,&emon))!=GOOD) return(err);
   if( bufferEmon[buffer].allowAllCycles != emon ) {
      bufferEmon[buffer].allowAllCycles = emon;
      bufferEmon[buffer].calculated = FALSE;
      GetEmonInfo(buffer);
   }
   if (cpuType == CPU32) {
      frameNo = GetPhysicalFrame(buffer,logFrame);
      if((err=GetStartingBusCycle(buffer, &frameNo, &frameData, &foundOne)) 
         !=GOOD) return(err);
      if( foundOne ) {
         *instFrame = (frameData.groupSlsw & 0x40) == 0;
         address = ((frameData.groupRmsw & 0xff)<<16) + (frameData.groupRlsw);
      }
   }
   else {
      // if it wasn't for looping instructions this same method would work
      // for both the CPU32 and the CPU16
      BOOLEAN second;
      frame = logFrame;
      if((err=TrcFindClosestNInst(buffer,&frame,-1,&count,&second))!=GOOD)
         return(err);
      frameNo = GetPhysicalFrame(buffer,frame);
      if((err=GetStartingBusCycle(buffer, &frameNo, &frameData, &foundOne)) 
         !=GOOD) return(err);
      if( foundOne ) {
         *instFrame = TRUE;
         address=((frameData.groupRmsw & 0xf) << 16) + (frameData.groupRlsw);
      }
   }
   if( foundOne ) {
      if((err=SdnWriteMember(SDN_LINKCURS_ADDRESS,&address,GOOD))!=GOOD)
         return(err);
   }
   return(GOOD);
}

/* 
**    GetTraceFrames
**       Reads numFrames frames of trace.  If weedOutEmon is TRUE then we
**    only return the frames with the EMON bit on.
*/
RETCODE GetTraceFrames(U16 buffer, U32 *frameNo, U32 numFrames, 
                       U32 *framesRead, TRACE_FRAME *frames){
   LOOP_VAR i;                 
   *framesRead = 0;
   for(i=0; i < numFrames; i++) {
      ReadTraceFrame(*frameNo,&frames[i]);
      if(((frames[i].groupSlsw&0x10)==0) /* find first frame with EMON on*/
         && !bufferEmon[buffer].allowAllCycles ) {
         RETCODE err;
         BOOLEAN fnd;
         if((err=HandleSplitEmonSearch(buffer,frameNo,
                                       TRACE_SEARCH_FORWARD, &fnd))!=GOOD)
            return(err);
         if( !fnd ) return(GOOD);
         ReadTraceFrame(*frameNo,&frames[i]);
      }
      /* only want data if EMON bit is on or debugEmon is on */
      if(((frames[i].groupSlsw&0x10)==0)
         && !bufferEmon[buffer].allowAllCycles ) return(GOOD);
      *frameNo = IncPhysicalFrame(*frameNo,1);
      (*framesRead)++;
   }
   return(GOOD);
}

/* !!! processor specific routine */
static BOOLEAN dataValid = FALSE;
BOOLEAN CompletedBusCycleFound(TRACE_FRAME rawFrame,TRACE_FRAME *busFrame,
                               BOOLEAN *showCycleQualified) {
   BOOLEAN qualified = FALSE;
   U16 statusGroup;
   PROBE_TYPE probeType;
   SdnReadMember(SDN_PROBE_TYPE, &probeType);

   if (probeType == M68040_TB) {
      if ((!dataValid) && ((rawFrame.groupSlsw & 0x01) == 0)) {  /* -TS low */
         /* address, status valid on this clock */
         busFrame->groupRlsw = rawFrame.groupRlsw;
         busFrame->groupRmsw = rawFrame.groupRmsw;
         busFrame->groupSlsw = rawFrame.groupSlsw;
         busFrame->groupSmsw = rawFrame.groupSmsw;
         *showCycleQualified = TRUE;
      } else if ((!dataValid) && *showCycleQualified &&
                 ((rawFrame.groupSlsw & 0x06) != 0x06)) {  /* -TA or -TEA low */
         /* data valid on this clock */
         busFrame->groupTlsw = rawFrame.groupTlsw;
         busFrame->groupTmsw = rawFrame.groupTmsw;
         *showCycleQualified=FALSE;
         dataValid = TRUE;
      } else if (dataValid && ((rawFrame.groupSlsw & QUAL_FRAME_BIT) == 0)) {
         qualified = TRUE;
      }
      return(qualified);
   }

   if ((showCycleEnable) && (SHOWQUALFR(rawFrame))) {
      /* address, status valid on this clock */
      busFrame->groupRlsw = rawFrame.groupRlsw; 
      busFrame->groupRmsw = rawFrame.groupRmsw; 
      busFrame->groupSlsw &= 0x40;
      busFrame->groupSlsw |= (rawFrame.groupSlsw & 0xffbf);
      busFrame->groupSmsw = rawFrame.groupSmsw; 
      *showCycleQualified = TRUE;
   } else if (showCycleEnable && *showCycleQualified) {
      /* data and framequal valid on following clock */
      busFrame->groupTlsw = rawFrame.groupTlsw;
      busFrame->groupTmsw = rawFrame.groupTmsw;
      *showCycleQualified=FALSE;
      dataValid = TRUE;
      qualified = TRUE;
   } else {
      if( (rawFrame.groupSlsw & QUALBIT()) == 0 ) {
         /* addr, data, status valid on this cycle */
         busFrame->groupRlsw = rawFrame.groupRlsw; 
         busFrame->groupRmsw = rawFrame.groupRmsw; 
         busFrame->groupSlsw &= 0x40;
         busFrame->groupSlsw |= (rawFrame.groupSlsw & 0xffbf);
         busFrame->groupSmsw = rawFrame.groupSmsw; 
         busFrame->groupTlsw = rawFrame.groupTlsw; 
         busFrame->groupTmsw = rawFrame.groupTmsw; 
         dataValid = TRUE;
      }
      if( (rawFrame.groupSlsw & QUAL_FRAME_BIT) == 0 ) {
         qualified = TRUE;
      }
   }

   /* get state of special status bits then set all other bits */
   statusGroup = (rawFrame.groupSlsw & 0x40) | ~0x40;
   busFrame->groupSlsw &= statusGroup;
   return(qualified);
}

/*
** GetStartingBusCycle
**    Need a special routine to handle getting the first bus cycle
**    since this routine needs to go backwards from the starting
**    frame until a completely valid bus cycle is found (all bits
**    have been defined).  Then using this frame information we start 
**    at the start frame and mesh in valid frame information until
**    a frame qualifier is found - indicating a bus cycle is complete.
*/         /* processor specific routine now!!! */
RETCODE GetStartingBusCycle(U16 buffer, U32 *frameNo, TRACE_FRAME *frame,
         BOOLEAN *foundOne) {
   BOOLEAN found, showCycleQualified;
   RETCODE err;
   TRACE_FRAME tempFrame;
   U32 before, after, numFrames, startFrame;
   PROBE_TYPE probeType;
   *foundOne = FALSE;
   startFrame = *frameNo;
   if ((err = SdnReadMember(SDN_PROBE_TYPE, &probeType)) != GOOD) return(err);
   frame->groupRlsw = frame->groupRmsw = frame->groupSlsw = frame->groupSmsw =
      frame->groupTlsw = frame->groupTmsw = 0;
   /* special status bits are active low so initialize as high */
   frame->groupSlsw = 0x40;
   FrameScoop(buffer,*frameNo,&before, &after);
   if( !after ) return(ER_END_OF_BUFFER);                    
   if( before < MAX_FOR_BUS_CYCLE ) numFrames = before;
   else numFrames = MAX_FOR_BUS_CYCLE;
   found = FALSE;
   /*
   ** 1. Go backwards until either the beginning of the trace buffer is
   **    encountered or the next previous bus cycle completion is detected.
   **
   **    Going backwards, show cycles are qualified when any frame is preceded
   **    by the show qualifier.
   */
   showCycleQualified = FALSE;
   while( numFrames-- ) {
      U16 *vram, groupS;  
      PWORD *vramAlias = (PWORD *)&vram;
      *frameNo = IncPhysicalFrame(*frameNo,-1);
      vram = Frame2Addr(*frameNo);
      if(vramAlias->offset&0x100000) groupS = vram[GROUP_S_HIGH+INC_LSW];
      else groupS = vram[GROUP_S_LOW + INC_LSW];
      if (showCycleEnable && showCycleQualified && (SHOWQUALGR(groupS)))
         found=TRUE;
      else found = ((groupS & QUAL_FRAME_BIT) == 0);
      showCycleQualified = TRUE;
      if (found) break;
   }
   /* Increment frame number to point to clock just past the end of previous
   ** bus cycle */
   if( found ) *frameNo = IncPhysicalFrame(*frameNo,1);
   /*
   ** 2. Go forward, picking up any data qualified along the way until
   **    we reach the specified start frame.
   */
   dataValid = FALSE;
   showCycleQualified = FALSE;
   while( *frameNo != startFrame ) {
      ReadTraceFrame(*frameNo, &tempFrame);
      *frameNo = IncPhysicalFrame(*frameNo,1);
      /* only want to look at emon On frames-skip frames with EMON=0 */
      if((tempFrame.groupSlsw & 0x10) == 0)
         continue;  /* don't care about state of debugEmon */
      CompletedBusCycleFound(tempFrame, frame, &showCycleQualified);
   }
   /*
   ** 3. Continue going forward until an entire bus cycle is gathered
   **    (indicated by dataValid = all data fields qualified AND
   **    frame qualified).
   **
   **    If this is the first frame of the trace buffer, there may not
   **    be qualified data available for all the fields.  In this case,
   **    dataValid will be false, and we will continue going forward thru
   **    the next frame.
   **
   **    If we reach the end of the trace buffer (after decrements to 0)
   **    without finding a fully qualified frame, we cannot gather a
   **    complete bus cycle, so return with *foundOne FALSE.
   */
   while( after-- ) {
      U32 framesRead;
      if((err=GetTraceFrames(buffer, frameNo, 1, &framesRead, &tempFrame)) 
         != GOOD) return(err);
      if( framesRead != 1 ) break;
      if( CompletedBusCycleFound(tempFrame,frame,&showCycleQualified)
            && dataValid ) {
         *foundOne = TRUE;
         break;
      }
   }
   return(GOOD);
}

/*
** GetNextBusCycle
**    Starting with the incoming frame information we start 
**    at the start Frame and mesh in valid frame information until
**    a frame qualifier is found - indicating a bus cycle is complete.
*/
RETCODE GetNextBusCycle(U16 buffer, U32 *frameNo, TRACE_FRAME *frame,
         BOOLEAN *foundOne) {
   RETCODE err;
   U32 numFrames, before, framesRead;
   TRACE_FRAME rawFrame;
   BOOLEAN showCycleQualified;
   PROBE_TYPE probeType;
   SdnReadMember(SDN_PROBE_TYPE, &probeType);
   *foundOne = FALSE;
   frame->groupSlsw |= 0x40;
   FrameScoop(buffer, *frameNo, &before, &numFrames);
   showCycleQualified = FALSE;
   if (probeType == M68040_TB) dataValid = FALSE;
   while(numFrames--) {
      if((err=GetTraceFrames(buffer, frameNo, 1, &framesRead, &rawFrame)) 
         != GOOD) return(err);
      if( framesRead == 0 ) return(GOOD);
      if( CompletedBusCycleFound(rawFrame,frame,&showCycleQualified) ) {
         *foundOne = TRUE;
         return(GOOD);
      }
   }
   /* no bus cycle frame found before end of buffer:
      foundOne being FALSE indicates this so there's
      no reason to error out.
    */
   return(GOOD); 
}

RETCODE BackwardPositionFrameNumber(U16 buffer, U32 *frameNo,
                                    TRACE_CYCLES mode, U32 *numFrames){
   U32 availFrames, foundFrames, after, requestedFrames=*numFrames;
   RETCODE err;
   PROBE_TYPE probeType;
   if ((err = SdnReadMember(SDN_PROBE_TYPE, &probeType)) != GOOD) return(err);
   FrameScoop(buffer,*frameNo,&availFrames,&after);
   *numFrames = foundFrames = 0;
   if( requestedFrames > 256 ) return(ER_TOO_MANY_FRAMES);
   while( availFrames-- ) {
      U16 *vram, groupS;  
      PWORD *vramAlias = (PWORD *)&vram;
      vram = Frame2Addr(*frameNo);
      if(vramAlias->offset&0x100000) groupS = vram[GROUP_S_HIGH+INC_LSW];
      else groupS = vram[GROUP_S_LOW + INC_LSW];
      if( (groupS & 0x10) || bufferEmon[buffer].allowAllCycles ) {
         if (mode == CLOCK_CYCLE) foundFrames++;
         else if (mode == BUS_CYCLE) {
            if (showCycleEnable && (SHOWQUALGR(groupS)))
               foundFrames++;
            else if ((groupS&QUAL_FRAME_BIT) == 0) foundFrames++;
         }
      }
      if( foundFrames == requestedFrames ) break;
      *frameNo = IncPhysicalFrame(*frameNo,-1);
   }
   if( (availFrames == -1) && (mode == CLOCK_CYCLE) ) foundFrames++;
   if( !foundFrames ) return(ER_END_OF_BUFFER);
   *numFrames = foundFrames;
   return(GOOD);
}

RETCODE ForwardReadTrace(U16 buffer, U32 frameNo, TRACE_CYCLES mode,
                         U32 *numFrames, TRACE_INFO *traceData){
   RETCODE err;
   BOOLEAN firstTime = TRUE, foundOne;
   LOOP_VAR i;
   TRACE_FRAME *framePtr;
   U32 before, maxNumFrames, requestedFrames=*numFrames, prevInstFrame;
   PROBE_TYPE probeType;
   SdnReadMember(SDN_PROBE_TYPE, &probeType);
   FrameScoop(buffer, frameNo, &before, &maxNumFrames);
   // To support relative timestamp mode we need to get the frame
   // just prior to the starting frame.  Since we don't know what
   // mode we are we just assume it's always relative. First frame in
   // buffer won't have a relative timestamp value.
   prevInstFrame = frameNo;
   if( before ) {
      // !!! kludge need to backup an extra cycle since frameNo decr
      // after check.
      U32 tmpCount = 2,tmpFrame = frameNo;
      if((err=BackwardPositionFrameNumber(buffer, &tmpFrame, mode,
                                           &tmpCount)) != GOOD ) return(err);
      if( tmpCount ) prevInstFrame = tmpFrame;
   }
   traceData[0].rGroup = 0xffffffffL; // timestamp signature
   traceData[0].frameNumber = PhysFrameToLogical(buffer,prevInstFrame);

   if( !maxNumFrames ) return(ER_END_OF_BUFFER);  /* no frames to read */
   if( requestedFrames > 256 ) return(ER_TOO_MANY_FRAMES);
   if( requestedFrames > maxNumFrames ) requestedFrames = maxNumFrames;
   *numFrames = 0;
   for(i=1; i <= requestedFrames; i++) {
      U32 framesRead;
      framePtr = (TRACE_FRAME *)&traceData[i].rGroup;
      if( mode == BUS_CYCLE ) {
         if( firstTime ) {
            if((err=GetStartingBusCycle(buffer,&frameNo,framePtr,&foundOne))
               != GOOD ) return(err);
         }
         else {
            if (probeType == M68040_TB) frameNo--;
            if((err=GetNextBusCycle(buffer,&frameNo,framePtr,&foundOne))
               != GOOD ) return(err); 
         }
      }
      else if( mode == CLOCK_CYCLE ) {
         if((err=GetTraceFrames(buffer,&frameNo,1,&framesRead,framePtr))
            != GOOD ) return(err);
         foundOne = (framesRead != 0);
      }
      if( firstTime ) {
         if( !foundOne ) return(ER_END_OF_BUFFER);
         firstTime = FALSE;
      }
      else {/* we found at least one frame it's ok to fail now-just return */
         if( !foundOne ) return(GOOD);
      }
      (*numFrames)++;
      traceData[i].frameNumber = PhysFrameToLogical(buffer,
                              IncPhysicalFrame(frameNo, -1));
   }
   (*numFrames)++;   // incr for timestamp Marker
   
   return(GOOD);
}

/*
**
**  TrcReadTraceTask
**
**  Description:
**     Registered on SD_TRACE_BUFF_LEN field of all trace buffer windows.
**     Reads the specified frames from TMOD VRAM.  Now being changed to
**     handle checking for physical limits within a buffer.  Also if
**     SD_TRACE_BUFF_LEN field is negative a backward read is done.
**     Also SDN_FRAME_TYPE is read to determine if bus cycles or clock
**     cycles are being processed.
*/
RETCODE PRIVATE TrcReadTraceTask(DESCRIPTOR desc){
   RETCODE err, err2;
   if((err=TrcReadTrace(desc))!=GOOD) {
      MEMBER_INDEX index;
      TRACE_INFO traceData;
      DESCRIPTOR tempDesc;
      err2=SdGetMemberIndex(desc,&index);
      if(!err2) err=SdnRegister(SDN_TRACE_STORE+index,NULLPTR,&tempDesc);
      if( !err2 )
         err2=
           SdWritePartialMember(tempDesc,0,sizeof(TRACE_INFO),&traceData,err);
      SdUnRegister(tempDesc);
      return(err2);
   }
   return(GOOD);
}
      
RETCODE PRIVATE TrcReadTrace(DESCRIPTOR desc){
   RETCODE err,err1;
   MEMBER_INDEX index;
   TRACE_INFO *traceData;
   DESCRIPTOR tempDesc;
   S32 length, logFrame;
   U16 buffer;
   U32 frameNo, frameCount=0, memSize;
   BOOLEAN emon;
   TRACE_CYCLES frameMode;
   if ((err = SdReadMember(desc, &length)) != GOOD) return(err);
   /* clear out host count incase we error out */
   if((err=SdWriteMemberNoCallback(desc,&frameCount,GOOD))!=GOOD) return(err);
   if ((err = SdGetMemberIndex(desc,&index)) != GOOD) return(err);
   if ((err = SdnReadMember(SDN_TRACE_START_FRAME+index, &logFrame)) != GOOD)
      return(err);
   if ((err = SdnReadMember(SDN_ACTIVE_BUFFER+index, &buffer)) != GOOD)
      return(err);
   if( !ValidTraceBuffer(buffer) ) return(ER_INVALID_BUFFER);
   PendForEmonInfo();
   if( GetNumFramesInTraceBuffer(buffer) == 0 ) return(ER_END_OF_BUFFER);   
   frameNo = GetPhysicalFrame(buffer,logFrame);
   if ((err = SdnReadMember(SDN_BUFFER_EMON+index, &emon)) != GOOD)
      return(err);
   if( bufferEmon[buffer].allowAllCycles != emon ) {
      bufferEmon[buffer].allowAllCycles = emon;
      bufferEmon[buffer].calculated = FALSE;
      GetEmonInfo(buffer);
   }   
   if ((err = SdnReadMember(SDN_FRAME_TYPE+index, &frameMode)) != GOOD)
      return(err);
   if ((err = SdnRegister(SDN_TRACE_STORE+index,NULLPTR,&tempDesc)) != GOOD)
      return(err);
   if( length < 0 ) frameCount = 0 - length;
   else frameCount = length;
   memSize = sizeof(TRACE_INFO)*frameCount;
   if ((traceData = sc_gmem(memSize)) == NULL) {
      SdUnRegister(tempDesc);
      return(ER_NO_MEM);
   }
   if( length < 0 ) {   /* backwards trace type */
      err1=BackwardPositionFrameNumber(buffer, &frameNo,frameMode,&frameCount);
      if( err1 == GOOD )
         err1=ForwardReadTrace(buffer,frameNo,frameMode,&frameCount,traceData);
   }
   else {
      err1=ForwardReadTrace(buffer,frameNo,frameMode,&frameCount,traceData);
   }
   if((err=SdWriteMemberNoCallback(desc,&frameCount,GOOD))!=GOOD) {
      sc_rmem(traceData,memSize);
      SdUnRegister(tempDesc);
      return(err);
   }
   if( err1 || !frameCount ) frameCount = 1;   /* write at least one since
      host is waiting */
   if ((err = SdWritePartialMember(tempDesc,0,sizeof(TRACE_INFO)*frameCount,
         traceData,err1)) != GOOD) {
      sc_rmem(traceData,memSize);
      SdUnRegister(tempDesc);
      return(err);
   }
   if ((err = sc_rmem(traceData,memSize)) != GOOD) {
      SdUnRegister(tempDesc);
      return(err);
   }
   if ((err = SdUnRegister(tempDesc)) != GOOD) return(err);
   return(GOOD);
}

/**************************************************************************
**
** TrcSetShowCycleEnable
** TrcGetShowCycleEnable
**
**************************************************************************/
RETCODE EXPORT TrcSetShowCycleEnable(BOOLEAN enable) {
   showCycleEnable = enable;
   return(GOOD);
}
RETCODE EXPORT TrcGetShowCycleEnable(BOOLEAN *enable) {
   *enable = showCycleEnable;
   return(GOOD);
}

VOID TrcSetFrameAsMarkerInPairs(U32 frame, U8 couple) {
   // marks physical frame as inst "start". Does no boundry checking to speed
   // process up... might be too slow anyway!
   // couple:
   //       2 - first fetch
   //       1 - second fetch
   //       0 - used to say mark first fetch - FIRST - then second fetch
   U8 offset = (3 - (frame & 3))*2, bitSet;
   if( !couple ) {  // 360 - telling us to first mark First half.
      U8 fetches = instMarkers[(frame/4)] & (3 << offset);
      if( fetches ) couple = 1; // set second fetch
      else couple = 2;  // no marks already set so mark first half.
   }
   bitSet = (1*couple) << offset;
   instMarkers[(frame/4)] |= bitSet;
}

VOID TrcSetFrameAsMarker(U32 frame) {
   TrcSetFrameAsMarkerInPairs(frame,2);
}

RETCODE TrcFindClosestNInst(U16 buffer, S32 *frame, S16 count, U16 *actCount,
                            BOOLEAN *secondOne) {
   return(TrcFindNClosest(instMarkers,chunks,buffer,frame,count,actCount,
                          secondOne));
}

RETCODE TrcFindNClosest(U8 *markers, BOOLEAN *chunkArray, U16 buffer,
                        S32 *frame, S16 count, U16 *actCount,
                        BOOLEAN *secondOne) {
   U16 absCount;
   U32 physFrame = GetPhysicalFrame(buffer, *frame), oldPhysFrame,
                   nextChunkPhysFrame, prevChunkPhysFrame;
   S32 oldestFrame, newestFrame;
   U8 offset = (3 - (physFrame & 3))*2, oldestOffset, bitSet, *bufferEndPtr,
      *bufferStartPtr;
   U8 *instMarkerPtr = &markers[(physFrame/4)], *oldestMarkerPtr;
   RETCODE err;
   *actCount = 0;
   if( count > 0 ) return(1/*ER_WHY_WHY_WOULD_YOU_DO_THIS*/);
   if((err=TraceBufferInfo(buffer,FALSE,&oldestFrame,&newestFrame))!=GOOD)
      return(err);
   bufferStartPtr = &markers[(MaxNumFramesPerTraceBuffer()*buffer)/4];
   bufferEndPtr = bufferStartPtr + (MaxNumFramesPerTraceBuffer()/4) - 1;
   bitSet = 2 << offset;  // start with upper bit (i.e.: first fetch)
   if( count == 0 ) {
      // Case of finding the closest frame by going forward!
      // Go forward until first frame is found or until Newest frame
      // is reached (worst case).
      BOOLEAN found=FALSE;
      U8 yOffset, *yMarkerPtr, *endChunkPtr;
      U32 yPhysFrame;
      yPhysFrame = GetPhysicalFrame(buffer, newestFrame);
      yMarkerPtr = &markers[(yPhysFrame/4)];
      yOffset = (3 - (yPhysFrame & 3))*2;
      if((err=ProcessChunk(buffer,chunkArray,physFrame,&nextChunkPhysFrame,
                           &prevChunkPhysFrame)) !=GOOD) return(err);
      endChunkPtr = &markers[(nextChunkPhysFrame/4)];
      while( instMarkerPtr != yMarkerPtr ) {
         if( (bitSet & *instMarkerPtr) != 0 ) {
            found = TRUE;                      
            break;                             
         }
         bitSet >>= 1;                          // Check second half
         if( !(*instMarkerPtr) || !bitSet ) {
            while(1) {
               bitSet = 0x80;
               instMarkerPtr++;
               if( instMarkerPtr == (bufferEndPtr+1) ) {
                  // need to reset back to beginning of marker buffer area.
                  instMarkerPtr = bufferStartPtr;
               }
               if( instMarkerPtr == yMarkerPtr ) break;
               if( instMarkerPtr == endChunkPtr ) {
                  // have crossed chunk boundary - setup/check next chunk
                  physFrame = nextChunkPhysFrame;
                  if((err=ProcessChunk(buffer,chunkArray,physFrame,
                                      &nextChunkPhysFrame,&prevChunkPhysFrame))
                      !=GOOD) return(err);
                  endChunkPtr = &markers[(nextChunkPhysFrame/4)];
               }
               if( !TrcFindForwardLiveOne(&instMarkerPtr, endChunkPtr,
                                          bufferEndPtr+1,
                                          bufferStartPtr) ) {
                  U16 status;
                  U32 copy = ConvMarkerPtrToPhysicalFrame(instMarkerPtr,
                                                              bitSet,markers);
                  // If we can't find any markers in this chunk need to check
                  // EMON bit to make sure it's not off.
                  JustReadTraceStatus(copy,&status);
                  if( (status &0x10) == 0 ) { // if EMON is OFF!
                     BOOLEAN fnd;

                     if((err=HandleSplitEmonSearch(buffer,&copy,
                                    TRACE_SEARCH_FORWARD, &fnd))!=GOOD)
                        return(err);
                     if( !fnd ) return(ER_END_OF_BUFFER);
                     instMarkerPtr = &markers[(copy/4)];
                     if((err=ProcessChunk(buffer,chunkArray,copy,
                                          &nextChunkPhysFrame,
                                          &prevChunkPhysFrame))
                        !=GOOD) return(err);
                     endChunkPtr = &markers[(nextChunkPhysFrame/4)];
                     break;
                  }
                  else {
                     // if we can't found something in this chunk lets
                     // setup to check next chunk or exit.
                     instMarkerPtr = endChunkPtr-1;
                  }
               }
               else break;
            } 
         }
         if((err=TrcDqCheckAbort())!=GOOD) return(err);
      }
      // if we broke because we reached the newest frame froniter
      // we can check the frames in the last byte and see if we can
      // found our one frame (sigh...)
      if( !found ) {
         U8 yBitSet = 2 << yOffset;
         while( bitSet != yBitSet ) {
            if( (bitSet & *instMarkerPtr) != 0 ) {
               found = TRUE;
               break;
            }
            bitSet >>= 1;
         }     
      }
      if( !found ) return(ER_END_OF_BUFFER);
   }
   else {
      U8 *savInstMarkerPtr, lastGoodBitSet, *beginChunkPtr;
      // Else we are going backwards to find N number of instructions.
      absCount = abs(count);
      oldPhysFrame = GetPhysicalFrame(buffer, oldestFrame);
      oldestMarkerPtr = &markers[(oldPhysFrame/4)];
      oldestOffset = (3 - (oldPhysFrame & 3)) * 2;
      if((err=ProcessChunk(buffer,chunkArray,physFrame,&nextChunkPhysFrame,
                           &prevChunkPhysFrame))
         !=GOOD) return(err);
      
      beginChunkPtr = &markers[prevChunkPhysFrame/4];
      while( instMarkerPtr != oldestMarkerPtr ) {
         if( (bitSet & *instMarkerPtr) != 0 ){
            savInstMarkerPtr = instMarkerPtr;
            lastGoodBitSet = bitSet;
            (*actCount)++;
         }
         if( *actCount == absCount ) break;
         bitSet <<= 1;
         if( !(*instMarkerPtr) || !bitSet ) {
            while(1) {
               bitSet = 1;
               instMarkerPtr--;
               if( instMarkerPtr == bufferStartPtr-1 ) {
                  // need to wrap to top of marker buffer area.
                  instMarkerPtr = bufferEndPtr;
               }
               if( instMarkerPtr == oldestMarkerPtr ) break;

                              if( instMarkerPtr == beginChunkPtr ) {
                  // have crossed chunk boundary - setup/check next chunk
                  physFrame = prevChunkPhysFrame;
                  if((err=ProcessChunk(buffer,chunkArray,physFrame,
                                       &nextChunkPhysFrame,
                                       &prevChunkPhysFrame)) !=GOOD)
                     return(err);
                  beginChunkPtr = &markers[prevChunkPhysFrame/4];
               }
               if( !TrcFindReverseLiveOne(&instMarkerPtr, beginChunkPtr,
                                          bufferStartPtr-1, bufferEndPtr) ) {
                  U16 status;
                  U32 copy = ConvMarkerPtrToPhysicalFrame(instMarkerPtr,
                                                          bitSet,markers);
                  // If we can't find any markers in this chunk need to check
                  // EMON bit to make sure it's not off.
                  JustReadTraceStatus(copy,&status);
                  if( (status &0x10) == 0 ) { // if EMON is OFF!
                     BOOLEAN fnd;
                     U32 copy = physFrame;
                     if((err=HandleSplitEmonSearch(buffer,&copy,
                                    TRACE_SEARCH_BACKWARD, &fnd))!=GOOD)
                        return(err);
                     if( !fnd ) return(ER_END_OF_BUFFER);
                     instMarkerPtr = &markers[(copy/4)]; 
                     if((err=ProcessChunk(buffer,chunkArray,copy,
                                          &nextChunkPhysFrame,
                                          &prevChunkPhysFrame)) !=GOOD)
                        return(err);
                     beginChunkPtr = &markers[prevChunkPhysFrame/4];
                     break; // assume I have a good one.
                  }
                  else {
                     // if we can't found something in this chunk lets
                     // setup to check next chunk or exit.
                     instMarkerPtr = beginChunkPtr+1;
                  }
               }
               else
                  break;
            }
         }
         if((err=TrcDqCheckAbort())!=GOOD) return(err);
      }
      // if we broke because we reached the oldest frame froniter
      // we can check the frames in the last byte and see if we can
      // meet our count requirement.
      if( *actCount != absCount ) {
         U8 oldestBitSet = 2 << oldestOffset;
         while( bitSet != oldestBitSet ) {
            if( (bitSet & *instMarkerPtr) != 0 ) {
               // need to save where last good one found
               savInstMarkerPtr = instMarkerPtr;
               lastGoodBitSet = bitSet; 
               (*actCount)++;
            }
            if( *actCount == absCount ) break;
            bitSet <<= 1;
         }
         bitSet = lastGoodBitSet;   // reset to good bit for translation.
         instMarkerPtr = savInstMarkerPtr;
      }
      if( (*actCount != absCount) && (*actCount == 0) )
         return(ER_END_OF_BUFFER);
   }
   // If we made it here we have a good frame; now need to convert
   // instMarker/bitSet to physical frame and then to logical frame.
    *frame =  PhysFrameToLogical(buffer,
                                 ConvMarkerPtrToPhysicalFrame(instMarkerPtr,
                                                              bitSet,markers));
   *secondOne = ((bitSet & 0x55) != 0);
   return(GOOD);   
}

static RETCODE (*chunkingRoutine)(U16,U16,S32,S32);

VOID SetChunkRoutine(RETCODE (*chunker)(U16, U16, S32, S32)) {
   chunkingRoutine = chunker;
}

extern BOOLEAN *flushChunks;

RETCODE ProcessChunk(U16 buffer, BOOLEAN *chunkArray, U32 physFrame,
                     U32 *nextChunkPhysFrame, U32 *prevChunkPhysFrame) {
   U16 chunk, nextChunk, prevChunk, status;
   U32 chunkPhysStart, next, prev, copy;   
   S32 oldest, newest, chunkStart, chunkEnd;
   RETCODE err;
   chunk = physFrame / chunkSize;
   chunkPhysStart = chunk * chunkSize;
   if((err=TraceBufferInfo(buffer,FALSE,&oldest,&newest))!=GOOD)
      return(err);
   chunkStart = PhysFrameToLogical(buffer,chunkPhysStart);
   chunkEnd = chunkStart + chunkSize;
   JustReadTraceStatus(physFrame,&status);
   if( !chunkArray[chunk] && ((status &0x10) == 0) ) { // if EMON is OFF!
      BOOLEAN fnd;
      S32 endFrame;
      S32 curFrame;
      LOOP_VAR curChunk;
      copy = chunkPhysStart;
      // first check forward for EMON ON
      if((err=HandleSplitEmonSearch(buffer,&copy,
                                    TRACE_SEARCH_FORWARD, &fnd))!=GOOD)
            return(err);
      if( !fnd ) endFrame = newest;
      else endFrame = PhysFrameToLogical(buffer,copy);
      // now mark all the chunks between starting point and first frame
      // where EMON goes ON as calculated.
      curFrame = chunkStart + chunkSize - 1;  // send end frame as check point
      curChunk = chunk;
      while( curFrame < endFrame ) {
         chunks[curChunk] = TRUE;
         flushChunks[curChunk] = TRUE;
         curFrame += chunkSize;
         curChunk++;
         if( curChunk == NUM_SUBBUFFERS ) curChunk = 0;
      }
      // now check backwards.
      copy = chunkPhysStart;
      if((err=HandleSplitEmonSearch(buffer,&copy,
                                    TRACE_SEARCH_BACKWARD, &fnd))!=GOOD)
         return(err);
      if( !fnd ) endFrame = oldest;
      else endFrame = PhysFrameToLogical(buffer,copy);
      curFrame = chunkStart;  // send start frame as check point
      curChunk = chunk;
      while( curFrame > endFrame ) {
         chunks[curChunk] = TRUE;
         flushChunks[curChunk] = TRUE;
         curFrame -= chunkSize;
         curChunk--;
         if( !curChunk ) curChunk = NUM_SUBBUFFERS;
      }
   }
   if( ((chunkStart < oldest) && (chunkEnd < oldest))
      || ((chunkStart > newest) && (chunkEnd > newest)) ) {
      // chunk is off of range - just set flag and get out.
      chunkArray[chunk] = TRUE;
      return(GOOD);
   }
   nextChunk = chunk + 1;
   prevChunk = chunk - 1;
   if( nextChunk == ((MaxNumFramesPerTraceBuffer()*(buffer+1))/chunkSize) ) 
      nextChunk = (MaxNumFramesPerTraceBuffer() * buffer) / chunkSize;
   if( chunk == ((MaxNumFramesPerTraceBuffer() * buffer) / chunkSize) )
      prevChunk = (MaxNumFramesPerTraceBuffer() * (buffer+1)-1) / chunkSize;
   next = nextChunk*chunkSize;
   prev = ((prevChunk+1)*chunkSize)-1;
   if( chunkStart <= oldest ) {
      chunkStart=oldest;
      prev = GetPhysicalFrame(buffer, oldest);
   }
   if( chunkEnd >= newest ) {
      chunkEnd=newest;
      next = GetPhysicalFrame(buffer, newest);
   }
   if( !chunkArray[chunk] ) {    // chunk hasn't already been processed.
      if((err=chunkingRoutine(chunk, buffer,chunkStart,chunkEnd))!=GOOD)
         return(err);
      chunks[chunk] = TRUE;   // want to always mark inst chunks too since
                              // chunkingRoutine must do both
   }
   *nextChunkPhysFrame = next;
   *prevChunkPhysFrame = prev;
   return(GOOD);
}   

U32 ConvMarkerPtrToPhysicalFrame(U8 *instMarkerPtr, U8 bitSet, U8 *markers){
   U32 physFrame;
   U8 offset;
   physFrame = (instMarkerPtr - markers) * 4;
   offset = 0;
   while( (bitSet & 0xC0) == 0 ) {
      bitSet <<= 2;
      offset++;
   }
   physFrame += offset;
   return(physFrame);
}

U32 TrcMarkerSize(VOID) { return(markerAreaSize); }

_far VOID TrcComputeEmonInfoTask(VOID) {
   RETCODE err;
   U16 numTrcBufs, i;
   SdReadMember(descNumTrcbufs,&numTrcBufs);
   for (i=0; i<numTrcBufs; i++) GetEmonInfo(i);
   sc_fpost(emonInfoFlag, EMON_INFO_DONE, &err);
   KillSelf();
}

RETCODE StartEmonInfoTask(VOID) {
   RETCODE err;
   sc_tcreate(TrcComputeEmonInfoTask, EMONINFO_TASK_ID, PRI_DISPATCH_HIGH,
      &err);
   return(err);
}

RETCODE PendForEmonInfo(VOID) {
   RETCODE err;
   U32 flags;
   flags = sc_finquiry(emonInfoFlag, &err);
   if ((flags & EMON_INFO_DONE) == 0) StartEmonInfoTask();
   sc_fpend(emonInfoFlag, 0, EMON_INFO_DONE, OR_PEND, &err);
   return(err);
}

RETCODE ClearEmonInfoFlag(VOID) {
   RETCODE err;
   sc_fclear(emonInfoFlag, EMON_INFO_DONE, &err);
   return(err);
}

VOID EXPORT JustReadTraceStatus(U32 frame, U16 *status) {
   U16 *vram;
   PWORD *vramAlias = (PWORD *)&vram;
   vram = Frame2Addr(frame);
   /*
   ** VRAM offset 0xxxxx is actually located at address 4xxxxx.  All other
   ** VRAM addresses match.
   */
   if (vramAlias->offset & 0x100000) {
      *status = vram[GROUP_S_HIGH + INC_LSW];
   }
   else {
      *status = vram[GROUP_S_LOW + INC_LSW];
   }
}

   
/******************************** E O F ***********************************/
