#define _DIAGMCE_H

typedef struct {
   STATUS OpenShortError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
   U8 IOSignals[2];
} ErrorMceOpenShort;

typedef struct {
   STATUS MemoryError;
   U32 address;
} ErrorMceMemTest;

typedef struct {
   STATUS WorkingError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
} ErrorMceWorkTest;

typedef struct {
   STATUS ConnectorError;
   ErrorMceWorkTest Working[96];
} ErrorMceConnTest;

typedef struct {
   STATUS PullhighError;
   U8 EpStatus[2];
} ErrorMcePullhigh;


VOID InitialMceDiag(VOID);
RETCODE MceOpenShortTest(ErrorMceOpenShort *Value);
RETCODE McePullhighTest(ErrorMcePullhigh *Value);
RETCODE MceMemoryTest(U32 adrlength,ErrorMceMemTest *Value);
RETCODE MceConnectorTest(ErrorMceConnTest *Value);
