#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  $Log:   S:/tbird/arcmtat2/diag186/makefile.mav  $
#  
#     Rev 1.0   14 Jan 1997 10:39:38   gene
#  Initial revision.
#  
#     Rev 1.0   10 May 1996 16:12:04   jacky
#  Get file from ATL. V1.3
#
#  $Header:   S:/tbird/arcmtat2/diag186/makefile.mav   1.0   14 Jan 1997 10:39:38   gene  $
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = .
BIN = c:\mtat2_fw\diag186\bin
DIAGBIN = c:\mtat2_fw\diag186\bin
CCDIR = d:\C600\bin
INC = d:\C600\include
LNKDIR = d:\lnkloc\bin
TMPDIR = d:\

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(DIAGBIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(DIAGBIN)
.PATH.ABS = $(DIAGBIN)
.PATH.HEX = $(DIAGBIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
#CC = $(CCDIR)\bcc
MASM = $(CCDIR)\masm
#MASM = $(CCDIR)\tasm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = -c -f- -mm -v -vi -y -w
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
 $(CC) $(CFLAG) /I. /I$(INC) /Fo$(DIAGBIN)\$&.obj $&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fc$(SRC)\$&.COD /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fs$(TMPDIR)\ERR /Fo$(DIAGBIN)\$&.obj $(SRC)\$&.C
#$(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fc /Fs$(TMPDIR)\ERR /Fo$(DIAGBIN)\$&.obj $(SRC)\$&.C
#$(CC) $(CFLAG) -I. -I$(INC) -o$(DIAGBIN)\$&.obj $(SRC)\$&.C
# find ": error " $(TMPDIR)\err.lst > $&.lst
# find ": warning " $(TMPDIR)\err.lst >> $&.lst

.A00.obj:
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $&.A00,$(DIAGBIN)\$&,$(TMPDIR)\ERR;
# $(MASM) /Mx /Zi $&.Asm,$(DIAGBIN)\$&,$(SRC)\$&;
# $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(DIAGBIN)\$&,$(TMPDIR)\ERR;
#$(MASM) /Mx /Zi /w /z /i$(ASMSRC) $(ASMSRC)\$&.A00,$(DIAGBIN)\$&,$(TMPDIR)\ERR;
#find "error " $(TMPDIR)\err.lst > $&.lst
#find "warning " $(TMPDIR)\err.lst >> $&.lst

# define all objs
LNK_depends =  start.obj dgtmain.OBJ dgtlib.obj trcdiag.obj \
               trclib.obj emucomm.obj epm186.obj ovmem.obj \
               diagmce.obj trcflex.obj
#

DIAGNOST.BIN : DIAGNOST.OMF
 $(PROM)  $(DIAGBIN)\DIAGNOST.ABS TO $(DIAGBIN)\DIAGNOST.BIN ADDRESSES(0400H, 01FFFFH) CHECKSUM

DIAGNOST.OMF : DIAGNOST.ABS
 $(CV2OMF) $(DIAGBIN)\DIAGNOST.ABS TO $(DIAGBIN)\DIAGNOST.OMF

DIAGNOST.ABS : DIAGNOST.LNK
 $(LOC)  @&&!
            $(DIAGBIN)\DIAGNOST.LNK TO &
            $(DIAGBIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 CODE,&
                 CODE_END,&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END&
&                 XSEG,&
&                 NMCS2H&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               CODE(00400H), DATA_BEG(080000H),&
               STACK(08C000H),&
               XSEG(090000H),NMCS2H(0D0000H),&
&               DATA2(0A0000H),&
               DATA1(0C0000H),&
               DEBSYM(020000H),DEBTYP(028000H)),&
               GROUPS(DGROUP(080000H)) &
            ) &
            SEGSIZE(STACK(04000H)) &
            MAP &
            ST(INIT) &
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
start.obj : start.a00
epm186.obj : epm186.a00 cpm.equ cpmio.def depc.asm nmcs2h.def sio.equ xseg.def
ovmem.obj : ovmem.a00

# .C  condition definition
dgtmain.obj  : dgtmain.c emucomm.h dgtllfw.h dgttypes.h
emucomm.obj : emucomm.c emucomm.h dgtllfw.h
dgtlib.obj : dgtlib.c dgtlib.h dgtllfw.h
trcdiag.obj : trcdiag.c trcdiag.h
trclib.obj : trclib.c trclib.h
trcflex.obj : trcflex.c trcflex.h pipe.ttf pio.ttf pipe4.ttf p4pio.ttf
diagmce.obj : diagmce.c diagmce.h


#DIAGNOST.hex : DIAGNOST.abs
#$(OH86) $&
# $(CHKSUM) $&.hex 0 0d0000 0ffffb 0ffffe

DIAGNOST.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(DIAGBIN)\start.obj,$(DIAGBIN)\epm186.obj,&
             $(DIAGBIN)\dgtmain.obj,$(DIAGBIN)\ovmem.obj,&
             $(DIAGBIN)\dgtlib.obj,$(DIAGBIN)\trcdiag.obj,&
             $(DIAGBIN)\diagmce.obj,$(DIAGBIN)\trcflex.obj,&
             $(DIAGBIN)\trclib.obj,&
             $(DIAGBIN)\emucomm.obj,$(SRC)\MLIBCE.SSI TO $(DIAGBIN)\DIAGNOST.LNK
!

