
/****************************************************************************
**
** Name: trcdiag.h
**
** Description:
**   Header file for trigger and trace operation
**
** Status: PRELIMINARY
****************************************************************************/



#define _TRCDIAG_

#define P0Pipe       0x0E
#define P0Pio        0x01
#define P4Pipe       0x0D
#define P4Pio        0x02
#define MNTrace      0x03
#define SMain        0x04
#define CodeCov      0x08

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04

/* P4 control port corresponding bit define */

#define nOETRIG        0x08
#define nOETRCM        0x04
#define nOEBREG        0x02
#define EnByteWr       0x01

/* Serial EEPROM corresponding bit define */

#define PullSKHi       0xFD
#define PullSKLo       0xFC
#define PullCSHi       0x80
#define PullCSLo       0x00

/* I/O port address define1*/

#define P4CtrlAX      0xF325
#define LA0A1nOE      0xF33C
#define FClkSel0      0xF330
#define FClkSel1      0xF334

/* P0 port address define */

#define ReadP0Byte1    0xF300
#define ReadP0Byte2    0xF301
#define ReadP0Byte3    0xF302
#define ReadP0Byte4    0xF303
#define ReadP0CtrlPort 0xF304
#define P0CtrlPort     0xF307

/* P1 port address define */

#define ReadP1Byte1    0xF308
#define ReadP1Byte2    0xF309
#define ReadP1Byte3    0xF30A
#define ReadP1Byte4    0xF30B
#define ReadP1CtrlPort 0xF30C
#define P1CtrlPort     0xF30F

/* P2 port address define */

#define ReadP2Byte1    0xF310
#define ReadP2Byte2    0xF311
#define ReadP2Byte3    0xF312
#define ReadP2Byte4    0xF313
#define ReadP2CtrlPort 0xF314
#define P2CtrlPort     0xF317

/* P3 port address define */

#define ReadP3Byte1    0xF318
#define ReadP3Byte2    0xF319
#define ReadP3Byte3    0xF31A
#define ReadP3Byte4    0xF31B
#define ReadP3CtrlPort 0xF31C
#define P3CtrlPort     0xF31F

/* MAINCONTROL port address define */

#define RegByte0      0xF328
#define RegByte1      0xF329
#define RegByte2      0xF32A
#define RegByte3      0xF32B
#define RegByte4      0xF32C
#define MCtrlByte1    0xF32D
#define MCtrlByte2    0xF32E
#define MCtrlByte3    0xF32F
#define nRDMN         0xF328

#define ERR_TRIG       0x4000
#define ERR_PIPE_DONE  0x4001
#define ERR_P4_DONE    0x4002
#define ERR_MN_DONE    0x4003


                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/


RETCODE TestSportDataBus(U32 *ptr)  ;
RETCODE TestRportDataBus(U32 *ptr)  ;
RETCODE TestTportDataBus(U32 *ptr)  ;
RETCODE TestUportDataBus(U32 *ptr)  ;
RETCODE TestVportDataBus(U32 *ptr)  ;
RETCODE TestWportDataBus(U32 *ptr)  ;
RETCODE TestRportAddrBus(U32 *ptr)  ;
RETCODE TestSportAddrBus(U32 *ptr)  ;
RETCODE TestTportAddrBus(U32 *ptr)  ;
RETCODE TestUportAddrBus(U32 *ptr)  ;
RETCODE TestVportAddrBus(U32 *ptr)  ;
RETCODE TestWportAddrBus(U32 *ptr)  ;
RETCODE TestRSTrcBufDataBus(U32 *ptr) ;
RETCODE TestTUTrcBufDataBus(U32 *ptr) ;
RETCODE TestTPTrcBufDataBus(U32 *ptr) ;
RETCODE TestTSTrcBufDataBus(U32 *ptr) ;
RETCODE TestVWTrcBufDataBus(U32 *ptr) ;
RETCODE TestEventTrcBufDataBus(U32 *ptr) ;
RETCODE TestRSTrcBufAddrBus(U32 *ptr) ;
RETCODE TestTUTrcBufAddrBus(U32 *ptr) ;
RETCODE TestTPTrcBufAddrBus(U32 *ptr) ;
RETCODE TestVWTrcBufAddrBus(U32 *ptr) ;
RETCODE TestTSTrcBufAddrBus(U32 *ptr) ;

RETCODE TestSeqRAM(VOID)  ;
