$PAGEWIDTH(132)
$MOD186
NAME    CAN186
CODE    segment at 0
        assume cs:CODE
;
;
        org     00h
_canTop db      08h     dup(0)
;
        org     08h
_canVtr:
        dw      offset _canGetIf
        dw      0
;
        org     0Ch
_canStart:
;the following 2 routine must be placed here to calculate offset _canGetIf
_canSavePc:
        mov     ss,word ptr _canTop
        mov     sp,word ptr _canTop+2H
        iret
_canGetIf:
        mov     word ptr _canTop,ss
        mov     word ptr _canTop+2H,sp
        jmp     far ptr _canEnnd
;
        org     50h
_canStart2:
        org     6Ah
_canEndCode     label   byte
_canEnnd:
;
        jmp     far ptr _canStart
;
;
        org     70h
_canBuf1        label   byte
_canStack:
        db      10h     dup(0)
;the other routines could be placed here
;----------------------------------------------------------
; Used in Original Program as start entry
;----------------------------------------------------------
_canStCode      equ    offset _canStart
;----------------------------------------------------------
; Used in Short Program as start entry
;----------------------------------------------------------
_canStCode2     equ    offset _canStart2
;----------------------------------------
;get register
_getRegst:
	mov	word ptr _canBuf1,ax
	mov	word ptr _canBuf1+2,bx
	mov	word ptr _canBuf1+4,cx
	mov	word ptr _canBuf1+6,dx
	mov	word ptr _canBuf1+08H,bp
	mov	word ptr _canBuf1+0AH,si
	mov	word ptr _canBuf1+0CH,di
	mov	word ptr _canBuf1+0EH,ds
	mov	word ptr _canTop,es
        jmp     far ptr _canEnnd
_getReged:
;---------------------------------------
;save register
_saveRegst:
	mov	ax,word ptr _canBuf1
	mov	bx,word ptr _canBuf1+2
	mov	cx,word ptr _canBuf1+4
	mov	dx,word ptr _canBuf1+6
	mov	bp,word ptr _canBuf1+08H
	mov	si,word ptr _canBuf1+0AH
	mov	di,word ptr _canBuf1+0CH
	mov	ds,word ptr _canBuf1+0EH
	mov	es,word ptr _canTop
        jmp     far ptr _canEnnd
_saveReged:
;-----------------------------------------
;set parameter
_setParast:
	mov	es,word ptr _canBuf1   		;first address.
	mov	di,word ptr _canBuf1+2            
	mov	dx,word ptr _canBuf1+4          ;address length(bytes).
	mov	cx,word ptr _canBuf1+06h        ;address length(bytes).
	mov	bp,word ptr _canBuf1+08h        ;data count.
	mov	bx,word ptr _canBuf1+0ah        ;temp buffer
	mov	ds,word ptr _canBuf1+0ch 	;another address.
	mov	si,word ptr _canBuf1+0eh            
        jmp     far ptr _canEnnd
_setParaed:
;------------------------------------------
;read byte cx times from es:di
_disBytest:
        xor     bx,bx
dispByte1:
        mov     al,es:[di]              ;read from target/emm
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      notrdy3
        mov     _canBuf1[bx],al
        inc     di
        inc     bx
        loop    dispByte1
        mov     cl,10h                  ;let cx=16 for upload command
        jmp     far ptr _canEnnd
notrdy3:
	mov	word ptr _canBuf1,es		;not ready address
	mov	word ptr _canBuf1+2,di         
        jmp     far ptr _canEnnd
_disByteed:
;--------------------------------------
;read word cx/2 times from es:di
_disWordst:
        xor     bx,bx
        shr     cx,1                    ;divide by 2
dispWord1:
        mov     ax,es:[di]              ;read from target/emm
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      notrdy4
        mov     word ptr _canBuf1[bx],ax
        inc     di
        inc     di
        inc     bx
        inc     bx
        loop    dispWord1
        mov     cl,10h                  ;let cx=16 for upload command
        jmp     far ptr _canEnnd
notrdy4:
	mov	word ptr _canBuf1,es		;not ready address
	mov	word ptr _canBuf1+2,di         
        jmp     far ptr _canEnnd
_disWorded:
;--------------------------------------------
;write byte dx cx times to es:di,data count in bp
;verify in _canTop,1 need to verify,error flag in _canTop+1,1 is error
_wrBytest:
        mov     si,bp           ;temp buffer
	xor     bx,bx
	or	cx,cx		;check cx = 0 ?
	je      writeByte5      ;YES, SEGMENT BOUNDARY
WriteByte1:
	mov	al,_canBuf1[BX] 	;GET FILL DATA.
	MOV	es:[di],AL	;WRITE DATA TO MEMORY.
	cmp	byte ptr _canTop,1 	;VERIFY FLAG ON ?
	jne	writeByte2 	;NEED NOT VERIFY.
	cmp	al,es:[di]     	;CHECK SAME DATA ?
	je	writeByte2      ;VERIFY OK.
	jmp	error
writeByte2:
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error
	inc	di		;UPDATE WRITING POINTER
	or	di,di		;OVER SEGMENT ?
	jne	writeByte3      ;NOT OVER SEGMENT.
	mov	ax,es		;UPDATE SEGMENT.
	add	ax,1000H
	mov	es,ax		;SAVE TO SEGMENT REGISTER.
writeByte3:
	inc	bx		;UPDATE READING POINTER
	dec	bp		;UPDATE DATA STRING COUNT.
	jnz	writeByte4      ;ACCESSING NEXT.
	MOV	bp,si   	;RESTORE DATA STRING COUNT TO REGISTER.
	xor	bx,bx
writeByte4:
	loop	writeByte1
writeByte5:
	dec	dx		;
				;COMPLETED ?
	jge	writeByte1	;NOT YET
        xor     dx,dx           ;set dx=0,cx=16,bp=8 for download
        mov     cl,10h
        mov     bp,si
        jmp     far ptr _canEnnd
error:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_wrByteed:
;--------------------------------------------
; echo address
;error echo:_canBuf1 + 0   --> source address segment
;                      2   --> source address offset
;--------------------------------------------
_errWrst:
	mov	word ptr _canBuf1,es		;first address.
	mov	word ptr _canBuf1+2,di         
        jmp     far ptr _canEnnd
_errWred:
;---------------------------------------------
;write Word dx cx/2 times to es:di,data count in bp
;verify in _canTop,1 need to verify,error flag in _canTop+1,1 is error
_wrWordst:
	or	cx,cx		;check cx = 0 ?
	je      writeWord5      ;YES, SEGMENT BOUNDARY
WriteWord1:
        inc     bx
        cmp     bx,bp
        jb      WriteWord6
        xor     bx,bx
WriteWord6:
	mov	al,byte ptr _canBuf1[bx] 	;GET FILL DATA.
        inc     bx
        cmp     bx,bp
        jb      WriteWord7
        xor     bx,bx
WriteWord7:
	mov	ah,byte ptr _canBuf1[bx] 	;GET FILL DATA.
	MOV	es:[di],ax	;WRITE DATA TO MEMORY.
	cmp	byte ptr _canTop,1 	;VERIFY FLAG ON ?
	jne	writeWord2 	;NEED NOT VERIFY.
	cmp	ax,word ptr es:[di]     	;CHECK SAME DATA ?
	je	writeWord2      ;VERIFY OK.
	jmp	error1
writeWord2:
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error
	inc	di		;UPDATE WRITING POINTER
        inc     di
	cmp     di,2 		;OVER SEGMENT ?
	jnc	writeWord4      ;NOT OVER SEGMENT.
	mov	ax,es		;UPDATE SEGMENT.
	add	ax,1000H
	mov	es,ax		;SAVE TO SEGMENT REGISTER.
writeWord4:
        dec     cx
        dec     cx
	jne 	writeWord1
writeWord5:
	dec	dx		;
				;COMPLETED ?
	jge	writeWord1	;NOT YET
        xor     dx,dx           ;set dx=0,cx=16,bp=8 for download
        mov     cl,10h
        jmp     far ptr _canEnnd
error1:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_wrWorded:
;---------------------------------------------
; byte test of es:di,length dx cx
; error flag in _canTop+1,1 is error
_tstByte1st:
	or	cx,cx		;
	jne	testByte1       ;
	dec	dx		;UPDATE UPPER COUNT
testByte1:
	mov	ax,di		;GET WRITING DATA
	xor	al,ah		;EXCLUSIVE OR AND SAVE DATA IN AL REGISTER.
	mov	es:[di],al 	;WRITE MEMORY DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error2
	mov	bl,es:[di] 	;READ ALREADY WRITING DATA TO BE COMPARED.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error2
	cmp	al,bl		;
	jne	error2  	;SET ERROR FLAG, ERROR ADDRESS.
	not	al		;COMPLEMENT WRITE DATA
	mov	es:[di],al 	;WRITE COMPLEMENT DATA TO MEMORY.
	inc	di		;UPDATE MEMORY POINTER.
	or	di,di		;OVER SEGMENT ?
	jne	testByte2       ;NOT
	mov	ax,es		;ADJUST SEGMENT VALUE.
	add	ax,1000h	;
	mov	es,ax		;RESTORE
testByte2:
	dec	cx		;COUNT = 0?
	jne	testByte1       ;TEST NEXT MEMORY.
	dec	dx		;UPDATE UPPER COUNT.
	jge	testByte1       ;TEST NEXT MEMORY.
        jmp     far ptr _canEnnd
error2:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_tstByte1ed:
;check written data 
; byte test of es:di,length dx cx
; error flag in _canTop+1,1 is error
_tstByte2st:
	or	cx,cx		
	jne	testByte3       ;NEED TO UPDATE COUNT ?
	dec	dx		;
testByte3:
	mov	ax,di		;GET WRITED DATA.
	xor	al,ah		;
	not     al		;
	mov	bl,es:[di] 	;TEST WRITED DATA
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error3
	cmp	al,bl		;EQUAL WRITE DATA ?
	jne	error3  	;SET ERROR FLAG, ERROR ADDRESS.
	inc	di		;UPDATE OFFSET.
	or	di,di		;OVER SEGMENT
	jne	testByte4       ;
	mov	ax,es		;ADJUST SEGMENT
	add	ax,1000h	;
	mov	es,ax		;
testByte4:
	dec	cx		;
	jne	testByte3	;CHECK NEXT.
	dec	dx		;
	jge	testByte3       ;
        jmp     far ptr _canEnnd
error3:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_tstByte2ed:
;-----------------------------------------------
; word test of es:di,length dx cx
; error flag in _canTop+1,1 is error
_tstWord1st:
        test    cx,1
        je      testWord0
        inc     cx
        jne     testWord0
        inc     dx
testWord0:
	or	cx,cx		;
	jne	testWord1       ;
	dec	dx		;UPDATE UPPER COUNT
testWord1:
	mov	ax,di		;GET WRITING DATA
	mov	bx,di		;GET WRITING DATA
	xor	al,ah		;EXCLUSIVE OR AND SAVE DATA IN AL REGISTER.
        inc     bx
        xor     bl,bh
        mov     ah,bl
	mov	es:[di],ax 	;WRITE MEMORY DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error4
	mov	bx,es:[di] 	;READ ALREADY WRITING DATA TO BE COMPARED.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error4
	cmp	ax,bx		;
	jne	error4  	;SET ERROR FLAG, ERROR ADDRESS.
	not	ax		;COMPLEMENT WRITE DATA
	mov	es:[di],ax 	;WRITE COMPLEMENT DATA TO MEMORY.
	inc	di		;UPDATE MEMORY POINTER.
	inc	di		;UPDATE MEMORY POINTER.
	cmp     di,2 		;OVER SEGMENT ?
	jnc	testWord2       ;NOT
	mov	ax,es		;ADJUST SEGMENT VALUE.
	add	ax,1000h	;
	mov	es,ax		;RESTORE
testWord2:
	dec	cx		;COUNT = 0?
	dec	cx		;COUNT = 0?
	jne	testWord1       ;TEST NEXT MEMORY.
	dec	dx		;UPDATE UPPER COUNT.
	jge	testWord1       ;TEST NEXT MEMORY.
        jmp     far ptr _canEnnd
error4:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_tstWord1ed:
;check written data 
; word test of es:di,length dx cx
; error flag in _canTop+1,1 is error
_tstWord2st:
        test    cx,1
        je      testWord5
        inc     cx
        jne     testWord5
        inc     dx
testWord5:
	or	cx,cx		
	jne	testWord3       ;NEED TO UPDATE COUNT ?
	dec	dx		;
testWord3:
	mov	ax,di		;GET WRITED DATA.
	mov	bx,di		;GET WRITED DATA.
	xor	al,ah		;
        inc     bx
        xor     bl,bh
        mov     ah,bl
	not     ax		;
	mov	bx,es:[di] 	;TEST WRITED DATA
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error5
	cmp	ax,bx		;EQUAL WRITE DATA ?
	jne	error5  	;SET ERROR FLAG, ERROR ADDRESS.
	inc	di		;UPDATE OFFSET.
	inc	di		;UPDATE OFFSET.
	cmp     di,2 		;OVER SEGMENT
	jnc	testWord4       ;
	mov	ax,es		;ADJUST SEGMENT
	add	ax,1000h	;
	mov	es,ax		;
testWord4:
	dec	cx		;
	dec	cx		;
	jne	testWord3	;CHECK NEXT.
	dec	dx		;
	jge	testWord3       ;
        jmp     far ptr _canEnnd
error5:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_tstWord2ed:
;------------------------------------------------
;byte compare,starting source BP,DI,destination BX,SI,Length DX,CX
;error flag in _canTop+1, 1 is error                          
_comBytest:
	or	cx,cx
	jz	compByte5
compByte1:
        mov     es,bp           ;source address
	mov	al,es:[di] 	;GET SOURCE DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error6
	mov	byte ptr _canBuf1+4,al	;SAVE SOURCE READING DATA IN TEMP. BUFFER.
        mov     es,bx           ;destination address
	mov	al,es:[si]	;GET COMPARE DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error6
	mov	byte ptr _canBuf1+0ah,al	;SAVE DESTINATION READING IN TEMP. BUFFER
	cmp	byte ptr _canBuf1+4,al	;DATA EQUAL ?
	je	compByte2       ;EQUAL DATA.
	jmp	error6
compByte2:
	inc	di		;UPDATE READING POINTER
	or	di,di		;OVER SEGMENT ?
	jne	compByte3   	;NOT OVER SEGMENT.
	add	bp,1000H
compByte3:
	inc	si		;UPDATE READING POINTER
	or	si,si		;OVER SEGMENT ?
	jne	compByte4   	;NOT OVER SEGMENT.
	add	bx,1000H
compByte4:
	loop	compByte1     
compByte5:
	dec	dx		;
	jge	compByte1     	;NOT YET
        jmp     far ptr _canEnnd
error6:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_comByteed:
;error address
;error echo:_canBuf1 + 0   --> source address segment
;                      2   --> source address offset
;                      4   --> source data
;                      6   --> destination address segment
;                      8   --> destination address offset
;                      0ah --> destination data
_errComst:
	mov	word ptr _canBuf1,bp		;first address.
	mov	word ptr _canBuf1+2,di         
	mov	word ptr _canBuf1+6,bx          ;second address
	mov	word ptr _canBuf1+8,si         
        jmp     far ptr _canEnnd
_errComed:
;------------------------------------------------
;word compare,starting source BP,DI,destination BX,SI,Length DX,CX
;error flag in _canTop+1, 1 is error                          
_comWordst:
	or	cx,cx
	jz	compWord5
compWord1:
        mov     es,bp           ;source address
	mov	ax,word ptr es:[di] 	;GET SOURCE DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error7
	mov	word ptr _canBuf1+4,ax	;SAVE SOURCE READING DATA IN TEMP. BUFFER.
        mov     es,bx           ;destination address
	mov	ax,word ptr es:[si]	;GET COMPARE DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error7
	mov	word ptr _canBuf1+0ah,ax	;SAVE DESTINATION READING IN TEMP. BUFFER
	cmp	word ptr _canBuf1+4,ax	;DATA EQUAL ?
	je	compWord2       ;EQUAL DATA.
	jmp	error7
compWord2:
	inc	di		;UPDATE READING POINTER
	inc	di		;UPDATE READING POINTER
	or	di,di		;OVER SEGMENT ?
	jne	compWord3   	;NOT OVER SEGMENT.
	add	bp,1000H
compWord3:
	inc	si		;UPDATE READING POINTER
	inc	si		;UPDATE READING POINTER
	or	si,si		;OVER SEGMENT ?
	jne	compWord4   	;NOT OVER SEGMENT.
	add	bx,1000H
compWord4:
        dec     cx
        dec     cx
        jne 	compWord1     
compWord5:
	dec	dx		;
	jge	compWord1     	;NOT YET
        jmp     far ptr _canEnnd
error7:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_comWorded:
;-----------------------------------------------
;byte checksum,starting address ES DI, length DX CX
;checksum data in _canBuf1
;error flag in _canTop+1, 1 is error                          
_cheBytest:
	or	cx,cx		;COUNT =0 ?
	jne	chesumByte1	;DO NOT ADJUST UPPER COUNT DX.
	dec	dx		;ADJUST UPPER COUNT.
chesumByte1:
        clc			;RESET CARRY FLAG.
	xor	al,al		;RESET WORKING REGISTER
chesumbyte2:
	mov	bl,es:[di] 	;GET DATA
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      notrdy1
	add	al,bl		;ADD CHECKSUM DATA.
	adc	al,0		;ADD CARRY.
	inc	di		;UPDATE POINTER.
	or	di,di		;OFFSET = 64K ?
	jne	chesumByte3     ;DO NOT ADJUST DATA SEGMENT.
	mov	si,es		;
	add	si,1000h	;ADJUST TO NEXT 64K SEGMENT AREA.
	mov	es,si		;
chesumByte3:
	dec	cx      	;UPDATE LOWER COUNT
	jne	chesumByte2	;
	dec	dx		;UPDATE UPPER COUNT
	jge	chesumByte2	;
	mov	_canBuf1,al	;SAVE CHECKSUM DATA
        jmp     far ptr _canEnnd
notrdy1:
	mov	word ptr _canBuf1,es		;not ready address.
	mov	word ptr _canBuf1+2,di         
        jmp     far ptr _canEnnd
_cheByteed:
;-----------------------------------------------
;word checksum,starting address ES DI, length DX CX
;checksum data in _canBuf1
_cheWordst:
	or	cx,cx		;COUNT =0 ?
	jne	chesumWord1	;DO NOT ADJUST UPPER COUNT DX.
	dec	dx		;ADJUST UPPER COUNT.
chesumWord1:
        clc			;RESET CARRY FLAG.
	xor	ax,ax		;RESET WORKING REGISTER
chesumWord2:
	mov	bx,word ptr es:[di] 	;GET DATA
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      notrdy2
	add	ax,bx		;ADD CHECKSUM DATA.
	adc	ax,0		;ADD CARRY.
	inc	di		;UPDATE POINTER.
	inc	di		;UPDATE POINTER.
	or	di,di		;OFFSET = 64K ?
	jne	chesumWord3     ;DO NOT ADJUST DATA SEGMENT.
	mov	si,es		;
	add	si,1000h	;ADJUST TO NEXT 64K SEGMENT AREA.
	mov	es,si		;
chesumWord3:
	dec	cx      	;UPDATE LOWER COUNT
	dec	cx      	;UPDATE LOWER COUNT
	jne	chesumWord2	;
	dec	dx		;UPDATE UPPER COUNT
	jge	chesumWord2	;
	mov	word ptr _canBuf1,ax	;SAVE CHECKSUM DATA
        jmp     far ptr _canEnnd
notrdy2:
	mov	word ptr _canBuf1,es		;not ready address
	mov	word ptr _canBuf1+2,di         
        jmp     far ptr _canEnnd
_cheWorded:
;----------------------------------------------------
; byte search,starting address ES DI,length DX CX,data count BP
; data count temp buffer in ds,buffer pointer si,compare pattern bx=1
; data string in _canBuf1
_seaBytest:
searchByte1:
	mov	ah,_canBuf1[si]	;GET SEARCH DATA
	mov	al,es:[di] 	;GET MEMORY DATA
        cmp     byte ptr _canTop+2,bl   ;not ready?
        jz      serachByte9
	inc	di		;
	or	di,di		;OVER SEGMENT ?
	jne	searchByte3   
	mov	di,es		;
	add	di,1000h	;ADJUST SEGMENT
	mov	es,di
	xor	di,di		;RESET OFFSET
searchByte3:
	cmp	al,ah		;COMPARE DATA EQUAL ?
	jne	searchByte2     ;NOT EQUAL
	dec	bp		;DATA STRING SEARCH COMPLETED ?
	jne     searchByte4
serachByte9:
        jmp     far ptr _canEnnd
searchByte4:
        inc     si
searchByte5:
	dec	cx		;LOWER COUNT = 0 ?
	jne	searchByte1   
	dec	dx		;UPDATE UPPER COUNT
	jge	searchByte1   
	jmp	error8
searchByte2:    		;
	sub	di,si		;POINT TO THE 1ST BYTE OF DATA STRING
	mov	ax,si		;keep the di register content for usung later
	jnc	searchByte7     ;
	mov	si,es		;segment adjuestment
	sub	si,1000h	;
	mov	es,si		;
searchByte7:            	;
	xor	si,si		;INITIAL DATA PATTERN POINTER
	mov	bp,ds
;
	or	ax,ax		;if mis-matched at the first byte of data 
				;string, decrease counter by 1
	jne	searchByte8     ;
        jmp     searchByte5
searchByte8:            	;restore the counter to have a correct 
				;comparison length;
	dec	ax
	add	cx,ax
	jnc	searchByte1
	inc	dx
	jmp	searchByte1
error8:
	mov	byte ptr _canTop+1,bl    ;error flag
        jmp     far ptr _canEnnd
_seaByteed:
;-----------------------------------------------------
; search OK
; data count keep in _canTop+2
; result address segment in _canBuf1,offset in _canBuf1+2
_seaOKst:
        mov     ax,ds           ;data count     
	sub	di,ax   	;GET SEARCH OK LOCATION.
	mov	word ptr _canBuf1+2,di	;SAVE LOCATION IN BUFFER
	mov	ax,es		;
	jnc	searchByte6 
	sub	ax,1000h	;ADJUST SEGMENT
searchByte6:
	mov	word ptr _canBuf1,ax	;SAVE SEGMENT IN BUFFER
        jmp     far ptr _canEnnd
_seaOKed:
;-----------------------------------------------------
; byte input,port in dx,length in cx,echo data in _canBuf1
_inBytest:
	xor	si,si		;INITIAL POINTER
inputByte1:
	in	al,dx		;INPUT PORT DATA.
	mov	byte ptr _canBuf1[si],al	;SAVE PORT DATA IN CANBUF.
	inc	dx		;UPDATE PORT POINTER.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	loop	inputByte1   
        jmp     far ptr _canEnnd
_inByteed:
;-----------------------------------------------------
; word input,port in dx,addr length in cx,echo data in _canBuf1
_inWordst:
	xor	si,si		;INITIAL POINTER
        shr     cx,1
inputWord1:
	in	ax,dx		;INPUT PORT DATA.
	mov	word ptr _canBuf1[si],ax	;SAVE PORT DATA IN CANBUF.
	inc	dx		;UPDATE PORT POINTER.
	inc	dx		;UPDATE PORT POINTER.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	loop	inputWord1   
        jmp     far ptr _canEnnd
_inWorded:
;-----------------------------------------------------
; byte output,port in dx,write times in cx,output data in _canBuf1
_outBytest:
	xor	si,si		;INITIAL POINTER
outputByte1:
	mov	al,byte ptr _canBuf1[si] 	;GET OUTPUT DATA
	out	dx,al		;OUTPUT PORT DATA.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	loop	outputByte1
        jmp     far ptr _canEnnd
_outByteed:
;-----------------------------------------------------
; word output,port in dx,write times in cx,output data in _canBuf1
_outWordst:
	xor	si,si		;INITIAL POINTER
outputWord1:
	mov	ax,word ptr _canBuf1[si] 	;GET OUTPUT DATA
	out	dx,ax		;OUTPUT PORT DATA.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	inc	si		;UPDATE SAVE BUFFER POINTER.
	loop	outputWord1
        jmp     far ptr _canEnnd
_outWorded:
;--------------------------------------------------------------
; COPY TRANSFER ALGORITHM:
;		      ---------------------------------------------------
;		      |///////////////////////XXXXXX\\\\\\\\\\\\\\\\\\\\|
;		      ---------------------------------------------------
;		      |<------- BLOCK-A   ----|--->|			|
;					      |<------- BLOCK-B  ------>|
; FORWARD_COPY : SOURCE = BLOCK-B, DESTINATION = BLOCK-A
; BACKWARD_COPY: SOURCE = BLOCK-A, DESTINATION = BLOCK-B
;------------------------------------------------------------------------------
;forward copy ,source > destination
;source start address in BP DI,destination start address in BX SI
;length in DX CX,verify flag in _canTop
;echo error flag in _canTop+1
_preCopyst:
	or	cx,cx	
	jne	forwardCopy1    ;
	dec	dx		;
forwardCopy1:
        mov     es,bp
	mov	al,es:[di] 	;GET COPY DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error9
        mov     es,bx
	MOV	es:[si],al	;COPY DATA TO DESTINATION
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error9
	cmp	byte ptr _canTop,1 	;VERIFY FLAG ON ?
	jne	forwardCopy2    ;NOT VERIFY
	mov	ah,es:[si]	;GET COPIED DATA.
	cmp	ah,al		;DATA EQUAL ?
	je	forwardCopy2   
	jmp	error9  	;NOT EQUAL DATA.
forwardCopy2:
	inc	si		;UPDATE READING POINTER
	or	si,si		;OVER SEGMENT ?
	jne	forwardCopy3    ;NOT OVER SEGMENT.
	add	bx,1000H
forwardCopy3:
	inc	di		;UPDATE READING POINTER
	or	di,di		;OVER SEGMENT ?
	jne	forwardCopy4    ;NOT OVER SEGMENT.
	add	bp,1000H
forwardCopy4:
	dec	cx		;
	jne	forwardCopy1    ;
	dec	dx		;
	jge	forwardCopy1    ;COMPLETED ?
        jmp     far ptr _canEnnd
error9:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_preCopyed:
;-------------------------------------------------------
;error address
;error echo:_canBuf1 + 0   --> source address segment
;                      2   --> source address offset
;                      4   --> destination address segment
;                      6   --> destination address offset 
_errCopyst:
	mov	word ptr _canBuf1,bp		;first address.
	mov	word ptr _canBuf1+2,di         
	mov	word ptr _canBuf1+4,bx          ;second address
	mov	word ptr _canBuf1+6,si         
        jmp     far ptr _canEnnd
_errCopyed:
;------------------------------------------------------------
;backward copy ,source < destination
;source end address in BP DI,destination end address in BX SI
;length in DX CX,verify flag in _canTop
;echo error flag in _canTop+1
_postCopyst:
	or	cx,cx	
	jne	backwardCopy1    ;
	dec	dx		;
backwardCopy1:
        mov     es,bp
	mov	al,es:[di] 	;GET COPY DATA.
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error10
        mov     es,bx
	MOV	es:[si],al	;COPY DATA TO DESTINATION
        cmp     byte ptr _canTop+2,1    ;not ready?
        jz      error10
	cmp	byte ptr _canTop,1 	;VERIFY FLAG ON ?
	jne	backwardCopy2   ;NOT VERIFY
	mov	ah,es:[si]	;GET COPIED DATA.
	cmp	ah,al		;DATA EQUAL ?
	je	backwardCopy2   
	jmp	error10 	;NOT EQUAL DATA.
backwardCopy2:
	sub	si,1    	;UPDATE READING POINTER
	jae	backwardCopy3   ;NOT OVER SEGMENT.
	sub	bx,1000H
backwardCopy3:
	sub	di,1            ;UPDATE READING POINTER
	jae	backwardCopy4   ;NOT OVER SEGMENT.
	sub	bp,1000H
backwardCopy4:
	dec	cx		;
	jne	backwardCopy1   ;
	dec	dx		;
	jge	backwardCopy1   ;COMPLETED ?
        jmp     far ptr _canEnnd
error10:
	mov	byte ptr _canTop+1,01H   ;error flag
        jmp     far ptr _canEnnd
_postCopyed:
;----------------------------------------------------------
; internal register R/W,start addrss in DI(FFX0)   
; R/W flag in DX 0--R,1--W , length in CX(maximum 16)
; DS is 0, data buffer in _canBuf1
; exist map table in BP, as followings
; 80186	   0  1  2  3  4  5  6	7   
;-----------------------------------------------------------------------
; 0FF20	   0  1  *  1  1  1  1	1   
; 0FF30	   1  1  1  1  1  1  1	1   
; 0FF40	   0  0  0  0  0  0  0	0   
; 0FF50	   1  1  1  1  1  1  1	1   
; 0FF60	   1  1  1  1  0  0  0	0   
; 0FF70	   0  0  0  0  0  0  0	0   
; 0FF80	   0  0  0  0  0  0  0	0   
; 0FF90	   0  0  0  0  0  0  0	0   
; 0FFA0	   1  *  *  *  *  0  0  0   
; 0FFB0	   0  0  0  0  0  0  0	0   
; 0FFC0	   1  1  1  1  1  1  0	0   
; 0FFD0	   1  1  1  1  1  1  0	0   
; 0FFE0	   1  1  1  0  0  0  0	0   
; 0FFF0	   1  0  0  0  0  0  0	1   
;	   *: When it is set, indicates the corresponding register
;	      can be access in Register Internal modify command.
_intRegst:
        xor     bx,bx                           ;clear buffer pointer
intRegister1:
        ror     bp,1                            ;test exist register
        jnc     intRegister3
        test    dl,0ffh                         ;test R/W
        jnz     intRegister2
        mov     ax,word ptr [di]                ;read from Internal register
        mov     word ptr _canBuf1[bx],ax        ;save to buffer
        jmp     intRegister3
intRegister2:        
        mov     ax,word ptr _canBuf1[bx]        ;read from buffer
        mov     word ptr [di],ax                ;save to internal register
intRegister3:        
        inc     di                              ;address pointer increase
        inc     di
        inc     bx                              ;buffer increase
        inc     bx
        loop    intRegister1
        jmp     far ptr _canEnnd
_intReged:
;--------------------------------------------------------
; savepc & getif & stop timer 0 can program
; 08h need to load _tim0Getif-_tim0Savepc+_canStart
;--------------------------------------------------------
_tim0GSst:
_tim0SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff56h
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_tim0GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff56h
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_tim0GSed:
;--------------------------------------------------------
; savepc & getif & stop timer 1 can program
; 08h need to load _tim1Getif-_tim1Savepc+_canStart
;--------------------------------------------------------
_tim1GSst:
_tim1SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff5eh
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_tim1GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff5eh
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_tim1GSed:
;--------------------------------------------------------
; savepc & getif & stop timer 2 can program
; 08h need to load _tim2Getif-_tim2Savepc+_canStart
;--------------------------------------------------------
_tim2GSst:
_tim2SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff66h
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_tim2GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff66h
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_tim2GSed:
;--------------------------------------------------------
; savepc & getif & stop timer 0 can program
; 08h need to load _tim0Getif-_tim0Savepc+_canStart
;--------------------------------------------------------
_ebtim0GSst:
_ebtim0SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff36h
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_ebtim0GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff36h
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_ebtim0GSed:
;--------------------------------------------------------
; savepc & getif & stop timer 1 can program
; 08h need to load _tim1Getif-_tim1Savepc+_canStart
;--------------------------------------------------------
_ebtim1GSst:
_ebtim1SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff3eh
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_ebtim1GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff3eh
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_ebtim1GSed:
;--------------------------------------------------------
; savepc & getif & stop timer 2 can program
; 08h need to load _tim2Getif-_tim2Savepc+_canStart
;--------------------------------------------------------
_ebtim2GSst:
_ebtim2SavePc:
;
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff46h
        mov     ax,word ptr _canTop+4
        or      ax,4000h
        mov     cs:[si],ax
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        iret
_ebtim2GetIf:
        mov     word ptr _canTop,ax
        mov     word ptr _canTop+2h,si
        mov     si,0ff46h
        mov     ax,cs:[si]
        mov     word ptr _canTop+4,ax
        or      ax,4000h
        and     ax,7fffh
        mov     cs:[si],ax                      ;stop timer
        mov     ax,word ptr _canTop
        mov     si,word ptr _canTop+2h
        jmp     far ptr _canEnnd
;
_ebtim2GSed:
;--------------------------------------------------------      
;
;--------------------------------------------------------
_timVtr:
        dw      _tim0Getif-_tim0Savepc+_canStart
        dw      0
;--------------------------------------------------------
; restore ss,sp from canTop
;--------------------------------------------------------
_savspst:
        mov     ss,word ptr _canTop
        mov     sp,word ptr _canTop+2H
        jmp     far ptr _canEnnd
_savsped:
;--------------------------------------------------------
; get ss,sp in canTop
;--------------------------------------------------------
_getspst:
        mov     word ptr _canTop,ss
        mov     word ptr _canTop+2H,sp
        jmp     far ptr _canEnnd
_getsped:
;----------------------------------------------------------
; modify "jmp far ptr _canStart" to "jmp far ptr _canStart2"
;----------------------------------------------------------------
_toStart2st:
        mov     byte ptr _canEndCode+1,_canStCode2
        jmp     far ptr _canEnnd
_toStart2ed:
;----------------------------------------------------------
; delay 4 + (65536-1) * (3+13) + (3+4) + 14 clks
;----------------------------------------------------------------
_Delayst:
        mov     bx,0                    ;4 clks
Delay1: dec     bx                      ;3 clks
        jnz     Delay1                  ;to Delay1 13 clks,or 4 clks
        jmp     far ptr _canEnnd        ;14 clks
_Delayed:
;----------------------------------------------------------
; halt
;----------------------------------------------------------------
_Haltst:
        hlt
        jmp     far ptr _canEnnd        ;
_Halted:
;---------------------------------------------------------
; modify "jmp far ptr _canStart2" to "jmp far ptr _canStart"
;----------------------------------------------------------------
_toStartst:
        mov     byte ptr _canEndCode+1,_canStCode
        jmp     far ptr _canEnnd
_toStarted:
;-----------------------------------------------------------
; jump to _canStart2
;------------------------------------------------------------
_jump2st:
        jmp     far ptr _canStart2
_jump2ed:
;---------------------------------------------------------------------
;modify 80c187 internal environment(14 bytes) content routine:
;content in _canBuf1 to _canBuf1+12
;modify 80c187 internal registers (80 bytes) content routine:
;control register st(0) to st(7)
;          content in _canBuf1+13 to _canBuf1+15
;          content in _canTop to _canTop+77
;
;
_wr187regst:
	frstor	_canBuf1        	;STORE 80C187 INTERNAL REGISTER FROM
	wait				;WAIT TILL NBUSY SIGNAL INACTIVE(HIGH)
	nop
	nop
	nop
;					;CAN RAM BUFFER ADDRESS 0 TO 9DH.
        jmp     far ptr _canEnnd
_wr187reged:
;---------------------------------------------------------------------
;read 80c187 internal environment(14 bytes) content routine:
;echo content in _canBuf1 to _canBuf1+12
;read 80c187 internal registers (80 bytes) content routine:
;read control register st(0) to st(7)
;          content in _canBuf1+13 to _canBuf1+15
;          content in _canTop to _canTop+77
;
_rd187regst:
        fsave 	_canBuf1              	;read register
        frstor	_canBuf1              	;read register
	wait				;WAIT TILL NBUSY SIGNAL INACTIVE(HIGH)
	nop
	nop
	nop
;					;CAN RAM BUFFER ADDRESS 0 TO 9DH.
        jmp     far ptr _canEnnd
_rd187reged:
;--------------------------------------------------------
;START OF ENTRY
_canDefPtr:
        dw      _canTop     ;CAN_TOP_P
        dw      _canVtr     ;CAN_VTR_P
        dw      _canStart   ;CAN_START_P
        dw      _canStart2  ;CAN_START2_P
        dw      _canEnnd    ;CAN_ENND_P
        dw      _canBuf1    ;CAN_BUF1_P
        dw      _canStack   ;CAN_STACK_P
        dw      _canSavePc  ;CAN_SAVEPC_P
        dw      _canGetIf   ;CAN_GETIF_P
        dw      _getRegst   ;CAN_GETREGST_P
        dw      _saveRegst  ;CAN_SAVREGST_P
        dw      _getReged   ;CAN_GETREGED_P
        dw      _saveReged  ;CAN_SAVREGED_P
        dw      _setParast  ;CAN_SETPARST_P
        dw      _setParaed  ;CAN_SETPARED_P
        dw      _disBytest  ;CAN_DISBYST_P
        dw      _disByteed  ;CAN_DISBYED_P
        dw      _disWordst  ;CAN_DISWDST_P
        dw      _disWorded  ;CAN_DISWDED_P
        dw      _wrBytest   ;CAN_WRBYST_P
        dw      _wrByteed   ;CAN_WRBYED_P
        dw      _wrWordst   ;CAN_WRWDST_P
        dw      _wrWorded   ;CAN_WRWDED_P
        dw      _tstByte1st  ;CAN_TSBY1ST_P
        dw      _tstByte1ed  ;CAN_TSBY1ED_P
        dw      _tstByte2st  ;CAN_TSBY2ST_P
        dw      _tstByte2ed  ;CAN_TSBY2ED_P
        dw      _tstWord1st  ;CAN_TSWD1ST_P
        dw      _tstWord1ed  ;CAN_TSWD1ED_P
        dw      _tstWord2st  ;CAN_TSWD2ST_P
        dw      _tstWord2ed  ;CAN_TSWD2ED_P
        dw      _comBytest   ;CAN_COMBYST_P
        dw      _comByteed   ;CAN_COMBYED_P
        dw      _comWordst   ;CAN_COMWDST_P
        dw      _comWorded   ;CAN_COMWDED_P
        dw      _errComst    ;CAN_ERCOMST_P
        dw      _errComed    ;CAN_ERCOMED_P
        dw      _cheBytest   ;CAN_CHEBYST_P
        dw      _cheByteed   ;CAN_CHEBYED_P
        dw      _cheWordst   ;CAN_CHEWDST_P
        dw      _cheWorded   ;CAN_CHEWDED_P
        dw      _seaBytest   ;CAN_SEABYST_P
        dw      _seaByteed   ;CAN_SEABYED_P
        dw      _seaOKst     ;CAN_SEAOKST_P
        dw      _seaOKed     ;CAN_SEAOKED_P
        dw      _inBytest    ;CAN_INBYST_P
        dw      _inByteed    ;CAN_INBYED_P
        dw      _inWordst    ;CAN_INWDST_P
        dw      _inWorded    ;CAN_INWDED_P
        dw      _outBytest   ;CAN_OUTBYST_P
        dw      _outByteed   ;CAN_OUTBYED_P
        dw      _outWordst   ;CAN_OUTWDST_P
        dw      _outWorded   ;CAN_OUTWDED_P
        dw      _preCopyst   ;CAN_COPYPRST_P
        dw      _preCopyed   ;CAN_COPYPRED_P
        dw      _errCopyst   ;CAN_ERCOPYST_P
        dw      _errCopyed   ;CAN_ERCOPYED_P
        dw      _postCopyst  ;CAN_COPYPOST_P
        dw      _postCopyed  ;CAN_COPYPOED_P
        dw      _intRegst    ;CAN_INTREGST_P
        dw      _intReged    ;CAN_INTREGED_P
        dw      _tim0GSst    ;CAN_TIM0GSST_P
        dw      _tim0GSed    ;CAN_TIM0GSED_P
        dw      _tim1GSst    ;CAN_TIM1GSST_P
        dw      _tim1GSed    ;CAN_TIM1GSED_P
        dw      _tim2GSst    ;CAN_TIM2GSST_P
        dw      _tim2GSed    ;CAN_TIM2GSED_P
        dw      _ebtim0GSst  ;CAN_EBT0GSST_P
        dw      _ebtim0GSed  ;CAN_EBT0GSED_P
        dw      _ebtim1GSst  ;CAN_EBT1GSST_P
        dw      _ebtim1GSed  ;CAN_EBT1GSED_P
        dw      _ebtim2GSst  ;CAN_EBT2GSST_P
        dw      _ebtim2GSed  ;CAN_EBT2GSED_P
        dw      _savspst     ;CAN_SAVSPST_P
        dw      _savsped     ;CAN_SAVSPED_P
        dw      _getspst     ;CAN_GETSPST_P
        dw      _getsped     ;CAN_GETSPED_P
        dw      _wr187regst  ;CAN_WR7REST_P
        dw      _wr187reged  ;CAN_WR7REED_P
        dw      _rd187regst  ;CAN_RD7REST_P
        dw      _rd187reged  ;CAN_RD7REED_P
        dw      _toStartst   ;CAN_TOSTST_P
        dw      _toStarted   ;CAN_TOSTED_P
        dw      _toStart2st  ;CAN_TOSTST2_P
        dw      _toStart2ed  ;CAN_TOSTED2_P
        dw      _jump2st     ;CAN_JP2ST_P
        dw      _jump2ed     ;CAN_JP2ED_P
        dw      _Delayst     ;CAN_DLYST_P
        dw      _Delayed     ;CAN_DLYED_P
        dw      _Haltst      ;CAN_HLTST_P
        dw      _Halted      ;CAN_HLTED_P
;END OF ENTRY
CODE    ENDS
        END
