/****************************************************************************
**
**  Name:  emuemul.h
**
**  Description:
**     Michelle emulation-group routines.
**     include:
**     "Read/write registers",
**     "Reset the emulator",
**     "Instruction step(s)"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emuemul.h_v  $
** 
**    Rev 1.0   03 Dec 1996 09:27:40   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:04:56   jacky
** Get file from ATL. V1.3
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emuemul.h_v   1.0   03 Dec 1996 09:27:40   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_EMUL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/
#define REG86_NUMBER 14

			/****************************
			 *                          *
			 *    EXTERNAL VARIABLES    *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *     LOCAL PROTOTYPES     *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *      EXECUTABLE CODE     *
			 *                          *
			 ****************************/



/****************************************************************************
**
**  EmuReset
**
**  Description: Michelle reset routine,
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuReset(VOID);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetReg(REG_MODE regMode, U16 regId);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetAllReg(VOID);

/****************************************************************************
**
**  EmuGetAllIntReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetAllIntReg(VOID);

/****************************************************************************
**
**  EmuGetAllCoReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetAllCoReg(VOID);

/****************************************************************************
**
**  EmuSetReg(VOID)
**
**  Description: Michelle emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        regId  --
**        value  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuSetReg(REG_MODE regMode, U16 regId, U16 value);

/****************************************************************************
**
**  EmuGetCoReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetCoReg(U16 regId);

/****************************************************************************
**
**  EmuSetCoReg(VOID)
**
**  Description: Michelle emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        regId  --
**        value  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuSetCoReg(U16 regId, U16 *value);

/****************************************************************************
**
**  EmuStepRange
**
**  Description: Michelle emulation routine, to set value to certain register.
**
**  Parameters:
**     input:
**        addr1 -- unsigned long,
**        addr2 -- unsignde long
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuStepRange(U32 addr1,U32 addr2);
/******************************** E O F ***********************************/

