/****************************************************************************
**
**  Name:  emuerror.h
**
**  Description:
**     Michelle error handle processing
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emuerror.h_v  $
** 
**    Rev 1.1   17 Dec 1996 17:29:54   gene
** added for MCE16C
** 
**    Rev 1.0   03 Dec 1996 09:27:40   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:05:24   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emuerror.h_v   1.1   17 Dec 1996 17:29:54   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_ERROR_

                       /****************************
			*                          *
			*       INCLUDE FILES      *
			*                          *
			****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

                       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/

//#define OK                          0    /* Normal return */
#define MICE_HALT                  ( -1)   /* Target CPU halted */
#define MEM_GUARD                  ( -2)   /* Access the guarded memory */
#define MEM_PROTECT                ( -3)   /* Access the protected memory */
#define ERROR_READ                 ( -4)   /* Memory read failure */
#define ERROR_WRITE                ( -5)   /* Memory write failure */
#define STEP_ERROR                 ( -6)   /* Target cnnot step */
#define NO_DIFF                    ( -7)   /* No difference in memory compare */
#define NO_FOUND                   ( -8)   /* Not found in memory search */
#define BREAK                      ( -9)   /* Break on memory access */
#define BREAK_I                    (-10)   /* Break on instruction fetch */
#define BAD_REG                    (-11)   /* Bad register number encountered */
#define BAD_IN                     (-12)   /* Error encountered on user input */
#define HALT_USER                  (-13)   /* user pressed ^C */
#define ERROR_COM                  (-14)   /* communication error */
#define ERROR_MICE                 (-15)   /* linking incorrect MICE model */
#define MICE_LIMIT                 (-16)   /* MICE limitation */
#define BUS_REQUEST                (-17)   /* Bus request */
#define BAD_FRAME                  (-18)   /* invalid frame number */
#define ERROR_BOUN                 (-19)   /* error map boundary */
#define MAP_FAIL                   (-20)   /* memory map fail */
#define ABS_OVERFLOW               (-21)   /* abs address overflow */
#define TEST_FAIL                  (-22)   /* test failure */
#define CPU_RUN                    (-23)   /* CPU free running */
#define BROKE                      (-24)   /* CPU stop */
#define NOT_READY                  (-25)   /* target is not ready */
#define COMMAND_ERROR              (-26)   /*  */
#define TIME_OUT                   (-27)   /*  */
#define NO_TRACE_MODULE            (-28)   /*  */
#define BKPT1_HALT                 (-29)   /*  */
#define BKPT2_HALT                 (-30)   /*  */
#define VIOL_HALT                  (-31)   /*  */
#define RBW_HALT                   (-32)   /*  */
#define TRIG_HALT                  (-33)   /*  */
#define LINK_MICE_FAIL             (-34)   /*  */
#define WARN_START                 (-35)   /*  */
#define BANK_FULL                  (-36)
#define ADDR_RANGE_OVERFLOW        (-37)
#define ATTRIBUTE_MISMATCH         (-38)
#define BANK_MISMATCH              (-39)
#define SPACE_MISMATCH             (-40)
#define ADDR_MISMATCH              (-41)
#define NO_VCC                     (-42)
#define USER_CC                    (-43)
#define TARGET_RESET               (-44)
#define NO_EMM                     (-45)
#define CNT_ERROR                  (-46) // only use at sw.
#define TIMER_ERROR                (-47) // only use at sw.
#define EVENT_FULL                 (-48)
#define BUFFER_EMPTY               (-49)
#define EMM_SET_ERROR              (-50)
#define EP_PENDING                 (-51)
#define REC_TIME_OUT               (-52) // only usd at sw.
#define INVALID_CPU                (-53) // only usd at sw.
#define MCE16C_FAIL                (-54)
#define EMM_FAIL                   (-55)
#define TRACE_BOARD_FAIL           (-56)
#define COV_RBW_FAIL               (-57)
#define CPU_FLY                    (-58)
#define INVALID_FLY_COMMAND        (-59)
#define INVALID_FIRMWARE           (-60) // only usd at sw.
// (-61) only use at sw
// (-62) only use at sw
/**********************************************/
/****  added error number for trace board  ****/
/**********************************************/
#define ERR_PIPE_DONE              (-63)
#define ERR_P4_DONE                (-64)
#define ERR_MN_DONE                (-65)
#define ERR_MN_CONFIG              (-66)
#define ERR_CODECOVERID            (-67)
#define ERR_UNKNOW_TBN             (-68)
#define ERR_LIST_MODE              (-69)
#define ERR_TRIG                   (-70)



typedef enum{
   TRACE_HARDWARE_ERROR  = 0x01,
   MCE16C_HARDWARE_ERROR = 0x02,
   NO_TARGET_VCC         = 0x04,
   EMM_CONTROL_RAM_ERROR = 0x08,
   DOWNLOAD4003_FAILURE  = 0x10
}HW_ERROR_NO;

typedef enum{
   RECEIVE_DATA_ERROR,
   TRANSMIT_DATA_ERROR,
   PROBE_TEST_ERROR,
   TRACE_TEST_ERROR,
   HEADER_TEST_ERROR,
   ACCESS_ERROR,
   TARGET_CANNOT_STEP,
   FILL_FAILED,
   COMPARE_FAILED,
   TEST_FAILED,
   COPY_FAILED,
   UNKNOWN_TYPE,
   LEN_TOO_LONG,
   LEN_EQUAL_ZERO,

   MAX_ERROR_NO
}ERROR_NO;


                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                         /****************************
                          *                          *
                          *      EXECUTABLE CODE     *
                          *                          *
                          ****************************/



/**************************************************************************
**
** ReportError
**
**  Description: report error by passing/returning an error code to host.
**               This code-id is included in the status field of the
**               transmitting data record.
**
**  Parameters:
**     input:
**
**
**     output:
**
**
*****************************************************************************/
VOID EmuReportError(ERROR_NO errCode);


/****************************************************************************
**
**  OutputError
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputError(COMMAND_ID cmdId, STATUS status);

/****************************************************************************
**
**  OutputBrOverError
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputBrOverError(BOOLEAN endData);
/******************************** E O F ***********************************/

