/***************************************************************************
**
**  Name:  emulib.h
**
**  Description:
**     Michelle library routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emulib.h_v  $
** 
**    Rev 1.0   03 Dec 1996 09:27:42   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:05:04   jacky
** Get file from ATL. V1.3
** 
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emulib.h_v   1.0   03 Dec 1996 09:27:42   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

#define _EMU_LIB_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/
#define IncreaseEven(x)  if ((x) % 2)  (x)++
#define ReduceEven(x)    if ((x) % 2)  (x)--
#define IncreaseQuad(x)  if ((x) % 4)  (x) = (((x) >> 2) << 2) + 4
#define ReduceQuad(x)    if ((x) % 4)  (x) = ((x) >> 2) << 2
#define HighWord(x)      ((U16)((U32)(x) >> 16))
#define LowWord(x)       ((U16)(x))
#define HighByte(x)      ((U8)((U16)(x) >> 8))
#define LowByte(x)       ((U8)(x))
#define LinearToPhysical(x)   ((U32)HighWord(x) << 4) + LowWord(x)
#define CheckBrOver()    (brOver)
#define maskBit          0x0001
#define maskBit2         0x0003


#define OutStream(diff,pos,streamLen) \
         outputStream[pos++] = streamLen;\
         memcpy(&outputStream[pos],diff,streamLen);/* error address */\
         pos += streamLen;\
         outputStream[pos++] = 0x00

#define OutEnd() \
           outputStream[outputStreamLen++] = 0x00

#define OutLength(len) \
           outputStream[outputStreamLen++] = len


/****************************************************************************
**
**  OutDoubleData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutMultipleData(U8 dataLen, VOID *data, U8 times);

/****************************************************************************
**
**  OutData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutData(U8 dataLen, VOID *data, BOOLEAN lenFlag);


/****************************************************************************
**
**  CheckViolation
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS CheckViolation(VOID);

/****************************************************************************
**
**  StopRun
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID StopRun(VOID);
/****************************************************************************
**
**  AddSegAddr
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
U32 AddSegAddr(U32 addr, U32 len);

/****************************************************************************
**
**  InitLam
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID InitLam(VOID);

/****************************************************************************
**
**  AccessIceFlag
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessIceFlag(ACCESS_MODE accessMode, ICE_FLAG flagName, U16 *value);

/****************************************************************************
**
**  AccessSignal
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessSignals(ACCESS_MODE accessMode, SIGNAL_FLAG signalName, U16 *value);

/****************************************************************************
**
**  AccesstatusFlag
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessStatusFlag
       (ACCESS_MODE accessMode, STATUS_FLAG statusName, U16 *value);


/****************************************************************************
**
**  AccessBaseReg
**
**  Description: Access register : Timer 0,1,2 from buffer.
**               Note : Before Access, it must check hardware data to save in
**                      buffer.
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessBaseReg
       (ACCESS_MODE accessMode, CPU_REGISTER regName, U16 *value);

/****************************************************************************
**
**  AccessCpuReg
**
**  Description: Access 86 register from buffer.
**               Note : Before Access, it must check hardware data to save in
**                      buffer.
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessCpuReg
       (ACCESS_MODE accessMode, CPU_REGISTER regName, U16 *value);

/****************************************************************************
**
**  AccessI87Reg
**
**  Description: Access 87 register from buffer.
**               Note : Before Access, it must check hardware data to save in
**                      buffer.
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessI87Reg
      (ACCESS_MODE accessMode, I87_REGISTER regName, U8 *value);

/****************************************************************************
**
**  AccessInternalReg
**
**  Description: Access Internal register from buffer.
**               Note : Before Access, it must check hardware data to save in
**                      buffer.
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessInternalReg
       (ACCESS_MODE accessMode, U16 regName, U16 *value);

/****************************************************************************
**
**  OutputStatus
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputStatus(STATUS status,U8 endData);

/****************************************************************************
*
*  GetBits
*
*  Description:
*
*  Parameters:
*    input:
*      value     :
*      bitStart  :
*      length    :
*    output:
*      return value :
*
*****************************************************************************/
U16 GetBits(U16 value, U8 bitStart,U8 length);

/****************************************************************************
*
*  BitNo
*
*  Description:
*
*  Parameters:
*    input:
*      sizeNo:
*    output:
*      return:
*
*****************************************************************************/
U8 BitNo(U8 sizeNo);

/******************************** E O F ***********************************/

