/****************************************************************************
**
**  Name:  emumain.c
**
**  Description:
**     Michelle main(base) function routine. Include the control procedure.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emumain.c_v  $
** 
**    Rev 1.4   22 Jan 1997 08:53:18   gene
** 
**    Rev 1.3   30 Dec 1996 11:58:12   gene
** modified for SPA
** 
**    Rev 1.7   26 Dec 1996 20:21:30   jacky
** MTATII
** 
**    Rev 1.2   20 Dec 1996 18:21:58   gene
** modified FUNCTION_TEST command report status
** 
**    Rev 1.1   17 Dec 1996 17:24:10   gene
** added for MCE16C
** 
**    Rev 1.0   09 Dec 1996 15:20:28   gene
** Initial revision.
** 
**    Rev 1.0   03 Dec 1996 09:27:34   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:06:30   jacky
** Get file from ATL. V1.3
**
**
**  $Header:   S:/tbird/arcmtat2/mp186/emumain.c_v   1.4   22 Jan 1997 08:53:18   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

           /****************************
            *                          *
            *       INCLUDE FILES      *
            *                          *
            ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_GLOBAL_
#include "emuglb.h"
#endif

#ifndef _FUNCTION_TEST_
#include "functest.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_MEM_
#include "emumem.h"
#endif

#ifndef _EMU_PORT_
#include "emuport.h"
#endif

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#include <conio.h>

extern U16 errorFlag;
extern U8 cpuFlag;
extern U32 bankSize;
extern BOOLEAN mtatExist;
           /****************************
            *                          *
            *     LOCAL DEFINITIONS    *
            *                          *
            ****************************/
#define MCR     0XF004

            /****************************
             *                          *
             *    EXTERNAL VARIABLES    *
             *                          *
             ****************************/

            /****************************
             *                          *
             *     LOCAL PROTOTYPES     *
             *                          *
             ****************************/
VOID InitFwControl(VOID);
VOID InitDataBase(VOID);
RETCODE ReceiveInputCommand(VOID);
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream);
RETCODE ProcessCommand(U16 ac, U8 *av[]);

VOID spaTest(VOID);
            /****************************
             *                          *
             *      EXECUTABLE CODE     *
             *                          *
             ****************************/



/***************************************************************************
**
** EmuSetID
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
****************************************************************************/
VOID EmuSetID(VOID) {
STATUS status;
U16 cpuId,argc,phyCpu,lp;
U8 *argv[10];

   status = GOOD;
   phyCpu = IDCode() & 0xff;
   AccessIceFlag(WRITE_ONE,PHY_CPU_TYPE,&phyCpu);
   ReceiveStream(); /* read the input commands stream. */
   DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
   if((COMMAND_ID)(*argv[0]) == SET_ID) {
      cpuId = *(U16 *)(argv[1]+1);
      switch (phyCpu) {
         case XL_EA :
            switch (cpuId) {
               case I80C188EA :
                  cpuFlag = 0x12;
                  break;
               case I80C186EA :
                  cpuFlag = 0x22;
                  break;
               case I80C188XL :
                  cpuFlag = 0x11;
                  break;
               case I80C186XL :
                  cpuFlag = 0x21;
                  break;
               default :
                  status = INVALID_CPU;
            }
            break;
         case EB :
            switch (cpuId) {
               case I80C186EB :
                  cpuFlag = 0x24;
                  break;
               case I80C188EB :
                  cpuFlag = 0x14;
                  break;
               default :
                  status = INVALID_CPU;
            }
            break;
         case EC :
            switch (cpuId) {
               case I80C186EC :
                  cpuFlag = 0x28;
                  break;
               case I80C188EC :
                  cpuFlag = 0x18;
                  break;
               default :
                  status = INVALID_CPU;
            }
      }
      memcpy(&idData[CPU_TYPE],&cpuId,2);
      //if ((status == GOOD) && (fwId != phyCpu)) status = INVALID_FIRMWARE;
      OutputStatus(status,ON);
   }
   else OutputStatus(COMMAND_ERROR,ON);
   TransmitStream();
   outp(MCR,0);
   if (status != GOOD) {
      for (lp = 0; lp < 0x1000; lp++);
      FwReset();
   }
}

/***************************************************************************
**
**  EmuGetInfo
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
****************************************************************************/
VOID EmuGetInfo(VOID) {
U16 argc;
U8 *argv[10],dataLen;

   ReceiveStream(); /* read the input commands stream. */
   DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
   if((COMMAND_ID)(*argv[0]) == GET_ID) {
      OutputStatus(GOOD,OFF);
      dataLen = 6;
      OutData(dataLen,idData,ON);
      OutEnd();
   }
   else OutputStatus(COMMAND_ERROR,ON);
   TransmitStream();
   outp(MCR,0);
}

/***************************************************************************
**
** FunctionTest
**
**  Description: Michelle Test function.
**
**  Parameters:
**     input:
**        none
**
**     output:
**
****************************************************************************/
VOID FunctionTest(VOID) {
STATUS status;
U16 testId,argc;
U8 *argv[10];

   for(;;) {
      status = GOOD;
      ReceiveStream(); /* read the input commands stream. */
      DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
      if((COMMAND_ID)(*argv[0]) == FUNCTION_TEST) {
         testId = *(U16 *)(argv[1]+1);
         if (testId != END_TEST) status = EmuFunctionTest(testId);
         OutputStatus(status,ON);
         TransmitStream();
         outp(MCR,0);
      }
      else {
         OutputStatus(COMMAND_ERROR,ON);
         TransmitStream();
         outp(MCR,0);
         return;
      }
      if (testId == END_TEST) return;
   }
}

/***************************************************************************
**
**  main()
**
**  Description: Michelle main routine, with its linear control process
**               sequence. We always think this fw process with one single
**               task.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
****************************************************************************/
main() {
   U16 argc;
   U8 *argv[10];
   ERROR_NO errNo;

   //fwId = EB;
   InitDataBase(); /* all data sets setting or default value. */
   InitFwControl(); // Initial hardware and firmware
//   spaTest();

   while (TRUE) {
      ReceiveStream(); /* read the input commands stream. */
      DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
      errNo = ProcessCommand(argc,argv); /* case switching the command tasks */
      if (errNo == OK) {
         TransmitStream();
      }
      else EmuReportError(errNo);
   }
   return(GOOD);
}

VOID InitFwControl(VOID) {
U8 status;
U16 emmSize,baseReg[BASE_REG_NO],lp;
U8 vccFlag;
U16 action[11],ev[11];


   status = GOOD;
   AccessIceFlag(WRITE_ONE,RESET_FLAG,&C_ON);
   idData[FIRMWARE_TYPE] = 'M'; // This is a MICEpack firmware.
   idData[FIRMWARE_VER] = 0x10; // FW version is 1.0.
   SetClockPhase();
   if (iceStartFlag == 0xaaaa) EmuSetID(); // Cold start need set cpu type.

   InitCpPort();
   if (InitialTraceMachine()) status |= TRACE_HARDWARE_ERROR;
   InitEpPort();
   if (errorFlag) status |= DOWNLOAD4003_FAILURE;

//   if (iceStartFlag == 0xaaaa) { // Cold Start.
      emmSize = InitEm() & 0x00ff;
      bankSize = 0x20000 * emmSize;
      AccessIceFlag(WRITE_ONE,EMM_SIZE,&emmSize);
      AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
      if (MapTest()) status |= EMM_CONTROL_RAM_ERROR;
//   }
//   if (mtatExist) InitCov();
   if (mtatExist) idData[TRACE_EXIST] = ON;
   else idData[TRACE_EXIST] = OFF;
//status = InitMapTable();
   InitMapTable();

   if (CanTest()) status |= MCE16C_HARDWARE_ERROR;
   if (InitialReset(baseReg)) status |= NO_TARGET_VCC;
   idData[INIT_HW_STATUS] = status;

   if (iceStartFlag == 0xaaaa)  EmuGetInfo(); // Cold start need get MICEPack infomation.

   if (iceStartFlag == 0xaaaa) { // Cold start
      DisableControl();
      FunctionTest();
      EnableControl();
   }
   vccFlag = Reset(baseReg);
   AccessBaseReg(WRITE_ALL,noUse,baseReg);

   if ((iceStartFlag == 0xaaaa) && (mtatExist)) { // Cold start & trace board exist.
      EmuClrEvent(0); // clear all event
      EmuSetTimerCounter(0,0,0); // set trigger count0 and count1 are zero.
      EmuSetTraceBreak(OFF);
      EmuSetTraceBuff(1);
      EmuClrTrig(0); // clear all trigger.
      for (lp = 0; lp < 11; lp++) // clear ext event and counter 0/1.
         ev[lp]  =  0;
      for (lp = 0; lp < 8; lp++) { // if bus events occur then halt ep.
         ev[lp]  =  lp+1;
         action[lp]  = 4;
      }
      EmuSetTrig(1,0,ev,action,0); // set trigger level 1 that all event break; backward trace.
   }
   iceStartFlag = 0x0;
   ClrViolFlg();
   EnEmRun();
   Exbp1Disable();
   Exbp2Disable();
   EmuSetMap(0,0,0x0c00); /* map all external */
   EmuSetControl(0x7fe); // all control signals enable except PEREQ.
}

VOID InitDataBase(VOID) {
U16 phyCpu,size,timerFlag = 0xff,bufNum = 4,brokeReason = BROKE;

   noUse = C_OFF = 0;
   C_ON = 1;
   noUseByte = 0;
   AccessIceFlag(READ_ONE,PHY_CPU_TYPE,&phyCpu);
   AccessIceFlag(CLEAR_ALL,noUse,&noUse);// special for timer flag
   AccessIceFlag(WRITE_ONE,PHY_CPU_TYPE,&phyCpu);
   AccessIceFlag(WRITE_ONE,FLY_RUN,&C_OFF);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&brokeReason);
   AccessIceFlag(WRITE_ONE,TIMER_FLAG,&noUse);
   AccessIceFlag(WRITE_ONE,TRACE_BUFF,&bufNum);
   AccessIceFlag(WRITE_ONE,VERIFY_FLAG,&C_ON);
   AccessStatusFlag(CLEAR_ALL,noUse,&noUse);
   size = S_BYTE;
   AccessIceFlag(WRITE_ONE,SIZE_FLAG,&size);
   //CommRecover();
}

RETCODE ReceiveInputCommand(VOID) { /* Receive data from communication port */
   ReceiveStream();
   return(GOOD);
}

/***************************************************************************
**
**  DispatchCommand
**
**  Description: Dispath the input command stream.
**         Note: Please refer input command protocol format.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**     output:
**        ac      : argument counter.
**        av      : argument position.
**
****************************************************************************/
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream) {

   *ac = 1;   /* Initial argument. */
   av[0] = cmdStream;
   cmdStream++;
   while ((*cmdStream) && (*cmdStream != 0xff)){
      av[(*ac)++] = cmdStream;
      cmdStream += *cmdStream + 1;
   }
   return(GOOD);
}

/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**        ac            : argument counter.
**        av            : argument position.
**     output:
**        outputStream  : the message of executive result.
**
****************************************************************************/
RETCODE ProcessCommand(U16 ac, U8 *av[]) {
U16 dataLen,flyFlag;
U32 data[10];
LOOP_VAR lp;
STATUS status;

   for (lp = 1; lp < (LOOP_VAR)ac; lp++) {
      dataLen = *(av[lp]);
      switch (dataLen) {
         case 1 : /* byte */
            data[lp] = *(U8 *)(av[lp]+1);
            break;
         case 2 : /* word */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         case 3 : /* 3 byte */
            data[lp] = *(U32 *)(av[lp]+1) & 0x00ffffff;
            break;
         case 4 : /* long */
            data[lp] = *(U32 *)(av[lp]+1);
            break;
         case 0xff : /* more than 255 */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         default : /* do nothing */
            data[lp] = 0;
            break;
      }
   }

   if (!ac) return(FALSE);
   status = GOOD;
   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   if (flyFlag) EmuGetCpuStatus();
   switch ((COMMAND_ID)(*av[0])) {
      case CHECKSUM :
         EmuChecksum((U32)data[1],(U32)data[2]);
         break;
      case CLR_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuClrEvent((U16)data[1]);
         break;
      case CLR_TRIG :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuClrTrig((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case COMPARE :
         EmuCompare((U32)data[1], (U32)data[2], (U32)data[3]);
         break;
      case COPY :
         EmuCopy((U32)data[1], (U32)data[2], (U32)data[3]);
         break;
      case FUNCTION_TEST :
         status = EmuFunctionTest((U16)data[1]);
         OutputStatus(status,ON);
         break;
      /*  only use at run command
      case ESC_COMMAND :
         break;
      */
      case FILL :
         EmuFill((U32)data[1], (U32)data[2], (U8 *)(av[3]+1), *av[3]);
         break;
      case GET_ID :
         EmuGetID();
         break;
      case GET_ALL_CO_REG :
         EmuGetAllCoReg();
         break;
      case GET_ALL_REG :
         EmuGetAllReg();
         break;
      case GET_ALL_INTERNAL_REG :
         EmuGetAllIntReg();
         break;
      case GET_CO_COVERAGE :
         break;
      case GET_CO_REG :
         EmuGetCoReg((U16)data[1]);
         break;
      case GET_CONTROL :
         EmuGetControl();
         break;
      case GET_DEPTH :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuGetTraceDepth((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_LAST_BUFF :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuGetTraceInfo();
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_MAP :
         EmuGetMap();
         break;
      case GET_EVENT :
         EmuGetAllEvent();
         break;
      case GET_MAP_SIZE :
         EmuGetMapSize();
         break;
      case GET_MODE :
         EmuGetMode();
         break;
      case GET_READY :
         EmuGetReady();
         break;
      case GET_REG :
         EmuGetReg((REG_MODE)data[1], (U16)data[2]);
         break;
      case GET_SIZE :
         EmuGetAccessSize();
         break;
      case GET_STAT :
         EmuGetStatus();
         break;
      case GET_SYNC :
         EmuGetSync();
         break;
      case GET_VERIFY :
         EmuGetVerify();
         break;
      case GET_WAIT :
         EmuGetWait();
         break;
      case GO_COMMAND :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            EmuGo((S16)data[1]);
            return(GOOD);
         }
         break;
    //  case HALT :
    //     EmuHalt();
    //     break;
      case INPUT :
         EmuInput((U16)data[1], (U16)data[2], (U16)data[3]);
         break;
      case LIST_TRACE :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuListTrace((U16)data[1],(U32)data[2],(QUALIFY_LIST *)(av[3]+1));
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case OUTPUT :
         EmuOutput((U16)data[1], (U8 *)(av[2]+1), (U16)data[3], (U16)data[4]);
         break;
      case READ_MEM_N :
         EmuReadMemN((U32)data[1], (U16)data[2]);
         break;
      case RESET :
         EmuReset();
         AccessIceFlag(READ_ONE,FLYING,&flyFlag);
         break;
      case SEARCH :
         EmuSearch((U32)data[1], (U32)data[2], (U8 *)(av[3]+1), *av[3]);
         break;
      case SET_CONTROL :
         EmuSetControl((U16)data[1]);
         break;
      case SET_CO_COVERAGE :
         break;
      case SET_CO_REG :
         EmuSetCoReg((U16)data[1],(U16 *)(av[2]+1));
         break;
      case SET_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuSetEvent((U16)data[1], (U8 *)(av[2]+1));
         break;
      case SET_ALL_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuSetAllEvent((U8 *)(av[1]+1),(U8 *)(av[2]+1),(U8 *)(av[3]+1));
         break;
      case SET_EX_BKPT :
         EmuSetExBkpt((U16)data[1], (U32)data[2]);
         break;
      case SET_EXT_EVENT :
         EmuSetExtEvent((U16)data[1]);
         break;
      //case SET_ID :
      //   EmuSetID((U16)data[1]);
      //   break;
      case SET_MEM_N :
         EmuSetMemN((U32)data[1], (U8 *)(av[2]+1), *av[2]);
         break;
      case SET_MAP :
         EmuSetMap((U32)data[1], (U32)data[2], (U16)data[3]);
         break;
      case SET_REG :
         EmuSetReg((REG_MODE)data[1], (U16)data[2],(U16)data[3]);
         break;
      case SET_READY :
         EmuSetReady((U16)data[1]);
         break;
      case SET_SIZE :
         EmuSetAccessSize((U16)data[1]);
         break;
      case SET_SYNC :
         EmuSetSync((U16)data[1]);
         break;
      case SET_TRACE_BREAK :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuSetTraceBreak((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case SET_TRACE_BUFF :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuSetTraceBuff((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case SET_TRIG :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuSetTrig((U16)data[1],(U8)data[2],(U16 *)(av[3]+1),(U16 *)(av[4]+1),(U16)(data[5]));
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_TRIG :
         if (mtatExist) EmuGetAllTrig();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SET_TIME_COUNT :
         EmuSetTimerCounter((U16)data[1],(U32)data[2],(U32)data[3]);
         break;
      case SET_TIMER_REG :
         EmuEpTimer((U16)data[1]);
         break;
      case SET_VERIFY :
         EmuSetVerify((U16)data[1]);
         break;
      case SET_WAIT :
         EmuSetWait((U16)data[1]);
         break;
      case STEP :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuStepRange((U32)data[1], (U32)data[2]);
         break;
      case STEP_ONE :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuStepRange(0,0);
         break;
      case TEST :
         EmuTest((U32)data[1], (U32)data[2]);
         break;
      case GET_CPU_STATUS :
         EmuGetCpuStatus();
         break;
      case ABORT :
         EmuAbort();
         AccessIceFlag(READ_ONE,FLYING,&flyFlag);
         break;
      case DIAGNOSTIC :
         EmuDiagnostic();
         break;
      case SET_TRACE_OFF_FULL :
         EmuSetTrcOffOnFull((U16)data[1]);
         break;
      case SET_TRIG_OUT_ACT :
         EmuSetTrigOutAct((ACTIVE_STATE)data[1]);
         break;
      case TRACE_ACTION :
         EmuTraceAction((U8)data[1]);
         break;
      case READ_STAMP :
         EmuReadFrameStamp((U16)data[1],(S32)data[2]);
         break;
      case SPA_SET_RANGE :
         EmuSPASetRange((U8)data[1],(U8)data[2],(U32)data[3],(U32)data[4]);
         break;
      case SPA_CLEAR_RANGE :
         EmuSPAClearRange((U8)data[1]);
         break;
      case SPA_GET_MA_INFO :
         EmuSPAGetMAInfo();
         break;
      case SPA_GET_TA_INFO :
         EmuSPAGetTAInfo();
         break;
      case SPA_GET_CC_INFO :
         EmuSPAGetCCInfo((U32)data[1],(U16)data[2],(U8)data[3]);
         break;
      case SPA_CLOSE :
         EmuSPAClose();
         break;
      case SPA_SETBKPT :
         EmuSPASetBkpt((U8)data[1],(EP_ADDR)data[2]);
         break;
      case SPA_OPEN :
         EmuSPAOpen();
         break;
      case R_FLUSH_ROM :
         EmuGetFROM();
         break;
      case W_FLUSH_ROM :
         EmuSetFROM((U8*)(av[1]+1));
         break;
      default :
         EmuReportError(COMMAND_ERROR);
   } /* end switch *data[0]. */
   //AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   //if (flyFlag) EmuGetCpuStatus();
   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   if (status == INVALID_FLY_COMMAND) OutputStatus(status,ON);
   else if (flyFlag && CheckEpStop()) {
        for (lp = 0; lp < 1000; lp++);
        StartGo(FLY_RUN);
   }
   return(GOOD);
}

RETCODE ListCodeCov(U32 adder,U16 len,U8 *data) ;

VOID spaTest() {
   U8 code = 0x90, jmpCode1[3] = { 0xE9, 0xED, 0x00 };
   U8 DataBuff[640], jmpCode2[3] = { 0xE9, 0xFD, 0xFA };
   U16 i, zero=0;

   EmuSetMap(0,0x7ffff,0x061); /* map 0 7ffff intetnal */
   EmuFill(0x0,0x3FFF,&code,1);

   EmuSetMemN(0x10,jmpCode1,3);     //  jmp 100
   EmuSetMemN(0x110,jmpCode1,3);   //  jmp 200
   EmuSetMemN(0x210,jmpCode1,3);   //  jmp 300
   EmuSetMemN(0x310,jmpCode1,3);   //  jmp 400
   EmuSetMemN(0x410,jmpCode1,3);   //  jmp 500
   EmuSetMemN(0x500,jmpCode2,3);   //  jmp 0


   EmuSPAClearRange(CC_RANGE);
   EmuSPASetRange(CC_RANGE,0,0,0x1000);

   EmuSetReg(I86_REG,R_CS,0x0);
   EmuSetReg(I86_REG,R_IP,0x0);
   EmuGo(SPA_CC_RUN);

   for (i=0; i < 0x2000; i++);
   EmuAbort();

   for (i=0 ; i < 3 ; i++) {
      ListCodeCov(0,0x20,DataBuff);
      ListCodeCov(0x100,0x20,DataBuff);
      ListCodeCov(0x200,0x20,DataBuff);
      ListCodeCov(0x300,0x20,DataBuff);
      ListCodeCov(0x400,0x20,DataBuff);
      ListCodeCov(0x40,0x20,DataBuff);
      ListCodeCov(0x140,0x20,DataBuff);
      ListCodeCov(0x240,0x20,DataBuff);
      ListCodeCov(0x340,0x20,DataBuff);
      ListCodeCov(0x440,0x20,DataBuff);
   }
}
/******************************** E O F ***********************************/

