/****************************************************************************
**
**  Name:  emumem.h
**
**  Description:
**     Michelle memory-group routines.
**     include:
**        "Read N bytes memory from Michelle -- EmuReadMemN()"
**        "Write N bytes memory to Michelle  -- EmuSetMemN()"
**        "Memory data comparing             -- EmuCompare()"
**        "Memory data coping                -- EmuCopy()"
**        "Memory data filling               -- EmuFill()"
**        "Memory data testing               -- EmuTest()"
**        "Memory data searching             -- EmuSearch()"
**        "Memory data checksumg             -- EmuChecksum()"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emumem.h_v  $
** 
**    Rev 1.0   03 Dec 1996 09:27:44   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:03:42   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emumem.h_v   1.0   03 Dec 1996 09:27:44   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_MEM_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/



/****************************************************************************
**
**  EmuReadMemN
**
**  Description: Michelle memory-group routine, to read a chunk memory
**               from "addr" location.
**
**  Parameters:
**     input:
**        addr -- unsigned long
**        len  -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**        return data -- "length" + "N bytes data string"
**
*****************************************************************************/
VOID EmuReadMemN(U32 addr, U32 len);

/****************************************************************************
**
**  EmuSetMemN
**
**  Description: Michelle memory-group routine, to write a chunk data
**               from "buff" to "addr" location. The driver program can
**               use this function to implement to download code from a
**               file.
**               The length should be limitted up to 1024 bytes(1KB).
**
**  Parameters:
**     input:
**        addr  -- unsigned long,
**        *buff -- unsigned char,
**        len   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuSetMemN(U32 addr, U8 *buff, U16 len);


/****************************************************************************
**
**  EmuCompare
**
**  Description: Michelle memory-group routine, to compare two memory
**               blocks.
**               Return the locations and its contents, if there has
**               difference.
**               The "addr" and "addrLen" is the addres range of the
**               first block.
**               The "addr2" is the start address of the second block.
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**        addr2 -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**        return data -- "length" + "location" + "contents"
**
*****************************************************************************/
VOID EmuCompare(U32 addr, U32 addrLen, U32 addr2);


/****************************************************************************
**
**  EmuCopy
**
**  Description: Michelle memory-group routine, to copy a memory block
**               data to another block's.
**               The "addr" and "addrLen" is the addres range of the
**               first block.
**               The "addr2" is the start address of the destination
**               block.
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**        addr2 -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuCopy(U32 addr, U32 addrLen, U32 addr2);


/****************************************************************************
**
**  EmuFill
**
**  Description: Michelle memory-group routine, to fill a memory range
**               with a specified pattern.
**               Fill a memory range with a specified pattern.
**               Data pattern is specified in "buff" array.
**               The lengh of the data pattern is "len".
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**        *buff -- unsigned char,
**        len   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuFill(U32 addr, U32 addrLen, U8 *buff, U16 len);

/****************************************************************************
**
**  EmuTest
**
**  Description: Michelle memory-group routine, to test a spcified
**               address range working O.K. or not? Is RAM or not?
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**
**    *** *pattern[n] -- char ===> optional
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**  NOTE: I have three ways to do this testing, you can decide how
**        to implement it by one of these.
**        1. (Read data from specified address location) -->
**           (Write pre-read data back to the same memory location) -->
**           (Compare these result then check it to report the status)
**        2. Write the defined special data pattern to the specified
**           memory loaction, then check the virolation.
**        3. Like method 2, but driver can select the "data pattern"
**           as she like. In this case, to add a parameter to indicate
**           the data pattern is necessary.
**
*****************************************************************************/
VOID EmuTest(U32 addr, U32 addrLen);

/****************************************************************************
**
**  EmuSearch
**
**  Description: Michelle memory-group routine, to search data pattern
**               in the specified address range.
**               Data pattern is specified in "buff" array.
**               The lengh of the data pattern is "len".
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**        *buff -- unsigned char,
**        len   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuSearch(U32 addr, U32 addrLen, U8 *buff, U16 len);

/****************************************************************************
**
**  EmuChecksum
**
**  Description: Michelle memory-group routine, to caculate the data
**               sum value of the specified address range.
**               The "addr" and "addrLen" is the address range.
**               The "size" is the sum-width = 0 --> caculate in byte
**                                           = 1 --> caculate in word
**                                           = 2 --> caculate in long word
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        addrLen -- unsigned long,
**        size  -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
****************************************************************************/
VOID EmuChecksum(U32 addr, U32 addrLen);

/******************************** E O F ***********************************/
