/***************************************************************************
**
**  Name:  emuport.c
**
**  Description:
**     Michelle port-group routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emuport.c_v  $
** 
**    Rev 1.0   03 Dec 1996 09:27:36   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:05:58   jacky
** Get file from ATL. V1.3
** 
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emuport.c_v   1.0   03 Dec 1996 09:27:36   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_PORT_
#include "emuport.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/***************************************************************************
**
**  EmuInput
**
**  Description: Michelle input routine,
**
**  Parameters:
**     input:
**        port -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        return data -- "length" + "data"
**
****************************************************************************/
VOID EmuInput(U16 port,U16 len, U16 size) {
U16 i86Reg[MAX_CPU_REG_NO];
U8 dataLen;

   StopRun();
   ClrViolFlg();
   EnEmDisViol();

   AccessCpuReg(READ_ALL,noUse,i86Reg);
   InputData(port,len,size);
   DisEmStop();
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
   diff = (U8 *)&canTemp;
   if (brOver == GOOD) {
      OutputStatus(GOOD,OFF);
      dataLen = (U8)len;
      OutData(dataLen,diff,ON);
      OutEnd();
   }
   else OutputBrOverError(ON);
}

/***************************************************************************
**
**  EmuOutput
**
**  Description: Michelle output routine,
**
**  Parameters:
**     input:
**        port  -- unsigned int,
**        value -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**
****************************************************************************/
VOID EmuOutput(U16 port, U8 *buff, U16 len, U16 size) {
U16 i86Reg[MAX_CPU_REG_NO];

   StopRun();
   ClrViolFlg();
   EnEmDisViol();
   AccessCpuReg(READ_ALL,noUse,i86Reg);
   OutputData(port,len,buff,size);
   DisEmStop();
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
   if (brOver == GOOD) OutputStatus(GOOD,ON);
   else OutputBrOverError(ON);
}

/******************************** E O F ***********************************/

