/****************************************************************************
**
**  Name:  emusetup.h
**
**  Description:
**     Michelle setup-group routines.
**     include:
**     "Get the identity of the Michelle FW version, HW configuration
**      and HW model type",
**     "Set access size to be byte/word/dword-accessing",
**     "Set or read the memory-write verify-flag",
**     "Control ready using external/internal",
**     "Set or read the memory mapping",
**     "Read all setup information",
**     "Set control signals",
**    * "set or read the wait-state" --- This is a issue to be discussed.
**      We will decide this latter.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/mp186/emusetup.h_v  $
** 
**    Rev 1.0   03 Dec 1996 09:27:44   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:05:10   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/mp186/emusetup.h_v   1.0   03 Dec 1996 09:27:44   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_SETUP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  EmuSetControl
**
**  Description: Michelle setup-group routine,
**
**  Parameters:
**     input:
**        signals -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetControl(U16 signals);

/****************************************************************************
**
**  EmuGetControl
**
**  Description: Michelle setup-group routine,
**
**  Parameters:
**     input:
**        signals -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetControl(VOID);


/****************************************************************************
**
**  EmuGetStatus
**
**  Description: Michelle setup-group routine, to read the current setting
**               of the Michelle.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." be Normal return
**        "Emulator Fatal Error" for HW error
**        return data -- "length" + "events" + "qualify: + "trigger" +
**                       "MAP" + control signals" +
**                       "ready setting"
**
**                     * "ID" is a issue to be discussed later
**
*****************************************************************************/
VOID EmuGetStatus(VOID);



/****************************************************************************
**
**  EmuGetID()
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
*****************************************************************************/
VOID EmuGetID(VOID);

/****************************************************************************
**
**  EmuSetMap()
**
**  Description: Michelle setup-group routine, to set the emulation
**               memory map.
**               "addr" is the starting address of this mapping memory.
**               It should be on the address boundary of 64KB.
**               "map" is the mapping of current 64K memory bank.
**               If memoryresolution is 4KB and map is 0xFFCF. The emulation
**               memory will be mapped as two segments. 0..0x3fff and
**               0x6000..0xffff.
**               The definition of "attr" as below:
**               BIT Meaning
**               --- --------------------------------------------
**                0  "0" = Internal Memory, "1" = External memory
**                1  "0" = Read/Write, "1" = Read-Only
**                2  "0" = Exist memory, "1" = Gard memory
**                3  Reserved
**                4  Segments(with bit 5) -- "00" = ES, "01" = CS
**                5  Segments(with bit 4) -- "10" = SS, "11" = DS
**                6  Reserved
**                7  Reserved
**
**  Parameters:
**     input:
**        "addr" -- unsigned long,
**        "map"  -- unsigned int,
**        "attr" -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetMap(U32 addr1, U32 addr2, U16 attrib);

/****************************************************************************
**
**  EmuGetMap()
**
**  Description: Michelle setup-group routine, to get the emulation
**               memory map.
**
**  Parameters:
**     input:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetMap(VOID);

/****************************************************************************
**
**  InitMapTable()
**
**  Description: Michelle setup-group routine, to get the emulation
**               memory map.
**
**  Parameters:
**     input:
**
**     output:
**
*****************************************************************************/
STATUS InitMapTable(VOID);

/***************************************************************************
**
**  EmuGetMapSize
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetMapSize(VOID);

/****************************************************************************
**
**  EmuGetMode()
**
**  Description: Michelle setup-group routine, to select the Mode
**               "src" = 0 --> command mode
**               "src" = 1 --> queue status mode
**
**  Parameters:
**     input:
**        src -- BOOLEAN (Or int)
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetMode(VOID);

/****************************************************************************
**
**  EmuSetReady()
**
**  Description: Michelle setup-group routine, to select the READY signal
**               source.
**               "src" = 0 --> Internal
**               "src" = 1 --> External
**
**  Parameters:
**     input:
**        src -- BOOLEAN (Or int)
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetReady(U16 flag);

/****************************************************************************
**
**  EmuGetReady()
**
**  Description: Michelle setup-group routine, to select the READY signal
**               source.
**               "src" = 0 --> Internal
**               "src" = 1 --> External
**
**  Parameters:
**     input:
**        src -- BOOLEAN (Or int)
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetReady(VOID);

/****************************************************************************
**
**  EmuSetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Byte-access (16-Bit),
**               "size" = 2 --> Byte-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetAccessSize(SIZE size);

/****************************************************************************
**
**  EmuGetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Byte-access (16-Bit),
**               "size" = 2 --> Byte-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetAccessSize(VOID);

/****************************************************************************
**
**  EmuSetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetWait(U16 count);

/****************************************************************************
**
**  EmuGetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetWait(VOID);

/****************************************************************************
**
**  EmuSetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetSync(U16 state);

/****************************************************************************
**
**  EmuGetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetSync(VOID);


/****************************************************************************
**
**  EmuSetVerify
**
**  Description: Michelle setup-group routine, to verify the writting
**               action onto the memory. (Memory write verification)
**               "flag" = 0 --> Disable the verification
**               "flag" = 1 --> Enable the verification
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetVerify(U16 flag);

/****************************************************************************
**
**  EmuGetVerify
**
**  Description: Michelle setup-group routine, to verify the writting
**               action onto the memory. (Memory write verification)
**               "flag" = 0 --> Disable the verification
**               "flag" = 1 --> Enable the verification
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetVerify(VOID);

/***************************************************************************
**
**  EmuTimer
**
**  Description:
**
**
**
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuEpTimer(U16 timerFlag);

/******************************** E O F ***********************************/

