#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  $Log:   S:/tbird/arcmtat2/mp186/makefile.mav  $
#  
#     Rev 1.2   17 Dec 1996 17:30:52   gene
#  
#     Rev 1.1   09 Dec 1996 12:09:02   gene
#  
#     Rev 1.1   09 Dec 1996 11:59:52   gene
#  
#     Rev 1.1   09 Dec 1996 11:58:14   gene
#  change path
#  
#     Rev 1.1   09 Dec 1996 11:49:20   gene
#  
#     Rev 1.1   09 Dec 1996 11:47:48   gene
#  
#     Rev 1.0   03 Dec 1996 09:27:48   gene
#  Initial revision.
#
#  $Header:   S:/tbird/arcmtat2/mp186/makefile.mav   1.2   17 Dec 1996 17:30:52   gene  $
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = .\asm
BIN = c:\mtat2_fw\mp186\bin
CCDIR = d:\C600\bin
INC = d:\C600\include
LNKDIR = d:\lnkloc\bin
USDDIR = C:\USD
TMPDIR = .\bin

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(BIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(BIN)
.PATH.ABS = $(BIN)
.PATH.HEX = $(BIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
#CC = $(CCDIR)\bcc
MASM = $(CCDIR)\masm
#MASM = $(CCDIR)\tasm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = /AL /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = -c -f- -mm -v -vi -y -w
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
 $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fo$(BIN)\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fa$(TMPDIR)\$&.asm /Fo$(BIN)\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fc$(SRC)\$&.COD /Fo$(BIN)\$&.obj $(SRC)\$&.C
#$(CC) $(CFLAG) -I. -I$(INC) -o$(BIN)\$&.obj $(SRC)\$&.C
# find ": error " $(TMPDIR)\err.lst > $&.lst
# find ": warning " $(TMPDIR)\err.lst >> $&.lst

.A00.obj:
# $(MASM) /Mx /Zi $&.Asm,$(BIN)\$&,$(SRC)\$&;
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(TMPDIR)\ERR;
#$(MASM) /Mx /Zi /w /z /i$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(TMPDIR)\ERR;
# find "error " $(TMPDIR)\err.lst > $&.lst
# find "warning " $(TMPDIR)\err.lst >> $&.lst

# define all objs
LNK_depends =  start.obj emumain.OBJ functest.obj emucomm.obj emuemul.obj\
               emuerror.obj emumem.obj  emuport.obj emulib.obj\
               emusetup.obj emutrace.obj emullfw.obj trclib.obj\
               epm186.obj ovmem.obj trcevent.obj trcflex.obj trctman.obj\
               codecov.obj
#

MAIN186.BIN : MAIN186.OMF
 $(PROM)  $(BIN)\MAIN186.ABS TO $(BIN)\MAIN186.BIN ADDRESSES(0400H, 03FFFFH) CHECKSUM

MAIN186.OMF : MAIN186.ABS
 $(CV2OMF) $(BIN)\MAIN186.ABS TO $(BIN)\MAIN186.OMF

MAIN186.ABS : MAIN186.LNK
 $(LOC)  @&&!
            $(BIN)\MAIN186.LNK TO $(BIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 CODE,&
                 CODE_END,&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END&
&                 XSEG,&
&                 NMCS2H,&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               CODE(00400H), DATA_BEG(080000H),&
               STACK(08C000H),&
               XSEG(090000H),NMCS2H(0D0000H),&
               DATA1(0C0000H),&
               DEBSYM(040000H),DEBTYP(048000H)),&
               GROUPS(DGROUP(080000H)) &
            )&
            SEGSIZE(STACK(04000H))&
            MAP &
            ST(INIT)&
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
epm186.obj : epm186.a00 cpm.equ epm.equ sio.equ cpmio.def\
            nmcs2h.def xseg.def can186.db can186.tbl epc.asm exbp188.db
start.obj : start.a00
ovmem.obj : ovmem.a00
#covrbw.obj : covrbw.a00

# .C  condition definition
emumain.obj  : emumain.c emucomm.h emuerror.h emullfw.h emutypes.h
functest.obj : functest.c functest.h emuerror.h emullfw.h
emucomm.obj : emucomm.c emucomm.h emuerror.h emullfw.h
emuemul.obj  : emuemul.c  emuemul.h emuerror.h emullfw.h
emuerror.obj : emuerror.c emuerror.h emuerror.h emullfw.h
emumem.obj   : emumem.c   emumem.h emuerror.h emullfw.h
emuport.obj  : emuport.c  emuport.h emuerror.h emullfw.h
emusetup.obj : emusetup.c emusetup.h emuerror.h emullfw.h
emutrace.obj : emutrace.c emutrace.h emuerror.h emullfw.h emutypes.h
emulib.obj   : emulib.c  emulib.h emuerror.h emullfw.h
trctman.obj  : trctman.c trctman.h trcerror.h trclib.h main.ttf
trcevent.obj : trcevent.c trcevent.h trcerror.h trclib.h trctman.h smain.ttf
trclib.obj   : trclib.c trclib.h
trcflex.obj  : trcflex.c trcflex.h trcerror.h trclib.h pio.ttf pipe4.ttf p4pio.ttf pipe.ttf 
codecov.obj  : codecov.c trctman.h trcerror.h trclib.h codcov.ttf

# Template file for dummy low level FW
emullfw.obj   : emullfw.c  emullfw.h


#main186.hex : main186.abs
#$(OH86) $&
# $(CHKSUM) $&.hex 0 0d0000 0ffffb 0ffffe

MAIN186.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(BIN)\start.obj,$(BIN)\emumain.obj,$(BIN)\emulib.obj,&
             $(BIN)\functest.obj,$(BIN)\emucomm.obj,$(BIN)\emuemul.obj,&
             $(BIN)\emuerror.obj,$(BIN)\emumem.obj,$(BIN)\emuport.obj,&
             $(BIN)\emusetup.obj,$(BIN)\emutrace.obj,$(BIN)\emullfw.obj,&
             $(BIN)\epm186.obj,$(BIN)\ovmem.obj,&
             $(BIN)\trcevent.obj,$(BIN)\trcflex.obj,$(BIN)\trctman.obj,&
             $(BIN)\trclib.obj,$(BIN)\codecov.obj,&
             $(SRC)\MLIBCE.SSI TO $(BIN)\MAIN186.LNK
!

