/***************************************************************************
**
** Name: codecov.c
**
** Description:
**   Services for code coverage
**
** Copyright (C) 1996 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <conio.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCTEST_
#include "trctest.h"
#endif

#ifndef _TRCDTST_
#include "trclib.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif
                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define TAC         0x08
#define TLD         0x10

/* P0 port address define */

#define WriteP0Byte1   0xF300
#define WriteP0Byte3   0xF302

/* P1 port address define */

#define WriteP1Byte1   0xF308
#define WriteP1Byte3   0xF30A

/* P2 port address define */

#define WriteP2Byte1   0xF310
#define WriteP2Byte3   0xF312

/* P3 port address define */

#define WriteP3Byte1   0xF318
#define WriteP3Byte3   0xF31A

/* P4 port address define */

#define WriteP4Byte1   0xF320
#define WriteP4Byte2   0xF321
#define nWRP4CtrlAX    0xF325
#define P4CtrlB        0xF327

/* MAIN CONTROL port address define */

#define WriteCompByte  0xF328
#define CodCovCtrlBYte 0xF32F

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern U8  FLEXConfig ;
extern U8  _far PIPEByte[];
extern U8  _far PIOByte[];
extern U8  _far P4PIPEByte[];
extern U8  _far P4PIOByte[];
extern U8  _far MNCPRWByte[];

U8 _based(_segname("_CODE")) CodCovge[] = {
#include "codcov.ttf"
};
U16 CodeCoverRange[12];



                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE SetCodCovRAM(VOID) ;
VOID SetTRCMData(U16 data) ;
RETCODE SetBC2CodCov(VOID) ;

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/***************************************************************************
**
**  SetBC2CodCov
**
****************************************************************************/
RETCODE SetBC2CodCov(VOID) {
   RETCODE err;
   U32 i,j=0;

   if ((FLEXConfig | P4Pipe) != P4Pipe) {
     if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P4Pipe ;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(LA0A1nOE,0x80);

   for (i=0;i <= 0xFF;i++) {
      WrBCOneAddr(Rport,(U16) i,0xFFFF,(U16) i,0);
   }
   for (i=0;i<=0xFFFF;i++) {
      WrBCOneAddr(Sport,(U16) i,0xFFFF,(U16) i,0);
   }

   for (i=0;i<=0xF;i++) {
      WrBCMaskAddr(Tport,0x0F00,(U16) (i << 8),0,(U16) i,0xFFF);
   }

   outp(LA0A1nOE,0);
}
/***************************************************************************
**
**  SetCodCovRAM
**
****************************************************************************/
RETCODE SetCodCovRAM(VOID) {
   RETCODE err;
   U8 temp = 0;

   if ((FLEXConfig & P4Pio ) != P4Pio ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P4Pio ;
   }
   if ((FLEXConfig & CodeCov ) != CodeCov) {
     if((err =  FLEXProgram(FLEX_MN,CodCovge)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= CodeCov;
   }

   outp(nWRP4CtrlAX,0);   //Disable TRCM Output enable

   outp(P0CtrlPort,nOEA);  // Enable P0-P4 output enable //
   outp(P1CtrlPort,nOEA);
   outp(P2CtrlPort,nOEA);
   outp(P3CtrlPort,nOEA);
   outp(P4CtrlB,nOEA);

   // Write data "0" to R,S,T,U,V,W port SSRAM

   SetTRCMData(0);

   outp(P4CtrlAX,FWrite3 | FWrite2 | FWrite1 | FWrite0 | EnByteWr);   //Enable TRCM Byte write enable
   outp(CodCovCtrlBYte,TLD);
   outpw(WriteCompByte,0);
   outp(CodCovCtrlBYte,TAC);
   while( (inp(nRDMN) & 0x01) != 1 ) ;
   outp(CodCovCtrlBYte,0);
   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable

   outp(P0CtrlPort,0);  // disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   // Prepare data "FF" to R,S,T,U,V,W port SSRAM

   SetTRCMData(0xFFFF);

   return(GOOD);
}

/*****************************************************************************
**
**  SetTRCMData
**
******************************************************************************/
VOID SetTRCMData(U16 data) {

     outpw(WriteP0Byte1,data) ; // Prepare data to R,S,T,U,V,W port SSRAM
     outpw(WriteP0Byte3,data) ;
     outpw(WriteP1Byte1,data) ;
     outpw(WriteP1Byte3,data) ;
     outpw(WriteP2Byte1,data) ;
     outpw(WriteP2Byte3,data) ;
     outpw(WriteP3Byte1,data) ;
     outpw(WriteP3Byte3,data) ;

     outpw(WriteP4Byte1,data);  // Prepare data to Event,Lv,TC port SSRAM

}

/*****************************************************************************
**
**  ProgramMNCodeCov
**
******************************************************************************/
RETCODE ProgramMNCodeCov(SPA_CC_RANGE_NODE *coderange) {
   RETCODE err;
   U8 i,temp = 0;

   outp(FClkSel0,0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   if((err = SetBC2CodCov()) != GOOD) return(err);      // Set Bus compare SSRAM to codecoverage
   if((err = SetCodCovRAM()) != GOOD) return(err);      // Set Code coverage SSRAM

   for (i=0;i<12;i++) {
     CodeCoverRange[i] = (U16) ((coderange[i].addr) >> 16);
   }
   for (i=0;i<8;i++) {
     temp |= coderange[i].used << i ;
   }
   outp(CodCovCtrlBYte,6);
   outp(WriteCompByte,temp);
   temp = 0;
   for (i=0;i<4;i++) {
     temp |= coderange[i+8].used << i ;
   }
   outp(CodCovCtrlBYte,7);
   outp(WriteCompByte,temp);

   for(i=0;i<6;i++) {
     outp(CodCovCtrlBYte,0);
     outp(WriteCompByte+i,(U8) (coderange[i].addr >> 16));
     outp(CodCovCtrlBYte,1);
     outp(WriteCompByte+i,(U8) (coderange[i].addr >> 24));
     outp(CodCovCtrlBYte,2);
     outp(WriteCompByte+i,(U8) (coderange[i].status));
     outp(CodCovCtrlBYte,3);
     outp(WriteCompByte+i,(U8) (coderange[i].addr >> 16));
     outp(CodCovCtrlBYte,4);
     outp(WriteCompByte+i,(U8) (coderange[i].addr >> 24));
     outp(CodCovCtrlBYte,5);
     outp(WriteCompByte+i,(U8) (coderange[i].status));
   }

   outp(P0CtrlPort,nOEA);  // Enable P0-P4 output enable //
   outp(P1CtrlPort,nOEA);
   outp(P2CtrlPort,nOEA);
   outp(P3CtrlPort,nOEA);
   outp(P4CtrlB,nOEA);

   outp(LA0A1nOE,0);

   outp(P4CtrlAX,nOEBREG | nOETRIG | EnByteWr);
   /* Enable Bus Register and Trigger State Machine Output Enable and Force
      Byte Wirte of trace buffer */

   outp(FClkSel0,0);  // Change FCLK2/FCLK3/FCLK4 TO EPCLK
   outp(FClkSel1,0);

   return(GOOD);
}

/*****************************************************************************
**
**  ListCodeCov
**
******************************************************************************/
RETCODE ListCodeCov(U32 adder,U16 len,U8 *data) {
   RETCODE err;
   U8  LoNibble,HiNibble,CoverageID,bit1,bit2,bit3,bit4;
   U8  *datapoint,** CoverDataByte;
   U16 currentAdder;
   U32 i;

   if ((FLEXConfig & P4Pio ) != P4Pio ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P4Pio ;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if ((FLEXConfig & CodeCov ) != CodeCov) {
     if((err =  FLEXProgram(FLEX_MN,CodCovge)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= CodeCov;
   }

   outp(FClkSel0,0x80);    // Change FCLK2/FCLK3 TO CPCLK
   outp(FClkSel1,0);

   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable

   outp(P0CtrlPort,0);  // disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   datapoint = data;
   CoverDataByte = &datapoint;
   for (i=0;i<12;i++) {
      if (CodeCoverRange[i] == (U16) (adder >>16) ) {
         CoverageID = (U8) (i / 2) ;
         break;
      }
   }
   outp(nWRP4CtrlAX,nOETRCM);   //Enable TRCM Output enable
   outp(CodCovCtrlBYte,TLD | TAC);
   for (i = 0;i < ((len/4 + 1)/2);i++) {
   currentAdder = (U16) ((adder >> 2) + 2*i );
   if ((currentAdder == 0) && (adder != 0)) CoverageID++;
   if (CoverageID == 6 ) return(ERR_CODECOVERID);
      switch(CoverageID) {
         case 0 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 = (U8)(inp(ReadP0Byte3) & 0x01) ;
            bit2 = (U8)(inp(ReadP0Byte4) & 0x02) ;
            bit3 = (U8)(inp(ReadP0Byte1) & 0x04) ;
            bit4 = (U8)(inp(ReadP0Byte2) & 0x08) ;
            LoNibble=(bit1 |bit2 |bit3 |bit4 );
            outpw(WriteCompByte,(currentAdder+1));
            bit1 = (U8)(inp(ReadP0Byte3) & 0x10) ;
            bit2 = (U8)(inp(ReadP0Byte4) & 0x20) ;
            bit3 = (U8)(inp(ReadP0Byte1) & 0x40) ;
            bit4 = (U8)(inp(ReadP0Byte2) & 0x80) ;
            HiNibble=(bit1 |bit2 |bit3 |bit4 );
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
         case 1 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 = (U8)(inp(ReadP1Byte3) & 0x01) ;
            bit2 = (U8)(inp(ReadP1Byte4) & 0x02) ;
            bit3 = (U8)(inp(ReadP1Byte1) & 0x04) ;
            bit4 = (U8)(inp(ReadP1Byte2) & 0x08) ;
            LoNibble=(bit1 |bit2 |bit3 |bit4 );
            outpw(WriteCompByte,(currentAdder+1));
            bit1 = (U8)(inp(ReadP1Byte3) & 0x10) ;
            bit2 = (U8)(inp(ReadP1Byte4) & 0x20) ;
            bit3 = (U8)(inp(ReadP1Byte1) & 0x40) ;
            bit4 = (U8)(inp(ReadP1Byte2) & 0x80) ;
            HiNibble=(bit1 |bit2 |bit3 |bit4 );
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
         case 2 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 = (U8)(inp(ReadP2Byte3) & 0x01) ;
            bit2 = (U8)(inp(ReadP2Byte4) & 0x02) ;
            bit3 = (U8)(inp(ReadP2Byte1) & 0x04) ;
            bit4 = (U8)((inp(nRDMN) & 0x02) <<2) ;
            LoNibble=(bit1 |bit2 |bit3 |bit4 );
            outpw(WriteCompByte,(currentAdder+1));
            bit1 = (U8)(inp(ReadP2Byte3) & 0x10) ;
            bit2 = (U8)(inp(ReadP2Byte4) & 0x20) ;
            bit3 = (U8)(inp(ReadP2Byte1) & 0x40) ;
            bit4 = (U8)((inp(nRDMN) & 0x02) <<2) ;
            HiNibble=(bit1 |bit2 |bit3 |bit4 );
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
         case 3 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 =  (U8)(inp(nRDMN) & 0x04) ;
            bit2 =  (U8)(inp(nRDMN) & 0x08) ;
            bit3 =  (U8)(inp(nRDMN) & 0x10) ;
            bit4 =  (U8)(inp(nRDMN) & 0x20) ;
            LoNibble= (U8) ((bit1 |bit2 |bit3 |bit4) >> 2);
            outpw(WriteCompByte,(currentAdder+1));
            bit1 =  (U8)(inp(nRDMN) & 0x04) ;
            bit2 =  (U8)(inp(nRDMN) & 0x08) ;
            bit3 =  (U8)(inp(nRDMN) & 0x10) ;
            bit4 =  (U8)(inp(nRDMN) & 0x20) ;
            HiNibble=(U8) ((bit1 |bit2 |bit3 |bit4) << 2);
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
         case 4 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 = (U8)(inp(ReadP3Byte3) & 0x01) ;
            bit2 = (U8)(inp(ReadP3Byte4) & 0x02) ;
            bit3 = (U8)(inp(ReadP3Byte1) & 0x04) ;
            bit4 = (U8)(inp(ReadP3Byte2) & 0x08) ;
            LoNibble=(bit1 |bit2 |bit3 |bit4 );
            outpw(WriteCompByte,(currentAdder+1));
            bit1 = (U8)(inp(ReadP3Byte3) & 0x10) ;
            bit2 = (U8)(inp(ReadP3Byte4) & 0x20) ;
            bit3 = (U8)(inp(ReadP3Byte1) & 0x40) ;
            bit4 = (U8)(inp(ReadP3Byte2) & 0x80) ;
            HiNibble=(bit1 |bit2 |bit3 |bit4 );
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
         case 5 :
            outpw(WriteCompByte,currentAdder);  //Set adder of TRCM
            bit1 = (U8)(inp(ReadEvent) & 0x01)    ;
            bit2 = (U8)((inp(ReadLvTc) & 0x01) << 1) ;
            bit3 = (U8)(inp(ReadLvTc) & 0x04)     ;
            bit4 = (U8)((inp(nRDMN) & 0x40) >> 3) ;
            LoNibble=(bit1 |bit2 |bit3 |bit4 );
            outpw(WriteCompByte,(currentAdder+1));
            bit1 = (U8)(inp(ReadEvent) & 0x01)    ;
            bit2 = (U8)((inp(ReadLvTc) & 0x01) << 1) ;
            bit3 = (U8)(inp(ReadLvTc) & 0x04)     ;
            bit4 = (U8)((inp(nRDMN) & 0x40) >> 3) ;
            HiNibble=(U8) ((bit1 |bit2 |bit3 |bit4 ) << 4);
            **CoverDataByte = (U8) (HiNibble | LoNibble);
            datapoint++;
         break;
      }
   }
   return(GOOD);
}
/********************************* EOF *************************************/
