/****************************************************************************
**
** Name: trcevent.c
**
** Description:
**   Bus event setting services
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/mp186/trace/trcevent.c_v  $
** 
**    Rev 1.5   02 Apr 1997 15:24:00   ibin
** 
** $Header:   S:/tbird/arcmtat2/mp186/trace/trcevent.c_v   1.5   02 Apr 1997 15:24:00   ibin  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <conio.h>
#include <dos.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif
// #ifndef _TRCERROR_
// #include "trcerror.h"
// #endif
#ifndef _TRCEVENT_
#include "trcevent.h"
#endif
#ifndef _TRCDTST_
#include "trclib.h"
#endif
#ifndef _TRCTMAN_
#include "trctman.h"
#endif
#ifndef _TRCFLEX_
#include "trcflex.h"
#endif
#ifndef _TRCTEST_
#include "trctest.h"
#endif


                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/


#define EVENT_QUANTITY 8

U8 _based(_segname("_CODE")) MNCPRWByte[] = {
#include "smain.ttf"
};


#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define Uport       0x03
#define Vport       0x04
#define Wport       0x05

#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define NPACS       0xFFA4
#define NMPCS       0xFFA8

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04

/* P0 port address define */

#define WriteP0Byte1    0xF300
#define WriteP0Byte2    0xF301
#define WriteP0Byte3    0xF302
#define WriteP0Byte4    0xF303
#define ReadP0CtrlPort  0xF304
#define P0CtrlPort      0xF307

/* P1 port address define */

#define WriteP1Byte1    0xF308
#define WriteP1Byte2    0xF309
#define WriteP1Byte3    0xF30A
#define WriteP1Byte4    0xF30B
#define ReadP1CtrlPort  0xF30C
#define P1CtrlPort      0xF30F

/* P2 port address define */

#define WriteP2Byte1    0xF310
#define WriteP2Byte2    0xF311
#define WriteP2Byte3    0xF312
#define WriteP2Byte4    0xF313
#define ReadP2CtrlPort  0xF314
#define P2CtrlPort      0xF317

/* P3 port address define */

#define WriteP3Byte1    0xF318
#define WriteP3Byte2    0xF319
#define WriteP3Byte3    0xF31A
#define WriteP3Byte4    0xF31B
#define ReadP3CtrlPort  0xF31C
#define P3CtrlPort      0xF31F

/* P4 port address define */

#define P4CtrlAX   0xF325
#define P4CtrlAY   0xF326
#define P4CtrlB    0xF327

/* MN port address define */

#define SetLo      0xF328
#define SetHi      0xF329
#define MaskLo     0xF32A
#define MaskHi     0xF32B
#define RWTrig     0xF32C
#define MNCtrlAX   0xF32D
#define MNCtrlAY   0xF32E
#define MNCtrlB    0xF32F

/* CPIO port address define */

#define ChgWr      0xF338

/* P0-P3 control port corresponding bit define */

#define nOEA       0x10
#define nOEX       0x08
#define nOEY       0x04
#define FSld       0x01

/* Main control port corresponding bit define */

#define SEQ       0x04
#define DOE       0x02
#define BCK       0x01

/* I/O corresponding bit define */

#define EnBCWr     0x20
#define Done       0x80


U8 ctrlbyte;
U16 _based(_segname("_CODE")) CtrlPort[6]=
{P0CtrlPort,P0CtrlPort,P1CtrlPort,P1CtrlPort,P2CtrlPort,P2CtrlPort};
U16 _based(_segname("_CODE")) ReadCtrlPort[6]=
{ReadP0CtrlPort,ReadP0CtrlPort,ReadP1CtrlPort,ReadP1CtrlPort,ReadP2CtrlPort
,ReadP2CtrlPort};
U16 _based(_segname("_CODE"))  WrByte1[6] =
{WriteP0Byte1,WriteP0Byte1,WriteP1Byte1,WriteP1Byte1,WriteP2Byte1,WriteP2Byte1};
U16 _based(_segname("_CODE"))  WrByte2[6] =
{WriteP0Byte2,WriteP0Byte2,WriteP1Byte2,WriteP1Byte2,WriteP2Byte2,WriteP2Byte2};
U16 _based(_segname("_CODE"))  WrByte3[6] =
{WriteP0Byte3,WriteP0Byte3,WriteP1Byte3,WriteP1Byte3,WriteP2Byte3,WriteP2Byte3};
U16 _based(_segname("_CODE"))  WrByte4[6] =
{WriteP0Byte4,WriteP0Byte4,WriteP1Byte4,WriteP1Byte4,WriteP2Byte4,WriteP2Byte4};
U8 _based(_segname("_CODE"))   nOE[6] =
{nOEX,nOEY,nOEX,nOEY,nOEX,nOEY};

static const U16 _based(_segname("_CODE")) pattern[] = {
   0x0C00 /* S (instruction fetch) */,
   0x0D00 /* R (memory read) */,
   0x0E00 /* W (memory write) */,
   0x0900 /* I (I/O read) */,
   0x0A00 /* O (I/O write) */,
   0x0800 /* A (interrupt acknowledge) */,
   0x0B00 /* H (bus halt) */,
   0x2000 /* D (DMA cycle) */ };

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern U8 FLEXConfig ;
extern U8  _far PIOByte[];
extern U8  _far PIPEByte[];
extern U8  _far P4PIPEByte[];
extern U8  _far P4PIOByte[];
extern U8  _far test[];


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE SetMultiStatus(EP_STATUS status,U8 eventID);

RETCODE SetOneEvent(BUS_EVENT *eventStruc,U8 eventID);
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U8 eventID) ;
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) ;

VOID SetExternalTraceBit(EP_STATUS status,U8 eventID) ;
VOID ClearAllEvent(VOID);

VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) ;
VOID SetBCData(U8 port,U16 mask,U16 set) ;

VOID WrBCRangeAddr(U8 port,U16 addr,U16 bit,U16 fcnt,U8 eventID) ;
VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  SetExternalTraceBit
**
*******************************************************************************/
VOID SetExternalTraceBit(EP_STATUS status,U8 eventID) {
   U8 i,cntvalue = 0,value,mask;

   mask = (U8) (status >> 24) ;
   value = (U8)(status >> 8) ;
   for (i=0; i < 8; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
   if ( cntvalue != 0 ) {
      WrBCMaskAddr(Wport,(U16) mask,(U16) value,~(0x01 << eventID),0xFF,
                   (0x01 << cntvalue)) ;
   }
   else {
      WrBCOneAddr(Wport,(U16) value,0x01,0xFF,eventID);
   }
}
/******************************************************************************
**
**  SetAllBusEvent
**
*******************************************************************************/
RETCODE SetAllBusEvent(BUS_EVENT *events) {
   RETCODE err;
   U8 eventID;

   if ((FLEXConfig | P4Pipe ) != P4Pipe ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P4Pipe;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(LA0A1nOE,0x80);
   outp(P4CtrlAX,0) ;  //Disable Bus Register output enable

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   ClearAllEvent() ;
   for (eventID = 0; eventID < EVENT_QUANTITY; eventID++) {
      if ((err = SetOneEvent(&events[eventID], eventID)) != GOOD)
         return(err);
   }

   outp(LA0A1nOE,0);

   return(GOOD);
}

/******************************************************************************
**
**  SetRangeAddr
**
**  Description:
**    Set upper or lower bound of range addr of one event
**
**  Parameters:
**    input:
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U8 eventID) {
   U16 addrloHiByte,addrloLoByte,addrhiHiByte,addrhiLoByte,fcnthi,fcntlo;

   addrloHiByte = (U16) (addrlo >> 16) ;
   addrloLoByte = (U16) addrlo ;
   addrhiHiByte = (U16) (addrhi >> 16) ;
   addrhiLoByte = (U16) addrhi ;
   fcnthi = addrhiHiByte-addrloHiByte;
   switch (fcnthi) {
      case 0 :
         WrBCOneAddr(Rport,addrloHiByte,0x0101,0x0100,eventID);
         break;
      case 1 :
         WrBCOneAddr(Rport,addrhiHiByte,0x0001,0x00,eventID);
         WrBCOneAddr(Rport,addrloHiByte,0x0100,0x00,eventID);
         break;
      case 2 :
         WrBCOneAddr(Rport,addrhiHiByte,0x0001,0x00,eventID);
         WrBCOneAddr(Rport,addrloHiByte+1,0x0001,0x00,eventID);
         WrBCOneAddr(Rport,addrhiHiByte-1,0x0100,0x00,eventID);
         WrBCOneAddr(Rport,addrloHiByte,0x0100,0x00,eventID);
         break;
      default:
         WrBCRangeAddr(Rport,addrloHiByte+1,0x0001,(0xFFFF-(fcnthi-2)),eventID) ;
         WrBCRangeAddr(Rport,addrloHiByte,0x0100,(0xFFFF-(fcnthi-2)),eventID) ;
         break;
   }

   if ( fcnthi != 0 ) {
      if ( addrloLoByte == addrhiLoByte )
         WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
      else {
         switch(0xFFFF-addrloLoByte) {
            case 0 :
               WrBCOneAddr(Sport,0xFFFF,0x0001,0,eventID);
               break;
            case 1 :
               WrBCOneAddr(Sport,0xFFFF,0x0001,0,eventID);
               WrBCOneAddr(Sport,0xFFFE,0x0001,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrloLoByte,0x0001,((addrloLoByte-2)),eventID);
               break;
         }
         switch(addrhiLoByte) {
            case 0 :
               WrBCOneAddr(Sport,0,0x0100,0,eventID);
               break;
            case 1 :
               WrBCOneAddr(Sport,0,0x0001,0,eventID);
               WrBCOneAddr(Sport,1,0x0001,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,0,0x0001,(0xFFFF-(addrhiLoByte-2)),eventID);
               break;
         }
      }
   }
   else {
      if (addrloLoByte < addrhiLoByte ) {
         fcntlo = addrhiLoByte - addrloLoByte;
         switch (fcntlo) {
            case 1 :
               WrBCOneAddr(Sport,addrloLoByte,0x0101,0,eventID);
               WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrloLoByte,0x0101,(0xFFFF-(fcntlo-2)),
                             eventID);
               break;
         }
      }
      else {
         fcntlo =addrloLoByte - addrhiLoByte ;
         switch (fcntlo) {
            case 1 :
               WrBCOneAddr(Sport,addrloLoByte,0x0101,0,eventID);
               WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrhiLoByte,0x0101,(0xFFFF-(fcntlo-2)),
                             eventID);
               break;
         }
      }
   }
   return(GOOD);
}

/******************************************************************************
**
**  SetSingleMask
**
**  Description:
**    Set addr, data or status field of one event to a single value or
**    a value with mask.
**    For a single value, set the input parameter "mask" to be 0xFFFFFFFF.
**
**  Parameters:
**    input:
**      field: ADDR_FIELD, DATA_FIELD or STATUS_FIELD
**      value: setting value
**      mask: setting mask
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) {
   U8 i,cntvalue= 0;

   switch (field) {
      case ADDR_FIELD:
         for (i=0; i < 16; i++) if ( (~(mask >> 16) >> i) & 1 ) cntvalue++;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Rport,(U16) (mask >> 16),(U16) (value >> 16),~(0x0101 << eventID),
                      (0x01<< eventID),(0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Rport,(U16) (value >> 16),0x0101,0x01,eventID);
         }
         cntvalue = 0;
         for (i=0; i < 16; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Sport,(U16) mask ,(U16) value,~(0x0101 << eventID),0,
                      (0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Sport,(U16) value,0x0101,0,eventID);
         }
         break;
      case DATA_FIELD:
         for (i=0; i < 16; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Vport,(U16) mask ,(U16) value,~(0x01 << eventID),0xFF,
                      (0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Vport,(U16) value,0x01,0xFF,eventID);
         }
         break;
   }
   return(GOOD);
}

/******************************************************************************
**
**  SetMultiStatus
**
**  Description:
**    Set status field of one event to multiple status.
**    For example:
**                 set EV1 to break EP at status Input or Output
**                     >Event 1 XXXXX XX I O
**                 we call the status field setting of EV1 "I or O"
**
**    There are 8 statuses(S, R, W, I, O, A, H, D) for 80C186/188 and not any
**    arbitrary combinations of these 8 statuses can be "or" together.
**    For 80C186/188, the status are defined by 8 signals(ES[7..0]).
**    So there are 2 status nibbles(ES[7..4] and ES[3..0]).
**
**           stats nibble 1                   status nibble 0
**        =======================          ========================
**           ES7 => GND                       ES3 => /REFRESH
**           ES6 => FLUSH                     ES2 => /S2
**           ES5 => A19/S6 (DMA)              ES1 => /S1
**           ES4 => /BHE                      ES0 => /S0
**
**    Two status X and Y can be set to "or" together if and only if status
**    X and Y are different at the same status nibble.
**    For example:
**       Only S, R, W, I, O, A, H can "or" with each other.
**       D can not "or" with S, R, W, I, O, A, H.
**       So there are two status groups of 80C186/188
**       (i.e. group {S,R,W,I,O,A,H} and group {D})
**
**        status  |  ES7 ES6 ES5 ES4 ES3 ES2 ES1 ES0  |  pattern  |  mask
**      ----------+-----------------------------------+-----------+---------
**           S    |   X   X   X   X   1   1   0   0   |   0x0C    |  0x0F
**           R    |   X   X   X   X   1   1   0   1   |   0x0D    |  0x0F
**           W    |   X   X   X   X   1   1   1   0   |   0x0E    |  0x0F
**           I    |   X   X   X   X   1   0   0   1   |   0x09    |  0x0F
**           O    |   X   X   X   X   1   0   1   0   |   0x0A    |  0x0F
**           A    |   X   X   X   X   1   0   0   0   |   0x08    |  0x0F
**           H    |   X   X   X   X   1   0   1   1   |   0x0B    |  0x0F
**           D    |   X   X   1   X   X   X   X   X   |   0x20    |  0x20
**
**        Note:  `0' means "Low", `1' means "High", `X' means "Don't Care".
**
**  Parameters:
**    input:
**      *xlxMap: Xilinx CLB map for this field of the event
**      status: this is a 32-bit data, each bit of it represent one status
**
**      bit -> 31302928272625242322212019181716151413121110 9 8 7 6 5 4 3 2 1 0
**      rep ->  . . . . . . . . . . . . . . . . . . . . . . . . D H A O I W R S
**
**              Example: if the setting is "I or O" then status = 0x0018
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetMultiStatus(EP_STATUS status,U8 eventID) {

   U8 i;

   if ((U8) status != 0 ) {
      for (i=0;i<6;i++) {
         if ((U8) (status >> i) & 1)
            WrBCMaskAddr(Tport,0xF00,pattern[i],~(0x01 << eventID),0xFF,0xFFF);
      }
      if (((U8) status & 0x20 ) == 0x20)
            WrBCMaskAddr(Tport,0x2000,0x2000,~(0x01 << eventID),0xFF,0x3FFF);
   }
   else {
      WrBCMaskAddr(Tport,0,0,0,0xFF,0);
   }
   return(GOOD);
}

/******************************************************************************
**
**  SetOneEvent
**
**  Description:
**    Set one busevent
**
**  Parameters:
**    input:
**      *eventStruct: the event setting
**      *xlxMap: Xilinx CLB map for this the event eventPhysicalID
**      eventPhysicalID: the physical location of the event
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetOneEvent(BUS_EVENT *eventStruct,U8 eventID) {
   RETCODE err;

   if (eventStruct->enable == NO) return(GOOD);
   switch (eventStruct->addrSpec) {
      case UNDEFINE_ADDR:
         WrBCMaskAddr(Rport,0,0,~(0x0101 << eventID),0,0);
         break;
      case RANGE_ADDR:
         if ((err = SetRangeAddr(eventStruct->addrLow,eventStruct->addrHigh,eventID)
             != GOOD)) return(err);
         break;
      case SINGLE_ADDR:
         if ((err = SetSingleMask(ADDR_FIELD,eventStruct->addrLow,eventStruct
            ->addrHigh,eventID)) != GOOD) return(err);
         break;
      case MASK_ADDR:
         if ((err = SetSingleMask(ADDR_FIELD,eventStruct->addrLow,eventStruct
            ->addrHigh,eventID)) != GOOD) return(err);
         break;
   }
   switch (eventStruct->dataSpec) {
      case UNDEFINE_DATA:
         WrBCMaskAddr(Vport,0,0,~(0x01 << eventID),0xFF,0);
         break;
      case SINGLE_DATA:
         if ((err = SetSingleMask(DATA_FIELD,eventStruct->dataLow,eventStruct
            ->dataHigh,eventID)) != GOOD) return(err);
         break;
      case MASK_DATA:
         if ((err = SetSingleMask(DATA_FIELD,eventStruct->dataLow,eventStruct
            ->dataHigh,eventID)) != GOOD) return(err);
         break;
   }
   if ((err = SetMultiStatus(eventStruct->status,eventID) != GOOD)) return(err);
   SetExternalTraceBit(eventStruct->status,eventID);
   return(GOOD);
}

/******************************************************************************
**
**  ClearAllEvent
**
**  Description:
**    Clear all busevent
**
**  Parameters:
**    input:
**    output:
**      <none>
**
*******************************************************************************/
VOID ClearAllEvent(VOID) {

   WrBCMaskAddr(Rport,0,0,0,0xFFFF,0);
   WrBCMaskAddr(Sport,0,0,0,0xFFFF,0);
   WrBCMaskAddr(Tport,0,0,0,0,0);
   WrBCMaskAddr(Uport,0,0,0,0xFF,0);
   WrBCMaskAddr(Vport,0,0,0,0,0);
   WrBCMaskAddr(Wport,0,0,0,0,0);
}

VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) {

   outp(CtrlPort[port],0);
   addrset &= addrmask ;
   SetBCAddr(port,addrmask,addrset,fcnt);
   SetBCData(port,datamask,dataset);
   outp(P4CtrlAY,port);
   ctrlbyte = (U8) inp(ReadCtrlPort[port]);
   ctrlbyte |= EnBCWr;
   outp(ChgWr,0x80);
   outp(CtrlPort[port],ctrlbyte);
   while ((inp(ReadCtrlPort[port]) & Done) != Done ) ;
   outp(CtrlPort[port],0);
   outp(ChgWr,0);
}

VOID WrBCRangeAddr(U8 port,U16 addr,U16 bit,U16 fcnt,U8 eventID) {

   outp(P0CtrlPort,FSld);
// outp(WriteP0Byte1,fcnt);
// outp(WriteP0Byte2,fcnt >> 8);
   outpw(WriteP0Byte1,fcnt);
   outp(P0CtrlPort,0);
// outp(WriteP0Byte1,(U8) addr);
// outp(WriteP0Byte2,(U8) (addr >> 8) );
   outpw(WriteP0Byte1,addr);
// outp(WriteP0Byte3,0xFF);
// outp(WriteP0Byte4,0xFF);
// outp(WriteP0Byte3,0);
// outp(WriteP0Byte4,0);
   outpw(WriteP0Byte3,0xFFFF);
   outpw(WriteP0Byte3,0);
   outp(P0CtrlPort,nOE[port]);
   SetBCData(port,~(bit << eventID),0);
   outp(P4CtrlAY,port);
   ctrlbyte = (U8) inp(ReadP0CtrlPort);
   ctrlbyte |= EnBCWr;
   outp(ChgWr,0x80);
   outp(P0CtrlPort,ctrlbyte);
   while ((inp(P0CtrlPort) & Done) != Done ) ;
   outp(P0CtrlPort,0);
   outp(ChgWr,0);
}

VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) {

   switch(port) {
      case Rport : case Sport :
         outp(CtrlPort[port],FSld);
//       outp(WrByte1[port],0xFF);
//       outp(WrByte2[port],0xFF);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
//       outp(WrByte1[port],(U8) addr);
//       outp(WrByte2[port],(U8) (addr >> 8) );
         outpw(WrByte1[port],addr);
//       outp(WrByte3[port],0xFF);
//       outp(WrByte4[port],0xFF);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),(data << eventID) );
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
      case Tport : case Uport : case Vport : case Wport :
         outp(CtrlPort[port],FSld);
//       outp(WrByte1[port],0xFF);
//       outp(WrByte2[port],0xFF);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
//       outp(WrByte1[port],(U8) (addr));
//       outp(WrByte2[port],(U8) (addr >> 8 ));
         outpw(WrByte1[port],addr);
//       outp(WrByte3[port],0xFF);
//       outp(WrByte4[port],0xFF);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),data);
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
   }
}
/******************************************************************************
**
**
**
*******************************************************************************/
VOID SetBCData(U8 port,U16 mask,U16 set) {

   switch(port) {
      case Rport :  case Sport :
         outp(MNCtrlAY,port);
//       outp(SetLo,(U8) set);
//       outp(SetHi,(U8)(set >> 8));
         outpw(SetLo,set);
//       outp(MaskLo,(U8) mask);
//       outp(MaskHi,(U8)( mask >> 8));
         outpw(MaskLo,mask);
      break ;
      case Tport : case Uport : case Vport : case Wport :
         outp(MNCtrlAY,port);
         outp(SetLo,(U8) set);
         outp(MaskLo,(U8) mask);
      break ;
   }
}

/******************************************************************************
**
**
**
*******************************************************************************/
VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) {

   outp(CtrlPort[port],FSld);
// outp(WrByte1[port],(U8) fcnt);
// outp(WrByte2[port],(U8) (fcnt >> 8));
   outpw(WrByte1[port],fcnt);
   outp(CtrlPort[port],0);
// outp(WrByte1[port],(U8) set);
// outp(WrByte2[port],(U8) (set >> 8 ));
   outpw(WrByte1[port],set);
// outp(WrByte3[port],0xFF);
// outp(WrByte4[port],0xFF);
   outpw(WrByte3[port],0xFFFF);
// outp(WrByte3[port],(U8) mask);
// outp(WrByte4[port],(U8) (mask >> 8 ));
   outpw(WrByte3[port],mask);
   outp(CtrlPort[port],nOE[port]);
}

/******************************************************************************
**
**  WriteSeqRAMs
**
*******************************************************************************/
RETCODE WriteSeqRAMs(U8 _far *data,U8 _far *buffer) {
   U16 i,srcOffset,desOffset;
   U32 srcSeg,srcPointer,desSeg,desPointer;
// U32 j;
   RETCODE err;

   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   srcSeg = FP_SEG(data);
   srcOffset = FP_OFF(data);
   srcPointer = (srcSeg << 4) + srcOffset ;

   desSeg = FP_SEG(buffer);
   desOffset = FP_OFF(buffer);
   desPointer = (desSeg << 4) + desOffset ;

// for (i=0;i<=0x1FFF;i++) {
//    *(data-(2*i)) = *(data-(2*i)) & (U8) 0x3F ;
// }

// for(j=0;j<=0xFF;j++) {

// outp(P4CtrlAX,0x01) ;  //Enable Trigger SSRAM nGW

   outpw(DMA1SL,(U16) srcPointer);    // Enable DMA Write Trigger SSRAM
   outpw(DMA1SH,(U16) (srcPointer >> 16));
   outpw(DMA1DL,RWTrig);
   outpw(DMA1DH,0);
   outpw(DMA1TC,0x4000);
   outp(MNCtrlAX,BCK);   //Enable MN Output enable
   outp(MNCtrlAX,DOE);
   outp(P4CtrlB,0x40) ;  //Enable Trigger SSRAM nGW
   outpw(DMA1CW,0x7A27);

   outp(P4CtrlB,0) ;  //Disable Trigger SSRAM nGW
   outp(P4CtrlAX,nOETRIG) ;  //Enable Trigger SSRAM nOE

   outp(MNCtrlAX,BCK);
   outp(MNCtrlAX,0) ;  //Disable MN Output enable
   outpw(DMA1SL,RWTrig);    // Enable DMA Read Trigger SSRAM
   outpw(DMA1SH,0);
   outpw(DMA1DL,(U16) desPointer);
   outpw(DMA1DH,(U16) (desPointer >> 16));
   outpw(DMA1TC,0x4000);
   inp(RWTrig);        // Dummy read
   inp(RWTrig);
   outpw(NPACS,0x0F38);
   outpw(NMPCS,0xC0B8);
   outpw(DMA1CW,0xAE27);
   outpw(NPACS,0x0F3F);
   outpw(NMPCS,0xC0BF);

   for (i=0 ; i<= 0x3FFF ; i++)
       if(*(data-i) != *(buffer+i) ) return(ERR_TRIG) ;
// }
   return(GOOD);
}

/********************************* EOF *************************************/
