/***************************************************************************
**
** Name: trctest.c
**
** Description:
**   Test trace memory
**
** Copyright (C) 1996 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <conio.h>
#include <dos.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#ifndef _TRCTEST_
#include "trctest.h"
#endif
//
//#ifndef _TRCDIAG_
//#include "trcdiag.h"
//#endif
//
#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

#ifndef _TRCDTST_
#include "trclib.h"
#endif
                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define NPACS       0xFFA4
#define NMPCS       0xFFA8
#define RWTrig     0xF32C

#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define Uport       0x03
#define Vport       0x04
#define Wport       0x05

/*
#define P0Pipe       0x01
#define P0Pio        0x02
#define P4Pipe       0x04
#define P4Pio        0x08
#define MNTrace      0x10
#define MNRW         0x20
*/

#define ChgWr      0xF338
#define EnBCWr     0x20
#define Done       0x80

#define SEQ       0x04
#define DOE       0x02
#define BCK       0x01

#define MNCtrlAX   0xF32D
#define MNCtrlAY   0xF32E
#define MNCtrlB    0xF32F

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04
#define FSld           0x01

/* MAIN control port corresponding bit define */

#define TOnFly         0x01

/* P0 port address define */

#define WriteP0Byte1    0xF300
#define WriteP0Byte2    0xF301
#define WriteP0Byte3    0xF302
#define WriteP0Byte4    0xF303
#define ReadP0CtrlPort  0xF304
#define P0CtrlPort      0xF307

/* P1 port address define */

#define WriteP1Byte1    0xF308
#define WriteP1Byte2    0xF309
#define WriteP1Byte3    0xF30A
#define WriteP1Byte4    0xF30B
#define ReadP1CtrlPort  0xF30C
#define P1CtrlPort      0xF30F

/* P2 port address define */

#define WriteP2Byte1    0xF310
#define WriteP2Byte2    0xF311
#define WriteP2Byte3    0xF312
#define WriteP2Byte4    0xF313
#define ReadP2CtrlPort  0xF314
#define P2CtrlPort      0xF317

/* P3 port address define */

#define WriteP3Byte1    0xF318
#define WriteP3Byte2    0xF319
#define WriteP3Byte3    0xF31A
#define WriteP3Byte4    0xF31B
#define ReadP3CtrlPort  0xF31C
#define P3CtrlPort      0xF31F

/* P4 port address define */

#define P4CtrlAX       0xF325
#define P4CtrlAY       0xF326
#define P4CtrlB        0xF327

U8 _based(_segname("_CODE")) MNTestByte[] = {
#include "testsram.ttf"
};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern U8  _far PIOByte[];
extern U8  _far MNTraceByte[];
extern U8  _far MNCPRWByte[];
extern U8  _far P4PIOByte[];
extern U8  _far P4PIPEByte[];
extern U8  trigBuf[4][0x800][2];
extern U8  _far SeqRamBuf[0x4000];
extern U8  FLEXConfig ;
extern U32 TrcBufSize;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE TestTrcBuf(U16 addr,TBuffer_TYPE type) ;
U16 RdBCOneAddr(U8 port,U16 addr) ;
VOID SetP0toP4(U8 data);
RETCODE WriteTrigRAMs(U8 _far *data,U8 _far *buffer) ;
//U8  buffer[1024];
                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/******************************************************************************
**
** TestSeqRAM
**
*******************************************************************************/
RETCODE TestSeqRAM(VOID)  {
   RETCODE err;
   U8 j,temp1,temp2;
   U16 i,k,data;
   struct {
   U16 addr,data;
   }errdata[20];


   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   for (j=0;j<20;j++) {
      errdata[j].addr = 0;
      errdata[j].data = 0;
   }
   j=0;
   for(i=0;i<=13;i++) {
      data = (0x01 << i);
      for (k=0;k<2;k++) {
         data ^= 0x3FFF;
         outp(MNCtrlAX,BCK);   //Enable MN Output enable
         outp(MNCtrlAX,DOE);
         outp(P4CtrlAX,0x01) ;  //Enable Trigger SSRAM nGW
         outp(0xF32C,(U8) (data >> 8));
         outp(0xF32C,(U8) data) ;
         outp(P4CtrlAX,0) ;  //Disable Trigger SSRAM nGW
         outp(MNCtrlAX,BCK);
         outp(MNCtrlAX,0) ;  //Disable MN Output enable
         outp(P4CtrlAX,0x08) ;  //Enable Trigger SSRAM nOE
         temp1 = (U8)inp(0xF32C);
         temp2 = (U8)inp(0xF32C);
         if ((temp1 != (U8)(data >> 8)) || ( temp2 != (U8) data)) {
            errdata[j].addr = temp1;
            errdata[j].data = temp2;
            j++;
         }
      }
   }
   k=0;
   for (j=0;j<4;j++) {
      for (i=0;i<0x800;i++) {
            trigBuf[j][i][0] = (U8) k;
            trigBuf[j][i][1] = (U8) (k >> 8);
            k++;
      }
   }
   WriteTrigRAMs((U8 _far *)&(trigBuf[3][0x800-1][1]),
                 (U8 _far *)&(SeqRamBuf[0]));

   return(GOOD);
}

RETCODE WriteTrigRAMs(U8 _far *data,U8 _far *buffer) {
   U16 i,srcOffset,desOffset;
   U32 srcSeg,srcPointer,desSeg,desPointer;
   RETCODE err;

   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   srcSeg = FP_SEG(data);
   srcOffset = FP_OFF(data);
   srcPointer = (srcSeg << 4) + srcOffset ;

   desSeg = FP_SEG(buffer);
   desOffset = FP_OFF(buffer);
   desPointer = (desSeg << 4) + desOffset ;

   outp(P4CtrlAX,0x01) ;  //Enable Trigger SSRAM nGW

   outp(MNCtrlAX,BCK);   //Enable MN Output enable
   outp(MNCtrlAX,DOE);

   outpw(DMA1SL,(U16) srcPointer);    // Enable DMA Write Trigger SSRAM
   outpw(DMA1SH,(U16) (srcPointer >> 16));
   outpw(DMA1DL,RWTrig);
   outpw(DMA1DH,0);
   outpw(DMA1TC,0x4000);
   outpw(DMA1CW,0x7A27);

   outp(P4CtrlAX,0) ;  //Disable Trigger SSRAM nGW
   outp(P4CtrlAX,0x08) ;  //Enable Trigger SSRAM nOE

   outpw(DMA1SL,RWTrig);    // Enable DMA Read Trigger SSRAM
   outpw(DMA1SH,0);
   outpw(DMA1DL,(U16) desPointer);
   outpw(DMA1DH,(U16) (desPointer >> 16));
   outpw(DMA1TC,0x4000);
   outp(MNCtrlAX,BCK);
   outp(MNCtrlAX,0) ;  //Disable MN Output enable
   inp(RWTrig);        // Dummy read
   inp(RWTrig);
   outpw(NPACS,0x0F38);
   outpw(NMPCS,0xC0B8);
   outpw(DMA1CW,0xAE27);
   outpw(NPACS,0x0F3F);
   outpw(NMPCS,0xC0BF);

   for (i=0 ; i<= 0x3FFF ; i++)
       if(*(data-i) != *(buffer+i) ) return(ERR_TRIG) ;
   return(GOOD);
}
/******************************************************************************
**
** TestTraceBuffer
**
*******************************************************************************/
RETCODE TestTraceBuffer(VOID)  {
   RETCODE err;

   if ((FLEXConfig & P4Pio ) != P4Pio ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P4Pio ;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);


   outp(FClkSel0,0x80);    // Change FCLK2/FCLK3 TO CPCLK
   outp(FClkSel1,0);


   if ((err = TestTrcBuf(WriteP1Byte1,RS_TBUF)) != GOOD ) return(ERR_RS_TBUF_TEST);
   if ((err = TestTrcBuf(WriteP0Byte1,TU_TBUF)) != GOOD ) return(ERR_TU_TBUF_TEST);
   if ((err = TestTrcBuf(WriteP0Byte1,TP_TBUF)) != GOOD ) return(ERR_TP_TBUF_TEST);
   if ((err = TestTrcBuf(WriteP2Byte1,VW_TBUF)) != GOOD ) return(ERR_VW_TBUF_TEST);
   if ((err = TestTrcBuf(WriteP2Byte1,TS_TBUF)) != GOOD ) return(ERR_TS_TBUF_TEST);

   return(GOOD) ;
}

/******************************************************************************
**
** TestTrcBuf
**
*******************************************************************************/
RETCODE TestTrcBuf(U16 addr,TBuffer_TYPE type)  {
   RETCODE Errflag = FALSE;
   U32 TAByte;
   U16 i,j;
   U32 data;
   struct {
   U32  adder,data1,data2;
   }aa[20];


   for (i=0;i<=19;i++) {
      aa[i].adder = 0;
      aa[i].data1 = 0;
      aa[i].data2 = 0;
   }
   i=0;
/*******************************************
**   Test trace buffer data bus
********************************************/
   outpw(0xF328,0x5A5A); // Set trace address
   switch(type)  {
      case RS_TBUF:  case TU_TBUF:  case TP_TBUF:
         for (i=0;i<32;i++) {
            data = (0x01 << i);
            for (j=0;j<2;j++) {
               data ^= 0xFFFF;
//             outp(P4CtrlAX,0);   //Disable TRCM Output enable
               SetP0toP4(nOEA);
               outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
               outpw(addr,(U16) data);
               outpw(addr+2,(U16) (data >> 16));
               outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
               SetP0toP4(0);
               outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
               if ( ((U16) data != inpw(addr)) || ((U16) (data >> 16) != inpw(addr+2))) {
                  Errflag = TRUE;
                  aa[i].adder = TAByte;
                  aa[i].data1 = inpw(addr);
                  aa[i].data2 = inpw(addr+2);
                  i++;
                  if (i >19) i=0;
               }
            }
         }
      break;
      case VW_TBUF:
         for (i=0;i<32;i++) {
            data = (0x01 << i);
            for (j=0;j<2;j++) {
               data ^= 0xFFFF;
               SetP0toP4(nOEA);
               outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
               outp(0xF32F,0);
               outp(addr,(U8) data);
               outpw(addr+2,(U16) (data << 8));
               outp(0xF32A,(U8) (data<< 24));
               outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
               SetP0toP4(0);
               outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
               outp(0xF32F,1);
               if (((U8) data != (U8) inp(addr)) || ((U16) (data << 8) !=  inpw(addr+2))
                  || ((U8) (data<< 24) != (U8) inp(0xF328) )){
                  Errflag = TRUE;
                  aa[i].adder = TAByte;
                  aa[i].data1 = (U16) (((U8) inp(0xF328) <<8 ) | ((U8) inp(addr)));
                  aa[i].data2 = inpw(addr+2);
                  i++;
                  if (i >19) i=0;
               }
            }
         }
        break;
      }



   outp(P4CtrlAX,0);   //Disable TRCM Output enable

   outp(P0CtrlPort,nOEA);  // Enable P0-P4 output enable //
   outp(P1CtrlPort,nOEA);
   outp(P2CtrlPort,nOEA);
   outp(P3CtrlPort,nOEA);
   outp(P4CtrlB,nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      outpw(0xf328,(U16) TAByte);

      switch(type)  {
        case RS_TBUF:  case TU_TBUF:  case TP_TBUF:
          outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
          outpw(addr,(U16) TAByte);
          outpw(addr+2,(U16) TAByte);
          outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
        break;
        case VW_TBUF :
          outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
          outp(addr,(U8) TAByte);
          outpw(addr+2,(U16) TAByte);
//        outp(0xF32A,(U8) (TAByte>>8));
          outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
        break;
        case TS_TBUF :
          outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
          outp(0xF32F,0);
          outp(0xF32A,(U8) TAByte);
          outpw(0xF32B,(U16) TAByte);
          outpw(0xF32D,(U16) TAByte);
          outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
        break;
      }
   }

   for (i=0;i<=19;i++) {
      aa[i].adder = 0;
      aa[i].data1 = 0;
      aa[i].data2 = 0;
   }
   i=0;
   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      outpw(0xf328,(U16) TAByte);

      switch(type) {
        case RS_TBUF:  case TU_TBUF:  case TP_TBUF:
          if ( ((U16) TAByte != inpw(addr)) || ((U16) TAByte != inpw(addr+2))) {
             Errflag = TRUE;
             aa[i].adder = TAByte;
             aa[i].data1 = inpw(addr);
             aa[i].data2 = inpw(addr+2);
             i++;
             if (i >19) i=0;
          }
        break;
        case VW_TBUF :
          outp(0xF32F,1);
          if (((U8) TAByte != (U8) inp(addr)) || ((U16) TAByte  !=  inpw(addr+2))){
//           || ((U8) (TAByte >>8) != (U8) inp(0xF328)) ){
             Errflag = TRUE;
             aa[i].adder = TAByte;
//           aa[i].data1 = (U16) (((U8) inp(0xF328) <<8 ) | ((U8) inp(addr)));
             aa[i].data1 = (U16) ((U8) inp(addr));
             aa[i].data2 = inpw(addr+2);
             i++;
             if (i >19) i=0;
          }
        break;
        case TS_TBUF :
          outp(0xF32F,1);
          if ( ((U16) TAByte != inpw(0xF329)) || ((U16) TAByte != inpw(0xF32B))) {
             Errflag = TRUE;
             aa[i].adder = TAByte;
             aa[i].data1 = inpw(0xF329);
             aa[i].data2 = inpw(0xF32B);
             i++;
             if (i >19) i=0;
          }
        break;

      }
   }
   if (Errflag == TRUE) return(Errflag);
   return(GOOD);
}

/******************************************************************************
**
** SetP0toP4
**
*******************************************************************************/
VOID SetP0toP4(U8 data) {

    outp(P0CtrlPort,data);  // Enable P0-P4 output enable //
    outp(P1CtrlPort,data);
    outp(P2CtrlPort,data);
    outp(P3CtrlPort,data);
    outp(P4CtrlB,data);
 }
/******************************************************************************
**
** TestBC
**
*******************************************************************************/
RETCODE TestBC(VOID)  {
   struct {
      U16 read,write;
   } aa[32];
   RETCODE err ;
   U32 i,j;
   U8  data= 0x1,k=0;
// U16 a[20],b[20];
   U16 temp;

   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
   FLEXConfig &= P4Pipe ;
   if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
   FLEXConfig |= P0Pio ;
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   FLEXConfig |= SMain ;

   outp(FClkSel0,0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

/*****************Test event*******************/

// for (j=0;j<=31;j++) {
//    aa[j].read = 0;
//    aa[j].write = 0;
// }
// WrBCMaskAddr(Rport,0,0,0,0xFFFF,0);
// for (i=0;i<16;i++)
// WrBCOneAddr(Rport,0,0xFFFF,0xFFFC,0);
// for(i=0;i<20;i++) {
//    aa[i].read = RdBCOneAddr(Rport,(U16) (i << 4));
// }
// WrBCMaskAddr(Rport,0xF,0,0xFEFE,1,0x1000);
// for(i=0;i<20;i++) {
//    aa[i].read = RdBCOneAddr(Rport,(U16) (i << 4));
// }
//
// for (j=0;j<=31;j++) {
//    aa[j].read = 0;
//    aa[j].write = 0;
// }
// WrBCMaskAddr(Sport,0,0,0,0xFFFF,0);
// WrBCMaskAddr(Sport,0xFFF0,0,0xFFF0,0xFFF0,14);
// for(i=0;i<20;i++) {
//    aa[i].read = RdBCOneAddr(Sport,(U16) i);
// }
//
//
// WrBCMaskAddr(Rport,0,0,0,0xFFFF,0);
// WrBCMaskAddr(Sport,0,0,0,0xFFFF,0);
// err = SetRangeAddr((U32) 0x100,(U32) 0x105,0);
// for(i=0;i<23;i++) {
//    aa[i].read = RdBCOneAddr(Rport,(U16) (0x0+i));
//    aa[i].write = RdBCOneAddr(Sport,(U16) (0xFE+i));
//}
// for (j=0;j<=31;j++) {
//    aa[j].read = 0;
//    aa[j].write = 0;
// }
// err = SetSingleMask(0,(U32) 0x10B,(U32) 0xFFFFF,(U8) 1);
// for(i=0;i<20;i++) {
//    aa[i].read = RdBCOneAddr(Rport,(U16) 0);
//    aa[i].write = RdBCOneAddr(Sport,(U16) (0x100+i));
//}
/******************************
** TestRport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }

   for (j=0;j <= 15;j++) {
      WrBCOneAddr(Rport,0xA5A5,0xFFFF,(U16) ~(data << j),0);
      temp = RdBCOneAddr(Rport,0xA5A5);
      if (temp != (U16) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U16) ~(data << j);
      }
      WrBCOneAddr(Rport,0x5A5A,0xFFFF,(U16) (data << j),0);
      temp = RdBCOneAddr(Rport,0x5A5A);
      if (temp != (U16) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U16) (data << j);
      }
   }

   for (i=0;i<=0xFFFF;i++) {
      WrBCOneAddr(Rport,(U16) i,0xFFFF,(U16) i,0);
   }
   if ((err = RdBC(Rport)) != GOOD) return(err);


/******************************
** TestSport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }
   outp(LA0A1nOE,0x80);

   for (j=0;j <= 15;j++) {
      WrBCOneAddr(Sport,0xA5A5,0xFFFF,(U16) ~(data << j),0);
      temp = RdBCOneAddr(Sport,0xA5A5);
      if (temp != (U16) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U16) ~(data << j);
      }
      WrBCOneAddr(Sport,0x5A5A,0xFFFF,(U16) (data << j),0);
      temp = RdBCOneAddr(Sport,0x5A5A);
      if (temp != (U16) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U16) (data << j);
      }
   }
   for (i=0;i<=0xFFFF;i++) {
      WrBCOneAddr(Sport,(U16) i,0xFFFF,(U16) i,0);
   }
   if ((err = RdBC(Sport)) != GOOD) return(err);
   outp(LA0A1nOE,0);

/******************************
** TestWport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }
   for (j=0;j <= 7;j++) {
      WrBCOneAddr(Wport,0x55,0xFFFF,(U8) ~(data << j),0);
      temp = RdBCOneAddr(Wport,0x55);
      if (temp != (U8) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U8) ~(data << j);
      }
      WrBCOneAddr(Wport,0xAA,0xFFFF,(U8) (data << j),0);
      temp = RdBCOneAddr(Wport,0xAA);
      if (temp != (U8) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U8) (data << j);
      }
   }

   for (i=0;i<=0xFF;i++) {
      WrBCOneAddr(Wport,(U16) i,0xFFFF,(U8) i,0);
   }
   if ((err = RdBC(Wport)) != GOOD) return(err);

/******************************
** TestTport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }
   for (j=0;j <= 7;j++) {
      WrBCOneAddr(Tport,0x5A5A,0xFFFF,(U8) ~(data << j),0);
      temp = RdBCOneAddr(Tport,0x5A5A);
      if (temp != (U8) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U8) ~(data << j);
      }
      WrBCOneAddr(Tport,0xA5A5,0xFFFF,(U8) (data << j),0);
      temp = RdBCOneAddr(Tport,0xA5A5);
      if (temp != (U8) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U8) (data << j);
      }
   }
   for (i=0;i<=0xFFFF;i++) {
      j = (U8) (i >> 8);
      WrBCOneAddr(Tport,(U16) i,0xFFFF,(U8) ((U8) i + j),0);
   }
   if ((err = RdBC(Tport)) != GOOD) return(err);

/******************************
** TestUport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }
   for (j=0;j <= 7;j++) {
      WrBCOneAddr(Uport,0x5A5A,0xFFFF,(U8) ~(data << j),0);
      temp = RdBCOneAddr(Uport,0x5A5A);
      if (temp != (U8) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U8) ~(data << j);
      }
      WrBCOneAddr(Uport,0xA5A5,0xFFFF,(U8) (data << j),0);
      temp = RdBCOneAddr(Uport,0xA5A5);
      if (temp != (U8) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U8) (data << j);
      }
   }
   for (i=0;i<=0xFFFF;i++) {
      j = (U8) (i >> 8);
      WrBCOneAddr(Uport,(U16) i,0xFFFF,(U8) ((U8) i + j),0);
   }
   if ((err = RdBC(Uport)) != GOOD) return(err);


/******************************
** TestVport                  *
******************************/
   for (j=0;j<=31;j++) {
      aa[j].read = 0;
      aa[j].write = 0;
   }
   for (j=0;j <= 7;j++) {
      WrBCOneAddr(Vport,0xA5A5,0xFFFF,(U8) ~(data << j),0);
      temp = RdBCOneAddr(Vport,0xA5A5);
      if (temp != (U8) ~(data << j) ) {
         aa[2*j].read = temp ;
         aa[2*j].write = (U8) ~(data << j);
      }
      WrBCOneAddr(Vport,0x5A5A,0xFFFF,(U8) (data << j),0);
      temp = RdBCOneAddr(Vport,0x5A5A);
      if (temp != (U8) (data << j) ) {
         aa[2*j+1].read = temp ;
         aa[2*j+1].write = (U8) (data << j);
      }
   }
   for (i=0;i<=0xFFFF;i++) {
      j = (U8) (i >> 8);
      WrBCOneAddr(Vport,(U16) i,0xFFFF,(U8) ((U8) i + j),0);
   }
   if ((err = RdBC(Vport)) != GOOD) return(err);


}



RETCODE RdBC(U8 port) {
   U16 readaddr1,CtrlPort,ReadCtrlPort,WrByte1,WrByte2,WrByte3,WrByte4,nOE;
   S32 i;
   U8  addrcnt,k;
   U16 j,tempa;
   RETCODE err;
   struct {
      U16 adder,data;
   } aa[20];

   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);
   switch (port) {
      case Rport :
         readaddr1 = 0xF328;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEX;
         break;
      case Sport :
         readaddr1 = 0xF32A;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEY;
         break;
      case Tport :
         readaddr1 = 0xF32C;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEX;
         break;
      case Uport :
         readaddr1 = 0xF32D;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEY;
         break;
      case Vport :
         readaddr1 = 0xF32E;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEX;
         break;
      case Wport :
         readaddr1 = 0xF32F;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEY;
         break;
   }

   for (j=0;j<=10;j++) {
       aa[j].adder = 0;
       aa[j].data = 0;
   }
   j=0;

   outp(CtrlPort,FSld);
   outpw(WrByte1,0xFFFF);
   switch (port) {
      case Rport : case Sport :
         for (i = 0xFFFF; i > 0;i--)  {
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inpw(readaddr1);
//          tempb = (U8) inp(readaddr1+addrcnt);
            if ( tempa != (U16) i)  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
      case Tport : case Uport : case Vport :
         for (i = 0xFFFF; i > 0;i--)  {
            k = (U8) (i >> 8);
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = (U8) inp(readaddr1);
            if (tempa != ((U8) (k + (U8) i)))  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
      case Wport :
         for (i = 0xFF; i > 0;i--)  {
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = (U8) inp(readaddr1);
            if (tempa != ((U8) i))  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
   }


   for (j=0;j<=10;j++) {
      if (aa[j].adder != 0) {
         if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
         return (1234);
      }
   }
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   return (GOOD);

}

U16 RdBCOneAddr(U8 port,U16 addr) {
   U16 readaddr1,CtrlPort,ReadCtrlPort,WrByte1,WrByte2,WrByte3,WrByte4,nOE;
   U8  addrcnt;
   RETCODE err;
   U16 tempa;

   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);
   switch (port) {
      case Rport :
         readaddr1 = 0xF328;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEX;
         break;
      case Sport :
         readaddr1 = 0xF32A;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEY;
         break;
      case Tport :
         readaddr1 = 0xF32C;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEX;
         break;
      case Uport :
         readaddr1 = 0xF32D;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEY;
         break;
      case Vport :
         readaddr1 = 0xF32E;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEX;
         break;
      case Wport :
         readaddr1 = 0xF32F;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEY;
         break;
   }

   outp(CtrlPort,FSld);
   outpw(WrByte1,0xFFFF);
   switch (port) {
      case Rport : case Sport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inpw(readaddr1);
//          tempb = (U8) inp(readaddr1+addrcnt);
      break;
      case Tport : case Uport : case Vport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inp(readaddr1);
      break;
      case Wport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            (U8) tempa = (U8) inp(readaddr1);
      break;
   }
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   return (tempa);
}
