/***************************************************************************
**
** Name: trctman.c
**
** Description:
**   Services for trigger and trace operation
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/
#include <string.h>
#include <conio.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

// #ifndef _TRCERROR_
// #include "trcerror.h"
// #endif

#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCDTST_
#include "trclib.h"
#endif

#ifndef _TRCTEST_
#include "trctest.h"
#endif
                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))

#define Mtat2Module  0x160C

#define MAX_TRACE_BUFFER_NUMBER 8
#define MAX_FRAME_WIDTH 19
#define FRAME_WIDTH 19
#define LIST_BUFFER_SIZE 48

static TRACE_FORM currentTraceMode = CYCLE_TRACE;
static U16 traceBufferNumber = 1;
static TRIG_LOC triggerLocation = POST_TRIG;
static BOOLEAN breakOnFull = YES;
static BOOLEAN ToffOnFull = YES;
static U8 numberOfBitOfTBN = 0;

static U32 trigPhyFrameOfTrcBuf[MAX_TRACE_BUFFER_NUMBER];

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

U32 counter0 = 0;
U32 counter1 = 0;
U8  TrcCtrlByte = 0;
U16 Mtat2VerCtrl ;
U8  FLEXConfig ;
U8  AdderBusWidth;
U32 TrcBufSize;

BOOLEAN gotTrigInfoOfTrcBuf[MAX_TRACE_BUFFER_NUMBER];
S32 startLogFrameOfTrcBuf[MAX_TRACE_BUFFER_NUMBER];
S32 endLogFrameOfTrcBuf[MAX_TRACE_BUFFER_NUMBER];
U32 haltPhyFrameOfTrcBuf[MAX_TRACE_BUFFER_NUMBER];

extern U8  _far PIOByte[];
extern U8  _far PIPEByte[];
extern U8  _far P4PIPEByte[];
extern U8  _far P4PIOByte[];
extern U8  _far MNCPRWByte[];

U8 _based(_segname("_CODE")) MNTraceByte[] = {
#include "main.ttf"
};

extern BOOLEAN mtatExist;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

BOOLEAN SearchTrigPoint(U16 trcBufLogID) ;
VOID CheckMtat2Exist(VOID) ;
VOID ListAddr(U8 **Ptr) ;
VOID ListData(U8 **Ptr) ;
VOID ListStatus(U8 **Ptr) ;
VOID ListExtBit(U8 **Ptr) ;
VOID ListTracePort(U8 **Ptr) ;
VOID ListTimeStamp(U8 **Ptr) ;
VOID ListEventLevel(U8 **Ptr) ;
VOID Gray2Bin(U8 *ptr) ;
VOID SetTAddr(U32 addr);

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  ConfigTrace
**
*******************************************************************************/
RETCODE ConfigTrace(U16 traceBufNum, TRIG_LOC trigLoc, BOOLEAN breakFull,
                    BOOLEAN ToffFull ) {
   U16 temp = traceBufNum;

   if (temp > (U16) MAX_TRACE_BUFFER_NUMBER) return(ERR_UNKNOW_TBN);
   while (temp != 1) {
   numberOfBitOfTBN = 0;
      if (temp % 2 != 0) return(ERR_UNKNOW_TBN);
      numberOfBitOfTBN++;
      temp /= 2;
   }
   traceBufferNumber = traceBufNum;
   triggerLocation = trigLoc;
   breakOnFull = breakFull;
   ToffOnFull = ToffFull;

   return(GOOD);
}

/******************************************************************************
**
**  GetTrigInfoOfTrcBuf
**
*******************************************************************************/
RETCODE GetTrigInfoOfTrcBuf(U16 trcBufLogID) {
   RETCODE err;
   U16 temp1,temp2;
   U8 i;

// if ((FLEXConfig & P4Pio ) != P4Pio ) {
//   if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
//   FLEXConfig |= P4Pio ;
// }
   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable

   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }

   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

// U32 stopadder;
// U8  byte1,byte2;

// outp(MCtrlByte2,0);
 //byte1 = (U8) inp(0xf329);
 //outp(MCtrlByte2,1);
 //byte2 = (U8) inp(0xf329);
 //stopadder = (U32) ( byte1 | byte2 << 8);

   for (i=0;i<MAX_TRACE_BUFFER_NUMBER;i++) {
      gotTrigInfoOfTrcBuf[i] = TRUE;
   }

   startLogFrameOfTrcBuf[trcBufLogID] = 0 ;
   endLogFrameOfTrcBuf[trcBufLogID] = -1 ;


   TraceStop() ;

   outp(FClkSel0,0x80);    // Change FCLK2/FCLK3 TO CPCLK
   outp(FClkSel1,0);

   outp(RegByte4,OECtrl);  // Disable Main Output Enable
   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable

   /* Check trace buffer empty ? */
   SetTAddr(0x00);
   outp(MCtrlByte2,ReadTINFO);
   temp1= (inp(nRDMN) & 0x03 ) ;
   SetTAddr(0x01);
   outp(MCtrlByte2,ReadTINFO);
   temp2= (inp(nRDMN) & 0x03 );
   if( (temp1 == 0) && (temp2 == 0) ) return(BUFFER_EMPTY) ;

   /* Search trigger point and start frame number and end frame number */
   SearchTrigPoint(trcBufLogID);

   if (trigPhyFrameOfTrcBuf[trcBufLogID] == 0xFFFF)
      trigPhyFrameOfTrcBuf[trcBufLogID] = TrcBufSize;

// ReadTimeStamp(0,0,timestamp);

// outp(P4CtrlAX,0);  // Disable Trace Memory Output Enable

   return(GOOD);
}


/******************************************************************************
**
** TraceStop
**
******************************************************************************/
VOID TraceStop(VOID) {
   outp(MCtrlByte3,TOnFly);
   outp(RegByte4,OECtrl);  // Disable Main Output Enable
}

/******************************************************************************
**
** TraceStart
**
******************************************************************************/
RETCODE TraceStart(VOID) {
   RETCODE err;
   TBuffer_SIZE size ;
   U8 i,temp = 0;
   U32  TraceFrameNumber,TotalFrameNumber,PFCounter = 0x20000L,cnt0,cnt1;

// if ((FLEXConfig | P4Pipe ) != P4Pipe ) {
//   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
//   FLEXConfig &= P4Pipe ;
// }

   outp(P4CtrlAX,0);

   if ((FLEXConfig | P0Pipe ) != P0Pipe ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P0Pipe ;
   }

   if ((FLEXConfig | MNTrace ) != MNTrace) {
     if((err =  FLEXProgram(FLEX_MN,MNTraceByte)) != GOOD ) return(err);
     FLEXConfig &= MNTrace ;
     outp(MCtrlByte3,TOnFly);
   }

   outp(FClkSel0,0);  // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   for (i=0;i<MAX_TRACE_BUFFER_NUMBER;i++) {
      gotTrigInfoOfTrcBuf[i] = FALSE;
   }
   size = Mtat2VerCtrl ;
   switch(size)  {
     case SIZE_32k :
       temp |= TBSel0 ;
       temp |= TBSel1 ;
     break ;
     case SIZE_64k :
       temp |= TBSel0 ;
     break ;
     case SIZE_128k :
       temp |= 0 ;
     break ;
   }
   TotalFrameNumber = TrcBufSize;
   switch (triggerLocation) {
      case PRE_TRIG:
       TraceFrameNumber = (PFCounter - TotalFrameNumber);
      break ;
      case CENTER_TRIG:
       TraceFrameNumber = (PFCounter - (TotalFrameNumber/2+1));
      break ;
      case POST_TRIG:
       TraceFrameNumber = PFCounter;
      break ;
   }

   /* Write data "0" to TINFO of TRCM */

// outp(P4CtrlAX,FWrite0 | FWrite1 | FWrite2 | FWrite3 | EnByteWr);
   outp(P4CtrlAX,FWrite3 | EnByteWr);
   outp(RegByte4,0); //Enable Main output enable
   SetTAddr(0x0000);
   outp(MCtrlByte1,FTAC | temp);
   outp(MCtrlByte2,ReadCtrlBit);
   while( (inp(MCtrlByte3) & TBDone) != TBDone ) ;
   outp(P4CtrlAX,0);

   outp(MCtrlByte1,0);
   SetTAddr(0x0000);

   cnt0 = 0xFFFFFFFF - counter0;
   cnt1 = 0xFFFFFFFF - counter1;
   outp(MCtrlByte2,TC0Load);
   outpw(RegByte0,(U16) cnt0);
   outpw(RegByte2,(U16) (cnt0 >>16));
   outp(MCtrlByte2,0);

   outp(MCtrlByte2,TC1Load);
   outpw(RegByte0,(U16) cnt1);
   outpw(RegByte2,(U16) (cnt1 >>16));
   outp(MCtrlByte2,0);

   outpw(RegByte0,(U16) TraceFrameNumber);      // Load PFCnounter value
   outp(RegByte2,(U8) (TraceFrameNumber >>16 ));

   temp |= ((~TrcCtrlByte & 03) <<2 );
   if (breakOnFull == YES) temp |=  TFullBrk ;
   if (ToffOnFull == YES) temp |=  TFull ;
   outp(MCtrlByte1,temp);

   outp(P4CtrlAX,FWrite0 | FWrite1 | FWrite2 | FWrite3 | nOEBREG | nOETRIG | EnByteWr);
   /* Enable Bus Register and Trigger State Machine Output Enable and Force
      Byte Wirte of trace buffer */

   outp(FClkSel0,0);  // Change FCLK2/FCLK3 TO EPCLK
   outp(FClkSel1,0);

   outp(MCtrlByte3,~TOnFly);
}

/******************************************************************************
**
** SearchTrigPoint
**
******************************************************************************/
BOOLEAN SearchTrigPoint(U16 trcBufLogID) {
   BOOLEAN foundTrigPoint = FALSE ,trcBufFull = FALSE,foundHaltPoint = FALSE;
   U32 TrcAddr;
   U8  temp1,temp2;

   startLogFrameOfTrcBuf[trcBufLogID] = 0 ;
   endLogFrameOfTrcBuf[trcBufLogID] = 0 ;

   SetTAddr(TrcBufSize);
   temp1= (U8) (inp(nRDMN) & 0x03 ) ;
   SetTAddr((TrcBufSize - 1));
   outp(MCtrlByte2,ReadTINFO);
   temp2= (U8) (inp(nRDMN) & 0x03 ) ;
   if( (temp1 != 0) && (temp2 != 0) ) trcBufFull = TRUE ;

   for (TrcAddr = 0;TrcAddr <= (U32) (TrcBufSize);TrcAddr++) {
      SetTAddr(TrcAddr);
      outp(MCtrlByte2,ReadTINFO);
      switch(triggerLocation) {
         case POST_TRIG:
           switch(inp(nRDMN) & 0x03 ) {
             case 0x00 :
               foundHaltPoint = TRUE;
               haltPhyFrameOfTrcBuf[trcBufLogID] = TrcAddr;
               if ( trcBufFull == FALSE ) {
                  if (foundTrigPoint == FALSE) {
                     trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1) ;
                     startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                  }
                  return(foundTrigPoint);
               }
               else {
                  if (foundTrigPoint == FALSE) {
                     trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1) ;
                     startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                  }
               }
             break ;
             case 0x01 :
               startLogFrameOfTrcBuf[trcBufLogID] -- ;
             break;
             case 0x02 :
               endLogFrameOfTrcBuf[trcBufLogID] ++ ;
             break;
             case 0x03 :
               foundTrigPoint = TRUE ;
//             startLogFrameOfTrcBuf[trcBufLogID] = 0 ;
               trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) TrcAddr;
             break;
           }
        break ;
        case CENTER_TRIG:
          switch(inp(nRDMN) & 0x03 ) {
            case 0x00 :
              foundHaltPoint = TRUE;
              haltPhyFrameOfTrcBuf[trcBufLogID] = TrcAddr;
              if ( trcBufFull == FALSE ) {
                 if ( foundTrigPoint == FALSE ) {
                    trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1);
                    startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                 }
                 return(foundTrigPoint);
              }
              else {
                 if (foundTrigPoint == FALSE) {
                    trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1) ;
                    startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                 }
              }
            break ;
            case 0x01 :
              startLogFrameOfTrcBuf[trcBufLogID] -- ;
            break;
            case 0x02 :
              endLogFrameOfTrcBuf[trcBufLogID] ++ ;
            break;
            case 0x03 :
              foundTrigPoint = TRUE ;
              trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) TrcAddr;
            break;
          }
        break;
        case PRE_TRIG:
          switch(inp(nRDMN) & 0x03 ) {
            case 0x00 :
              foundHaltPoint = TRUE;
              haltPhyFrameOfTrcBuf[trcBufLogID] = TrcAddr;
              if ( trcBufFull == FALSE ) {
                 if ( foundTrigPoint == FALSE ) {
                    trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1);
                    startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                 }
                 return(foundTrigPoint);
              }
              else {
                 if (foundTrigPoint == FALSE) {
                    trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1) ;
                    startLogFrameOfTrcBuf[trcBufLogID] ++ ;
                 }
              }
            break ;
            case 0x01 :
              startLogFrameOfTrcBuf[trcBufLogID] -- ;
            break;
            case 0x02 :
              endLogFrameOfTrcBuf[trcBufLogID] ++ ;
            break;
            case 0x03 :
//            endLogFrameOfTrcBuf[trcBufLogID] = 0;
              foundTrigPoint = TRUE ;
              trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) TrcAddr;
//            return(foundTrigPoint);
            break;
          }
        break;
      }
   }
   if ((foundHaltPoint == FALSE) && (foundTrigPoint == FALSE)) {
      startLogFrameOfTrcBuf[trcBufLogID] ++ ;
      trigPhyFrameOfTrcBuf[trcBufLogID]= (U32) (TrcAddr-1);
   }
   return(foundTrigPoint);
}

/******************************************************************************
**
**  CheckMtat2Exist
**
*******************************************************************************/
VOID CheckMtat2Exist(VOID) {
   BOOLEAN checkExist1 = NO,checkExist2 = NO;
   U16 readdata[16];
   U8 *ptr;
   U8 writeSet[] = {0x55,0xAA};

   mtatExist = YES;
   ptr = (U8 *)readdata;
   ReadSerialEEPROM(ptr);

   if (readdata[0] == 0xAA55) {
      if(readdata[1] != Mtat2Module ) mtatExist = NO ;

      switch(readdata[2]) {
        case 0x32  :
           TrcBufSize = TB32K_SIZE  ;
           Mtat2VerCtrl = SIZE_32k;
           break ;
        case 0x64  :
           TrcBufSize = TB64K_SIZE  ;
           Mtat2VerCtrl = SIZE_64k;
           break ;
        case 0x128 :
           TrcBufSize = TB128K_SIZE ;
           Mtat2VerCtrl = SIZE_128k;
           break ;
      }
   }
   else {
//    WriteSerialEEPROM(writeSet);
//    ReadSerialEEPROM(ptr);
//
//    if(readdata[0] == 0xAA55) mtatExist = YES ;
//    TrcBufSize = TB32K_SIZE  ;
      mtatExist = NO ;
   }
}
/******************************************************************************
**
**  InitialTraceMachine
**
*******************************************************************************/
RETCODE InitialTraceMachine(VOID) {
   RETCODE err;

   CheckMtat2Exist();
   if(mtatExist != YES) return(GOOD) ;

   currentTraceMode = CYCLE_TRACE;
   FLEXConfig = 0;
   counter0 = 0;
   counter1 = 0;
   traceBufferNumber = 1;
   numberOfBitOfTBN = 0;
   triggerLocation = POST_TRIG;
   breakOnFull = NO;

   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
   FLEXConfig &= P4Pipe ;
   if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
   FLEXConfig |= P0Pio ;
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   FLEXConfig |= SMain ;

   return(GOOD);
}

/******************************************************************************
**
** ListTraceBuffer
**
*******************************************************************************/
RETCODE ListTraceBuffer(TRACE_HEAD *log, QUALIFY_LIST *qualify,
                        U8 *frameContents) {
   RETCODE err;
   U16 i = 0, j, fNo = 0;
   S32 StartAddrOfTrcFrame, curFrame;
   U8  *traceDataPoint, *tmpDataPoint, frameStatus;

   U8 pattern[] = {
   0x0C /* S (instruction fetch) */,
   0x0D /* R (memory read) */,
   0x0E /* W (memory write) */,
   0x09 /* I (I/O read) */,
   0x0A /* O (I/O write) */,
   0x08 /* A (interrupt acknowledge) */,
   0x0B /* H (bus halt) */,
   0x20 /* D (DMA cycle) */ };

   U8 mask[] = {
   0x0F /* S (instruction fetch) */,
   0x0F /* R (memory read) */,
   0x0F /* W (memory write) */,
   0x0F /* I (I/O read) */,
   0x0F /* O (I/O write) */,
   0x0F /* A (interrupt acknowledge) */,
   0x0F /* H (bus halt) */,
   0x20 /* D (DMA cycle) */ };

   if ((FLEXConfig | MNTrace ) != MNTrace) return(ERR_MN_CONFIG);
// if ((FLEXConfig | P4Pipe ) != P4Pipe ) {
//   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
//   FLEXConfig &= P4Pipe ;
// }
   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable

   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }

   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   outp(RegByte4,OECtrl);  // Disable Main Output Enable
   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable

   switch (currentTraceMode) {
     case CLOCK_TRACE:
       switch (log->traceform) {
          case CLOCK_LIST:
             return(err);  /* not support yet */
             break;
          case CYCLE_LIST:
             return(err);  /* not support yet */
             break;
       }
       break;
     case CYCLE_TRACE:
       switch (log->traceform) {
          case CLOCK_LIST:
             return(ERR_LIST_MODE);
             /* when the tracing clock is EP cycle, it is impossible to list
                information in EP clock */
          break;
          case CYCLE_LIST:
            StartAddrOfTrcFrame = (log->startFrame) +
                                  trigPhyFrameOfTrcBuf[log->traceBufId];
            if (StartAddrOfTrcFrame < 0)
              StartAddrOfTrcFrame += (TrcBufSize + 1) ;
            if (StartAddrOfTrcFrame > (S32) TrcBufSize )
              StartAddrOfTrcFrame -= (TrcBufSize + 1) ;
            traceDataPoint = frameContents;
            curFrame = log->startFrame;
            if (qualify->qFlag) {
               qualify->startAddr &= qualify->addrMask;
               qualify->data &= qualify->dataMask;
            }
            while((fNo < LIST_BUFFER_SIZE) && (curFrame <=
                  endLogFrameOfTrcBuf[log->traceBufId]))  {
              tmpDataPoint = traceDataPoint;
              SetTAddr((U32) (StartAddrOfTrcFrame + (U32) i));
              ListAddr(&traceDataPoint);
              ListData(&traceDataPoint);
              ListStatus(&traceDataPoint);
              ListExtBit(&traceDataPoint);
              ListTracePort(&traceDataPoint);
              ListTimeStamp(&traceDataPoint);
              ListEventLevel(&traceDataPoint);
              if (qualify->qFlag) {
                 for (j=0; j<8 ;j++)
                    if ((tmpDataPoint[6] & mask[j]) == pattern[j]) {
                       frameStatus = (U8)(1 << j);
                       break;
                    }
                 if (qualify->addrMask == 0xFFFFF) {
                    if ((*(U32 *)&(tmpDataPoint[0]) < qualify->startAddr) ||
                        (*(U32 *)&(tmpDataPoint[0]) > qualify->endAddr) ||
                        ((frameStatus & qualify->status) == 0) ||
                        (*(U16 *)&(tmpDataPoint[4]) & qualify->dataMask) != qualify->data) {
                       traceDataPoint = tmpDataPoint;
                    } else {
                        memcpy(traceDataPoint,&curFrame,4);
                        traceDataPoint += 4;
                        fNo++;
                        if (qualify->qFlag == 2) break;
                    }
                 } else {
                    if (((*(U32 *)&(tmpDataPoint[0]) & qualify->addrMask) !=
                         qualify->startAddr) ||
                        ((frameStatus & qualify->status) == 0) ||
                        (*(U16 *)&(tmpDataPoint[4]) & qualify->dataMask) != qualify->data) {
                       traceDataPoint = tmpDataPoint;
                    } else {
                        memcpy(traceDataPoint,&curFrame,4);
                        traceDataPoint += 4;
                        fNo++;
                        if (qualify->qFlag == 2) break;
                    }
                 }
              } else {
                 fNo++;
              }
              i++;
              curFrame++;
            }
            if ( traceDataPoint == frameContents) log->frameLen = 0;
            log->frameLen = fNo;
          break;
       }
     break;
   }
   outp(P4CtrlAX,0);  // Disable Trace Memory Output Enable
   return(GOOD);
}

/*****************************************************************************
**
**  ListAddr
**
******************************************************************************/
VOID ListAddr(U8 **Ptr) {
   U8 i;

   for (i = 0;i < 4;i++) {
     **Ptr = (U8) inp(ReadP0Byte1 + i);
     (*Ptr)++ ;
   }
}
/*****************************************************************************
**
**  ListData
**
******************************************************************************/
VOID ListData(U8 **Ptr) {
   U8 i;

   for (i = 0;i < 2;i++) {
     **Ptr = (U8) inp(ReadP2Byte3 + i);
     (*Ptr)++ ;
   }
}
/*****************************************************************************
**
**  ListStatus
**
******************************************************************************/
VOID ListStatus(U8 **Ptr) {

     **Ptr = (U8) inp(ReadP1Byte4);
     (*Ptr)++ ;
}
/*****************************************************************************
**
**  ListExtBit
**
******************************************************************************/
VOID ListExtBit(U8 **Ptr) {

     **Ptr = (U8) inp(ReadP2Byte1);
     (*Ptr)++ ;
}
/*****************************************************************************
**
**  ListTracePort
**
******************************************************************************/
VOID ListTracePort(U8 **Ptr) {

     **Ptr = (U8) inp(ReadP3Byte3);
     (*Ptr)++ ;
     **Ptr = (U8) inp(ReadP3Byte4);
     (*Ptr)++ ;
     **Ptr = (U8) inp(ReadP3Byte1);
     (*Ptr)++ ;
     **Ptr = (U8) inp(ReadP3Byte2);
     (*Ptr)++ ;
}
/*****************************************************************************
**
**  ListTimeStamp
**
******************************************************************************/
VOID ListTimeStamp(U8 **Ptr) {
   U8 i;

   for (i = 0;i < 5;i++) {
     outp(MCtrlByte2,ReadGrayCnt+i);
     **Ptr = (U8) inp(nRDMN);
     (*Ptr)++ ;
   }
   Gray2Bin(*Ptr-5);
}
/*****************************************************************************
**
**  ListEventLevel
**
******************************************************************************/
VOID ListEventLevel(U8 **Ptr) {
   U8 i;

   for (i = 0;i < 2;i++) {
     **Ptr = (U8) inp(ReadEvent - i);
     (*Ptr)++ ;
   }
}

/*****************************************************************************
**
**  SPAListTrace
**
******************************************************************************/
RETCODE SPAListTrace(U8 *timeStamp,U8 *event) {
// RETCODE err;
   U8 i;

// if ((FLEXConfig & P0Pio ) != P0Pio ) {
//   if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
//   FLEXConfig |= P0Pio ;
// }

   outp(FClkSel0,0x80);    // Change FCLK2/FCLK3 TO CPCLK
   outp(FClkSel1,0);

   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   outp(P0CtrlPort,0x01); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0x01);
   outp(P2CtrlPort,0x01);
   outp(P3CtrlPort,0x01);
   outp(P4CtrlB,0);

   outp(MCtrlByte3,TOnFly);

   outp(RegByte4,OECtrl);  // Disable Main Output Enable
   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable

   SetTAddr(0);

   for (i = 0;i < 5;i++) {
     outp(MCtrlByte2,ReadGrayCnt+i);
     *(timeStamp + i) = (U8) inp(nRDMN);
   }
   Gray2Bin(timeStamp);

   for (i = 0;i < 2;i++) {
     *(event+i) = (U8) inp(ReadEvent - i);
   }

   outp(P4CtrlAX,0);  // Disable Trace Memory Output Enable
   outp(P0CtrlPort,0); // Enable P0-P4 output enable 
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   return(GOOD);
}

/*****************************************************************************
**
**  CheckTrigEvent
**
******************************************************************************
RETCODE CheckTrigEvent(VOID) {
   U8 i,trigaction;
   RETCODE err;

   if ((FLEXConfig & P4Pio ) != P4Pio ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P4Pio ;
   }

   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   outp(RegByte4,OECtrl);  // Disable Main Output Enable
   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable

   //Set trcace address = trigger point address
   SetTAddr((U32) (trigPhyFrameOfTrcBuf[0]));

   trigaction = (U8) inp(ReadEvent);
   for (i=0;i<8;i++) {
      if((trigaction & ((0x01) << i)) == ((0x01) << i))
      return(i+1);
   }
   trigaction = (U8) inp(ReadLvTc);
   for (i=0;i<2;i++) {
      if((trigaction & ((0x04) << i)) == ((0x04) << i))
      return((U8) (i+9));
   }
   trigaction = (U8) inp(ReadP2Byte1);
   if (trigaction & 0x01) return(FOUND_EXT_BIT);

   outp(P4CtrlAX,0);  // Disable Trace Memory Output Enable
   return(GOOD);
}
*/
/*****************************************************************************
**
**  ReadTimerCounter
**
******************************************************************************/
RETCODE ReadTimerCounter (U32 *cnt0AfterTraceHalt,U32 *cnt1AfterTraceHalt) {
   U16 i;
   U32 cTR0AfterTraceHalt = 0, cTR1AfterTraceHalt = 0;

   if ((FLEXConfig | MNTrace ) != MNTrace) return(ERR_MN_CONFIG);

   for (i = 0 ;i < 4 ;i++) {
     outp(MCtrlByte2,ReadTC0Byte3 - i);
     cTR0AfterTraceHalt |= (U32) inp(nRDMN) << (8*(3-i)) ;
   }
   for (i = 0 ;i < 4 ;i++) {
     outp(MCtrlByte2,ReadTC1Byte3 - i);
     cTR1AfterTraceHalt |= (U32) inp(nRDMN) << (8*(3-i)) ;
   }
   *cnt0AfterTraceHalt = cTR0AfterTraceHalt;
   *cnt1AfterTraceHalt = cTR1AfterTraceHalt;
   return(GOOD) ;
}
/*****************************************************************************
**
**  ReadHaltTimeStamp
**
******************************************************************************/
VOID ReadHaltTimeStamp(U8 *timeStamp)  {
   U8 i ;

   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   outp(RegByte4,OECtrl);  // Disable Main Output Enable
   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable

   SetTAddr(haltPhyFrameOfTrcBuf[0]);
   for (i=0;i< 5;i++)  {
     outp(MCtrlByte2,ReadGrayCnt+i);
     timeStamp[i] = (U8) inp(nRDMN);
   }
   Gray2Bin(timeStamp) ;

   outp(P4CtrlAX,0);  /* Disable Trace Memory Output Enable */
}

/*****************************************************************************
**
**  ReadTimeStamp
**
******************************************************************************/
VOID ReadTimeStamp(U16 trcBufLogID,S32 LogID,U8 *timeStamp)  {
   U8 i ;
   U32 PhyID;

   outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   outp(P0CtrlPort,0); // Disable P0-P4 output enable //
   outp(P1CtrlPort,0);
   outp(P2CtrlPort,0);
   outp(P3CtrlPort,0);
   outp(P4CtrlB,0);

   outp(P4CtrlAX,nOETRCM);  // Enable Trace Memory Output Enable
   outp(RegByte4,OECtrl);  // Disable Main Output Enable

   PhyID = LogID + trigPhyFrameOfTrcBuf[trcBufLogID];
   if (PhyID > TrcBufSize ) PhyID -= (TrcBufSize + 1) ;

   SetTAddr((U16)PhyID);
   for (i=0;i< 5;i++)  {
     outp(MCtrlByte2,ReadGrayCnt+i);
     timeStamp[i] = (U8) inp(nRDMN);
   }
   Gray2Bin(timeStamp) ;

   outp(P4CtrlAX,0);  /* Disable Trace Memory Output Enable */
}
/*****************************************************************************
**
**  ProgramTMANTrace
**
******************************************************************************/
RETCODE ProgramTMANTrace(U8 trcSel) {
   RETCODE err;
   TBuffer_SIZE size ;
   U8   i,temp = 0 ;
   U32  TraceFrameNumber,TotalFrameNumber,PFCounter = 0x20000L,cnt0,cnt1;

   if ((FLEXConfig | P4Pipe ) != P4Pipe ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P4Pipe ;
   }
   outp(P4CtrlAX,0);

   if ((FLEXConfig | P0Pipe ) != P0Pipe ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P0Pipe ;
   }
   if ((FLEXConfig | MNTrace ) != MNTrace) {
     if((err =  FLEXProgram(FLEX_MN,MNTraceByte)) != GOOD ) return(err);
     FLEXConfig &= MNTrace ;
   }

   for (i=0;i<MAX_TRACE_BUFFER_NUMBER;i++) {
      gotTrigInfoOfTrcBuf[i] = FALSE;
   }

   outp(FClkSel0,0);  // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0X80);

   outp(MCtrlByte3,TOnFly);

   size = Mtat2VerCtrl ;
   switch(size)  {
     case SIZE_32k :
       temp |= TBSel0 ;
       temp |= TBSel1 ;
     break ;
     case SIZE_64k :
       temp |= TBSel0 ;
     break ;
     case SIZE_128k :
       temp |= 0 ;
     break ;
   }
   TotalFrameNumber = TrcBufSize;
   switch (triggerLocation) {
      case PRE_TRIG:
       TraceFrameNumber = (PFCounter - TotalFrameNumber);
      break ;
      case CENTER_TRIG:
       TraceFrameNumber = (PFCounter - (TotalFrameNumber/2+1));
      break ;
      case POST_TRIG:
       TraceFrameNumber = PFCounter;
      break ;
   }

   /* Write data "0" to TINFO of TRCM */

// outp(P4CtrlAX,FWrite0 | FWrite1 | FWrite2 | FWrite3 | EnByteWr);
   outp(P4CtrlAX,FWrite3 | EnByteWr);
   outp(RegByte4,0);   //Enable Main Output Enable
   SetTAddr(0x0000);
   outp(MCtrlByte1,FTAC | temp);
   outp(MCtrlByte2,ReadCtrlBit);
   while( (inp(MCtrlByte3) & TBDone) != TBDone ) ;
   outp(P4CtrlAX,0);

   outp(MCtrlByte1,0);
   SetTAddr(0x0000);

   cnt0 = 0xFFFFFFFF - counter0;
   cnt1 = 0xFFFFFFFF - counter1;
   outp(MCtrlByte2,TC0Load);
   outpw(RegByte2,(U16) (cnt0 >>16));
   outpw(RegByte0,(U16) cnt0);
   outp(MCtrlByte2,0);
   outp(MCtrlByte2,TC1Load);
   outpw(RegByte0,(U16) cnt1);
   outpw(RegByte2,(U16) (cnt1 >>16));
   outp(MCtrlByte2,0);

   outpw(RegByte0,(U16) TraceFrameNumber);      // Load PFCnounter value
   outp(RegByte2,(U8) (TraceFrameNumber >>16 ));

   temp |= ((~TrcCtrlByte & 03) <<2 );
   temp |= trcSel << 7 ;
   if (breakOnFull == YES) temp |=  TFullBrk ;
   if (ToffOnFull == YES) temp |=  TFull ;
   outp(MCtrlByte1,temp);

// TraceStart();

   outp(LA0A1nOE,0);

   outp(MCtrlByte3,~TOnFly);

   outp(P4CtrlAX,FWrite0 | FWrite1 | FWrite2 | FWrite3 | nOEBREG | nOETRIG | EnByteWr);
   /* Enable Bus Register and Trigger State Machine Output Enable and Force
      Byte Wirte of trace buffer */

   outp(FClkSel0,0);  // Change FCLK2/FCLK3 TO EPCLK
   outp(FClkSel1,0);


   return(GOOD);
}

/******************************************************************************
**
**  IsTMANBreak
**
*******************************************************************************/
BOOLEAN IsTMANBreak(VOID) {
   outp(MCtrlByte2,ReadCtrlBit);
   return((BOOLEAN) (inp(nRDMN) >> 3));
}


/******************************************************************************
**
**  Gray2Bin
**
*******************************************************************************/
VOID Gray2Bin(U8 *ptr) {
   U8 BinData[5] ={0,0,0,0,0}, temp = 0;
   S8 i,j;

   for (j = 4; j >= 0; j--) {
      for (i = 7;i >= 0;i--) {
         temp = (U8) ((temp ^ (*(ptr+j) >> i)) & (0x01));
         *(BinData + j) |= temp << i;
      }
   }
   for (i=0;i<5;i++) {
      *(ptr+i) = *(BinData+i);
   }
 }
/***************************************************************************
**
**  ReadSerialEEPROM
**
****************************************************************************/
VOID ReadSerialEEPROM(U8 *ptr)  {

   U8 ReadIntSet[9] ;
   U16 *dataptr,serialdata,i,j;
   U16 temp;

   dataptr = (U16 *) ptr;
   for (i=0;i<16;i++) *(dataptr+i) = 0;
   ReadIntSet[0] = 0x02 ; // Read instruction Start bit
   ReadIntSet[1] = 0x02 ; // Read instruction Op code
   ReadIntSet[2] = 0x00 ; // Read instruction Op code
   ReadIntSet[3] = 0x00 ; // A5
   ReadIntSet[4] = 0x00 ; // A4
   outp(NPCS5,PullSKLo);
   for (i = 0;i < 16; i++) {
      outp(EEROMCS,PullCSLo);
      outp(EEROMCS,PullCSHi);
      outp(NPCS5,PullSKHi);
      for (j = 0;j < 4;j++) {
         serialdata = ( i & (0x08 >> j)) ;
         if ( serialdata == 0 ) ReadIntSet[j+5] =0x00;
         else
            ReadIntSet[j+5] =0x02;
      }
      for (j = 0;j < 9; j++)  {
        outp(NPCS5,(PullSKLo | ReadIntSet[j]));
        outp(NPCS5,(PullSKHi | ReadIntSet[j]));
      }
      outp(NPCS5,PullSKLo);
      for (j=8;j>0;j--) {
         outp(NPCS5,PullSKHi);
         temp = (U16) inp(ReadEEROM) & 0x0080 ;
         *(dataptr+i) |= ( temp << j);
         outp(NPCS5,PullSKLo);
      }
      for (j=0;j<=7;j++) {
         outp(NPCS5,PullSKHi);
         temp = (U16) inp(ReadEEROM) & 0x0080;
         *(dataptr+i) |= ( temp >> j) ;
         outp(NPCS5,PullSKLo);
      }
   }
   outp(EEROMCS,PullCSLo);
}
/***************************************************************************
**
**  WriteSerialEEPROM
**
****************************************************************************/
VOID WriteSerialEEPROM(U8 *ptr)  {


   U8 static const _based(_segname("_CODE")) EWENIntSet[] = {
                /* Start   Op    Op    A     A     A     A     A     A
                    Bit   Code  Code   5     4     3     2     1     0  */
                   0x02, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00};
   U8 static const _based(_segname("_CODE")) EWDSIntSet[] = {
                /* Start   Op    Op    A     A     A     A     A     A
                    Bit   Code  Code   5     4     3     2     1     0  */
                   0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   U8 i,j,temp[25];
   U16 *dataptr,serialdata,k;

   dataptr = (U16 *) ptr;
   outp(NPCS5,PullSKHi);
   outp(EEROMCS,PullCSLo);
   outp(EEROMCS,PullCSHi);
   for (i = 0;i < 9; i++)  {
      outp(NPCS5,(PullSKLo | EWENIntSet[i]));
      outp(NPCS5,(PullSKHi | EWENIntSet[i]));
   }

   temp[0] = 0x02 ; // Start bit
   temp[1] = 0x00 ; // Op code
   temp[2] = 0x02 ; // Op code
   temp[3] = 0x00 ; // A5
   temp[4] = 0x00 ; // A4
   for (i = 0;i < 16;i++) {
      for (j = 0;j < 4;j++) {
         serialdata = ( i & (0x08 >> j)) ;
         if ( serialdata == 0 ) temp[j+5] =0x00;
         else
            temp[j+5] =0x02;
      }
      for (j = 0;j < 16;j++) {
         serialdata = ( *(dataptr+i) & (0x8000 >> j));
         if ( serialdata == 0 ) temp[j+9] =0x00;
         else
            temp[j+9] =0x02;
      }
      outp(EEROMCS,PullCSLo);
      outp(EEROMCS,PullCSHi);
      for (j = 0;j < 25; j++)  {
         outp(NPCS5,(PullSKLo | temp[j]));
         outp(NPCS5,(PullSKHi | temp[j]));
      }
      outp(NPCS5,PullSKLo);
      outp(EEROMCS,PullCSLo);
      outp(EEROMCS,PullCSHi);
      for (k=0;k<0xFFFF;k++) {
         if (((U16) inp(ReadEEROM) & 0x80) == 0x80) break;
      }
      if (k == 0xFFFF) break;
   }
   for (i = 0;i < 9; i++)  {
      outp(NPCS5,(PullSKLo | EWDSIntSet[i]));
      outp(NPCS5,(PullSKHi | EWDSIntSet[i]));
   }
   outp(EEROMCS,PullCSLo);
}
/***************************************************************************
**
**  SetTAddr
**
****************************************************************************/
VOID SetTAddr(U32 addr) {

   outp(MCtrlByte2,TALoad);
   outpw(RegByte0,(U16) addr );
   outp(RegByte2,(U8)(addr >> 16));
   outp(MCtrlByte2,0);
}

/********************************* EOF *************************************/
