/****************************************************************************
**
** Name: cliulib.h
**
** Description:  CLI utility library.
**
** Status: CODED
**
** Copyright (C) 1992 Microtek International.  All rights reserved.
**
** $Log:   S:/tbird/mt2_186/inc/cliulib.h_v  $
** 
**    Rev 1.0   16 Dec 1996 13:54:10   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:22   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:44:16   Judy
   Initial revision.
** 
**    Rev 1.8   18 May 1994 16:41:46   nghia
** Moved all loader progress indicator routines and data type to LOADER.H
** 
**    Rev 1.7   11 May 1994 14:29:30   tom
** Added new version elements.
** 
**    Rev 1.6   23 Mar 1994 16:49:34   tom
** Check for compatible versions
** 
**    Rev 1.5   28 Sep 1993 15:39:10   ron
** added ReadLine and FindLine (initially, for peripheral presenter)
** 
**    Rev 1.4   23 Sep 1993 10:40:08   nghia
** Revised LDRPROC parameter flags as an U32 to support new laod option.
** 
**    Rev 1.3   10 Sep 1993 13:58:04   ron
** changed prototypes to pass LONG for window handle, for things that
** Actor calls (it can't pass unsigned ints).
** 
**    Rev 1.2   01 Sep 1993 14:37:14   ron
** changes for help/menu support in Peripheral Presenter
** 
**    Rev 1.1   30 Aug 1993 10:53:44   ron
** changes for Load Progress dialog
** 
**    Rev 1.0   08 May 1992 11:51:00   tom
** Initial revision.
**  
** $Header:   S:/tbird/mt2_186/inc/cliulib.h_v   1.0   16 Dec 1996 13:54:10   Judy  $
**
*****************************************************************************/

#define _CLIULIB_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
#ifndef HFILE
/* from windows.h for Windows 3.1 */
typedef int HFILE; /* Polymorphic with C runtime file handle type */
#endif

                       /**************************
                        *                        *
                        *          ERRORS        *
                        *                        *
                        **************************/

                        /*************************
                        *                        *
                        *   EVENT NOTIFICATION   *
                        *                        *
                        **************************/

                       /**************************
                        *                        *
                        *      PROTOTYPES        *
                        *                        *
                        **************************/

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
**  CLISetActive
**
**  Purpose:
**     Mark the CLI as active.  Should only be called from CLI Server.
**
**  Input:
**     cliHandle:  The CLI Server handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLISetActive(HANDLE cliHandle);


/*--------------------------------------------------------------------------
**  CLIClearActive
**
**  Purpose:
**     Mark the CLI as inactive.  Should only be called from CLI Server.
**
**  Input:
**     None.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIClearActive(void);


/*--------------------------------------------------------------------------
**  CLIGetActive
**
**  Purpose:
**     Return an indication of whether the CLI is active or not.
**
**  Input:
**     None.
**
**  Output:
**     cliHandle:  The CLI Server handle; 0 indicates CLI Server inactive.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIGetActive(HANDLE *cliHandle);


/*--------------------------------------------------------------------------
**  GetPowerViewsVersion
**
**  Purpose:
**     Return the PowerViews version.
**
**  Parameters:
**     major:  major version number.
**     minor:  minor version number.
**     bug:    bug version number.
**     string: build tag.
**     build:  build number.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetPowerViewsVersion(U16 *major, U16 *minor, CHAR *bug,
   LPSTR string, U16 *build);

/*--------------------------------------------------------------------------
**  SaveToolBarHandle
**
**  Purpose:
**     Save the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     The toolbar window's handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT SaveToolBarHandle(LONG hToolBar);

/*--------------------------------------------------------------------------
**  GetToolBarHandle
**
**  Purpose:
**     Return the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     None.
**
**  Output:
**     The toolbar window's handle.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetToolBarHandle(HANDLE FAR * lphToolBar);

/*--------------------------------------------------------------------------
**  RegisterHelpEntry
**
**  Purpose:
**    Record the Window Handle of a PowerViews window or dialog along with
**    the help entry to use for it.
**
**  Input:
**     hInd:       The index in the handle/entry array for this window.
**     hWnd:       The parent window handle (long since Actor can't pass
**                 unsigned ints).
**     helpEntry:  The help entry to use if F1 is pressed over that window.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT RegisterHelpEntry(U16 hInd, LONG hWnd, WORD helpEntry);

/*--------------------------------------------------------------------------
**  ReadLine
**
**  Purpose:
**     Read a line (efficiently) from the open file (a replacement for
**     a function that read the file one byte at a time).
**
**  Input:
**     hFile:  The file handle.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT ReadLine(HFILE hFile, LPSTR buf, U16 bufsize);

/*--------------------------------------------------------------------------
**  FindLine
**
**  Purpose:
**     Find and return the next non-blank non-comment line (used by 
**     configuration file readers).
**
**  Input:
**     hFile:  The file handle.
**     line:   The line number in the file.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT FindLine(HFILE hFile, U16 FAR *line, LPSTR buf, U16 bufsize);
#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
