/****************************************************************************
**
**  Name:  iniutil.h
**
**  Description:
**     Declarations of utility routines to access and manipulate
**		 the PWRVIEWS.INI and other INI files.
**     These routines are export from CLIULIB.DLL
**
**  Status:  PRELIMINARY | CODED | REVIEWED | TESTED
**
**  $Log:   S:/tbird/mt2_186/inc/iniutil.h_v  $
** 
**    Rev 1.0   16 Dec 1996 13:54:14   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:24   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:44:52   Judy
   Initial revision.
** 
**    Rev 1.0   18 May 1994 16:40:32   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/inc/iniutil.h_v   1.0   16 Dec 1996 13:54:14   Judy  $
**
**  Copyright (C) 1991, 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _INIUTIL_
#define _INIUTIL_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/
// Use in the IniSet/Getxxxx() routine to specified that the call is to
// access the PWRVIEWS.INI file
#define PWRVIEWS_INI_DEFAULT NULL


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
**
**  IniGetPwrViewsIniPath
**
**  Description:
**     Locate the PWRVIEWS.INI file directory and store the path for INI
**     access functions (see bellow).
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
******************************************************************************/
RETCODE EXPORT IniGetPwrViewsIniPath(VOID);

/******************************************************************************
**
**  IniSetNumber
**
**  Description:
**     Save the number <inNum> to the <iniFileName> file.
**     If <iniFileName> is NULL, the default PWRVIEWS.INI will be used.
**
**     The INI format is:
**        [sectionName]
**        <itemName>=<inNum - in text form>
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the <iniFileName>.
**        itemName (in)    : Name of the item contains the value.
**        iniFileName (in) : Name of the INI file (including path).
**        inNum (in)       : The numeric value to save.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT IniSetNumber(LPSTR sectionName, LPSTR itemName,
                            LPSTR iniFileName, U32 inNum);

/******************************************************************************
**
**  IniGetNumber
**
**  Description:
**     Get a numeric value of the specified item from the <iniFileName>.
**     If <iniFileName> is NULL, the default PWRVIEWS.INI will be used.
**
**     The INI format is:
**        [sectionName]
**        <itemName>=<outNum - in text form>
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the <iniFileName>.
**        itemName (in)    : Name of the item that holds the value.
**        iniFileName (in) : Name of the INI file (including path).
**     output:
**        outNum (out)     : The return numeric value.
**
******************************************************************************/
RETCODE EXPORT IniGetNumber(LPSTR sectionName, LPSTR itemName,
                            LPSTR iniFileName, U32 FAR* outNum);

/******************************************************************************
**
**  IniSetString
**
**  Description:
**     Save the input string to the specified item of the <iniFileName> file.
**     If <iniFileName> is NULL, the default PWRVIEWS.INI will be used.
**
**     The INI format is:
**        [sectionName]
**        <itemName>=<inStr>
**
**     NOTES: The maximum length of <inStr> is MAX_STRING_SIZE.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the <iniFileName>
**        itemName (in)    : Name of the item contains the value.
**        iniFileName (in) : Name of the INI file (including path).
**        inStr (in)       : The string to save.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT IniSetString(LPSTR sectionName, LPSTR itemName,
                            LPSTR iniFileName, LPSTR inStr);

/******************************************************************************
**
**  IniGetString
**
**  Description:
**     Get a string from the specified item of the <iniFileName> file.
**     If <iniFileName> is NULL, the default PWRVIEWS.INI will be used.
**
**     The INI format is:
**        [sectionName]
**        <itemName>=<outStr>
**
**     NOTES: <outStr> should be a string of MAX_STRING_SIZE characters.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the <iniFileName>
**        itemName (in)    : Name of the item that holds the string.
**        iniFileName (in) : Name of the INI file (including path).
**     output:
**        outStr (out)     : The returned string (Caller supplied).
**
******************************************************************************/
RETCODE EXPORT IniGetString(LPSTR sectionName, LPSTR itemName,
                            LPSTR iniFileName, LPSTR outStr);

#ifdef __cplusplus
}
#endif

#endif /* _INIUTIL_ */
/******************************** E O F ***********************************/