/****************************************************************************
**
**  Name:  trace.h
**
**  Description:
**     External interface for trace.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_186/inc/mp_trc.h_v  $
** 
**    Rev 1.0   16 Dec 1996 13:54:36   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:30   Judy
** Initial revision.
** 
**    Rev 1.8   01 Sep 1993 22:06:30   unknown
** proto changes needed for dq'r backup change
** 
**    Rev 1.7   22 Jul 1993 11:38:56   mindy
** Added routines needed for background task that marker the instruction
** starts within the trace buffer.
** 
**    Rev 1.6   10 Mar 1993 12:19:36   ernie
** Added support for show cycle triggering and tracing
** 
**    Rev 1.5   16 Dec 1992 15:28:36   mindy
** moved trace to fw
** 
**    Rev 1.4   18 Sep 1992 12:57:42   ernie
** Added control for emon fall trigger enable. Used by go from bkpt.
** 
**    Rev 1.3   01 Feb 1992 09:35:20   ernie
** Added support routines to change framequal polarity
** 
**    Rev 1.2   24 Oct 1991 09:54:20   ernie
** Added support for 8 and 32 bit event recognizers
** 
**    Rev 1.1   05 Aug 1991 09:46:02   ernie
** Coded.
** 
**    Rev 1.0   23 Jul 1991 15:29:08   jim
** Initial revision.
** 
**    Rev 1.0   23 Jul 1991 15:14:46   jim
** Initial revision.
** 
**    Rev 1.0   23 Jul 1991 14:59:30   jim
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/inc/mp_trc.h_v   1.0   16 Dec 1996 13:54:36   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MP_TRACE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define SEQENBWR  (IO_TMAN + 0x06)   /* D0=sequencer-enb, D1=action-enb */
#define SEQ_RUN 0x3  /* values for SEQENBWR port */
#define SEQ_STOP 0x1
#define SEQ_PROG 0x0

typedef struct {
/*   U32 addr;
   U16 data;
   U8  stat;
   U8  tstamp;
   U8  tbit;   */
   U16 groupRlsw;    //
   U16 groupRmsw;
   U16 groupSlsw;
   U16 groupSmsw;
   U16 groupTlsw;
   U16 groupTmsw;
} TRACE_FRAME;

typedef struct {
   U32 low;
   U32 high;
   U32 mask;
   BOOLEAN not;
} EVTREC_RANGE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/**************************************************************************
**
** TrcInit
**
** Description:
**    Initialize trace.  Must be called before responses to shared
**    data requests can be made.
** Parameters:
**    input:
**       none:
**    output:
**       none:
**************************************************************************/
RETCODE EXPORT TrcInit(HANDLE hLib);

/**************************************************************************
**
** TrcSetEmonFallEnable
** TrcGetEmonFallEnable
**
** Description:
**     Set whether to stop trace when emon turns off.
**
** Parameters:
**    input:
**      enable:     True to enable stopping trace when emon turns off
**    output:
**       none
**
**************************************************************************/
RETCODE EXPORT TrcSetEmonFallEnable(BOOLEAN enable);
RETCODE EXPORT TrcGetEmonFallEnable(BOOLEAN *enable);

VOID EXPORT ReadTraceFrame(U32 frame, TRACE_FRAME *result);
VOID EXPORT JustReadTraceStatus(U32 frame, U16 *status);


/* new routines */
BOOLEAN EXPORT DoubleVRam(VOID);      
U16 EXPORT IncSubBuffer(U16 subBuff, S16 count);
U16 EXPORT NumSubBufsPerTraceBuffer(VOID);
U16 EXPORT NumTraceBuffers(VOID);
U32 EXPORT IncPhysicalFrame(U32 frame, S32 count);
U16 EXPORT GetPostFillCount(VOID);
RETCODE EXPORT TraceBufferInfo(U16 buffer, BOOLEAN emon, S32 *oldest, 
                               S32 *youngest);

/**************************************************************************
**
** TrcSetShowCycleEnable
** TrcGetShowCycleEnable
**
** Description:
**     Set whether to recognize show cycles when assembling bus frames
**
** Parameters:
**    input:
**      enable:     True to enable recognition of show cycles
**    output:
**       none
**
**************************************************************************/
RETCODE EXPORT TrcSetShowCycleEnable(BOOLEAN enable);
RETCODE EXPORT TrcGetShowCycleEnable(BOOLEAN *enable);

/**************************************************************************
**
** TrcSetFrameAsMarker
**
** Description:
**     Incoming physical frame is marked as an instruction "start".  This
** can mean different things for different processors - but it is the frame
** number where the instruction starts. Am using the physical frame since
** there is a unique physical frame number for each frame - regardless of
** of the buffer - this speeds up the marking routine. No boundry checking
** is done to also speed up this routine!
**
** Parameters:
**    input:
**      frame:     Physical frame number of frame to mark as instruction start
**    output:
**       none
**
**************************************************************************/
VOID TrcSetFrameAsMarker(U32 frame);

RETCODE TrcFindClosestNInst(U16 buffer, S32 *frame, S16 count, U16 *actCount);
U16 TrcMarkerSize(VOID);

RETCODE TrcHostTimeInit(VOID);  // need CPUTYPE!?!

RETCODE TrcFindNClosest(U8 *markers, BOOLEAN *chunkArray, U16 buffer,
                        S32 *frame, S16 count, U16 *actCount);

VOID SetChunkRoutine(RETCODE (*chunker)(U16 chunk, U16 buffer, S32 startFrame,
                                        S32 stopFrame)) ;

U16 *Frame2Addr(U32 frame);
S32 PhysFrameToLogical(U16 buffer, U32 frame);

/******************************** E O F ***********************************/
