/****************************************************************************
**
** Name: pvtest.h
**
** Description:
**       Prototypes for confidence testing external interface
**
**  $Log:   S:/tbird/mt2_186/inc/pvtest.h_v  $
** 
**    Rev 1.0   16 Dec 1996 13:54:20   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:24   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:28   Judy
   Initial revision.
** 
**    Rev 1.0   10 May 1994 09:57:18   ernie
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/inc/pvtest.h_v   1.0   16 Dec 1996 13:54:20   Judy  $
**
** Copyright (C) 1991-94 Microtek International, Inc.
**
*****************************************************************************/
#define _PVTEST_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h" 
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"

#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
** TestRead
**
** description:
**   Memory read function including extended spaces
**
** parameters:
**   addr     address descriptor containing address offset
**   space    extended address space
**   length   number of bytes to read
**   data     returned TMalloc'ed data buffer (caller must free)
**   loop     if TRUE, repeat operation until aborted.
**
*****************************************************************************/
RETCODE EXPORT TestRead(DESCRIPTOR addr, ADDR_SPACE space, U32 length,
                        U8 **data, BOOLEAN loop);

/****************************************************************************
**
** TestWrite
**
** description:
**   Memory write function including extended spaces
**
** parameters:
**   addr     address descriptor containing address offset
**   space    extended address space
**   length   number of bytes to write
**   data     data buffer (this function TFrees buffer)
**   loop     if TRUE, repeat operation until aborted.
**
*****************************************************************************/
RETCODE EXPORT TestWrite(DESCRIPTOR addr, ADDR_SPACE space, U32 length,
                        U8 *data, BOOLEAN loop);

/****************************************************************************
**
** TestRamtst
**
** description:
**   Memory write function including extended spaces
**
** parameters:
**   addr     address descriptor containing address offset
**   space    extended address space
**   length   number of bytes to write
**   loop     if TRUE, repeat operation until aborted.
**   info     pointer to structure to receive error information
**
*****************************************************************************/
RETCODE EXPORT TestRamtst(DESCRIPTOR addr, ADDR_SPACE space, U32 length,
                         BOOLEAN loop, RAMTST_INFO *info);

/****************************************************************************
**
** TestIsExtendedSpace
**
** description:
**   Compare input string against known address spaces.  Return if found.
**
** parameters:
**   str      input string
**   space    pointer to receive addr space value
**   retval   TRUE if addr space was found
**
*****************************************************************************/
BOOLEAN EXPORT TestIsExtendedSpace(LPSTR str, ADDR_SPACE *space);

/****************************************************************************
**
** TestIsSastBitName
**
** description:
**   If space==SAST, search for incoming text in config file, return value.
**
** parameters:
**   str      input string
**   space    address space
**   addr     pointer to U32 to receive sast bit address.
**   retval   TRUE if addr space was found
**
*****************************************************************************/
BOOLEAN EXPORT TestIsSastBitName(LPSTR str, ADDR_SPACE space, U32 *addr);

/****************************************************************************
**
** TestSwapBytesInWord
** TestSwapBytesInLong
**
** description:
**   If incoming space is big-endian, swap the bytes,
**   otherwise return unchanged.
**
** parameters:
**   input    input value
**   space    address space
**
*****************************************************************************/
U16 EXPORT TestSwapBytesInWord(U16 input, ADDR_SPACE space);
U32 EXPORT TestSwapBytesInLong(U32 input, ADDR_SPACE space);

/******************************** E O F ***********************************/
