/*****************************************************************************
**
**    Name:    spa.h
** 
**    Description: 
**       Routines to set up and manage spa specifications.
**
**    Status: PRELIMINARY
**
**    $Log:   S:/tbird/mt2_186/inc/spa.h_v  $
** 
**    Rev 1.1   27 Jan 1997 14:34:52   Judy
** 
**    Rev 1.0   16 Dec 1996 13:55:16   Judy
** Initial revision.
** 
**    Rev 1.1   06 Sep 1996 17:32:14   Judy
** 
**    Rev 1.0   27 Aug 1996 15:21:34   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:43:08   Judy
   Initial revision.
**  
**    $Header:   S:/tbird/mt2_186/inc/spa.h_v   1.1   27 Jan 1997 14:34:52   Judy  $
**
*****************************************************************************/

#define _SPA_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SPA_RANGE_NUM  64
#define SPA_BANK_NUM   12
#define DEF_ITEM       0xff
#define SPA_RANGE_NAME_NUM 41

typedef struct {
   LPSTR namePtr;      // User set name
   LPSTR startPtr;     // User set start address
   LPSTR endPtr;       // User set end address
   U32 startAddr;       // User set start address
   U32 endAddr;         // User set stop address
   U8  bank;            // Using bank number. bit 0: bank 0, bit 1: bank 1...
   unsigned char item;  // 0xff: non used, 0,1,2,3: using item
} SPA_RANGE;

typedef struct {
   LPSTR namePtr;      // User set name
   LPSTR startPtr;     // User set start address
   LPSTR endPtr;       // User set end address
   char  item;         // 0xff: non used, bit 0,1: MA, bit 4,5: TA, bit 6,7: CC
   S8  buffer[SPA_RANGE_NAME_NUM*3]; // context of namePtr, startPtr, endPtr.
} SPA_RANGE_TEMP;

typedef struct {
   U32 startAddr;       // Using start address, 64k boundary
   U8  cnt;             // the bank had been used counts.
} SPA_BANK;

typedef struct {
   U16 count;
   U32 Stamp;
} SPA_MA_INFO;

typedef enum {
   SPA_MA,
   SPA_TA,
   SPA_CC
} SPA_RUM_MODE;

typedef enum {
   SPA_ID0,
   SPA_ID1,
   SPA_ID2,
   SPA_ID3
} SPA_RANGE_ID;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) ;
/**************************************************************************
**
** InitCServer
**
***************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle);
/*****************************************************************************
** 
**    SpaRangesAdd
** i/p: char *Name = name of the range
**      char *startAddr = segment:offset, start address of the range,
**      char *endAddr = segment:offset,  end address of the range
** 
** Note: To append new range record to spaRangeList
*****************************************************************************/
RETCODE EXPORT SpaRangesAdd(U8 type, LPSTR Name, LPSTR startAddr, LPSTR endAddr);
/*****************************************************************************
** 
**    SpaRangesEdit
** i/p: LPSTR Name = name of the range
**      LPSTR startAddr = segment:offset, start address of the range,
**      LPSTR endAddr = segment:offset,  end address of the range
** 
** Note: Setting range to spaRangeList according to the name.
*****************************************************************************/
RETCODE EXPORT SpaRangesEdit(U8 type, LPSTR Name, LPSTR startPtr, LPSTR endPtr);
/*****************************************************************************
** 
**    SpaRangesGet
** i/p: LPSTR Name = name of the range
**      LPSTR startAddr = segment:offset, start address of the range,
**      LPSTR endAddr = segment:offset,  end address of the range
** Note: To get range data according to the name.
*****************************************************************************/
RETCODE EXPORT SpaRangesGet(U8 type, LPSTR Name, LPSTR startPtr, LPSTR endPtr);
/*****************************************************************************
** 
**    SpaRangesDelete
** i/p: char *Name = name of the range
** 
** Note: To delete range record according to the name
*****************************************************************************/
RETCODE EXPORT SpaRangesDelete(U8 type, LPSTR Name);
/*****************************************************************************
** 
**    SpaRangesCountGet
** o/p: U8 far *count = number of used range
** 
** Note: To get how many ranges being used.
*****************************************************************************/
RETCODE EXPORT SpaRangesCountGet(U8 type, U8 FAR *count);
/*****************************************************************************
** 
**    SpaRangesGetByIndex
** i/p: U8 index = no. of the range
**      LPSTR Name
**      LPSTR startAddr
**      LPSTR endAddr
** 
** Note: To get range data according to being used index.
*****************************************************************************/
RETCODE EXPORT SpaRangesGetByIndex(U8 index, U8 type, LPSTR Name,
               LPSTR startAddr, LPSTR endAddr, U8 FAR *item);
/*****************************************************************************
** 
**    SpaSaveDataGet
** o/p: U8 index = number of used range
**      SPA_RANGE_TEMP *data= data
** 
** Note: To get ranges data.
*****************************************************************************/
RETCODE EXPORT SpaSaveDataGet(U8 type, U8 index, SPA_RANGE_TEMP *data);
/*****************************************************************************
** 
**    SpaRangesActionSet
** i/p: LPSTR name
**      SPA_RUN_MODE type
**      SPA_RANGE_ID id
** 
** Note: To set spaRangeList[].item
*****************************************************************************/
RETCODE EXPORT SpaRangesActionSet(LPSTR name, U8 type, SPA_RANGE_ID id);
/*****************************************************************************
** 
**    SpaRangesActionGet
** i/p: LPSTR name
**      SPA_RUN_MODE type
**      SPA_RANGE_ID id
** 
** Note: To get spaRangeList[].name according to id
*****************************************************************************/
RETCODE EXPORT SpaRangesActionGet(U8 type, SPA_RANGE_ID id, LPSTR name);
/*****************************************************************************
** 
**    SpaRangesActionClear
** i/p: SPA_RUN_MODE type
**      LPSTR name
** 
** Note: To clear spaRangeList[].item according to type and name
*****************************************************************************/
RETCODE EXPORT SpaRangesActionClear(LPSTR name,U8 type);
/*****************************************************************************
** 
**    SpaMAGet
** i/o: U32 *stamp : total timestamp
**      SPA_MA_INFO *data[4]: count and time data
** 
** Note: To get MA information.
*****************************************************************************/
RETCODE EXPORT SpaMAGet(U32 *stamp, SPA_MA_INFO *data, BOOLEAN *flag);
/*****************************************************************************
** 
**    SpaTAGet
** i/o: U32 *stamp[3] : total, longest, shortest time
**      U16 *data[9]: count data
** 
** Note: To get TA information.
*****************************************************************************/
RETCODE EXPORT SpaTAGet(U32 *stamp, U16 *data, BOOLEAN *flag);
/*****************************************************************************
** 
**    SpaCCGet
** i/o:
**      LPSTR startAddr
**      LPSTR endAddr
**      LPSTR ptr
**      BOOLEAN flag
** 
** Note: To get code coverage information.
*****************************************************************************/
RETCODE EXPORT SpaCCGet(LPSTR startPtr, LPSTR endPtr,
               LPSTR ptr, BOOLEAN *flag);
/*****************************************************************************
** 
**    SpaStart
** i/o: SPA_RUN_MODE type
** 
** Note: RUN
*****************************************************************************/
RETCODE EXPORT SpaStart(U8 type);
/*****************************************************************************
** 
**    SpaStop
** i/o: SPA_RUN_MODE type
** 
** Note: RUN
*****************************************************************************/
RETCODE EXPORT SpaStop(U8 type);
/*****************************************************************************
** 
**    SpaOpen
** 
** Note: To create spaRangeList and spaBankList.
*****************************************************************************/
RETCODE EXPORT SpaOpen(U8 type, LPSTR fileName);
/*****************************************************************************
** 
**    SpaCreate
** 
*****************************************************************************/
RETCODE EXPORT SpaCreate(VOID);
/*****************************************************************************
** 
**    SpaClose
** 
** Note: The function must be executed when spa window exits. In order to
**       change EP machine status.
*****************************************************************************/
RETCODE EXPORT SpaClose(VOID);
/*****************************************************************************
** 
**    SpaStatus
** 
** Note: return spa status: TRUE : running
**                          FALSE : halt
*****************************************************************************/
RETCODE EXPORT SpaStatus(VOID);
/*****************************************************************************
** 
**    SpaSetBkpt
** 
*****************************************************************************/
RETCODE EXPORT SpaSetBkpt(U32 segStr,U32 offStr);
/*****************************************************************************
** 
**    SpaGetBkpt
** 
*****************************************************************************/
RETCODE EXPORT SpaGetBkpt(U32 *segStr, U32 *offStr);
/*****************************************************************************
** 
**    SpaQuit
** 
** Note: To quit spaRangeList and spaBankList.
*****************************************************************************/
RETCODE EXPORT SpaQuit(VOID);
