/***************************************************************************
 *
 * Name : ABIFUNC.H
 *
 * Description : export function prototypes of ABI routines in
 *               REG86.C, MEM86.C, SUB86.C, and EXEC86.C
 *
 * Date : 12/07/1992
 *
 *    Copyright (C) 1992 Microtek International Inc.
 *    All Rights Reserved
 *
 ***************************************************************************/
#define _ABI_FUNC_

#ifndef _BASE_TYPE_
#include "basetype.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

RETCODE EXPORT iceGetID(U8 *ID_Info);
RETCODE EXPORT iceSetID(U16 idFlag);
RETCODE EXPORT iceGetWait(U16 *count);
RETCODE EXPORT iceSetWait(U16 count);
RETCODE EXPORT iceGetVerify(U16 *verifyFlag);
RETCODE EXPORT iceSetVerify(U16 verifyFlag);
RETCODE EXPORT iceGetSync(U16 *sync);
RETCODE EXPORT iceSetSync(U16 syncFlag);
RETCODE EXPORT iceGetMode(U16 *modeFlag);
RETCODE EXPORT iceGetControl(U16 *signals);
RETCODE EXPORT iceSetControl(U16 signals);
RETCODE EXPORT iceGetReady(U16 *readyFlag);
RETCODE EXPORT iceSetReady(U16 readyFlag);
RETCODE EXPORT iceGetStatus(VOID);
RETCODE EXPORT iceGetAccessSize(U16 *sizeFlag);
RETCODE EXPORT iceSetAccessSize(U16 sizeFlag);
RETCODE EXPORT iceSetTimerReg(U16 regNo);
RETCODE EXPORT iceInitialize(INITIAL_INFO *initialInfo);
RETCODE EXPORT iceDiagnostic(VOID);
S16 EXPORT iceSelfTest(U16 cmdId);
RETCODE EXPORT iceSetTraceBreak(U16 breakFull);
RETCODE EXPORT iceGetTraceBuffer(U16 *traceBufNum);
RETCODE EXPORT iceSetTraceBuffer(U16 traceBufNum);
RETCODE EXPORT iceGetTriggerFrame(U16 buffer, U32 *frame);
RETCODE EXPORT iceSetTimerCounter(U16 tcFlag, U32 tcData0,U32 tcData1);
RETCODE EXPORT iceGetTraceInfo(U16 *lastBuff, U32 *curCNT0, U32 *curCNT1, U16 *bufNO);
RETCODE EXPORT iceGetAllTrig(MP_TRIGGER *trig_record);
RETCODE EXPORT iceSetTrig(U16 levelNo, MP_TRIGGER *tmpTrig);
RETCODE EXPORT iceClearTrig(U16 levelNo);
RETCODE EXPORT iceSetBP(U16 evId, ADDR addr);
RETCODE EXPORT iceGetEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 *ext_record,
                 U8 *cntFlag, U32 *timeRecord, U16 *counter);
RETCODE EXPORT iceSetExtEvent(U16 evData);
RETCODE EXPORT iceSetAllEvents(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 ext_record);
RETCODE EXPORT iceSetEvent(U16 evId, BUS_EVENT *busEventData);
RETCODE EXPORT iceGetTraceBufferInfo(U16 bufID, S32 *start, S32 *end);
RETCODE EXPORT iceGetTraceFrame(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLen, MP_TRACE_INFO *frameData);
RETCODE EXPORT iceGo(U16 mode);
S16 EXPORT iceGetCpuStatus(U8 *goEnd);
RETCODE EXPORT iceReset(VOID);
RETCODE EXPORT iceAbort(VOID);
RETCODE EXPORT iceStepRange(ADDR addr1, ADDR addr2);
RETCODE EXPORT iceStepOne(VOID);
RETCODE EXPORT iceClearEvent(U16 evId);
RETCODE EXPORT iceGetReg(REG_MODE regMode, S16 regId,U32 *content);
RETCODE EXPORT iceGetAllReg(U16 *cpuReg);
RETCODE EXPORT iceGetAllIntReg(U16 *intReg);
RETCODE EXPORT iceSetReg(REG_MODE regMode, S16 regId, U32 content);
RETCODE EXPORT iceOutput(U16 port, U8 *data, U16 len, U16 size);
RETCODE EXPORT iceInput(U16 port, U16 len, U16 size, U8 *buff);
RETCODE EXPORT iceTest(ADDR addr, U32 len);
RETCODE EXPORT iceChecksum(ADDR addr, U32 len, U16 *n);
RETCODE EXPORT iceSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen);  /* search block for pattern */
RETCODE EXPORT iceCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findaddr1, RET_ADDR *findaddr2);
//RETCODE EXPORT iceCopy(ADDR addr1, U32 len, ADDR addr2); //Eric 2/11/98
RETCODE EXPORT iceCopy(ADDR addr1, U32 len, ADDR addr2, BOOLEAN srcTarget);
RETCODE EXPORT iceSetMem(ADDR addr, U8 ch);
RETCODE EXPORT iceSetMemN(ADDR addr, U8 *buff, U16 patternLen);
RETCODE EXPORT iceGetMem(ADDR addr, U8 *buff);
RETCODE EXPORT iceGetMemN(ADDR addr, U8 *buff, U16 len);
RETCODE EXPORT iceFill(ADDR addr, U32 len, U8 *buff, U16 patternLen);
RETCODE EXPORT iceSize(BUS_SIZE size);
RETCODE EXPORT iceGetMap(MAP_INFO *mapData);
RETCODE EXPORT iceGetMapSize(U8 *emmSize);
RETCODE EXPORT iceSetMap (U32 addr1, U32 addr2, U16 attr);
RETCODE EXPORT DiagnosticFunction(DIAG_ID diagID, U32 *memFailAddress,U8 *retID);
RETCODE EXPORT DownLoadFirmware(U8 *fileName,U16 buffSize,U8 timeOut);
RETCODE EXPORT CheckFwStatus(VOID);
void EXPORT AdvanceAddr(U32 *addr, int len);
RETCODE EXPORT iceGetQualifyFrame(U16 bufID, S32 startFrame, QUALIFY_LIST *cond,
            U8 *frameLen, MP_TRACE_INFO *frameData);
RETCODE EXPORT iceSetTraceOff(U16 trcOffFull);
RETCODE EXPORT iceSetTrigOutAction(U16 trigOutact);
RETCODE EXPORT iceTraceAction(U8 traceAction);
RETCODE EXPORT iceSPASetRange(U8 type,U8 id,U32 start,U32 end);
RETCODE EXPORT iceSPAClearRange(U8 type);
RETCODE EXPORT iceSPAGetMAInfo(U32 *stamp,MA_INFO_NODE *info,BOOLEAN *flagHalt);
RETCODE EXPORT iceSPAGetTAInfo(U32 *stamp,U16 *info,BOOLEAN *flagHalt);
RETCODE EXPORT iceSPAGetCCInfo(U32 start,U32 end,U8 FAR *buff,BOOLEAN *flagHalt);
RETCODE EXPORT iceReadFrameStamp(U16 bufId,S32 frameNo,U32 *stamp,U8 *stampMSB);
RETCODE EXPORT iceSPAClose(VOID);
RETCODE EXPORT iceReadLastStamp(U16 id,U32 *stamp,U8 *stampMSB);
RETCODE EXPORT iceSPASetBkpt(U8 enable,ADDR addr);
RETCODE EXPORT iceSPAOpen(VOID);
void EXPORT iceGetVerifyErrorInfo(BAD_MEMORY *badMemory);
RETCODE EXPORT iceWFROM(U8 *data);
RETCODE EXPORT iceRFROM(U8 *data);
/********************************** E O F ************************************/

