#define _REG86_DEFINE_

#define REG_NO     14
#define NUM_REGS   23   /* size of U16 cpu_regs[] array, for cpu register */
#define MAX_INTERNAL_REG_NO    128  /* size of U16 int_regs[] array, for internal registers */
#define NUM_COP1   7    /* size of U16 cop1_regs[] array, for internal registers */
#define NUM_COP2   8*10 /* size of U8 cop2_regs[] array, for internal registers */
#define REG_MAX    115     /* include cpu, internal and coprocess regs */

#define REG_PC          (-3)
#define REG_SP          (-2)
#define REG_FP          (-1)

#define AX   0
#define BX   1
#define CX   2
#define DX   3
#define RSP   4
#define BP   5
#define SI   6
#define DI   7
#define DS   8
#define SS   9
#define ES   10
#define CS   11
#define IP   12
#define FLAGS   13
#define MAX_CPU_REG186_NUM 16

#define OF   14
#define DF   15
#define IF   16
#define TF   17
#define SF   18
#define ZF   19
#define AF   20
#define PF   21
#define CF   22

#define AL   23
#define BL   24
#define CL   25
#define DL   26
#define AH   27
#define BH   28
#define RCH     29
#define DH   30
#define SIZE_CPUREG   1+DH

/* define internal registers */

enum  INTERNAL_REGISTER_XL_EA  {
//                    IDX    REAL ID
//------------------------------------
    IVR = 0,     // 0      0x20 // for slave mode only
    EOI   ,      // 1      0x22
    POLL  ,      // 2      0x24
    POLSTS,      // 3      0x26
    IMASK ,      // 4      0x28
    PRMSK,       // 5      0x2A
    INSERV,      // 6      0x2C
    REQST,       // 7      0x2E
    INTSTS,      // 8      0x30
    TCUCON,      // 9      0x32
    DMA0CON,     // 10     0x34
    DMA1CON,     // 11     0x36
    I0CON ,      // 12     0x38
    I1CON ,      // 13     0x3A
    I2CON ,      // 14     0x3C // not used in slave mode
    I3CON,       // 15     0x3E // not used in slave mode
    T0CNT ,      // 16     0x50
    T0CMPA,      // 17     0x52
    T0CMPB ,     // 18     0x54
    T0CON  ,     // 19     0x56
    T1CNT ,      // 20     0x58
    T1CMPA,      // 21     0x5A
    T1CMPB,      // 22     0x5C
    T1CON ,      // 23     0x5E
    T2CNT ,      // 24     0x60
    T2CMPA,      // 25     0x62
    X64  ,       // 26     0x64 // not used
    T2CON  ,     // 27     0x66
    UMCS  ,      // 28     0xA0
    LMCS  ,      // 29     0xA2
    PACS  ,      // 30     0xA4
    MMCS    ,    // 31     0xA6
    MPCS  ,      // 32     0xA8
    D0SRCL,      // 33     0xC0
    D0SRCH,      // 34     0xC2
    D0DSTL,      // 35     0xC4
    D0DSTH  ,    // 36     0xC6
    D0TC  ,      // 37     0xC8
    D0CON,       // 38     0xCA
    D1SRCL,      // 39     0xD0
    D1SRCH,      // 40     0xD2
    D1DSTL,      // 41     0xD4
    D1DSTH  ,    // 42     0xD6
    D1TC  ,      // 43     0xD8
    D1CON,       // 44     0xDA
    RFBASE,      // 45     0xE0
    RFTIME,      // 46     0xE2
    RFCON ,      // 47     0xE4
    PWRSAV,      // 48     0xF0
    PWRCON,      // 49     0xF2 // for EA only
    XF4  ,       // 50     0xF4 // not used
    STEPID  ,    // 51     0xF6 // for EA only
    XF8  ,       // 52     0xF8 // not used
    XFA  ,       // 53     0xFA // not used
    XFC  ,       // 54     0xFC // not used
    RELREG,      // 55     0xFE
    SIZE_XLEA_INTREG //56
};

enum INTERNAL_REGISTER_186EB {
//                 IDX    REAL ID
//------------------------------------
    EB_0X00=0,   // 0      0x00  // not used
    EB_EOI   ,   // 1      0x02
    EB_POLL  ,   // 2      0x04
    EB_POLSTS,   // 3      0x06
    EB_IMASK ,   // 4      0x08
    EB_PRMSK ,   // 5      0x0A
    EB_INSERV,   // 6      0x0C
    EB_REQST ,   // 7      0x0E
    EB_INTSTS,   // 8      0x10
    EB_TCUCON,   // 9      0x12
    EB_SCUCON,   // 10     0x14
    EB_I4CON ,   // 11     0x16
    EB_I0CON ,   // 12     0x18
    EB_I1CON ,   // 13     0x1A
    EB_I2CON ,   // 14     0x1C
    EB_I3CON ,   // 15     0x1E
    EB_T0CNT ,   // 16     0x30
    EB_T0CMPA,   // 17     0x32
    EB_T0CMPB,   // 18     0x34
    EB_T0CON ,   // 19     0x36
    EB_T1CNT ,   // 20     0x38
    EB_T1CMPA,   // 21     0x3A
    EB_T1CMPB,   // 22     0x3C
    EB_T1CON ,   // 23     0x3E
    EB_T2CNT ,   // 24     0x40
    EB_T2CMPA,   // 25     0x42
    EB_0X44  ,   // 26     0x44  // not used
    EB_T2CON ,   // 27     0x46
    EB_P1DIR ,   // 28     0x50
    EB_P1PIN ,   // 29     0x52
    EB_P1CON ,   // 30     0x54
    EB_P1LTCH,   // 31     0x56
    EB_P2DIR ,   // 32     0x58
    EB_P2PIN ,   // 33     0x5A
    EB_P2CON ,   // 34     0x5C
    EB_P2LTCH,   // 35     0x5E
    EB_B0CMP ,   // 36     0x60
    EB_B0CNT ,   // 37     0x62
    EB_S0CON ,   // 38     0x64
    EB_S0STS ,   // 39     0x66
    EB_S0RBUF,   // 40     0x68
    EB_S0TBUF,   // 41     0x6A
    EB_B1CMP ,   // 42     0x70
    EB_B1CNT ,   // 43     0x72
    EB_S1CON ,   // 44     0x74
    EB_S1STS ,   // 45     0x76
    EB_S1RBUF,   // 46     0x78
    EB_S1TBUF,   // 47     0x7A
    EB_GCS0ST,   // 48     0x80
    EB_GCS0SP,   // 49     0x82
    EB_GCS1ST,   // 50     0x84
    EB_GCS1SP,   // 51     0x86
    EB_GCS2ST,   // 52     0x88
    EB_GCS2SP,   // 53     0x8A
    EB_GCS3ST,   // 54     0x8C
    EB_GCS3SP,   // 55     0x8E
    EB_GCS4ST,   // 56     0x90
    EB_GCS4SP,   // 57     0x92
    EB_GCS5ST,   // 58     0x94
    EB_GCS5SP,   // 59     0x96
    EB_GCS6ST,   // 60     0x98
    EB_GCS6SP,   // 61     0x9A
    EB_GCS7ST,   // 62     0x9C
    EB_GCS7SP,   // 63     0x9E
    EB_LCSST ,   // 64     0xA0
    EB_LCSSP ,   // 65     0xA2
    EB_UCSST ,   // 66     0xA4
    EB_UCSSP ,   // 67     0xA6
    EB_RELREG,   // 68     0xA8
    EB_RFBASE,   // 69     0xB0
    EB_RFTIME,   // 70     0xB2
    EB_RFCON ,   // 71     0xB4
    EB_RFADDR,   // 72     0xB6
    EB_PWRCON,   // 73     0xB8
    EB_0XBA  ,   // 74     0xBA  // not used
    EB_STEPID,   // 75     0xBC
    SIZE_186EB_INTREG // 76
} ;

enum INTERNAL_REGISTER_186EC {
//                 IDX    REAL ID
//------------------------------------
    EC_MPICP0=0, // 0      0x00
    EC_MPICP1  , // 1      0x02
    EC_SPICP0,   // 2      0x04
    EC_SPICP1,   // 3      0x06
    EC_0X04  ,   // 4      0x08  // not used
    EC_SCUIRL,   // 5      0x0A
    EC_DMAIRL,   // 6      0x0C
    EC_TIMIRL,   // 7      0x0E
    EC_WDTRLDH,  // 8      0x20
    EC_WDTRLDL,  // 9      0x22
    EC_WDTCNTH,  // 10     0x24
    EC_WDTCNTL,  // 11     0x26
    EC_T0CNT ,   // 12     0x30
    EC_T0CMPA,   // 13     0x32
    EC_T0CMPB,   // 14     0x34
    EC_T0CON ,   // 15     0x36
    EC_T1CNT ,   // 16     0x38
    EC_T1CMPA,   // 17     0x3A
    EC_T1CMPB,   // 18     0x3C
    EC_T1CON ,   // 19     0x3E
    EC_T2CNT ,   // 20     0x40
    EC_T2CMPA,   // 21     0x42
    EC_0X44  ,   // 22     0x44  // not used
    EC_T2CON ,   // 23     0x46
    EC_P1DIR ,   // 24     0x50
    EC_P1PIN ,   // 25     0x52
    EC_P1CON ,   // 26     0x54
    EC_P1LTCH,   // 27     0x56
    EC_P2DIR ,   // 28     0x58
    EC_P2PIN ,   // 29     0x5A
    EC_P2CON ,   // 30     0x5C
    EC_P2LTCH,   // 31     0x5E
    EC_B0CMP ,   // 32     0x60
    EC_B0CNT ,   // 33     0x62
    EC_S0CON ,   // 34     0x64
    EC_S0STS ,   // 35     0x66
    EC_S0RBUF,   // 36     0x68
    EC_S0TBUF,   // 37     0x6A
    EC_B1CMP ,   // 38     0x70
    EC_B1CNT ,   // 39     0x72
    EC_S1CON ,   // 40     0x74
    EC_S1STS ,   // 41     0x76
    EC_S1RBUF,   // 42     0x78
    EC_S1TBUF,   // 43     0x7A
    EC_GCS0ST,   // 44     0x80
    EC_GCS0SP,   // 45     0x82
    EC_GCS1ST,   // 46     0x84
    EC_GCS1SP,   // 47     0x86
    EC_GCS2ST,   // 48     0x88
    EC_GCS2SP,   // 49     0x8A
    EC_GCS3ST,   // 50     0x8C
    EC_GCS3SP,   // 51     0x8E
    EC_GCS4ST,   // 52     0x90
    EC_GCS4SP,   // 53     0x92
    EC_GCS5ST,   // 54     0x94
    EC_GCS5SP,   // 55     0x96
    EC_GCS6ST,   // 56     0x98
    EC_GCS6SP,   // 57     0x9A
    EC_GCS7ST,   // 58     0x9C
    EC_GCS7SP,   // 59     0x9E
    EC_LCSST ,   // 60     0xA0
    EC_LCSSP ,   // 61     0xA2
    EC_UCSST ,   // 62     0xA4
    EC_UCSSP ,   // 63     0xA6
    EC_RELREG,   // 64     0xA8
    EC_RFBASE,   // 65     0xB0
    EC_RFTIME,   // 66     0xB2
    EC_RFCON ,   // 67     0xB4
    EC_RFADDR,   // 68     0xB6
    EC_PWRCON,   // 69     0xB8
    EC_PWRSAV,   // 70     0xBA
    EC_STEPID,   // 71     0xBC
    EC_D0SRCL,   // 72     0xC0
    EC_D0SRCH,   // 73     0xC2
    EC_D0DSTL,   // 74     0xC4
    EC_D0DSTH,   // 75     0xC6
    EC_D0TC,     // 76     0xC8
    EC_D0CON,    // 77     0xCA
    EC_DMAPRI,   // 78     0xCC
    EC_DMAHALT,  // 79     0xCE
    EC_D1SRCL,   // 80     0xD0
    EC_D1SRCH,   // 81     0xD2
    EC_D1DSTL,   // 82     0xD4
    EC_D1DSTH,   // 83     0xD6
    EC_D1TC,     // 84     0xD8
    EC_D1CON,    // 85     0xDA
    EC_D2SRCL,   // 86     0xE0
    EC_D2SRCH,   // 87     0xE2
    EC_D2DSTL,   // 88     0xE4
    EC_D2DSTH,   // 89     0xE6
    EC_D2TC,     // 90     0xE8
    EC_D2CON,    // 91     0xEA
    EC_D3SRCL,   // 92     0xF0
    EC_D3SRCH,   // 93     0xF2
    EC_D3DSTL,   // 94     0xF4
    EC_D3DSTH,   // 95     0xF6
    EC_D3TC,     // 96     0xF8
    EC_D3CON,    // 97     0xFA
    SIZE_186EC_INTREG // 98
} ;
/* define coprocessor registers */
enum COPROCESSOR_REGISTER {
 CNTRLW =  0,            // 0
 STATUSW,                // 1
 TAGW,                   // 2
 IPOFF,                  // 3
 CSSEL,                  // 4
 DATAOFF,                // 5
 DATASEL,                // 6
 ST0,                    // 7
 ST1,                    // 8
 ST2,                    // 9
 ST3,                    // 10
 ST4,                    // 11
 ST5,                    // 12
 ST6,                    // 13
 ST7,                    // 14
 SIZE_COPREG             // 15
};
#define COPBASE1 CNTRLW
#define COPBASE2 ST0

/*******************************************************/
/*            Define Target CPU type              */
/**************************************************/
#define M8086   0
#define M8088   1
#define M80186  2
#define M80188  3
#define M186EA  4
#define M188EA  5
#define M186EB  6
#define M188EB  7
#define M80286  8
#define M186EM  9
#define M188EM  10

typedef enum {
   I86_REG,       /*  */
   I87_REG,       /*  */
   INTERNAL_REG,
   INT_REG_MASTER,
   INT_REG_SLAVE,
   INT_REG_186EB,
   INT_REG_186EC
} REG_MODE ;

