/****************************************************************************
**
**  Name: addrini.h
**
**  Description:
**     This module contains utility routines to access and manipulate
**		 the PWRVIEWS.INI 
**
**  $Log:   S:/tbird/mt2_186/addr/addrini.h_v  $
** 
**    Rev 1.0   16 Dec 1996 16:15:52   Judy
** Initial revision.
** 
**    Rev 1.2   10 Aug 1994 10:46:26   marilyn
** Added function prototype.
** 
**    Rev 1.1   16 Jun 1994 14:56:34   nghia
** Merged to trunk. Used Ini services from CLIULIB.DLL
** 
**    Rev 1.0   31 May 1994 16:58:34   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/addr/addrini.h_v   1.0   16 Dec 1996 16:15:52   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __ADDRINI__
#define __ADDRINI__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _INIUTIL_
#include "iniutil.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
**
**  GetCpu16IndexRegUsed 
**
**  Description:
**     Get the INI setting of CPU16 index register usage.  Return GOOD if
**  the operation is successful.   
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
******************************************************************************/
RETCODE GetCpu16IndexRegUsed(VOID);


/******************************************************************************
**
**  AdrGetAddrDescToText 
**
**  Description:
**     Get all the address descriptor fields to an ascii buffer. 
**
**  Parameters:
**     input:
**        desc : input address descriptor
**        buf : caller provided text buffer
**     output:
**        buf : modified ascii text buffer
**
******************************************************************************/
RETCODE AdrGetAddrDescToText(DESCRIPTOR desc, LPSTR buf);


#ifdef __cplusplus
}
#endif

#endif /* __ADDRINI__ */
/******************************** E O F ***********************************/
