/***************************************************************************
**
**  Name:  dtinfo16.cpp
**
**  Description:
**     This is a dequeuer class file
**
**  Status:  
**
**  $Log:   S:/tbird/mt2_186/dad186/dtinfo16.cpv  $
** 
**    Rev 1.0   16 Dec 1996 15:13:50   Judy
** Initial revision.
** 
**    Rev 1.1   22 Jul 1993 10:18:40   ernie
** (For Mindy):  Added support for dequeuer backup and timestamp.
** 
**    Rev 1.0   08 Apr 1993 09:42:48   doug
** Initial revision.
** 
**    Rev 1.0   12 Mar 1993 09:51:28   mindy
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/dad186/dtinfo16.cpv   1.0   16 Dec 1996 15:13:50   Judy  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdio.h"
#include "string.h"

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _DTINFO16_
#include "dtinfo16.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _TBIRDMEM_
#include "tbirdmem.h"
#endif

#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif


                       /****************************
                        *                          *
                        *     EXTERNALS            *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
 

                        /***************************
                        *                          *
                        *    PROTOTYPES            *
                        *                          *
                        ***************************/

                         /***************************
                         *                          *
                         *     EXECUTABLE CODE      *
                         *                          *
                         ***************************/
/***************************  PUBLIC METHODS  *******************************/
RETCODE DtInfo::Disassemble(LPSTR buffer, U8 *bytes) {
   RETCODE err;
   char tmpBuff[256];
   U8 tmp;
   sprintf(tmpBuff,"%8ld ", frameNum);
   strcat(buffer,tmpBuff);

   if((err=TrcGetTimestampText(traceId, frameNum, prevFrameNum, buffer))
      != GOOD ) return(err);

   strcat(buffer," ");    // more space between timestamp and address
      
   // bytes in wrong order!!! Who's to blame???
   for(LOOP_VAR i=0; i < 6; i+=2 ) {
      tmp = bytes[i];
      bytes[i] = bytes[i+1];
      bytes[i+1] = tmp;
   }
   if((err=DasmInfo::Disassemble(buffer,bytes))!=GOOD) {
      strcat(buffer,"ERROR in FRAME\r\n");
      return(err);
   }
   return(GOOD);
}

RETCODE DtInfo::SetFrameNumber(S32 frame) {
   frameNum = frame;
   return GOOD;
}

S32 DtInfo::GetFrameNumber() {
   return frameNum;
};

RETCODE DtInfo::SetPrevFrameNumber(S32 frame) {
   prevFrameNum = frame;
   return GOOD;
}

S32 DtInfo::GetPrevFrameNumber() {
   return prevFrameNum;
};

RETCODE DtInfo::SetTraceId(DESCRIPTOR id) {
   traceId = id;
   return GOOD;
}

DESCRIPTOR DtInfo::GetTraceId() {
   return traceId;
}

/**************************  PROTECTED METHODS  ******************************/

/***************************  PRIVATE  METHODS  *****************************/
