/***************************************************************************
**
**  File name : ASMDEF86.H
**
**  Description : include file of assembler
**
**  Status: REVIEWED
**
**  $Log:   S:/tbird/mt2_186/dadamd/asmdef86.h_v  $
** 
**    Rev 1.0   26 Jun 1997 15:25:54   cjchen
** Initial revision.
** 
**    Rev 1.1   03 Apr 1997 15:06:36   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:38   Judy
** Initial revision.
** 
**    Rev 1.3   18 Oct 1994 10:44:34   steve
** extended the size of Extra in OPERANDSTRUCT to 32-bits.
** 
**    Rev 1.2   11 Oct 1994 11:03:12   steve
** 
**    Rev 1.1   11 Oct 1994 11:01:16   steve
**
**  $Header:   S:/tbird/mt2_186/dadamd/asmdef86.h_v   1.0   26 Jun 1997 15:25:54   cjchen  $
**
**  Copyright (C) 1994 Microtek International Inc.   All Rights Reserved
**
****************************************************************************/
#define _ASMDEF86_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAXOPERAND 3
#define MAXOPCODE  3

#define COUNT(x) (sizeof(x)/sizeof(x[0]))

enum OPERAND_TYPE {
    NONE,
    SEG,
    AL,AX,CL,DX, REG8,REG16,REG32,
    MEMDIRECT,MEMDIRECTBYTE,MEMDIRECTWORD,MEMDIRECTDWORD,
        MEM,MEMBYTE,MEMWORD,MEMDWORD,MEMQWORD,MEMTBYTE,MEMNEAR,MEMFAR,
    DATAONE,DATA8, DATA,
    SEGOFFSET,
    ST,STI,
    CR, DR, TR // Special registers
};

typedef RETCODE (*TYPEROUTINE)();

typedef struct {
    U8 Format[3];
    TYPEROUTINE Type;
} FORMATSTRUCT;

typedef struct {
    TYPEROUTINE Type;
    U8 Codes[MAXOPCODE];
} CODESTRUCT;

typedef struct {
    CHAR *Mnemonic;
    CODESTRUCT *CodeTable;
    U16 TotalCode;
    FORMATSTRUCT *FormatTable;
    U16 TotalFormat;
} ASMSTRUCT;

typedef struct {
    CHAR OperandType;
    CHAR MemberID;
    S32  Number;
    S32  Extra;
} OPERANDSTRUCT;

/******************************** E O F ***********************************/
