/****************************************************************************
**
**  Name:  mkerrs.h
**
**  Description:
**     Contains declarations for MKERRORS.EXE
**
**  $Log:   S:/tbird/mt2_186/errtext/mkerrs.h_v  $
** 
**    Rev 1.1   26 Feb 1997 11:36:08   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 14:29:40   Judy
** Initial revision.
** 
**    Rev 1.0   21 Jul 1994 16:10:22   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/errtext/mkerrs.h_v   1.1   26 Feb 1997 11:36:08   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _MKERRS_
#define _MKERRS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/*
 * LOCKED means that you can't change the error code, even if changeCodes
 * is true.
 */
#define LOCKED       1
#define UNLOCKED     2

#define ER_RC_BASE   500
#define ER_HELP_BASE 3000
#define BAD          (GOOD + 666)
#define MAX_ERRORS   2048

typedef struct {
   CHAR *name;
   U32  code;
   CHAR *text;
   CHAR *helpentry;
   U8   flags; /* only LOCKED/UNLOCKED so far */
} ErrorDef;

typedef ErrorDef * ErrorDefPtr;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE Regen_mkerrs_h(VOID);
RETCODE CopyHeader(FILE *fp, char *HeaderFile);
RETCODE Regen_errcodec_h(VOID);
RETCODE Regen_errcodea_h(VOID);
RETCODE Regen_errerr_h(VOID);
RETCODE Regen_errtext_rc(VOID);

U32 SizeErrArray(VOID);
U32 SizeErrArray1(VOID);

#endif /* _MKERRS_ */
/******************************** E O F *************************************/
