/* Dq interface */!!

inherit(TRviewInfo, #DQviewInfo, #(descArray
initDone), 2, nil)!!

now(class(DQviewInfo))!!

now(DQviewInfo)!!

/* PUBLIC -- return textStr based on view line # */
Def viewLineAddr(self, lineNum | tmp entry)
{ 
  if (lineNum >= viewStartLine(self)) cand (lineNum <= viewEndLine(self))
  then
    entry := lineNum - viewStartLine(self);
    tmp := descArray[#descs][ entry ];
    ^tmp;
  else
    ^nil
  endif ;
}
!!

Def remove(self | index)
{ index := 0;
  loop
  while (index < 150)
  begin
    if (descArray[#descs][index] <> 0) then
      destroyAddress(AddressLibClass$Inst,descArray[#descs][index]);
    endif;
    index := index + 1;
  endLoop;
  descArray := nil;
}!!

/* PRIVATE -- return  */
Def initFrameGroup(self, trace, dq, startFrame, numFrames, nextOrPrevious
    | bufStr realStartRef realEndRef textAddrRef textLenRef textColl retCode
      adrDescRef tmp)
{
  retCode := prim_trcTracingGet(TraceLibClass$Inst);
  /* if error or tracing just leave */
  if( (retCode[0] <> 0) cor (retCode[1] = 1) ) ^0; endif;

  showWaitCurs(); 

 def(UserType, #AddrDescArray, #(
    long descs 150));

  /* set startFrame position in trace */
  retCode := prim_trcReadFrameSet( trace, startFrame);
  if (retCode <> 0) then ^retCode endif ;

  if( numFrames < 25 ) 
    numFrames := 25;    /* force min. amount requested to 25 instructions */
  endif;
  /* do the frame search */
  realStartRef  := new( Struct, 4 ) ;
  realEndRef    := new( Struct, 4 ) ;
  textAddrRef   := new( Struct, 4 ) ;
  adrDescRef   := new( Struct, 4 ) ;  
  textLenRef    := new( Struct, 2 ) ;
  if (nextOrPrevious = #Next)
  then
    retCode := dadForwardDqInst( dq, numFrames, realStartRef, realEndRef, 
                            textAddrRef, textLenRef, adrDescRef) ;
  else
    retCode := dadBackwardDqInst( dq, numFrames, realStartRef, realEndRef, 
                            textAddrRef, textLenRef, adrDescRef ) ;
  endif ;
  
  if (retCode <> 0) 
    displayError(ErrorTextLibClass$Inst,retCode,FORCE_POPUP);
    showOldCurs();
    ^retCode;
  endif;    
/* we didn't get any frames (i.e.: no text) */
  if( wordAt(textLenRef,0) = 0 )
    cFree( MallocLibClass$Inst, longAt(textAddrRef, 0) ) ;
    /* @@@ need to free up addr descs and array */
    showOldCurs();
    ^retCode 
  endif; 

  /* get the text into a textCollection */
  add( textColl := new( TextCollection, 1), "" ) ;
  bufStr := physicalString(
               copyFromLong( new(Struct, wordAt(textLenRef,0)),
                             longAt(textAddrRef, 0) ) 
                           ) ;
                       
  descArray := cStructFromStruct(TbirdStruct,#AddrDescArray,
                     copyFromLong(new(Struct,600),longAt(adrDescRef,0)));
  insertText( textColl, bufStr, 0, 0 ) ; 
  cFree( MallocLibClass$Inst, longAt(textAddrRef, 0) ) ;
  cFree( MallocLibClass$Inst, longAt(adrDescRef, 0) ) ;
  removeLast( textColl ) ; 
  showOldCurs();
  ^initialize( self, 
               longAt(realStartRef, 0), longAt(realEndRef, 0), textColl )
}
!!
