/* Library for Trigger Server dll; creates trigger instances */!!

inherit(ProvidedLibs, #TriggerLib, #(initialized /* prevent duplicate initialization */), 2, nil)!!

setClassVars(TriggerLib, #())!!

now(class(TriggerLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize(new(self:ancestor), path);
}
!!

now(TriggerLib)!!

/* 11/14/1996 13:41 */

Def freeTrigger(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#TRIGTRIGGERFREE]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;

}!!

/* 7/29/1996 13:46 */

Def openTriggerWindow(self, rect, style |hWndPtr)
{ 
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      if (rect <> nil)
         lastError := pcall( procs[#TRIGOPENWINDOW], 0, left(rect),
              top(rect), width(rect), height(rect), style, 0, hWndPtr);
      else
         lastError := pcall( procs[#TRIGOPENWINDOW], 0, 0,
              0, 0, 0, style, 0, hWndPtr);
      endif;
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
    endif;
    /* 04/18/94 - Nghia - only return nil no handle or critical error */
    if ((lastError = ER_PP_WIN_CREATE_FAIL) cor
        (longAt(hWndPtr, 0) = 0)) then
      ^nil;
    endif;
    ^longAt(hWndPtr, 0);

}!!

/* 7/29/1996 13:46 */

Def existsTriggerWindow(self | hWndPtr)
{
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      lastError := pcall( procs[#TRIGEXISTSWINDOW], hWndPtr);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    if (longAt(hWndPtr, 0) <> 0)
       ^longAt(hWndPtr, 0);
    endif;
    ^nil;
}!!

/* 7/29/1996 13:45 */

Def closeTriggerWindow(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#TRIGCLOSEWINDOW]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    TheTriggerPresenter := nil;
    ^TheTriggerPresenter;

}!!

/* PRIVATE */
Def addImportProcs(self)
{
  add( self, #INITCSERVER, 1, #(0, 0) ) ;
  add( self, #TRIGACTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGACTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGACTIONCLEAR, 1, #(1, 0) ) ;
  add( self, #TRIGCOUNTERFUNCTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGCOUNTERFUNCTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGCOUNTERVALUESET, 1, #(1, 0, 1) ) ;
  add( self, #TRIGCOUNTERVALUEGET, 1, #(1, 0, 1) ) ;
  add( self, #TRIGEVENTCLEAR, 1, #(1) ) ;
  add( self, #TRIGEVENTENABLESET, 1, #(1, 0) ) ;
  add( self, #TRIGEVENTENABLEGET, 1, #(1, 1) ) ;
  add( self, #TRIGEXTSET, 1, #(1, 0) ) ;
  add( self, #TRIGEXTGET, 1, #(1, 1) ) ;
/*  add( self, #TRIGEXTEVENTSET, 1, #(1, 0, 0) ) ; */
  add( self, #TRIGEXTEVENTGET, 1, #(1, 1, 1) ) ;
  add( self, #TRIGEVENTNAMESET, 1, #(1, 1) ) ;
  add( self, #TRIGEVENTNAMEGET, 1, #(1, 1, 0) ) ;
  add( self, #TRIGEVENTSET, 1, #(1, 0) ) ;
  add( self, #TRIGEVENTSERVERGET, 1, #(1, 1) ) ;
  add( self, #TRIGFILLACTIONSET, 1, #(1, 0) ) ;
  add( self, #TRIGFILLACTIONGET, 1, #(1, 1) ) ;
  add( self, #TRIGSEQLEVELSET, 1, #(1, 0) ) ;
  add( self, #TRIGTRACECONFIGUREGET, 1, #(1, 1) ) ;
  add( self, #TRIGTRACECONFIGURESET, 1, #(1, 0) ) ;
  add( self, #TRIGTRACEMODEGET, 1, #(1, 1) ) ;
  add( self, #TRIGTRACEMODESET, 1, #(1, 0) ) ;
  add( self, #TRIGTRIGGERCLEAR, 1, #(1) ) ;
  add( self, #TRIGTRIGGERCLOSE, 1, #(1) ) ;
  add( self, #TRIGTRIGGEROPEN, 1, #(1, 1, 1) ) ;
  add( self, #TRIGTRIGGERSAVEAS, 1, #(1, 1) ) ;
  add( self, #TRIGQUALIFIERSET, 1, #(1, 0) ) ;
  add( self, #TRIGQUALIFIERGET, 1, #(1, 1) ) ;
  add( self, #TRIGEXTSETTINGDLG, 1, #(1));
  add( self, #TRIGOPENWINDOW,  1, #(0, 0, 0, 0, 0, 1, 1, 1));
  add( self, #TRIGCLOSEWINDOW, 1, nil);
  add( self, #TRIGEXISTSWINDOW,1, #(1));
  add( self, #TRIGTRIGGERFREE, 1, nil);
}
!!

/* PRIVATE 
   Open and initialize trigger server library & load trigger dll
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* PUBLIC -- create a trigger instance */
Def triggerOpen(self, fileName, template | aTrigger, rc, descriptorPtr) 
{ 
  aTrigger := new( Trigger ) ;
  descriptorPtr := new( Struct, 4 ) ;
  
  rc := pcall(procs[#TRIGTRIGGEROPEN], descriptorPtr, asciiz(fileName),
              asciiz(template)) ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0) ^nil ; endif ;
  setDescriptor( aTrigger, longAt(descriptorPtr, 0) );
  setFileName(  aTrigger, fileName ) ;
  setProcs( aTrigger, procs(self) ) ;
  
  ^aTrigger
}!!

/* TriggerLib Class Initialization Code */
