/****************************************************************************
**
**  Name: custdlg.h
**
**  Description:
**     Declaration of the classes that customized the COMMDLG.DLL's
**     FILEOPEN dialog box.
**     NOTES: The CommFileDlg base class is an export class from CLIULIB.
**
**  $Log:   S:/tbird/mt2_186/loader/custdlg.h_v  $
** 
**    Rev 1.1   26 Feb 1997 11:49:24   Judy
** 
**    Rev 1.0   14 Jun 1996 17:25:48   Judy
** Initial revision.
** 
**    Rev 1.3   12 Oct 1994 09:18:42   nghia
** Removed processorFamily data member from LoadFileDlg class.
** 
**    Rev 1.2   11 Oct 1994 11:37:14   nghia
** Added processorFamily to LoadFileDlg class to transfer information from
** the LOADER.DLL to callback function.
** 
**    Rev 1.1   11 Oct 1994 10:23:42   nghia
** No changes.
** 
**    Rev 1.0   14 Jul 1994 10:45:40   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/loader/custdlg.h_v   1.1   26 Feb 1997 11:49:24   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __CUSTDLG__
#define __CUSTDLG__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _DLGOBJ_
#include "..\cliulib\dlgobj.h"   // base class for COMMDLG File dialog
#endif

#ifndef _WDLGRSC_
#include "..\cliulib\wdlgrsc.h"
#endif

#ifndef __LDRDLGS__
#include "ldrdlgs.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
//-----------------------------------------------------------------------------
//
// Class: LoadFileDlg
//
// Description:
//    Declaration of the LoadFileDlg class.  This class provide object
//    that handles selecting a LoadFile to load.
//    NOTES: CommFileDlg is a based export class.
//
//-----------------------------------------------------------------------------
class LoadFileDlg : public CommFileDlg {
public:

                    //--------------------------//
                    // CONSTRUCTOR & DESTRUCTOR //
                    //--------------------------//
   LoadFileDlg(HWND parent, U16 filterId, LPSTR initDir, U32 loadFlags,
               ADDR_SPACE loadSpace);
   
                    //--------------------------//
                    //   INITIALIZED METHODS    //
                    //--------------------------//
   
                    //--------------------------//
                    //    ACCESSING METHODS     //
                    //--------------------------//

                    //--------------------------//
                    //    OPERATOR METHODS      //
                    //--------------------------//

                    //--------------------------//
                    //    OPERATION METHODS     //
                    //--------------------------//
   // Set the LoadFile info
   VOID SetLoadFileInfo(U32 loadFlags, ADDR_SPACE loadSpace);
   
   // Return the LoadFile Info - fileName and Flags setting.
   RETCODE GetLoadFileInfo(LPSTR lpFileName, U32 *loadFlags,
                           ADDR_SPACE *addrSpace);
   
                    //--------------------------//
                    //       CLASS METHODS      //
                    //--------------------------//
   // return the LoadFileDlg object - convert base pointer 
   static LoadFileDlg *GetObject(HWND hDlg);

protected:

private:
                    //--------------------------//
                    //       LOCAL METHODS      //
                    //--------------------------//
public:
                    //--------------------------//
                    //       DATA MEMBERS       //
                    //--------------------------//
   // data members
   // These member are here to transfer data from LOADER.DLL to COMMDLG.DLL
   U32              loadOptions;
   ADDR_SPACE       loadAddrSpace;
   
//---------------------------------------------------------------------------
// FRIEND 
friend UINT CALLBACK LdrLoadFileDlgHookProc(HWND, UINT, WPARAM, LPARAM);
friend RETCODE LdrOpenLoadFileDlg(HWND, LPSTR, LPSTR, U32 *, ADDR_SPACE *);

};
//// End of <LoadFileDlg>

#endif /* __CUSTDLG__ */
/******************************** E O F *************************************/
