/****************************************************************************
**
**  Name:  memcli.h
**
**  Description:
**     Memory CLI commands
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/mem/memcli.h_v  $
** 
**    Rev 1.2   27 Jan 1997 14:20:10   Judy
** 
**    Rev 1.1   20 Jan 1997 13:18:34   Judy
** To modify diagnotice function
** 
**    Rev 1.0   16 Dec 1996 13:50:12   Judy
** Initial revision.
** 
**    Rev 1.3   18 May 1994 09:52:54   marilyn
** Added SendCliMessage as public.
** 
**    Rev 1.2   28 Feb 1992 11:38:56   doug
** simple read, write, and fill
**
**  $Header:   S:/tbird/mt2_186/mem/memcli.h_v   1.2   27 Jan 1997 14:20:10   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MEMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_CLI_FILL_LENGTH 0x100

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**************************************************************************
**
** InitCServer
**
** Description: Initialize the commands for the Memory Server.
**
** Parameters:
**    input:
**       cliHandle:  CLI Server Handle
**       dllHandle:  DLL Handle.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) ;

/***************************************************************************
**
**  MemCliDumpMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the read(dump) memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliDumpMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
**  MemCliWriteMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the write memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliWriteMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
**  MemCliFillMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the fill(write) memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliFillMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***********************************************************************
**
**  SendCliMessage
**
*************************************************************************/
RETCODE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);
/***********************************************************************
**
**  SendCliMessageNo
**
*************************************************************************/
RETCODE SendCliMessageNo(HANDLE cliHandle, LPSTR msgPtr);

/******************************** E O F ***********************************/
