/****************************************************************************
**
**  Name:  PLM86.H
**
**  Description:
**      Header file used for PL/M 86 support
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/omf86/plm86.h_v  $
** 
**    Rev 1.0   26 Feb 1997 11:40:36   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:37:06   Judy
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/omf86/plm86.h_v   1.0   26 Feb 1997 11:40:36   Judy  $
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __PLM86__
#define __PLM86__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef __BASE__
#include "base.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define PAGE_HEADER_BLANK            1
#define FILE_HEADER_BLANK            2
#define PAGE_BREAK                  12
#define FILENAME_LEN                13
#define HEADER_POS                  10
#define CONTROL_POS                 21
#define HEADER_DELIMITER            '='
#define DELIMITER_POS               10
#define WARNING_ERROR               "*** "
#define SPLIT_LINE                  "                    -"


#define MAX_LINES                32767
#define MAX_MNAMES               32767

#define DEFAULT_MAX_LINES         2048
#define DEFAULT_MAX_MNAMES         256

// Class MNAMES - Object to hold PL/M Module Names, derived from LNAMES class
class MNAMES : public LNAMES {
public:
   BOOLEAN usedFlag;

   // CTor & DTor
   MNAMES() : LNAMES() { usedFlag = FALSE; }
   MNAMES(LPSTR iStr) : LNAMES(iStr) { usedFlag = FALSE; }

   BOOLEAN Used() { return usedFlag; }
   VOID Used(BOOLEAN value) { usedFlag = value; }
};

typedef MNAMES* MNAMESPTR;
typedef U16     LINENUM;

                       /****************************
                        *                          *
                        *     PROTOTYPES           *
                        *                          *
                        ****************************/

RETCODE DestroyModNames(VOID);
VOID    GetPathName(VOID);
RETCODE LoadLinenum(LINENUM_ENTRY *, U16 *);
VOID    PlmModuleEnd(VOID);
RETCODE ProcessCOMENT(OMF86_FUNC_PARA *);

#endif /* __PLM86__ */
