/****************************************************************************
**
**  Name:  REGTBL.CPP
**
**  Description:
**      Register translation services for OMF86 Loader
**
**  Status:  PRILIMINARY
**
**  $Log:   S:/tbird/mt2_186/omf86/regtbl.cpv  $
** 
**    Rev 1.0   26 Feb 1997 11:40:36   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:37:04   Judy
** Initial revision.
** 
**    Rev 1.1   09 May 1995 10:57:34   nghia
** Used LdrGetLoaderPath() to retrieve the correct loader path to locate
** the register table configuration file.
** 
**    Rev 1.0   20 Sep 1994 11:56:00   joyce
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/omf86/regtbl.cpv   1.0   26 Feb 1997 11:40:36   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef __STDIO_H_
#include <stdio.h>
#endif

#ifndef __STRING_H_
#include <string.h>
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _OMF86LDR_
#include "omf86ldr.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
STATIC U16 RegTable[MAX_REGISTER_SUPPORTED];
//STATIC CHAR LoaderPath[MAX_PATH_SIZE] = "";
U16 RegistersCnt = 0;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  SetupRegisterTable
**
******************************************************************************/
RETCODE SetupRegisterTable(VOID) {
RETCODE err;
S8 ldrConfigFilename[32];
FILE *ifp;  /* cpu configuration file */
static char item[20];
S8 cline[MAX_LINE];
LOOP_VAR i;

   if ((err = ProcInsertCpu("ldr%s.cfg",ldrConfigFilename)) != GOOD)
       return(err);
   if ((ifp = fopen(ldrConfigFilename, "r")) == NULL) {
      if ((err = LdrWarning(ER_NOT_FOUND, (LPSTR)ldrConfigFilename,
                            NULL, NULL)) != GOOD)
         return(err);
      return ERR_REPORTED(ER_NOT_FOUND); /* Global error code */
   }

    /* skip ahead to nRegs line in config file */
   do {
      if (fgets(cline, MAX_LINE, ifp) == NULL) return(ER_CONFIG_FILE_FORMAT);
   } while (strstr(cline, "nRegs") == NULL);

   /* read in number of registers */
   sscanf(cline, "%5s = %d", item, &RegistersCnt);
   if (RegistersCnt > MAX_REGISTER_SUPPORTED)
      RegistersCnt = MAX_REGISTER_SUPPORTED;
   for (i=0; i < RegistersCnt; i++) {
      REG_ID list[2], curIndex;

      if (fgets(cline, MAX_LINE, ifp) == NULL)
         return(ER_CONFIG_FILE_FORMAT);
      if( sscanf(cline, "%d %d", &list[0], &list[1]) == 2 ) {
         // if more than one index than we are defining a pair
         if((err=CpuRegisterMultipleRegisters(list,&curIndex))!=GOOD)
            return(err);
         list[0] = curIndex;
      }
      RegTable[i] = list[0];
   }
   return(GOOD);
}

/******************************************************************************
**
**  GetRegID
**
******************************************************************************/
RETCODE GetRegID(U16 reg, U16 FAR *cpuRegId) {
RETCODE err;

   if (reg > RegistersCnt) {
      if ((err = LdrWarning(ER_BAD_REG_INDEX, NULL, NULL, NULL)) != GOOD)
         return err;
      return ERR_REPORTED(ER_BAD_REG_INDEX);
   }
   *cpuRegId = RegTable[reg];
   return(GOOD);
}

/******************************************************************************
**
**  CheckRegisterIndex
**
******************************************************************************/
RETCODE CheckRegisterIndex(U16 reg)
{
   RETCODE err;
   if (reg > RegistersCnt) {
      if ((err = LdrWarning(ER_BAD_REG_INDEX, NULL, NULL, NULL)) != GOOD)
         return err;
      return(ER_BAD_REG_INDEX);
   }
   return(GOOD);
}
/*********************************** EOF ************************************/
