/****************************************************************************
**
**  Name:  peripres.h
**
**  Description:
**     Include file for peripheral presenter component.  Declarations
**     for peripheral presenter objects.
**
**  $Log:   S:/tbird/mt2_186/peri/peripres.h_v  $
** 
**    Rev 1.0   16 Dec 1996 16:20:08   Judy
** Initial revision.
** 
**    Rev 1.0   11 Oct 1996 18:47:24   Judy
** Initial revision.
** 
**    Rev 1.12   19 Apr 1994 16:12:50   nghia
** Added function prototypes for PERIDIAL and export functions for dialogs.
** 
**    Rev 1.11   03 Nov 1993 13:44:56   ron
** ready for 2.1 initial build
** 
**  $Header:   S:/tbird/mt2_186/peri/peripres.h_v   1.0   16 Dec 1996 16:20:08   Judy  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PERIPRES_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _PERISERV_
#include "periserv.h"
#endif

#ifndef _PERIMENU_
#include "perimenu.h"
#endif

#ifndef _PERIDIAL_
#include "peridial.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

//*****************************************************************
//   PeriOpenWindow
//
//   Description:
//      Activate the peripheral window.
//
//   Parameters:
//      parent (in): handle of the parent window
//      left (in): left most X coordinate for window position
//      top (in): top most Y coordinate for window position
//      width (in): width of window
//      height (in): height of window
//      dwStyle (in): specifies window style
//      dwExStyle (in): specifies extended window style
//      periWindow (out): handle of the peripheral window
//******************************************************************
RETCODE EXPORT PeriOpenWindow(HWND parent, int left, int top, int width,
      int height, DWORD dwStyle, DWORD dwExStyle, HWND *periWindow);


//*****************************************************************
//   PeriCloseWindow
//
//   Description:
//      Close the peripheral window.
//
//   Parameters:  none
//******************************************************************
RETCODE EXPORT PeriCloseWindow();

//*****************************************************************
//   PeriExistsWindow
//
//   Description:
//      Check to see if peripheral window does exist.
//
//   Parameters:
//      periHandle (out) : return the valid window handle or NULL
//******************************************************************
RETCODE EXPORT PeriExistsWindow(HWND *periHandle);

RETCODE EXPORT PeriInvalidateDisplay(VOID);
RETCODE EXPORT PeriRepaintDisplay(VOID);
RETCODE PeriSetCommands(HWND, BOOLEAN);

/* Edit command routines */
RETCODE EditBuffer(HINSTANCE module, HWND parent, PTRegister reg);
RETCODE EditReg(HINSTANCE module, HWND parent, PTRegister reg, U16 fieldNo);
RETCODE EditGotoAddr(HINSTANCE module, HWND parent);
RETCODE EditGotoReg(HINSTANCE module, HWND parent);
RETCODE EditGotoPeri(HINSTANCE module, HWND parent);

LONG FAR PASCAL EXPORT PeriWndProc(HWND, UINT, WPARAM, LPARAM);

/* Peripheral Dialog Proc */
BOOL EXPORT RegMainDlgProc (HWND, UINT, UINT, LONG); 
BOOL EXPORT GotoRegDlgProc (HWND, UINT, UINT, LONG); 
BOOL EXPORT GotoAddrDlgProc (HWND, UINT, UINT, LONG);
BOOL EXPORT GotoPeriDlgProc (HWND, UINT, UINT, LONG);
BOOL EXPORT MainDlgProc (HWND, UINT, UINT, LONG);

#ifdef __cplusplus
}
#endif

/*************************** E O F ***********************************/
