/****************************************************************************
**
**  Name:  stkendian.h
**
**  Description:
**      This file contains the endian related defines and macros for the
**      stack server routines.
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/mt2_186/stkservr/stkendia.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:45:00   Judy
** Initial revision.
** 
**    Rev 1.3   20 Aug 1992 16:20:00   marilyn
** Firmware returns little endian in byte access.
** 
**    Rev 1.2   19 Aug 1992 09:05:10   marilyn
** Firmware returns little endian.
** 
**    Rev 1.1   13 Aug 1992 17:05:54   marilyn
** Target is apparently BIG endian.
** 
**    Rev 1.0   10 Aug 1992 09:23:20   marilyn
** Initial revision.
** 
**    Rev 1.0   05 Mar 1992 16:28:28   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/stkservr/stkendia.h_v   1.0   16 Dec 1996 14:45:00   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _STKENDIA_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define LITTLEENDIAN 0
#define BIGENDIAN 1

#define HOSTENDIAN LITTLEENDIAN
#define TARGETENDIAN BIGENDIAN

#define FLIPENDIAN_U32(byteStream)   {U8 temp;          \
   temp = byteStream[3];                                \
   byteStream[3] = byteStream[0];                       \
   byteStream[0] = temp;                                \
   temp = byteStream[2];                                \
   byteStream[2] = byteStream[1];                       \
   byteStream[1] = temp;  }                             \

#define FLIPENDIAN_U16(byteStream)  {U8 temp;           \
   temp = byteStream[1];                                \
   byteStream[1] = byteStream[0];                       \
   byteStream[0] = temp;  }

#define CHECKENDIAN_U32(byteStream)             \
     if (HOSTENDIAN != TARGETENDIAN)            \
        FLIPENDIAN_U32(byteStream)

#define CHECKENDIAN_U16(byteStream)             \
     if (HOSTENDIAN != TARGETENDIAN)            \
        FLIPENDIAN_U16(byteStream)

                        /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
