/****************************************************************************
**
**  Name:  stkwalk.h
**
**  Title: Stack Walker
**
**  Description: Declarations for stack walker
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/stkservr/stkwalk.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:44:58   Judy
** Initial revision.
** 
**    Rev 1.16   01 Sep 1993 21:42:02   mindy
** added HiWare stack frame support
** 
**    Rev 1.15   06 Aug 1993 15:54:16   mindy
** Made changes to fix Cosmic
** 
**    Rev 1.14   15 Jun 1993 11:10:06   mindy
** Added frame type defines for Introl and Cosmic.  Changed stack structure
** and added/changed other routine prototypes.
** 
**    Rev 1.13   12 Jan 1993 10:33:38   marilyn
** Moved prototype for ReleasePreviousFrames to stkutil.h.
** 
**    Rev 1.12   21 Oct 1992 17:11:22   marilyn
** Added some frame information fields.
** 
**    Rev 1.11   13 Aug 1992 17:08:06   marilyn
** Added prototypes.
** 
**    Rev 1.10   02 Jun 1992 16:17:46   marilyn
** added prototype for FreeStkVarBuf and modified for ReadFrameHex.
** 
**    Rev 1.9   28 May 1992 16:42:50   marilyn
** Made FindFrame public.
** 
**    Rev 1.8   20 Mar 1992 08:47:00   marilyn
** Added additional field to typeinfo structure.
** 
**    Rev 1.7   12 Mar 1992 17:26:20   marilyn
** No change.
** 
**    Rev 1.6   11 Mar 1992 10:41:08   marilyn
** Added prototypes.
** 
**    Rev 1.5   27 Feb 1992 15:39:24   marilyn
** Removed intermediary routines GetCurrentFramePtr,GetCurrentStackPtr,
** and GetCurrentPC.  Updated to new cpu interface.
** 
**    Rev 1.4   14 Feb 1992 11:44:06   marilyn
** Removed typedef of stack type to stkcli.h
** 
**    Rev 1.3   13 Feb 1992 16:57:58   marilyn
** Added proto for GetCurrentPC.
** 
**    Rev 1.2   11 Feb 1992 15:58:06   marilyn
** No change.
** 
**    Rev 1.1   10 Feb 1992 13:56:56   marilyn
** Added prototypes for shared routines.
**
**    Rev 1.0   24 Jan 1992 12:07:52   brucea
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/stkservr/stkwalk.h_v   1.0   16 Dec 1996 14:44:58   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _STKWALK_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _STKSERVR_
#include "stkservr.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _VARSERVR_
#include "varservr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define NULL_FRAME_TYPE -1
/* Different CPU32 frame types */
#define CPU32_FRAME_TYPE 0
#define CPU32_NO_FRAME_TYPE 1

/* Different CPU16 frame types */
#define COSMIC_ALL_PARM_ON_STACK_FRAME_TYPE  0
#define COSMIC_1ST_PARM_IN_D_REG             1
#define COSMIC_1ST_PARM_IN_DE_REG            2
#define INTROL_FRAME_TYPE                    3
#define CPU16_NO_FRAME_TYPE                  5
#define HICROSS_FRAME_TYPE                   6

#define STK_DISPLAY_BUF_OVERHEAD (sizeof(STK_DISPLAY_TYPE))
#define STK_MAX_CHARS_PER_LINE  132
#define STK_MAX_LINES_PER_BUF 20

#define STACK_WFLAGS (GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_ZEROINIT)

#define MIN_START_SIZE 5
#define MAX_FUNC_NAME    MAX_SYMNAME_LENGTH

typedef struct {
   SYM_DESCRIPTOR functionDesc;
   SYM_DESCRIPTOR moduleDesc;
   LPSTR funcNamePtr;
   FUNC_CLASS funcClass;
   U32 stackSize;
   DESCRIPTOR funcAddrRangeDesc;
   U8 frameType;
   U32 pushMask;
   U8 numParams;
   SYM_DESCRIPTOR firstLocal;
   U16 localListCount;
   U8 funcName[MAX_FUNC_NAME];
} FUNC_INFO_TYPE;


typedef struct frame_entry{
   U8 frameNum;
   DESCRIPTOR frameDesc;   // either points to stack location of old fp
                           // or return PC (if routine doesn't have a frame).
   DESCRIPTOR returnPCDesc;
   FUNC_INFO_TYPE funcInfo;
   struct frame_entry *next;
   struct frame_entry *previous;
} STK_FRAME_NODE;

typedef	STK_FRAME_NODE *STK_FRAME_LIST_TYPE;


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE FreeStkVarBuf(VS_DISPLAY_PTR displayBufPtr);

RETCODE GetStkBuf(U32 size,
                  LPWORD *bufptr);


RETCODE FindFrame(U8 frameNum,
                  STK_FRAME_NODE **frame);

RETCODE StkReadFrameNAndLocals(DESCRIPTOR stkSessionId,
                               U8 frameStart,
                               U8 frameEnd,
                               BOOLEAN interActive,
                               STK_DISPLAY_PTR *dispPtr);

RETCODE StkReadFrameHex(DESCRIPTOR stkSessionId,
                        U8 frameStart,
                        U8 frameEnd,
                        STK_DISPLAY_PTR *dispPtr);

RETCODE PopStack(DESCRIPTOR stackDesc, U32 offset); 

RETCODE SearchForReturnPC(DESCRIPTOR stackDesc,
                          DESCRIPTOR stackBaseDesc,
                          DESCRIPTOR *retPCDesc,
                          DESCRIPTOR *retAddrStackPosDesc,
                          BOOLEAN *isValid);

/******************************** E O F ***********************************/
