/****************************************************************************
**
**  Name:  symget.h
**
**  Description:
**     Prototype info for the routines that get entries from the symbol table.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/symbol/symget.h_v  $
** 
**    Rev 1.1   26 Feb 1997 11:43:28   Judy
** 
**    Rev 1.1   14 Jan 1997 15:32:04   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:18   Judy
** Initial revision.
** 
**    Rev 1.7   29 Aug 1992 22:05:34   brucea
** Added: SymGetParentModule, SymGetSymbolBasicType headers
** 
**    Rev 1.6   01 Apr 1992 23:45:52   brucea
** Fixed: #ifdef __cplusplus to only include SymGetVarLifetimeInfo in the compile
**    if it is a C++ compile
** 
**    Rev 1.5   13 Jan 1992 17:22:44   john
** Added prototype: SymGetVarLifetimeInfo
** 
**    Rev 1.4   11 Dec 1991 16:07:30   brucea
** Changes below:
** Removed GetAddrFromDesc prototype
** 
**    Rev 1.3   02 Dec 1991 10:41:02   john
** Merged branch 1.2.1
** 
**    Rev 1.2.1.1   29 Nov 1991 19:52:48   brucea
** Added function prototype GetAddrFromDesc
** Removed SymGetCompAddr
** 
**    Rev 1.2   31 Oct 1991 17:01:00   john
** Removed EXPORT keyword from a function that did not need it.
** Moved two functions to symblsvr.h.
** 
**    Rev 1.1   23 Oct 1991 13:01:38   john
** Added prototypes for new functions.
** 
**    Rev 1.0   17 Oct 1991 10:15:28   john
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/symbol/symget.h_v   1.1   26 Feb 1997 11:43:28   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SYMGET_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _MEMMANAG_
#include "memmanag.h"
#endif
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus

/***************************************************************************
** SymGetVarLifetimeInfo
**
** Description: Gets the alive/dead status of a register variable
**
** Input Parameters:
**    inputSymbol:   the descriptor to a register var
** Output Parameters:
**    lifetimeState: returns LIVE or DEAD
** Errors:
**    ER_SYMBOL_NOT_A_REG: the descriptor does not point to a register
**                         variable.
***************************************************************************/
RETCODE SymGetVarLifetimeInfo(SYM_DESCRIPTOR inputSymbol,
                              VAR_LIFETIME_STATE &lifetimeState);


//--------------------------------------------------------------------------
// SymGetSymbolBasicType
//
// Input parameter:
//    inputSymbol: symbol descriptor of symbol's basic type desired
//
// Output parameter:
//    basicType: code, data, or unknown.  Unknown types are:
//       SYM_PUBLIC_UNKNOWN:
//       SYM_MISCELLANEOUS:
//       SYM_CONSTANT:
//       SYM_TYPE:
//       SYM_UNDEFINED:
//--------------------------------------------------------------------------
RETCODE SymGetSymbolBasicType(SYM_DESCRIPTOR      inputSymbol, 
                              BASIC_SYM_ADDR_TYPE *basicType);


//--------------------------------------------------------------------------
// SymGetParentModule
//
// Description:
//    given and input symbol descriptor, this function checks that the
//    symbol is a module and returns that descriptor.
//    If not, it gets the parent symbol descriptor and loops.
//    If the symbol type is SYM_ROOT, the function terminates and sets
//    the output descriptor to NULL_SYMBOL.
//
// Input parameter:
//    inputSymbol: starting point for check for module type
//
// Output parameter:
//    moduleSymbol: return symbol descriptor pointing to module symbol
//                  or NULL_SYMBOL if not found
//--------------------------------------------------------------------------
RETCODE SymGetParentModule(SYM_DESCRIPTOR inputSymbol, 
                           SYM_DESCRIPTOR *moduleSymbol);


#endif

/******************************** E O F ***********************************/
