/*****************************************************************************
** Name:  varcli.h
**
** Description:
**    Routines to access the CLI for the variable server.
**
** Status:   PRELIMINARY
**
** $Log:   S:/tbird/mt2_186/varsrv/varcli.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:48:08   Judy
** Initial revision.
** 
**    Rev 1.1   28 Feb 1992 10:59:52   marilyn
** No change.
** 
**    Rev 1.0   22 Jan 1992 17:40:48   marilyn
** Initial revision.
** 
**
** $Header:   S:/tbird/mt2_186/varsrv/varcli.h_v   1.0   16 Dec 1996 14:48:08   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _VARCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**   AddVar
**
**   Purpose:
**      To add the specified variable to the variable table.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  AddVar(LPSTR cmdString, U32 argc, U32 argv[]);


/**********************************************************************
**
**   DeleteVar
**
**   Purpose:
**   To remove the specified variable from the variable table.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters: 
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  DeleteVar(LPSTR cmdString, U32 argc, U32 argv[]);


/*******************************************************************************
**
**   DisplayVar
**
**   Purpose:
**      To display the specified variable exactly the same as the variable
**      presenter does.  In the absence of any specified variable, all
**      variables added by the CLI are displayed sequentially.
**      Given a variable "path" and name, if found in the variable server
**      list (from the AddVar command), the variable and its value is
**      displayed.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**      Invalid number of arguments
**      Symbol name (or portion of) not found
**
******************************************************************************/
RETCODE EXPORT  DisplayVar(LPSTR cmdString, U32 argc, U32 argv[]);


/*******************************************************************************
**
**   DumpVars
**
**   Purpose:
**      To display all variables exactly the same as the variable
**      presenter does. No arguements allowed.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error: error if argc > 1.
**
******************************************************************************/
RETCODE EXPORT  DumpVars(LPSTR cmdString, U32 argc, U32 argv[]);


/****************************************************************************
**
**   SetVar
**
**   Purpose:
**      To set the value of the specified variable.
**      Syntax provides an optional module name, function name, followed
**      by variable name and assignment value; i.e.
**          [moduleName [funcName]] <varName> <varValue>
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**      invalid number of arguments
**      symbol name not found
**      variable value not valid size
**      variable value field has invalid characters
**
******************************************************************************/
RETCODE EXPORT  SetVar(LPSTR cmdString, U32 argc, U32 argv[]);


/******************************** E O F ***********************************/
