/***************************************************************************
**
**    Name:    daddef.h
**
**    Description:
**        Internal definitions for the DAD server.
**
**    $Log:   S:/tbird/arcm332/dasm/daddef.h_v  $
** 
**    Rev 1.15   05 Sep 1994 18:11:20   mindy
** changed interface to support linked cursors better
** 
**    Rev 1.14   22 Jul 1993 10:15:30   ernie
** (For Mindy):  Added support for dequeuer backup
** 
**    Rev 1.13   15 Jul 1993 16:57:18   ernie
** Made constants unsigned
** 
**    Rev 1.12   13 Jul 1993 19:25:28   doug
** Errors consolidated in errtext/mkerrors.h
** 
**    Rev 1.11   13 Jul 1993 09:26:54   ernie
** Added prototype for new function GetDasmInstNoAlloc()
** 
**    Rev 1.10   09 Jun 1993 09:00:10   ernie
** Added call member to DASM_INFO and prototype for IsTransfer()
** 
**    Rev 1.9   06 Jan 1993 17:38:14   marilyn
** Added define for MAX_INST_PER_BUFFER of 250.
** 
**    Rev 1.8   05 Jan 1993 15:57:32   courtney
** Removed MemAlloc and related macros, for consistency with other servers.
** 
**    Rev 1.7   16 Dec 1992 15:35:18   mindy
** moved dq to fw
** 
**    Rev 1.6   16 Oct 1992 15:12:36   john
** increased asm/dasm table to handle dc.w for asm
** 
**    Rev 1.5   15 Oct 1992 10:35:48   john
** bumped max number of insts because some were added to 68030.tbl
** 
**    Rev 1.4   14 Oct 1992 15:09:56   john
** increased buffer size
** 
**    Rev 1.3   13 Oct 1992 11:26:42   ernie
** Changed def of DqInsts to get rid of warning
** 
**    Rev 1.2   19 Aug 1992 09:17:44   marilyn
** Added error codes
** 
**    Rev 1.1   05 Aug 1992 10:38:32   marilyn
** Added another error message.
** 
**    Rev 1.0   31 Jul 1992 14:43:24   marilyn
** Initial revision.
** 
**    Rev 1.9   17 Jul 1992 09:37:02   marilyn
** Added prototypes.
** 
**    Rev 1.8   10 Jul 1992 17:20:54   marilyn
** Added additonal prototypes.
** 
**    Rev 1.7   23 Jun 1992 16:31:36   marilyn
** Added prototypes.
**
**    $Header:   S:/tbird/arcm332/dasm/daddef.h_v   1.15   05 Sep 1994 18:11:20   mindy  $
*/

#define _DAD_DEFINE_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef __STRING_H_
#include <string.h>
#endif

#ifndef _DADDQ332_
#include "daddq332.h"
#endif


                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/

#define UNSIZED         0
#define TB              1
#define TW              2
#define TL              4
#define TQ              8
#define TS              16
#define TD              32
#define TX              64
#define TP              128
#define TWL             6
#define TBW             3
#define TBWL            7
#define TBWLSDXP        247
#define TWLQ            14
#define LINE            0x10

#define MAX_MNEMONIC_SIZE  11
#define MAX_CODE_LENGTH    11
#define MAX_NUM_INST       265
#define MAX_NUM_CO_INST    123
#define MAX_INST_PER_LINE  6     /* bytes */
#define MAX_LINE_LENGTH    256u   /* bytes */
#define MAX_INST_PER_BUFFER 250u  /* max insts per 64KB buffer */
#define MAX_LINE_PER_INST  3
#define MAX_OPSTRING       256
#define MAX_OPERAND        30

#define FULL_EXTENSION  0x0100
#define BRIEF_EXTENSION 0x0000

typedef struct operator {
   U8       mnemonic[MAX_MNEMONIC_SIZE+1], /* content operand size */
            opStringStorage[MAX_OPSTRING], /* content symbol */
            FAR *opString,
            operandStorage[MAX_OPERAND],
            FAR *operand,
            size[2],
            eaType,
            eaPos,
            cpuType,
            opLength;
   BOOLEAN  symbol;
   U16      objCode[MAX_CODE_LENGTH];
} OPERATOR;

typedef struct ea {
   U16    AdrMode;
   U16    AdrReg; /* high nibble : start register no. */
}EA;              /*  low nibble :   end register no. */


typedef struct instruction {
   U8     Mnemonic[MAX_MNEMONIC_SIZE+1],
          OpSize,
          OpType,
          EaType,
          EaPos,
          CpuType;
}INSTRUCTION;


typedef struct {
   BOOLEAN transfer;                        /* control transfer instruction */
   BOOLEAN conditional;                 /* conditional transfer instruction */
   BOOLEAN returnType;                      /* return type with pc on stack */
   BOOLEAN knowAddr;                          /* exact target address known */
   U32 target    ;                    /* Target address of control transfer */
   BOOLEAN flushableInst;    /* instruction will cause an instruction flush */
   BOOLEAN bkptInst;            /* Is instruction a breakpoint instruction? */
   BOOLEAN call;                              /* instruction is a call type */
   U8 bytesUsed;                                    /* Number of bytes used */
} DASM_INFO;


                      /********************
                      **                 **
                      **   Macros        **
                      **                 **
                      ********************/

#define ctoi(c)  ( ((U8)(c) > 0x39) ?  ((U8)((c) - 'a') + 10) : ((U8)((c) - '0')) )  /* Char to Dec */
#define htoc(i)  ((U8)((i) + '0'))  /* Hex to Char, only 0 - 7 */

#define MY_ATOL(value, string) \
   {    CHAR FAR * ptr; \
        U16 temp; \
        value = 0; \
        ptr = string; \
        while (*ptr) { \
           temp = ((U16)*ptr) - 0x30; \
           if ((temp > 9) || (temp < 0)) { \
              value = -2; \
              break; \
           } else { \
              value = (value * 10) + temp; \
           } \
           ++ ptr; \
        } \
   }


                    /**************************
                    **                       **
                    **   Prototypes          **
                    **                       **
                    **************************/


RETCODE TraceBufInst(U16 FAR *OpWord, U32 addrOffset, BOOLEAN DadSymbol,
                  U8 *inst, DASM_INFO FAR *dasmInfo);

RETCODE IsCallOrRTS(DESCRIPTOR StartAddr, DESCRIPTOR calledAddr,
                    CALL_TYPE *type);

RETCODE GetDasmInst(DESCRIPTOR startAddr, U16 numInst, LPSTR *buffer, 
                    BOOLEAN DasmSymbol);

RETCODE GetDasmInstNoAlloc(DESCRIPTOR startAddr, LPSTR buffer, 
                    BOOLEAN DasmSymbol);

RETCODE CheckDasmInst(DESCRIPTOR startAddr,BOOLEAN DasmSymbol,U8 *instLen,
                      BOOLEAN *instValid);

RETCODE GetDasmInstByLine(DESCRIPTOR startAddr, U16 *lines, LPSTR *buffer, 
                    BOOLEAN DasmSymbol);

S8      FindString(U8 Count, U8 **Source, U8 *Search);

RETCODE FreeDasmCache(VOID);

RETCODE AsmInst(OPERATOR *OpSet, LPSTR inInst, LPSTR *outInst,
                LPWORD numBytes, DESCRIPTOR startAddr);

RETCODE DqInsts(DQ_STATE *dqState, S32 numInst, LPSTR buffer,
                DESCRIPTOR *descs);

RETCODE GetBits(U16 Value, U8 BitStart,U8 Length);

RETCODE DummyGetAsmLine(LPSTR buffer);

RETCODE InitOpSet(OPERATOR *opSet,BOOLEAN symbols);

RETCODE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);

RETCODE IsTransfer(DESCRIPTOR startAddr, DESCRIPTOR transferAddr,
      TRANSFER_TYPE *transfer);

VOID GetStartEndFrame(S32 *starting, S32 *ending);
/*********************************** E O F ***********************************/
