/****************************************************************************
**
**  Name:  dsinfo16.h
**
**  Description:
**     This is a disassembler class header
**
**  Status:  
**
**  $Log:   S:/tbird/mt2_186/dad186/dsinfo16.h_v  $
** 
**    Rev 1.0   16 Dec 1996 15:13:50   Judy
** Initial revision.
** 
**    Rev 1.5   15 Jun 1994 10:44:56   nghia
** Added IncStartAddressOverFlow().
** 
**    Rev 1.4   10 Jun 1994 17:11:42   nghia
** Added member function to return the instLength.
** 
**    Rev 1.3   28 Mar 1994 10:24:56   nghia
** Support DadCurrentDasmAddr() routine.
** Added StartAddress() member function to retrieve the current DASM address.
** 
**    Rev 1.2   09 Jun 1993 09:03:16   ernie
** Added class functions IsTransfer, IsKnownAddr, GetDataOffset
** 
**    Rev 1.1   25 May 1993 12:07:50   ernie
** Changed dasmSym to be system-wide global
** 
**    Rev 1.0   08 Apr 1993 09:42:34   doug
** Initial revision.
** 
**    Rev 1.1   30 Mar 1993 16:12:46   ernie
** (for mindy): added symbol support
** 
**    Rev 1.0   12 Mar 1993 09:53:56   mindy
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/dad186/dsinfo16.h_v   1.0   16 Dec 1996 15:13:50   Judy  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/
#define _DSINFO16_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdio.h"

#ifndef _ADDR_
#include "addr.h"
#endif
#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

                       /****************************
                        *                          *
                        *     EXTERNALS            *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define MAX_LINE_LENGTH 255

enum PREBYTE { PAGE0, PAGE1=0X17, PAGE2=0X27, PAGE3=0X37 };
enum OPTYPE { INH, ACCOFF, EXT, IMMED, INDEX, ABS, PSHLIST, PULLIST,
              I_TO_E, E_TO_I, E_TO_E, XOYO, DC_ERR};
enum REGOPTIONS { XREG, YREG, ZREG };

typedef struct {
   OPTYPE type;
   REGOPTIONS reg;
    /* vvv   use this existing typedef (LONGSIZE indicates 20 bit value) */
   MEM_SIZE size;
   BOOLEAN maskedInst;
   MEM_SIZE maskSize;
   U16 mask;
   U32 data;
   U32 effAddr;
   U32 effAddr2;
} ADDRESS_MODE;

class AsmDasmBase {
public:
   void far *operator new(size_t size);
   void operator delete(void far *p);
   BOOLEAN ValidInstruction();
   U8 InstLength();
   
protected:
   DESCRIPTOR   pcAddress;
   U8           hexCode[6];         /* max instruction */
   U8           *codePtr;           /* points at hexCode bytes */
   U8           instLength;         /* Number of bytes used in current inst */
   ADDRESS_MODE addrMode;
};

class DasmInfo : public AsmDasmBase {
public:
   RETCODE Disassemble(LPSTR buffer, U16 numInst=1);
      // Disassemble at least one instruction at current starting address.
      // Current instruction(s) are concatenated onto the end of the
      // existing string. Thus caller must initialize buffer accordingly.
   
   RETCODE Disassemble(LPSTR buffer, U8 bytes[6]);
      // Disassemble bytes coming in
   
   RETCODE DecodeMemory();
      // Reads Bytes from memory from starting address and decodes the
      // instruction information but doesn't print out anything or change
      // the starting address.
   RETCODE StartAddress(DESCRIPTOR addr);
   RETCODE GetStartAddress(DESCRIPTOR *addr);
   RETCODE SetStartAddress(DESCRIPTOR addr);

   RETCODE IncStartAddress();
      // Increments start address by current instruction length.
   RETCODE IncStartAddress(U32 offset);
      // Increments start address given offset.

   RETCODE IncStartAddressOverFlow();
      // Increments start address by current instruction length
      // Address limit overflow allow.
   
   BOOLEAN StartAddressInRange(DESCRIPTOR range);
      // Returns TRUE if start address in given range.
   
   CALL_TYPE GetCallType() { return callType; };
   BOOLEAN IsTransfer() { return transfer; };
   BOOLEAN IsKnownAddr() { return (addrMode.type == ABS); };
   U32 GetDestOffset() { return addrMode.effAddr; };
   U16 DataCycles() { return dataCycles; };
   
   DasmInfo();
   DasmInfo(DESCRIPTOR addr);

// The following are opcode parsing routines - ideally they should be
// private.  However if I make them private I can not initialize my
// static array of opcode function pointers.  I think it would be more
// of a waste of code space to initialize that array at run time just
// so I can make these routines private!
   RETCODE Adc();
   RETCODE Add();
   RETCODE And();
   RETCODE Asl();
   RETCODE Asr();
   RETCODE Bclr();
   RETCODE Bit();
   RETCODE Brclr();
   RETCODE Brset();
   RETCODE Bset();
   RETCODE Clr();
   RETCODE Cmp();
   RETCODE Com();
   RETCODE Cps();
   RETCODE Cpx();
   RETCODE Cpy();
   RETCODE Cpz();
   RETCODE Dec();
   RETCODE Eor();
   RETCODE Inc();
   RETCODE Jmp();
   RETCODE Jsr();
   RETCODE Lda();
   RETCODE Lds();
   RETCODE Ldx();
   RETCODE Ldy();
   RETCODE Ldz();
   RETCODE Lsr();
   RETCODE Neg();
   RETCODE Opcd07();
   RETCODE Opcd17();
   RETCODE Opcd27();
   RETCODE Opcd37();
   RETCODE Opcd7b();
   RETCODE Opcd7c();
   RETCODE OpcdB0();
   RETCODE OpcdB1();
   RETCODE OpcdB2();
   RETCODE OpcdB3();
   RETCODE OpcdB4();
   RETCODE OpcdB5();
   RETCODE OpcdB6();
   RETCODE OpcdB7();
   RETCODE OpcdB8();
   RETCODE OpcdB9();
   RETCODE OpcdBA();
   RETCODE OpcdBB();
   RETCODE OpcdBC();
   RETCODE OpcdBD();
   RETCODE OpcdBE();
   RETCODE OpcdBF();
   RETCODE OpcdFA();
   RETCODE OpcdFB();
   RETCODE Or();
   RETCODE Rol();
   RETCODE Ror();
   RETCODE Sbc();
   RETCODE Store();
   RETCODE Sts();
   RETCODE Stx();
   RETCODE Sty();
   RETCODE Stz();
   RETCODE Sub();
   RETCODE Tst();
   
protected:
   VOID CommonInitialization();	  
   VOID PrintInfo(LPSTR buffer);
   VOID PrintIndexRegister(LPSTR buffer);
   RETCODE LookupAddrSymbol(LPSTR buffer);

   CHAR         mnemonic[6];
   PREBYTE      preByte;
   U8           opcode;
   BOOLEAN      transfer;                   /* control transfer instruction */
   BOOLEAN      conditional;                     /* conditional instruction */
   CALL_TYPE    callType;
   U16          dataCycles;                        /* # data words required */

private:
   VOID DecodeBytes();
   RETCODE FillCodeBuffer();
   U8 GetNextCodeByte();
   VOID Group6Mnemonic();
   RETCODE Group6Address();
   VOID Opcode4XToFXMnemonic(U8 index);
   RETCODE Opcode4XToFXAddress();
   RETCODE MaskedAddress();
   RETCODE HandleImmed8();
   RETCODE HandleImmed16();
   RETCODE HandleIndex8();
   RETCODE HandleIndex16();
   RETCODE HandleIndex20();
   RETCODE HandleExt();
   RETCODE HandleExt20();
   RETCODE HandleAccOffset();
   RETCODE HandleRel(BOOLEAN changeType, U16 relOff, U16 limitValue);
   RETCODE HandleRel8(BOOLEAN changeType);
   RETCODE HandleRel16(BOOLEAN changeType);
   RETCODE HandleExtToExt();
   RETCODE HandleIxpToExt();
   RETCODE HandleExtToIxp();
   RETCODE DetermineIndexRegister();
   RETCODE FlagError();
};
 
