
LOCAL char *OutputPtr = NULL;
LOCAL int   OutputRows = 16, rowCount = 0;
LOCAL int   accessSize, deqSize;
LOCAL S32   LastFrame;


/* Codes must be sorted */
LOCAL U8 CondBranchCode[] = {
   0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
   0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
   0xCE, 0xE0, 0xE1, 0xE2, 0xE3
};

/* Codes must be sorted */
LOCAL U8 UncondBranchCode[] = {
   0x9A, 0xC2, 0xC3, 0xCA, 0xCB, 0xCC, 0xCD, 0xCF,
   0xE8, 0xE9, 0xEA, 0xEB
};

PRIVATE BOOLEAN CheckFrame  (DESCRIPTOR dqStateId, DASM_INFO *dasmInfo, S32 startFrame);
PRIVATE BOOLEAN SkipFrame   (DESCRIPTOR dqStateId, S32 *endFrame);
PRIVATE int     DisplayFrame(DESCRIPTOR dqStateId, S32 Frame);
PRIVATE int     PutOneFrame (S32 Frame, U32 Addr, U16 Data, U8 Stat, U8 Tbits);
PRIVATE char   *FrameNoStr  (S32 Frame);
PRIVATE         ByteToBitstr(U8 data, char *buffer);
PRIVATE         GetDeqInfo();
PRIVATE         GetCodeKind(U8 *Code,  int *codeKind);
PRIVATE BOOLEAN SearchCode (U8 *Table, int TableLen, U8 Code);

/***************************************************************************
**
**  Name: GetCodeKind(Code,  codeKind)
**
**  Description:
**     determine the kind of codes:
**     no branch, conditional branch, or unconditional branch
**
**  Input:  codes
**
**  Output: code kind
**
****************************************************************************/
PRIVATE GetCodeKind(U8 *Code,  int *codeKind)
{
U8 ID;

   ID = (Code[1] & 0x38) >> 3;
   if (Code[0] == 0xFF && ID >= 2 && ID <= 5)   /* JMP/CALL reg/mem */
      *codeKind = UNCONDBRANCH;   /* unconditional branch */
   else if (SearchCode(UncondBranchCode,
            sizeof(UncondBranchCode)/sizeof(U8), Code[0]))
      *codeKind = UNCONDBRANCH;   /* unconditional branch */
   else if (SearchCode(CondBranchCode,
            sizeof(CondBranchCode)/sizeof(U8), Code[0]))
      *codeKind = CONDBRANCH;     /* conditional branch */
   else
      *codeKind = NOBRANCH;       /* no branch */
}  /* end of GetCodeKind() */

/***************************************************************************
**
**  Name: SearchCode(Table, TableLen, Code)
**
**  Description:
**     search code in code table
**
**  Input:  code table, table length, code
**
**  Return: TRUE if found, FALSE otherwise
**
****************************************************************************/
PRIVATE BOOLEAN SearchCode(U8 *Table, int TableLen, U8 Code)
{
int Low, High, Mid;

   Low = 0;
   High = TableLen - 1;
   while (Low <= High) {
      Mid = (Low + High) / 2;
      if (Code < Table[Mid])
         High = Mid - 1;
      else if (Code > Table[Mid])
         Low = Mid + 1;
      else
         return (TRUE);
   }
   return (FALSE);
}  /* end of SearchCode() */


