/* Class: GotoAddrDialog 
   Given an address descriptor, convert the input address descriptor to its
   text format and display in the edit control of self.  When user select OK,
   get the edit text and convert it back into the input descriptor.

*/!!

inherit(Dialog, #GotoAddrDialog, #(addrDesc /* address descriptor */
hlpEntry   /* help context id */), 2, nil)!!

setClassVars(GotoAddrDialog, #())!!

now(class(GotoAddrDialog))!!

/* 03/15/1994 11:85 - PUBLIC
  Open a new GotoAddrDialog object for the caller.
  NOTES:
    - <addrDesc> is an address descriptor.  This Class uses the
    input <addrDesc> for address conversion. 
    - If successful, the getAddr() method will return the input
    <addrDesc>, else it returns nil.
    - The caller is responsible to destroy the input <addrDesc> if
    user pressed CANCEL or there is error occurred.
*/
Def open(self, addrDesc | dlg)
{
  dlg := new(self);
  ^init(dlg, addrDesc);
}!!

now(GotoAddrDialog)!!

/* 6/14/1994 14:14 - PUBLIC (VIRTUAL)
  Always return GOOD;
*/
Def acceptInputAddr(self)
{ 
  ^GOOD;
}
!!

/* 6/2/1994 13:03 - VIRTUAL */
Def getViewAddressSize(self)
{ 
  ^nil;
}
!!

/* 3/21/1994 17:25 - PUBLIC */
Def setHelpEntry(self, hlp)
{
  hlpEntry := hlp;
}!!

/* 3/15/1994 11:58 - PRIVATE
   Initialize self instance variable. 
   Return self.
*/
Def init(self, newAddr)
{
  addrDesc := newAddr;
}
!!

/* 3/15/1994 11:58 - PRIVATE
   Initialize self before display.
*/
Def initDialog(self, wp, lp | addrTxt)
{
  if not(hlpEntry)
    hlpEntry := HE_DLGR_GOTO_ADDRESS;
  endif;
  
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_GOTO_ADDRESS,
     getHWnd(self), hlpEntry);
  /* convert the input descriptor and set the initial value */
  if (TheProcFamily = PROC_FAMILY_X86) then
    addrTxt := getAddressTextParam(AddressLibClass$Inst, addrDesc, 0, 0);
  else  
    addrTxt := getAddressTextParam(AddressLibClass$Inst, addrDesc, 1, 0);
  endif; 
  /* make sure addrTxt is valid */
  if not(addrTxt) addrTxt := "0x"; endif;  
  
  setItemText(self, DLG_GOTO_ADDRESS, addrTxt);
  /* informs Windows to set focus to tab stop 1 */
  ^1;
}
!!

/* 3/15/1994 11:58 - PUBLIC
  Return the address descriptor 
  NOTES: Caller needs to destroy the returned descriptor when done.
*/
Def getAddr(self)
{
  ^addrDesc;
}
!!

/* 3/15/1994 11:58 - PRIVATE
   Command processing
*/
Def command(self, wp, lp | s1 index)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP is
      contextNumber(TheHelpObject, hWnd, hlpEntry);
    endCase
    case wp == IDOK and high(lp)= 0 is
      if ((s1 := getItemText(self, DLG_GOTO_ADDRESS)) = "") then
         displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "Go To", nil, nil);
        setItemFocus(self, DLG_GOTO_ADDRESS);
        ^0;
      endif;
      /* Convert the input text ot the <addrDesc> */     
      if not(convertTextToAddrDesc(AddressLibClass$Inst, s1, addrDesc)) cor
        not(acceptInputAddr(self)) then
        setItemFocus(self, DLG_GOTO_ADDRESS);
        ^0;
      endif;
      /* input is acceptable, end */
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!

