/* CLASS: StkAreaDialog
   Provide StackArea dialog box for the stack presenter
 */!!

inherit(Dialog, #StkAreaDialog, #(stackBase /* addrDescriptor */
stackSize  /* U32 */), 2, nil)!!

now(class(StkAreaDialog))!!

/* 7/14/1993 12:58 - PUBLIC
 Create an instance of the dialog box. Initialize and setup 
 for runModal() call.
*/
Def new(self, oldBase, oldSize | theDlg)
{ 
  /* validate input */
  if not(oldBase and oldSize) 
    ^nil;
  endif;
  theDlg := new(self:Behavior);
  setValues(theDlg, oldBase, oldSize);
  ^theDlg;
}
!!

now(StkAreaDialog)!!

/* 7/14/1993 13:35 - PRIVATE
  Get the instant variables stack base and size
*/
Def getValues(self)
{ 
  if stackBase cand stackSize
    ^tuple(stackBase, stackSize);
  endif;  
  ^nil;
}
!!

/* 7/14/1993 13:35 - PRIVATE
  Set the instant variables for dialog
*/
Def setValues(self, oldBase, oldSize)
{ 
  stackBase := oldBase;
  stackSize := oldSize;
}
!!

/* 7/14/1993 13:57 - PRIVATE
  validate the input is a valid string.
*/
Def validateInput(self, inStr, errCode | value )
{ 
  if (inStr  = "")
    displayFormattedError(ErrorTextLibClass$Inst, 
        errCode, FORCE_POPUP, nil, nil, nil);
    ^nil;
  endif;
  ^GOOD;
}
!!

/* 7/14/1993 13:44 - PRIVATE
  Commands processing
*/
Def command(self, wp, lp | tmpStr, tmpVal)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, HE_DLGR_STACK_AREA);
    endCase
    
    case wp == IDOK and high(lp)= 0 is
      /* Valiadate stack base and size input */
      tmpStr := getItemText(self, DLG_STACK_BASE_ADDR);
      if not(validateInput(self, tmpStr, ER_STACK_SIZE_MISSING)) cor
         not(convertTextToAddrDesc(AddressLibClass$Inst, tmpStr, stackBase)) 
        setItemFocus(self, DLG_STACK_BASE_ADDR);
        ^GOOD; 
      endif;  
      
      /* validate stack size */
      tmpStr := getItemText(self, DLG_STACK_SIZE);
      if not(validateInput(self, tmpStr, ER_STACK_INVALID_SIZE)) cor
        (not(tmpVal := string2int(tmpStr)) cand
         not(tmpVal := getSymbolicOffset(AddressLibClass$Inst, tmpStr)))
        setItemFocus(self, DLG_STACK_SIZE);
        ^GOOD; 
      endif;   
      stackSize := tmpVal;
      
      /* Everything is GOOD, lets exit */     
      end(self, IDOK);
    endCase
  endSelect;
  ^GOOD;
}!!

/* 7/14/1993 11:58 - PRIVATE
  Set old values into edit boxes.
*/
Def initDialog(self, wp, lp | addrTxt)
{
  /* place initial value */
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_STACK_AREA,
     getHWnd(self), HE_DLGR_STACK_AREA);
  if not(addrTxt := getAddressText(AddressLibClass$Inst, stackBase)) then
     addrTxt := "0x";
  endif;
  /* set the text strings in edit controls */
  setItemText(self, DLG_STACK_BASE_ADDR, addrTxt);
  setItemText(self, DLG_STACK_SIZE, asString(stackSize));
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!
